/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerResponse;
import android.accounts.AuthenticatorDescription;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import java.util.HashMap;

public class ChooseAccountActivity
extends Activity {
    private static final String TAG = "AccountManager";
    private AccountManagerResponse mAccountManagerResponse = null;
    private Parcelable[] mAccounts = null;
    private Bundle mResult;
    private HashMap<String, AuthenticatorDescription> mTypeToAuthDescription = new HashMap();

    private void getAuthDescriptions() {
        for (AuthenticatorDescription authenticatorDescription : AccountManager.get(this).getAuthenticatorTypes()) {
            this.mTypeToAuthDescription.put(authenticatorDescription.type, authenticatorDescription);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getDrawableForType(String string2) {
        boolean bl = this.mTypeToAuthDescription.containsKey(string2);
        Drawable drawable2 = null;
        if (!bl) return drawable2;
        try {
            AuthenticatorDescription authenticatorDescription = this.mTypeToAuthDescription.get(string2);
            Drawable drawable3 = this.createPackageContext(authenticatorDescription.packageName, 0).getDrawable(authenticatorDescription.iconId);
            return drawable3;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            boolean bl2 = Log.isLoggable(TAG, 5);
            drawable2 = null;
            if (!bl2) return drawable2;
            Log.w(TAG, "No icon name for account type " + string2);
            return null;
        }
        catch (Resources.NotFoundException notFoundException) {
            boolean bl3 = Log.isLoggable(TAG, 5);
            drawable2 = null;
            if (!bl3) return drawable2;
            Log.w(TAG, "No icon resource for account type " + string2);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void finish() {
        if (this.mAccountManagerResponse != null) {
            if (this.mResult != null) {
                this.mAccountManagerResponse.onResult(this.mResult);
            } else {
                this.mAccountManagerResponse.onError(4, "canceled");
            }
        }
        super.finish();
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mAccounts = this.getIntent().getParcelableArrayExtra("accounts");
        this.mAccountManagerResponse = (AccountManagerResponse)this.getIntent().getParcelableExtra("accountManagerResponse");
        if (this.mAccounts == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        this.getAuthDescriptions();
        AccountInfo[] accountInfoArray = new AccountInfo[this.mAccounts.length];
        for (int i = 0; i < this.mAccounts.length; ++i) {
            accountInfoArray[i] = new AccountInfo(((Account)this.mAccounts[i]).name, this.getDrawableForType(((Account)this.mAccounts[i]).type));
        }
        this.setContentView(17367127);
        ListView listView = (ListView)this.findViewById(16908298);
        listView.setAdapter(new AccountArrayAdapter((Context)this, 17367043, accountInfoArray));
        listView.setChoiceMode(1);
        listView.setTextFilterEnabled(true);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                ChooseAccountActivity.this.onListItemClick((ListView)adapterView, view, n, l);
            }
        });
    }

    protected void onListItemClick(ListView listView, View view, int n, long l) {
        Account account = (Account)this.mAccounts[n];
        Log.d(TAG, "selected account " + account);
        Bundle bundle = new Bundle();
        bundle.putString("authAccount", account.name);
        bundle.putString("accountType", account.type);
        this.mResult = bundle;
        this.finish();
    }

    private static class AccountArrayAdapter
    extends ArrayAdapter<AccountInfo> {
        private AccountInfo[] mInfos;
        private LayoutInflater mLayoutInflater;

        public AccountArrayAdapter(Context context, int n, AccountInfo[] accountInfoArray) {
            super(context, n, accountInfoArray);
            this.mInfos = accountInfoArray;
            this.mLayoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            ViewHolder viewHolder;
            if (view == null) {
                view = this.mLayoutInflater.inflate(17367128, null);
                viewHolder = new ViewHolder();
                viewHolder.text = (TextView)view.findViewById(16909095);
                viewHolder.icon = (ImageView)view.findViewById(16909094);
                view.setTag(viewHolder);
            } else {
                viewHolder = (ViewHolder)view.getTag();
            }
            viewHolder.text.setText(this.mInfos[n].name);
            viewHolder.icon.setImageDrawable(this.mInfos[n].drawable);
            return view;
        }
    }

    private static class AccountInfo {
        final Drawable drawable;
        final String name;

        AccountInfo(String string2, Drawable drawable2) {
            this.name = string2;
            this.drawable = drawable2;
        }
    }

    private static class ViewHolder {
        ImageView icon;
        TextView text;

        private ViewHolder() {
        }
    }
}

