/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.KeyframeSet;
import android.animation.Keyframes;
import android.animation.ObjectAnimator;
import android.animation.PathKeyframes;
import android.animation.PropertyValuesHolder;
import android.animation.StateListAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.PathParser;
import android.util.StateSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.InflateException;
import android.view.animation.AnimationUtils;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatorInflater {
    private static final boolean DBG_ANIMATOR_INFLATER = false;
    private static final int SEQUENTIALLY = 1;
    private static final String TAG = "AnimatorInflater";
    private static final int TOGETHER = 0;
    private static final int VALUE_TYPE_COLOR = 4;
    private static final int VALUE_TYPE_CUSTOM = 5;
    private static final int VALUE_TYPE_FLOAT = 0;
    private static final int VALUE_TYPE_INT = 1;
    private static final int VALUE_TYPE_PATH = 2;

    private static Animator createAnimatorFromXml(Resources resources, Resources.Theme theme, XmlPullParser xmlPullParser, float f) throws XmlPullParserException, IOException {
        return AnimatorInflater.createAnimatorFromXml(resources, theme, xmlPullParser, Xml.asAttributeSet(xmlPullParser), null, 0, f);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static Animator createAnimatorFromXml(Resources resources, Resources.Theme theme, XmlPullParser xmlPullParser, AttributeSet attributeSet, AnimatorSet animatorSet, int n, float f) throws XmlPullParserException, IOException {
        void var7_8;
        int n2;
        Object var7_7 = null;
        ArrayList<void> arrayList = null;
        int n3 = xmlPullParser.getDepth();
        while (((n2 = xmlPullParser.next()) != 3 || xmlPullParser.getDepth() > n3) && n2 != 1) {
            void var7_10;
            if (n2 != 2) continue;
            String string2 = xmlPullParser.getName();
            if (string2.equals("objectAnimator")) {
                ObjectAnimator objectAnimator = AnimatorInflater.loadObjectAnimator(resources, theme, attributeSet, f);
            } else if (string2.equals("animator")) {
                ValueAnimator valueAnimator = AnimatorInflater.loadAnimator(resources, theme, attributeSet, null, f);
            } else {
                if (!string2.equals("set")) {
                    throw new RuntimeException("Unknown animator name: " + xmlPullParser.getName());
                }
                AnimatorSet animatorSet2 = new AnimatorSet();
                TypedArray typedArray = theme != null ? theme.obtainStyledAttributes(attributeSet, R.styleable.AnimatorSet, 0, 0) : resources.obtainAttributes(attributeSet, R.styleable.AnimatorSet);
                int n4 = typedArray.getInt(0, 0);
                AnimatorInflater.createAnimatorFromXml(resources, theme, xmlPullParser, attributeSet, animatorSet2, n4, f);
                typedArray.recycle();
            }
            if (animatorSet == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<void>();
            }
            arrayList.add(var7_10);
        }
        if (animatorSet != null && arrayList != null) {
            Animator[] animatorArray = new Animator[arrayList.size()];
            int n5 = 0;
            for (Animator animator2 : arrayList) {
                int n6 = n5 + 1;
                animatorArray[n5] = animator2;
                n5 = n6;
            }
            if (n != 0) {
                animatorSet.playSequentially(animatorArray);
                return var7_8;
            }
            animatorSet.playTogether(animatorArray);
        }
        return var7_8;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static StateListAnimator createStateListAnimatorFromXml(Context context, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws IOException, XmlPullParserException {
        StateListAnimator stateListAnimator = new StateListAnimator();
        block4: while (true) {
            switch (xmlPullParser.next()) {
                default: {
                    continue block4;
                }
                case 1: 
                case 3: {
                    return stateListAnimator;
                }
                case 2: 
            }
            Animator animator2 = null;
            if (!"item".equals(xmlPullParser.getName())) continue;
            int n = xmlPullParser.getAttributeCount();
            int[] nArray = new int[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3;
                int n4 = attributeSet.getAttributeNameResource(i);
                if (n4 == 16843213) {
                    animator2 = AnimatorInflater.loadAnimator(context, attributeSet.getAttributeResourceValue(i, 0));
                    n3 = n2;
                } else {
                    n3 = n2 + 1;
                    if (!attributeSet.getAttributeBooleanValue(i, false)) {
                        n4 = -n4;
                    }
                    nArray[n2] = n4;
                }
                n2 = n3;
            }
            if (animator2 == null) {
                animator2 = AnimatorInflater.createAnimatorFromXml(context.getResources(), context.getTheme(), xmlPullParser, 1.0f);
            }
            if (animator2 == null) {
                throw new Resources.NotFoundException("animation state item must have a valid animation");
            }
            stateListAnimator.addState(StateSet.trimStateSet(nArray, n2), animator2);
        }
    }

    public static Animator loadAnimator(Context context, int n) throws Resources.NotFoundException {
        return AnimatorInflater.loadAnimator(context.getResources(), context.getTheme(), n);
    }

    public static Animator loadAnimator(Resources resources, Resources.Theme theme, int n) throws Resources.NotFoundException {
        return AnimatorInflater.loadAnimator(resources, theme, n, 1.0f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Animator loadAnimator(Resources resources, Resources.Theme theme, int n, float f) throws Resources.NotFoundException {
        XmlResourceParser xmlResourceParser = null;
        try {
            xmlResourceParser = resources.getAnimation(n);
            Animator animator2 = AnimatorInflater.createAnimatorFromXml(resources, theme, xmlResourceParser, f);
            return animator2;
        }
        catch (XmlPullParserException xmlPullParserException) {
            Resources.NotFoundException notFoundException = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(xmlPullParserException);
            throw notFoundException;
        }
        catch (IOException iOException) {
            Resources.NotFoundException notFoundException = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(iOException);
            throw notFoundException;
        }
        finally {
            if (xmlResourceParser != null) {
                xmlResourceParser.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ValueAnimator loadAnimator(Resources resources, Resources.Theme theme, AttributeSet attributeSet, ValueAnimator valueAnimator, float f) throws Resources.NotFoundException {
        TypedArray typedArray = theme != null ? theme.obtainStyledAttributes(attributeSet, R.styleable.Animator, 0, 0) : resources.obtainAttributes(attributeSet, R.styleable.Animator);
        TypedArray typedArray2 = null;
        if (valueAnimator != null) {
            typedArray2 = theme != null ? theme.obtainStyledAttributes(attributeSet, R.styleable.PropertyAnimator, 0, 0) : resources.obtainAttributes(attributeSet, R.styleable.PropertyAnimator);
        }
        if (valueAnimator == null) {
            valueAnimator = new ValueAnimator();
        }
        AnimatorInflater.parseAnimatorFromTypeArray(valueAnimator, typedArray, typedArray2, f);
        int n = typedArray.getResourceId(0, 0);
        if (n > 0) {
            valueAnimator.setInterpolator(AnimationUtils.loadInterpolator(resources, theme, n));
        }
        typedArray.recycle();
        if (typedArray2 != null) {
            typedArray2.recycle();
        }
        return valueAnimator;
    }

    private static ObjectAnimator loadObjectAnimator(Resources resources, Resources.Theme theme, AttributeSet attributeSet, float f) throws Resources.NotFoundException {
        ObjectAnimator objectAnimator = new ObjectAnimator();
        AnimatorInflater.loadAnimator(resources, theme, attributeSet, objectAnimator, f);
        return objectAnimator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StateListAnimator loadStateListAnimator(Context context, int n) throws Resources.NotFoundException {
        XmlResourceParser xmlResourceParser = null;
        try {
            xmlResourceParser = context.getResources().getAnimation(n);
            StateListAnimator stateListAnimator = AnimatorInflater.createStateListAnimatorFromXml(context, xmlResourceParser, Xml.asAttributeSet(xmlResourceParser));
            return stateListAnimator;
        }
        catch (XmlPullParserException xmlPullParserException) {
            Resources.NotFoundException notFoundException = new Resources.NotFoundException("Can't load state list animator resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(xmlPullParserException);
            throw notFoundException;
        }
        catch (IOException iOException) {
            Resources.NotFoundException notFoundException = new Resources.NotFoundException("Can't load state list animator resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(iOException);
            throw notFoundException;
        }
        finally {
            if (xmlResourceParser != null) {
                xmlResourceParser.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseAnimatorFromTypeArray(ValueAnimator valueAnimator, TypedArray typedArray, TypedArray typedArray2, float f) {
        TypeEvaluator typeEvaluator;
        boolean bl;
        long l;
        long l2;
        block8: {
            int n;
            boolean bl2;
            int n2;
            boolean bl3;
            block10: {
                block9: {
                    block7: {
                        l2 = typedArray.getInt(1, 300);
                        l = typedArray.getInt(2, 0);
                        int n3 = typedArray.getInt(7, 0);
                        bl = n3 == 0;
                        TypedValue typedValue = typedArray.peekValue(5);
                        bl3 = typedValue != null;
                        n2 = bl3 ? typedValue.type : 0;
                        TypedValue typedValue2 = typedArray.peekValue(6);
                        bl2 = typedValue2 != null;
                        n = bl2 ? typedValue2.type : 0;
                        if (n3 != 2) break block7;
                        typeEvaluator = AnimatorInflater.setupAnimatorForPath(valueAnimator, typedArray);
                        break block8;
                    }
                    if (bl3 && n2 >= 28 && n2 <= 31) break block9;
                    typeEvaluator = null;
                    if (!bl2) break block10;
                    typeEvaluator = null;
                    if (n < 28) break block10;
                    typeEvaluator = null;
                    if (n > 31) break block10;
                }
                bl = false;
                typeEvaluator = ArgbEvaluator.getInstance();
            }
            AnimatorInflater.setupValues(valueAnimator, typedArray, bl, bl3, n2, bl2, n);
        }
        valueAnimator.setDuration(l2);
        valueAnimator.setStartDelay(l);
        if (typedArray.hasValue(3)) {
            valueAnimator.setRepeatCount(typedArray.getInt(3, 0));
        }
        if (typedArray.hasValue(4)) {
            valueAnimator.setRepeatMode(typedArray.getInt(4, 1));
        }
        if (typeEvaluator != null) {
            valueAnimator.setEvaluator(typeEvaluator);
        }
        if (typedArray2 != null) {
            AnimatorInflater.setupObjectAnimator(valueAnimator, typedArray2, bl, f);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TypeEvaluator setupAnimatorForPath(ValueAnimator valueAnimator, TypedArray typedArray) {
        String string2 = typedArray.getString(5);
        String string3 = typedArray.getString(6);
        PathParser.PathDataNode[] pathDataNodeArray = PathParser.createNodesFromPathData(string2);
        PathParser.PathDataNode[] pathDataNodeArray2 = PathParser.createNodesFromPathData(string3);
        if (pathDataNodeArray != null) {
            if (pathDataNodeArray2 != null) {
                valueAnimator.setObjectValues(pathDataNodeArray, pathDataNodeArray2);
                if (PathParser.canMorph(pathDataNodeArray, pathDataNodeArray2)) return new PathDataEvaluator(PathParser.deepCopyNodes(pathDataNodeArray));
                throw new InflateException(typedArray.getPositionDescription() + " Can't morph from " + string2 + " to " + string3);
            }
            valueAnimator.setObjectValues(new Object[]{pathDataNodeArray});
            return new PathDataEvaluator(PathParser.deepCopyNodes(pathDataNodeArray));
        }
        PathDataEvaluator pathDataEvaluator = null;
        if (pathDataNodeArray2 == null) return pathDataEvaluator;
        valueAnimator.setObjectValues(new Object[]{pathDataNodeArray2});
        return new PathDataEvaluator(PathParser.deepCopyNodes(pathDataNodeArray2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static void setupObjectAnimator(ValueAnimator valueAnimator, TypedArray typedArray, boolean bl, float f) {
        ObjectAnimator objectAnimator = (ObjectAnimator)valueAnimator;
        String string2 = typedArray.getString(1);
        if (string2 == null) {
            objectAnimator.setPropertyName(typedArray.getString(0));
            return;
        }
        String string3 = typedArray.getString(2);
        String string4 = typedArray.getString(3);
        if (string3 == null && string4 == null) {
            throw new InflateException(typedArray.getPositionDescription() + " propertyXName or propertyYName is needed for PathData");
        }
        PathKeyframes pathKeyframes = KeyframeSet.ofPath(PathParser.createPathFromPathData(string2), 0.5f * f);
        if (bl) {
            Keyframes.FloatKeyframes floatKeyframes = pathKeyframes.createXFloatKeyframes();
            Keyframes.FloatKeyframes floatKeyframes2 = pathKeyframes.createYFloatKeyframes();
        } else {
            Keyframes.IntKeyframes intKeyframes = pathKeyframes.createXIntKeyframes();
            Keyframes.IntKeyframes intKeyframes2 = pathKeyframes.createYIntKeyframes();
        }
        PropertyValuesHolder propertyValuesHolder = null;
        if (string3 != null) {
            void var9_10;
            propertyValuesHolder = PropertyValuesHolder.ofKeyframes(string3, (Keyframes)var9_10);
        }
        PropertyValuesHolder propertyValuesHolder2 = null;
        if (string4 != null) {
            void var10_13;
            propertyValuesHolder2 = PropertyValuesHolder.ofKeyframes(string4, (Keyframes)var10_13);
        }
        if (propertyValuesHolder == null) {
            objectAnimator.setValues(propertyValuesHolder2);
            return;
        }
        if (propertyValuesHolder2 == null) {
            objectAnimator.setValues(propertyValuesHolder);
            return;
        }
        objectAnimator.setValues(propertyValuesHolder, propertyValuesHolder2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void setupValues(ValueAnimator valueAnimator, TypedArray typedArray, boolean bl, boolean bl2, int n, boolean bl3, int n2) {
        if (bl) {
            if (bl2) {
                float f = n == 5 ? typedArray.getDimension(5, 0.0f) : typedArray.getFloat(5, 0.0f);
                if (!bl3) {
                    valueAnimator.setFloatValues(f);
                    return;
                }
                float f2 = n2 == 5 ? typedArray.getDimension(6, 0.0f) : typedArray.getFloat(6, 0.0f);
                valueAnimator.setFloatValues(f, f2);
                return;
            } else {
                float f = n2 == 5 ? typedArray.getDimension(6, 0.0f) : typedArray.getFloat(6, 0.0f);
                valueAnimator.setFloatValues(f);
                return;
            }
        }
        if (bl2) {
            int n3 = n == 5 ? (int)typedArray.getDimension(5, 0.0f) : (n >= 28 && n <= 31 ? typedArray.getColor(5, 0) : typedArray.getInt(5, 0));
            if (!bl3) {
                valueAnimator.setIntValues(n3);
                return;
            }
            int n4 = n2 == 5 ? (int)typedArray.getDimension(6, 0.0f) : (n2 >= 28 && n2 <= 31 ? typedArray.getColor(6, 0) : typedArray.getInt(6, 0));
            valueAnimator.setIntValues(n3, n4);
            return;
        }
        if (!bl3) return;
        int n5 = n2 == 5 ? (int)typedArray.getDimension(6, 0.0f) : (n2 >= 28 && n2 <= 31 ? typedArray.getColor(6, 0) : typedArray.getInt(6, 0));
        valueAnimator.setIntValues(n5);
    }

    private static class PathDataEvaluator
    implements TypeEvaluator<PathParser.PathDataNode[]> {
        private PathParser.PathDataNode[] mNodeArray;

        private PathDataEvaluator() {
        }

        public PathDataEvaluator(PathParser.PathDataNode[] pathDataNodeArray) {
            this.mNodeArray = pathDataNodeArray;
        }

        @Override
        public PathParser.PathDataNode[] evaluate(float f, PathParser.PathDataNode[] pathDataNodeArray, PathParser.PathDataNode[] pathDataNodeArray2) {
            if (!PathParser.canMorph(pathDataNodeArray, pathDataNodeArray2)) {
                throw new IllegalArgumentException("Can't interpolate between two incompatible pathData");
            }
            if (this.mNodeArray == null || !PathParser.canMorph(this.mNodeArray, pathDataNodeArray)) {
                this.mNodeArray = PathParser.deepCopyNodes(pathDataNodeArray);
            }
            for (int i = 0; i < pathDataNodeArray.length; ++i) {
                this.mNodeArray[i].interpolatePathDataNode(pathDataNodeArray[i], pathDataNodeArray2[i], f);
            }
            return this.mNodeArray;
        }
    }
}

