/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.KeyframeSet;
import android.animation.Keyframes;
import android.animation.PathKeyframes;
import android.animation.PropertyValuesHolder;
import android.animation.TypeConverter;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.graphics.Path;
import android.graphics.PointF;
import android.util.Property;
import java.lang.ref.WeakReference;

public final class ObjectAnimator
extends ValueAnimator {
    private static final boolean DBG = false;
    private static final String LOG_TAG = "ObjectAnimator";
    private boolean mAutoCancel = false;
    private Property mProperty;
    private String mPropertyName;
    private WeakReference<Object> mTarget;

    public ObjectAnimator() {
    }

    private <T> ObjectAnimator(T t, Property<T, ?> property) {
        this.setTarget(t);
        this.setProperty(property);
    }

    private ObjectAnimator(Object object, String string2) {
        this.setTarget(object);
        this.setPropertyName(string2);
    }

    private boolean hasSameTargetAndProperties(Animator animator2) {
        if (animator2 instanceof ObjectAnimator) {
            PropertyValuesHolder[] propertyValuesHolderArray = ((ObjectAnimator)animator2).getValues();
            if (((ObjectAnimator)animator2).getTarget() == this.getTarget() && this.mValues.length == propertyValuesHolderArray.length) {
                for (int i = 0; i < this.mValues.length; ++i) {
                    PropertyValuesHolder propertyValuesHolder = this.mValues[i];
                    PropertyValuesHolder propertyValuesHolder2 = propertyValuesHolderArray[i];
                    if (propertyValuesHolder.getPropertyName() != null && propertyValuesHolder.getPropertyName().equals(propertyValuesHolder2.getPropertyName())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static <T> ObjectAnimator ofArgb(T t, Property<T, Integer> property, int ... nArray) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofInt(t, property, nArray);
        objectAnimator.setEvaluator(ArgbEvaluator.getInstance());
        return objectAnimator;
    }

    public static ObjectAnimator ofArgb(Object object, String string2, int ... nArray) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofInt(object, string2, nArray);
        objectAnimator.setEvaluator(ArgbEvaluator.getInstance());
        return objectAnimator;
    }

    public static <T> ObjectAnimator ofFloat(T t, Property<T, Float> property, Property<T, Float> property2, Path path) {
        PathKeyframes pathKeyframes = KeyframeSet.ofPath(path);
        return ObjectAnimator.ofPropertyValuesHolder(t, PropertyValuesHolder.ofKeyframes(property, (Keyframes)pathKeyframes.createXFloatKeyframes()), PropertyValuesHolder.ofKeyframes(property2, (Keyframes)pathKeyframes.createYFloatKeyframes()));
    }

    public static <T> ObjectAnimator ofFloat(T t, Property<T, Float> property, float ... fArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(t, property);
        objectAnimator.setFloatValues(fArray);
        return objectAnimator;
    }

    public static ObjectAnimator ofFloat(Object object, String string2, String string3, Path path) {
        PathKeyframes pathKeyframes = KeyframeSet.ofPath(path);
        return ObjectAnimator.ofPropertyValuesHolder(object, PropertyValuesHolder.ofKeyframes(string2, (Keyframes)pathKeyframes.createXFloatKeyframes()), PropertyValuesHolder.ofKeyframes(string3, (Keyframes)pathKeyframes.createYFloatKeyframes()));
    }

    public static ObjectAnimator ofFloat(Object object, String string2, float ... fArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(object, string2);
        objectAnimator.setFloatValues(fArray);
        return objectAnimator;
    }

    public static <T> ObjectAnimator ofInt(T t, Property<T, Integer> property, Property<T, Integer> property2, Path path) {
        PathKeyframes pathKeyframes = KeyframeSet.ofPath(path);
        return ObjectAnimator.ofPropertyValuesHolder(t, PropertyValuesHolder.ofKeyframes(property, (Keyframes)pathKeyframes.createXIntKeyframes()), PropertyValuesHolder.ofKeyframes(property2, (Keyframes)pathKeyframes.createYIntKeyframes()));
    }

    public static <T> ObjectAnimator ofInt(T t, Property<T, Integer> property, int ... nArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(t, property);
        objectAnimator.setIntValues(nArray);
        return objectAnimator;
    }

    public static ObjectAnimator ofInt(Object object, String string2, String string3, Path path) {
        PathKeyframes pathKeyframes = KeyframeSet.ofPath(path);
        return ObjectAnimator.ofPropertyValuesHolder(object, PropertyValuesHolder.ofKeyframes(string2, (Keyframes)pathKeyframes.createXIntKeyframes()), PropertyValuesHolder.ofKeyframes(string3, (Keyframes)pathKeyframes.createYIntKeyframes()));
    }

    public static ObjectAnimator ofInt(Object object, String string2, int ... nArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(object, string2);
        objectAnimator.setIntValues(nArray);
        return objectAnimator;
    }

    public static <T> ObjectAnimator ofMultiFloat(Object object, String string2, TypeConverter<T, float[]> typeConverter, TypeEvaluator<T> typeEvaluator, T ... TArray) {
        return ObjectAnimator.ofPropertyValuesHolder(object, PropertyValuesHolder.ofMultiFloat(string2, typeConverter, typeEvaluator, TArray));
    }

    public static ObjectAnimator ofMultiFloat(Object object, String string2, Path path) {
        return ObjectAnimator.ofPropertyValuesHolder(object, PropertyValuesHolder.ofMultiFloat(string2, path));
    }

    public static ObjectAnimator ofMultiFloat(Object object, String string2, float[][] fArray) {
        return ObjectAnimator.ofPropertyValuesHolder(object, PropertyValuesHolder.ofMultiFloat(string2, fArray));
    }

    public static <T> ObjectAnimator ofMultiInt(Object object, String string2, TypeConverter<T, int[]> typeConverter, TypeEvaluator<T> typeEvaluator, T ... TArray) {
        return ObjectAnimator.ofPropertyValuesHolder(object, PropertyValuesHolder.ofMultiInt(string2, typeConverter, typeEvaluator, TArray));
    }

    public static ObjectAnimator ofMultiInt(Object object, String string2, Path path) {
        return ObjectAnimator.ofPropertyValuesHolder(object, PropertyValuesHolder.ofMultiInt(string2, path));
    }

    public static ObjectAnimator ofMultiInt(Object object, String string2, int[][] nArray) {
        return ObjectAnimator.ofPropertyValuesHolder(object, PropertyValuesHolder.ofMultiInt(string2, nArray));
    }

    public static <T, V, P> ObjectAnimator ofObject(T t, Property<T, P> property, TypeConverter<V, P> typeConverter, TypeEvaluator<V> typeEvaluator, V ... VArray) {
        return ObjectAnimator.ofPropertyValuesHolder(t, PropertyValuesHolder.ofObject(property, typeConverter, typeEvaluator, VArray));
    }

    public static <T, V> ObjectAnimator ofObject(T t, Property<T, V> property, TypeConverter<PointF, V> typeConverter, Path path) {
        return ObjectAnimator.ofPropertyValuesHolder(t, PropertyValuesHolder.ofObject(property, typeConverter, path));
    }

    public static <T, V> ObjectAnimator ofObject(T t, Property<T, V> property, TypeEvaluator<V> typeEvaluator, V ... VArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(t, property);
        objectAnimator.setObjectValues(VArray);
        objectAnimator.setEvaluator(typeEvaluator);
        return objectAnimator;
    }

    public static ObjectAnimator ofObject(Object object, String string2, TypeConverter<PointF, ?> typeConverter, Path path) {
        return ObjectAnimator.ofPropertyValuesHolder(object, PropertyValuesHolder.ofObject(string2, typeConverter, path));
    }

    public static ObjectAnimator ofObject(Object object, String string2, TypeEvaluator typeEvaluator, Object ... objectArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(object, string2);
        objectAnimator.setObjectValues(objectArray);
        objectAnimator.setEvaluator(typeEvaluator);
        return objectAnimator;
    }

    public static ObjectAnimator ofPropertyValuesHolder(Object object, PropertyValuesHolder ... propertyValuesHolderArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator();
        objectAnimator.setTarget(object);
        objectAnimator.setValues(propertyValuesHolderArray);
        return objectAnimator;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void animateValue(float f) {
        Object object = this.getTarget();
        if (this.mTarget != null && object == null) {
            this.cancel();
            return;
        } else {
            super.animateValue(f);
            int n = this.mValues.length;
            for (int i = 0; i < n; ++i) {
                this.mValues[i].setAnimatedValue(object);
            }
        }
    }

    @Override
    public ObjectAnimator clone() {
        return (ObjectAnimator)super.clone();
    }

    @Override
    String getNameForTrace() {
        return "animator:" + this.getPropertyName();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getPropertyName() {
        if (this.mPropertyName != null) {
            return this.mPropertyName;
        }
        if (this.mProperty != null) {
            return this.mProperty.getName();
        }
        PropertyValuesHolder[] propertyValuesHolderArray = this.mValues;
        String string2 = null;
        if (propertyValuesHolderArray == null) return string2;
        int n = this.mValues.length;
        string2 = null;
        if (n <= 0) return string2;
        int n2 = 0;
        while (n2 < this.mValues.length) {
            String string3 = n2 == 0 ? "" : string2 + ",";
            string2 = string3 + this.mValues[n2].getPropertyName();
            ++n2;
        }
        return string2;
    }

    public Object getTarget() {
        if (this.mTarget == null) {
            return null;
        }
        return this.mTarget.get();
    }

    @Override
    void initAnimation() {
        if (!this.mInitialized) {
            Object object = this.getTarget();
            if (object != null) {
                int n = this.mValues.length;
                for (int i = 0; i < n; ++i) {
                    this.mValues[i].setupSetterAndGetter(object);
                }
            }
            super.initAnimation();
        }
    }

    public void setAutoCancel(boolean bl) {
        this.mAutoCancel = bl;
    }

    @Override
    public ObjectAnimator setDuration(long l) {
        super.setDuration(l);
        return this;
    }

    @Override
    public void setFloatValues(float ... fArray) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                PropertyValuesHolder[] propertyValuesHolderArray = new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat(this.mProperty, fArray)};
                this.setValues(propertyValuesHolderArray);
                return;
            }
            PropertyValuesHolder[] propertyValuesHolderArray = new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat(this.mPropertyName, fArray)};
            this.setValues(propertyValuesHolderArray);
            return;
        }
        super.setFloatValues(fArray);
    }

    @Override
    public void setIntValues(int ... nArray) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                PropertyValuesHolder[] propertyValuesHolderArray = new PropertyValuesHolder[]{PropertyValuesHolder.ofInt(this.mProperty, nArray)};
                this.setValues(propertyValuesHolderArray);
                return;
            }
            PropertyValuesHolder[] propertyValuesHolderArray = new PropertyValuesHolder[]{PropertyValuesHolder.ofInt(this.mPropertyName, nArray)};
            this.setValues(propertyValuesHolderArray);
            return;
        }
        super.setIntValues(nArray);
    }

    @Override
    public void setObjectValues(Object ... objectArray) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                PropertyValuesHolder[] propertyValuesHolderArray = new PropertyValuesHolder[]{PropertyValuesHolder.ofObject(this.mProperty, (TypeEvaluator)null, objectArray)};
                this.setValues(propertyValuesHolderArray);
                return;
            }
            PropertyValuesHolder[] propertyValuesHolderArray = new PropertyValuesHolder[]{PropertyValuesHolder.ofObject(this.mPropertyName, (TypeEvaluator)null, objectArray)};
            this.setValues(propertyValuesHolderArray);
            return;
        }
        super.setObjectValues(objectArray);
    }

    public void setProperty(Property property) {
        if (this.mValues != null) {
            PropertyValuesHolder propertyValuesHolder = this.mValues[0];
            String string2 = propertyValuesHolder.getPropertyName();
            propertyValuesHolder.setProperty(property);
            this.mValuesMap.remove(string2);
            this.mValuesMap.put(this.mPropertyName, propertyValuesHolder);
        }
        if (this.mProperty != null) {
            this.mPropertyName = property.getName();
        }
        this.mProperty = property;
        this.mInitialized = false;
    }

    public void setPropertyName(String string2) {
        if (this.mValues != null) {
            PropertyValuesHolder propertyValuesHolder = this.mValues[0];
            String string3 = propertyValuesHolder.getPropertyName();
            propertyValuesHolder.setPropertyName(string2);
            this.mValuesMap.remove(string3);
            this.mValuesMap.put(string2, propertyValuesHolder);
        }
        this.mPropertyName = string2;
        this.mInitialized = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setTarget(Object object) {
        if (this.getTarget() != object) {
            WeakReference<Object> weakReference = object == null ? null : new WeakReference<Object>(object);
            this.mTarget = weakReference;
            this.mInitialized = false;
        }
    }

    @Override
    public void setupEndValues() {
        this.initAnimation();
        Object object = this.getTarget();
        if (object != null) {
            int n = this.mValues.length;
            for (int i = 0; i < n; ++i) {
                this.mValues[i].setupEndValue(object);
            }
        }
    }

    @Override
    public void setupStartValues() {
        this.initAnimation();
        Object object = this.getTarget();
        if (object != null) {
            int n = this.mValues.length;
            for (int i = 0; i < n; ++i) {
                this.mValues[i].setupStartValue(object);
            }
        }
    }

    @Override
    public void start() {
        ValueAnimator.AnimationHandler animationHandler = (ValueAnimator.AnimationHandler)sAnimationHandler.get();
        if (animationHandler != null) {
            for (int i = -1 + animationHandler.mAnimations.size(); i >= 0; --i) {
                if (!(animationHandler.mAnimations.get(i) instanceof ObjectAnimator)) continue;
                ObjectAnimator objectAnimator = (ObjectAnimator)animationHandler.mAnimations.get(i);
                if (!objectAnimator.mAutoCancel || !this.hasSameTargetAndProperties(objectAnimator)) continue;
                objectAnimator.cancel();
            }
            for (int i = -1 + animationHandler.mPendingAnimations.size(); i >= 0; --i) {
                if (!(animationHandler.mPendingAnimations.get(i) instanceof ObjectAnimator)) continue;
                ObjectAnimator objectAnimator = (ObjectAnimator)animationHandler.mPendingAnimations.get(i);
                if (!objectAnimator.mAutoCancel || !this.hasSameTargetAndProperties(objectAnimator)) continue;
                objectAnimator.cancel();
            }
            for (int i = -1 + animationHandler.mDelayedAnims.size(); i >= 0; --i) {
                if (!(animationHandler.mDelayedAnims.get(i) instanceof ObjectAnimator)) continue;
                ObjectAnimator objectAnimator = (ObjectAnimator)animationHandler.mDelayedAnims.get(i);
                if (!objectAnimator.mAutoCancel || !this.hasSameTargetAndProperties(objectAnimator)) continue;
                objectAnimator.cancel();
            }
        }
        super.start();
    }

    @Override
    public String toString() {
        String string2 = "ObjectAnimator@" + Integer.toHexString(this.hashCode()) + ", target " + this.getTarget();
        if (this.mValues != null) {
            for (int i = 0; i < this.mValues.length; ++i) {
                string2 = string2 + "\n    " + this.mValues[i].toString();
            }
        }
        return string2;
    }
}

