/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Keyframe;
import android.animation.Keyframes;
import android.animation.TypeEvaluator;
import android.graphics.Path;
import android.graphics.PointF;
import java.util.ArrayList;

class PathKeyframes
implements Keyframes {
    private static final ArrayList<Keyframe> EMPTY_KEYFRAMES = new ArrayList();
    private static final int FRACTION_OFFSET = 0;
    private static final int NUM_COMPONENTS = 3;
    private static final int X_OFFSET = 1;
    private static final int Y_OFFSET = 2;
    private float[] mKeyframeData;
    private PointF mTempPointF = new PointF();

    public PathKeyframes(Path path) {
        this(path, 0.5f);
    }

    public PathKeyframes(Path path, float f) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("The path must not be null or empty");
        }
        this.mKeyframeData = path.approximate(f);
    }

    private static float interpolate(float f, float f2, float f3) {
        return f2 + f * (f3 - f2);
    }

    private PointF interpolateInRange(float f, int n, int n2) {
        int n3 = n * 3;
        int n4 = n2 * 3;
        float f2 = this.mKeyframeData[n3 + 0];
        float f3 = this.mKeyframeData[n4 + 0];
        float f4 = (f - f2) / (f3 - f2);
        float f5 = this.mKeyframeData[n3 + 1];
        float f6 = this.mKeyframeData[n4 + 1];
        float f7 = this.mKeyframeData[n3 + 2];
        float f8 = this.mKeyframeData[n4 + 2];
        float f9 = PathKeyframes.interpolate(f4, f5, f6);
        float f10 = PathKeyframes.interpolate(f4, f7, f8);
        this.mTempPointF.set(f9, f10);
        return this.mTempPointF;
    }

    private PointF pointForIndex(int n) {
        int n2 = n * 3;
        int n3 = n2 + 1;
        int n4 = n2 + 2;
        this.mTempPointF.set(this.mKeyframeData[n3], this.mKeyframeData[n4]);
        return this.mTempPointF;
    }

    @Override
    public Keyframes clone() {
        try {
            Keyframes keyframes = (Keyframes)super.clone();
            return keyframes;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Keyframes.FloatKeyframes createXFloatKeyframes() {
        return new FloatKeyframesBase(){

            @Override
            public float getFloatValue(float f) {
                return ((PointF)PathKeyframes.this.getValue((float)f)).x;
            }
        };
    }

    public Keyframes.IntKeyframes createXIntKeyframes() {
        return new IntKeyframesBase(){

            @Override
            public int getIntValue(float f) {
                return Math.round(((PointF)PathKeyframes.this.getValue((float)f)).x);
            }
        };
    }

    public Keyframes.FloatKeyframes createYFloatKeyframes() {
        return new FloatKeyframesBase(){

            @Override
            public float getFloatValue(float f) {
                return ((PointF)PathKeyframes.this.getValue((float)f)).y;
            }
        };
    }

    public Keyframes.IntKeyframes createYIntKeyframes() {
        return new IntKeyframesBase(){

            @Override
            public int getIntValue(float f) {
                return Math.round(((PointF)PathKeyframes.this.getValue((float)f)).y);
            }
        };
    }

    @Override
    public ArrayList<Keyframe> getKeyframes() {
        return EMPTY_KEYFRAMES;
    }

    @Override
    public Class getType() {
        return PointF.class;
    }

    @Override
    public Object getValue(float f) {
        int n = this.mKeyframeData.length / 3;
        if (f < 0.0f) {
            return this.interpolateInRange(f, 0, 1);
        }
        if (f > 1.0f) {
            return this.interpolateInRange(f, n - 2, n - 1);
        }
        if (f == 0.0f) {
            return this.pointForIndex(0);
        }
        if (f == 1.0f) {
            return this.pointForIndex(n - 1);
        }
        int n2 = 0;
        int n3 = n - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            float f2 = this.mKeyframeData[0 + n4 * 3];
            if (f < f2) {
                n3 = n4 - 1;
                continue;
            }
            if (f > f2) {
                n2 = n4 + 1;
                continue;
            }
            return this.pointForIndex(n4);
        }
        return this.interpolateInRange(f, n3, n2);
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public void setEvaluator(TypeEvaluator typeEvaluator) {
    }

    private static abstract class FloatKeyframesBase
    extends SimpleKeyframes
    implements Keyframes.FloatKeyframes {
        private FloatKeyframesBase() {
        }

        @Override
        public Class getType() {
            return Float.class;
        }

        @Override
        public Object getValue(float f) {
            return Float.valueOf(this.getFloatValue(f));
        }
    }

    private static abstract class IntKeyframesBase
    extends SimpleKeyframes
    implements Keyframes.IntKeyframes {
        private IntKeyframesBase() {
        }

        @Override
        public Class getType() {
            return Integer.class;
        }

        @Override
        public Object getValue(float f) {
            return this.getIntValue(f);
        }
    }

    private static abstract class SimpleKeyframes
    implements Keyframes {
        private SimpleKeyframes() {
        }

        @Override
        public Keyframes clone() {
            try {
                Keyframes keyframes = (Keyframes)super.clone();
                return keyframes;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        @Override
        public ArrayList<Keyframe> getKeyframes() {
            return EMPTY_KEYFRAMES;
        }

        @Override
        public void invalidateCache() {
        }

        @Override
        public void setEvaluator(TypeEvaluator typeEvaluator) {
        }
    }
}

