/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.format.DateUtils;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.DatePicker;
import java.util.Calendar;

public class DatePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
DatePicker.OnDateChangedListener {
    private static final String DAY = "day";
    private static final String MONTH = "month";
    private static final String YEAR = "year";
    private final Calendar mCalendar;
    private final DatePicker mDatePicker;
    private final OnDateSetListener mDateSetListener;
    private boolean mTitleNeedsUpdate = true;
    private final DatePicker.ValidationCallback mValidationCallback = new DatePicker.ValidationCallback(){

        @Override
        public void onValidationChanged(boolean bl) {
            Button button = DatePickerDialog.this.getButton(-1);
            if (button != null) {
                button.setEnabled(bl);
            }
        }
    };

    public DatePickerDialog(Context context, int n, OnDateSetListener onDateSetListener, int n2, int n3, int n4) {
        super(context, DatePickerDialog.resolveDialogTheme(context, n));
        this.mDateSetListener = onDateSetListener;
        this.mCalendar = Calendar.getInstance();
        Context context2 = this.getContext();
        View view = LayoutInflater.from(context2).inflate(17367131, null);
        this.setView(view);
        this.setButton(-1, (CharSequence)context2.getString(17039370), this);
        this.setButton(-2, (CharSequence)context2.getString(0x1040000), this);
        this.setButtonPanelLayoutHint(1);
        this.mDatePicker = (DatePicker)view.findViewById(16909096);
        this.mDatePicker.init(n2, n3, n4, this);
        this.mDatePicker.setValidationCallback(this.mValidationCallback);
    }

    public DatePickerDialog(Context context, OnDateSetListener onDateSetListener, int n, int n2, int n3) {
        this(context, 0, onDateSetListener, n, n2, n3);
    }

    static int resolveDialogTheme(Context context, int n) {
        if (n == 0) {
            TypedValue typedValue = new TypedValue();
            context.getTheme().resolveAttribute(16843948, typedValue, true);
            n = typedValue.resourceId;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateTitle(int n, int n2, int n3) {
        if (!this.mDatePicker.getCalendarViewShown()) {
            this.mCalendar.set(1, n);
            this.mCalendar.set(2, n2);
            this.mCalendar.set(5, n3);
            this.setTitle(DateUtils.formatDateTime(this.mContext, this.mCalendar.getTimeInMillis(), 98326));
            this.mTitleNeedsUpdate = true;
            return;
        } else {
            if (!this.mTitleNeedsUpdate) return;
            this.mTitleNeedsUpdate = false;
            this.setTitle(17040593);
            return;
        }
    }

    public DatePicker getDatePicker() {
        return this.mDatePicker;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        switch (n) {
            case -1: {
                if (this.mDateSetListener != null) {
                    this.mDateSetListener.onDateSet(this.mDatePicker, this.mDatePicker.getYear(), this.mDatePicker.getMonth(), this.mDatePicker.getDayOfMonth());
                    return;
                }
            }
            default: {
                return;
            }
            case -2: 
        }
        this.cancel();
    }

    @Override
    public void onDateChanged(DatePicker datePicker, int n, int n2, int n3) {
        this.mDatePicker.init(n, n2, n3, this);
        this.updateTitle(n, n2, n3);
    }

    @Override
    public void onRestoreInstanceState(Bundle bundle) {
        super.onRestoreInstanceState(bundle);
        int n = bundle.getInt(YEAR);
        int n2 = bundle.getInt(MONTH);
        int n3 = bundle.getInt(DAY);
        this.mDatePicker.init(n, n2, n3, this);
    }

    @Override
    public Bundle onSaveInstanceState() {
        Bundle bundle = super.onSaveInstanceState();
        bundle.putInt(YEAR, this.mDatePicker.getYear());
        bundle.putInt(MONTH, this.mDatePicker.getMonth());
        bundle.putInt(DAY, this.mDatePicker.getDayOfMonth());
        return bundle;
    }

    public void updateDate(int n, int n2, int n3) {
        this.mDatePicker.updateDate(n, n2, n3);
    }

    public static interface OnDateSetListener {
        public void onDateSet(DatePicker var1, int var2, int var3, int var4);
    }
}

