/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.ActivityOptions;
import android.app.ActivityTransitionCoordinator;
import android.app.SharedElementCallback;
import android.content.Intent;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.ResultReceiver;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import java.util.ArrayList;

class ExitTransitionCoordinator
extends ActivityTransitionCoordinator {
    private static final long MAX_WAIT_MS = 1000L;
    private static final String TAG = "ExitTransitionCoordinator";
    private Activity mActivity;
    private ObjectAnimator mBackgroundAnimator;
    private boolean mExitComplete;
    private boolean mExitNotified;
    private Bundle mExitSharedElementBundle;
    private Handler mHandler;
    private boolean mIsBackgroundReady;
    private boolean mIsCanceled;
    private boolean mIsExitStarted;
    private boolean mIsHidden;
    private Bundle mSharedElementBundle;
    private boolean mSharedElementNotified;
    private boolean mSharedElementsHidden;

    /*
     * Enabled aggressive block sorting
     */
    public ExitTransitionCoordinator(Activity activity, ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<View> arrayList3, boolean bl) {
        super(activity.getWindow(), arrayList, ExitTransitionCoordinator.getListener(activity, bl), bl);
        this.viewsReady(this.mapSharedElements(arrayList2, arrayList3));
        this.stripOffscreenViews();
        boolean bl2 = !bl;
        this.mIsBackgroundReady = bl2;
        this.mActivity = activity;
    }

    static /* synthetic */ boolean access$1002(ExitTransitionCoordinator exitTransitionCoordinator, boolean bl) {
        exitTransitionCoordinator.mIsBackgroundReady = bl;
        return bl;
    }

    static /* synthetic */ boolean access$502(ExitTransitionCoordinator exitTransitionCoordinator, boolean bl) {
        exitTransitionCoordinator.mIsCanceled = bl;
        return bl;
    }

    static /* synthetic */ ObjectAnimator access$902(ExitTransitionCoordinator exitTransitionCoordinator, ObjectAnimator objectAnimator) {
        exitTransitionCoordinator.mBackgroundAnimator = objectAnimator;
        return objectAnimator;
    }

    private void beginTransitions() {
        Transition transition2 = ExitTransitionCoordinator.mergeTransitions(this.getSharedElementExitTransition(), this.getExitTransition());
        ViewGroup viewGroup = this.getDecor();
        if (transition2 != null && viewGroup != null) {
            this.setGhostVisibility(4);
            this.scheduleGhostVisibilityChange(4);
            TransitionManager.beginDelayedTransition(viewGroup, transition2);
            this.scheduleGhostVisibilityChange(0);
            this.setGhostVisibility(0);
            viewGroup.invalidate();
            return;
        }
        this.transitionStarted();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Bundle captureExitSharedElementsState() {
        Bundle bundle = new Bundle();
        RectF rectF = new RectF();
        Matrix matrix = new Matrix();
        int n = 0;
        while (n < this.mSharedElements.size()) {
            String string2 = (String)this.mSharedElementNames.get(n);
            Bundle bundle2 = this.mExitSharedElementBundle.getBundle(string2);
            if (bundle2 != null) {
                bundle.putBundle(string2, bundle2);
            } else {
                this.captureSharedElementState((View)this.mSharedElements.get(n), string2, bundle, matrix, rectF);
            }
            ++n;
        }
        return bundle;
    }

    private void delayCancel() {
        if (this.mHandler != null) {
            this.mHandler.sendEmptyMessageDelayed(106, 1000L);
        }
    }

    private void exitTransitionComplete() {
        this.mExitComplete = true;
        this.notifyComplete();
    }

    private void fadeOutBackground() {
        block3: {
            block2: {
                Drawable drawable2;
                if (this.mBackgroundAnimator != null) break block2;
                ViewGroup viewGroup = this.getDecor();
                if (viewGroup == null || (drawable2 = viewGroup.getBackground()) == null) break block3;
                Drawable drawable3 = drawable2.mutate();
                this.getWindow().setBackgroundDrawable(drawable3);
                this.mBackgroundAnimator = ObjectAnimator.ofInt((Object)drawable3, "alpha", 0);
                this.mBackgroundAnimator.addListener(new AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationEnd(Animator animator2) {
                        ExitTransitionCoordinator.access$902(ExitTransitionCoordinator.this, null);
                        if (!ExitTransitionCoordinator.this.mIsCanceled) {
                            ExitTransitionCoordinator.access$1002(ExitTransitionCoordinator.this, true);
                            ExitTransitionCoordinator.this.notifyComplete();
                        }
                    }
                });
                this.mBackgroundAnimator.setDuration(this.getFadeDuration());
                this.mBackgroundAnimator.start();
            }
            return;
        }
        this.mIsBackgroundReady = true;
    }

    private void finish() {
        this.stopCancel();
        if (this.mActivity != null) {
            this.mActivity.mActivityTransitionState.clear();
            this.mActivity.finish();
            this.mActivity.overridePendingTransition(0, 0);
            this.mActivity = null;
        }
        this.mHandler = null;
        this.mSharedElementBundle = null;
        if (this.mBackgroundAnimator != null) {
            this.mBackgroundAnimator.cancel();
            this.mBackgroundAnimator = null;
        }
        this.mExitSharedElementBundle = null;
        this.clearState();
    }

    private void finishIfNecessary() {
        if (this.mIsReturning && this.mExitNotified && this.mActivity != null && (this.mSharedElements.isEmpty() || this.mSharedElementsHidden)) {
            this.finish();
        }
        if (!this.mIsReturning && this.mExitNotified) {
            this.mActivity = null;
        }
    }

    private Transition getExitTransition() {
        ArrayList arrayList = this.mTransitioningViews;
        Transition transition2 = null;
        if (arrayList != null) {
            boolean bl = this.mTransitioningViews.isEmpty();
            transition2 = null;
            if (!bl) {
                transition2 = this.configureTransition(this.getViewsTransition(), true);
            }
        }
        if (transition2 == null) {
            this.exitTransitionComplete();
            return transition2;
        }
        transition2.addListener(new ActivityTransitionCoordinator.ContinueTransitionListener(){

            @Override
            public void onTransitionEnd(Transition transition2) {
                transition2.removeListener(this);
                ExitTransitionCoordinator.this.exitTransitionComplete();
                if (ExitTransitionCoordinator.this.mIsHidden && mTransitioningViews != null) {
                    ExitTransitionCoordinator.this.showViews(mTransitioningViews, true);
                }
                if (ExitTransitionCoordinator.this.mSharedElementBundle != null) {
                    ExitTransitionCoordinator.this.delayCancel();
                }
                super.onTransitionEnd(transition2);
            }
        });
        transition2.forceVisibility(4, false);
        return transition2;
    }

    private static SharedElementCallback getListener(Activity activity, boolean bl) {
        if (bl) {
            return activity.mEnterTransitionListener;
        }
        return activity.mExitTransitionListener;
    }

    private Transition getSharedElementExitTransition() {
        boolean bl = this.mSharedElements.isEmpty();
        Transition transition2 = null;
        if (!bl) {
            transition2 = this.configureTransition(this.getSharedElementTransition(), false);
        }
        if (transition2 == null) {
            this.sharedElementTransitionComplete();
            return transition2;
        }
        transition2.addListener(new ActivityTransitionCoordinator.ContinueTransitionListener(){

            @Override
            public void onTransitionEnd(Transition transition2) {
                transition2.removeListener(this);
                ExitTransitionCoordinator.this.sharedElementTransitionComplete();
                if (ExitTransitionCoordinator.this.mIsHidden) {
                    ExitTransitionCoordinator.this.showViews(ExitTransitionCoordinator.this.mSharedElements, true);
                }
            }
        });
        ((View)this.mSharedElements.get(0)).invalidate();
        return transition2;
    }

    private void hideSharedElements() {
        this.moveSharedElementsFromOverlay();
        if (!this.mIsHidden) {
            this.hideViews(this.mSharedElements);
        }
        this.mSharedElementsHidden = true;
        this.finishIfNecessary();
    }

    private void sharedElementExitBack() {
        final ViewGroup viewGroup = this.getDecor();
        if (viewGroup != null) {
            viewGroup.suppressLayout(true);
        }
        if (viewGroup != null && this.mExitSharedElementBundle != null && !this.mExitSharedElementBundle.isEmpty() && !this.mSharedElements.isEmpty() && this.getSharedElementTransition() != null) {
            this.startTransition(new Runnable(){

                @Override
                public void run() {
                    ExitTransitionCoordinator.this.startSharedElementExit(viewGroup);
                }
            });
            return;
        }
        this.sharedElementTransitionComplete();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sharedElementTransitionComplete() {
        Bundle bundle = this.mExitSharedElementBundle == null ? this.captureSharedElementState() : this.captureExitSharedElementsState();
        this.mSharedElementBundle = bundle;
        this.notifyComplete();
    }

    private void startExitTransition() {
        Transition transition2 = this.getExitTransition();
        ViewGroup viewGroup = this.getDecor();
        if (transition2 != null && viewGroup != null && this.mTransitioningViews != null) {
            TransitionManager.beginDelayedTransition(viewGroup, transition2);
            ((View)this.mTransitioningViews.get(0)).invalidate();
            return;
        }
        this.transitionStarted();
    }

    private void startSharedElementExit(final ViewGroup viewGroup) {
        Transition transition2 = this.getSharedElementExitTransition();
        transition2.addListener(new Transition.TransitionListenerAdapter(){

            @Override
            public void onTransitionEnd(Transition transition2) {
                transition2.removeListener(this);
                if (ExitTransitionCoordinator.this.mExitComplete) {
                    ExitTransitionCoordinator.this.delayCancel();
                }
            }
        });
        final ArrayList<View> arrayList = this.createSnapshots(this.mExitSharedElementBundle, this.mSharedElementNames);
        viewGroup.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            @Override
            public boolean onPreDraw() {
                viewGroup.getViewTreeObserver().removeOnPreDrawListener(this);
                ExitTransitionCoordinator.this.setSharedElementState(ExitTransitionCoordinator.this.mExitSharedElementBundle, arrayList);
                return true;
            }
        });
        this.setGhostVisibility(4);
        this.scheduleGhostVisibilityChange(4);
        if (this.mListener != null) {
            this.mListener.onSharedElementEnd(this.mSharedElementNames, this.mSharedElements, arrayList);
        }
        TransitionManager.beginDelayedTransition(viewGroup, transition2);
        this.scheduleGhostVisibilityChange(0);
        this.setGhostVisibility(0);
        viewGroup.invalidate();
    }

    private void stopCancel() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(106);
        }
    }

    protected Transition getSharedElementTransition() {
        if (this.mIsReturning) {
            return this.getWindow().getSharedElementReturnTransition();
        }
        return this.getWindow().getSharedElementExitTransition();
    }

    @Override
    protected Transition getViewsTransition() {
        if (this.mIsReturning) {
            return this.getWindow().getReturnTransition();
        }
        return this.getWindow().getExitTransition();
    }

    protected boolean isReadyToNotify() {
        return this.mSharedElementBundle != null && this.mResultReceiver != null && this.mIsBackgroundReady;
    }

    @Override
    protected boolean moveSharedElementWithParent() {
        return !this.mIsReturning;
    }

    protected void notifyComplete() {
        if (this.isReadyToNotify()) {
            if (!this.mSharedElementNotified) {
                this.mSharedElementNotified = true;
                this.delayCancel();
                this.mResultReceiver.send(103, this.mSharedElementBundle);
            }
            if (!this.mExitNotified && this.mExitComplete) {
                this.mExitNotified = true;
                this.mResultReceiver.send(104, null);
                this.mResultReceiver = null;
                ViewGroup viewGroup = this.getDecor();
                if (!this.mIsReturning && viewGroup != null) {
                    viewGroup.suppressLayout(false);
                }
                this.finishIfNecessary();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onReceiveResult(int n, Bundle bundle) {
        switch (n) {
            case 100: {
                this.stopCancel();
                this.mResultReceiver = (ResultReceiver)bundle.getParcelable("android:remoteReceiver");
                if (this.mIsCanceled) {
                    this.mResultReceiver.send(106, null);
                    this.mResultReceiver = null;
                    return;
                }
                this.notifyComplete();
                return;
            }
            case 101: {
                this.stopCancel();
                if (!this.mIsCanceled) {
                    this.hideSharedElements();
                    return;
                }
            }
            default: {
                return;
            }
            case 105: {
                this.mHandler.removeMessages(106);
                this.startExit();
                return;
            }
            case 107: 
        }
        this.mExitSharedElementBundle = bundle;
        this.sharedElementExitBack();
    }

    public void resetViews() {
        if (this.mTransitioningViews != null) {
            this.showViews(this.mTransitioningViews, true);
        }
        this.showViews(this.mSharedElements, true);
        this.mIsHidden = true;
        ViewGroup viewGroup = this.getDecor();
        if (!this.mIsReturning && viewGroup != null) {
            viewGroup.suppressLayout(false);
        }
        this.moveSharedElementsFromOverlay();
        this.clearState();
    }

    public void startExit() {
        if (!this.mIsExitStarted) {
            this.mIsExitStarted = true;
            ViewGroup viewGroup = this.getDecor();
            if (viewGroup != null) {
                viewGroup.suppressLayout(true);
            }
            this.moveSharedElementsToOverlay();
            this.startTransition(new Runnable(){

                @Override
                public void run() {
                    ExitTransitionCoordinator.this.beginTransitions();
                }
            });
        }
    }

    public void startExit(int n, Intent intent) {
        if (!this.mIsExitStarted) {
            this.mIsExitStarted = true;
            ViewGroup viewGroup = this.getDecor();
            if (viewGroup != null) {
                viewGroup.suppressLayout(true);
            }
            this.mHandler = new Handler(){

                @Override
                public void handleMessage(Message message) {
                    ExitTransitionCoordinator.access$502(ExitTransitionCoordinator.this, true);
                    ExitTransitionCoordinator.this.finish();
                }
            };
            this.delayCancel();
            this.moveSharedElementsToOverlay();
            if (viewGroup != null && viewGroup.getBackground() == null) {
                this.getWindow().setBackgroundDrawable(new ColorDrawable(-16777216));
            }
            ActivityOptions activityOptions = ActivityOptions.makeSceneTransitionAnimation(this.mActivity, this, this.mAllSharedElementNames, n, intent);
            this.mActivity.convertToTranslucent(new Activity.TranslucentConversionListener(){

                @Override
                public void onTranslucentConversionComplete(boolean bl) {
                    if (!ExitTransitionCoordinator.this.mIsCanceled) {
                        ExitTransitionCoordinator.this.fadeOutBackground();
                    }
                }
            }, activityOptions);
            this.startTransition(new Runnable(){

                @Override
                public void run() {
                    ExitTransitionCoordinator.this.startExitTransition();
                }
            });
        }
    }

    public void stop() {
        if (this.mIsReturning && this.mActivity != null) {
            this.mActivity.convertToTranslucent(null, null);
            this.finish();
        }
    }
}

