/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.UserHandle;
import android.util.Log;
import java.util.ArrayList;

public class TaskStackBuilder {
    private static final String TAG = "TaskStackBuilder";
    private final ArrayList<Intent> mIntents = new ArrayList();
    private final Context mSourceContext;

    private TaskStackBuilder(Context context) {
        this.mSourceContext = context;
    }

    public static TaskStackBuilder create(Context context) {
        return new TaskStackBuilder(context);
    }

    public TaskStackBuilder addNextIntent(Intent intent) {
        this.mIntents.add(intent);
        return this;
    }

    public TaskStackBuilder addNextIntentWithParentStack(Intent intent) {
        ComponentName componentName = intent.getComponent();
        if (componentName == null) {
            componentName = intent.resolveActivity(this.mSourceContext.getPackageManager());
        }
        if (componentName != null) {
            this.addParentStack(componentName);
        }
        this.addNextIntent(intent);
        return this;
    }

    public TaskStackBuilder addParentStack(Activity activity) {
        Intent intent = activity.getParentActivityIntent();
        if (intent != null) {
            ComponentName componentName = intent.getComponent();
            if (componentName == null) {
                componentName = intent.resolveActivity(this.mSourceContext.getPackageManager());
            }
            this.addParentStack(componentName);
            this.addNextIntent(intent);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TaskStackBuilder addParentStack(ComponentName componentName) {
        int n = this.mIntents.size();
        PackageManager packageManager = this.mSourceContext.getPackageManager();
        try {
            ActivityInfo activityInfo = packageManager.getActivityInfo(componentName, 0);
            String string2 = activityInfo.parentActivityName;
            while (string2 != null) {
                Intent intent;
                ComponentName componentName2 = new ComponentName(activityInfo.packageName, string2);
                activityInfo = packageManager.getActivityInfo(componentName2, 0);
                string2 = activityInfo.parentActivityName;
                Intent intent2 = string2 == null && n == 0 ? Intent.makeMainActivity(componentName2) : (intent = new Intent().setComponent(componentName2));
                this.mIntents.add(n, intent2);
            }
            return this;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e(TAG, "Bad ComponentName while traversing activity parent metadata");
            throw new IllegalArgumentException(nameNotFoundException);
        }
    }

    public TaskStackBuilder addParentStack(Class<?> clazz) {
        return this.addParentStack(new ComponentName(this.mSourceContext, clazz));
    }

    public Intent editIntentAt(int n) {
        return this.mIntents.get(n);
    }

    public int getIntentCount() {
        return this.mIntents.size();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Intent[] getIntents() {
        Intent[] intentArray = new Intent[this.mIntents.size()];
        if (intentArray.length != 0) {
            intentArray[0] = new Intent(this.mIntents.get(0)).addFlags(0x1000C000);
            for (int i = 1; i < intentArray.length; ++i) {
                intentArray[i] = new Intent(this.mIntents.get(i));
            }
        }
        return intentArray;
    }

    public PendingIntent getPendingIntent(int n, int n2) {
        return this.getPendingIntent(n, n2, null);
    }

    public PendingIntent getPendingIntent(int n, int n2, Bundle bundle) {
        if (this.mIntents.isEmpty()) {
            throw new IllegalStateException("No intents added to TaskStackBuilder; cannot getPendingIntent");
        }
        return PendingIntent.getActivities(this.mSourceContext, n, this.getIntents(), n2, bundle);
    }

    public PendingIntent getPendingIntent(int n, int n2, Bundle bundle, UserHandle userHandle) {
        if (this.mIntents.isEmpty()) {
            throw new IllegalStateException("No intents added to TaskStackBuilder; cannot getPendingIntent");
        }
        return PendingIntent.getActivitiesAsUser(this.mSourceContext, n, this.getIntents(), n2, bundle, userHandle);
    }

    public void startActivities() {
        this.startActivities(null);
    }

    public void startActivities(Bundle bundle) {
        this.startActivities(bundle, new UserHandle(UserHandle.myUserId()));
    }

    public void startActivities(Bundle bundle, UserHandle userHandle) {
        if (this.mIntents.isEmpty()) {
            throw new IllegalStateException("No intents added to TaskStackBuilder; cannot startActivities");
        }
        this.mSourceContext.startActivitiesAsUser(this.getIntents(), bundle, userHandle);
    }
}

