/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Printer;
import android.util.SparseArray;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public final class DeviceAdminInfo
implements Parcelable {
    public static final Parcelable.Creator<DeviceAdminInfo> CREATOR;
    static final String TAG = "DeviceAdminInfo";
    public static final int USES_ENCRYPTED_STORAGE = 7;
    public static final int USES_POLICY_DEVICE_OWNER = -2;
    public static final int USES_POLICY_DISABLE_CAMERA = 8;
    public static final int USES_POLICY_DISABLE_KEYGUARD_FEATURES = 9;
    public static final int USES_POLICY_EXPIRE_PASSWORD = 6;
    public static final int USES_POLICY_FORCE_LOCK = 3;
    public static final int USES_POLICY_LIMIT_PASSWORD = 0;
    public static final int USES_POLICY_PROFILE_OWNER = -1;
    public static final int USES_POLICY_RESET_PASSWORD = 2;
    public static final int USES_POLICY_SETS_GLOBAL_PROXY = 5;
    public static final int USES_POLICY_WATCH_LOGIN = 1;
    public static final int USES_POLICY_WIPE_DATA = 4;
    static HashMap<String, Integer> sKnownPolicies;
    static ArrayList<PolicyInfo> sPoliciesDisplayOrder;
    static SparseArray<PolicyInfo> sRevKnownPolicies;
    final ResolveInfo mReceiver;
    int mUsesPolicies;
    boolean mVisible;

    static {
        sPoliciesDisplayOrder = new ArrayList();
        sKnownPolicies = new HashMap();
        sRevKnownPolicies = new SparseArray();
        sPoliciesDisplayOrder.add(new PolicyInfo(4, "wipe-data", 17040147, 17040148));
        sPoliciesDisplayOrder.add(new PolicyInfo(2, "reset-password", 17040143, 17040144));
        sPoliciesDisplayOrder.add(new PolicyInfo(0, "limit-password", 17040139, 17040140));
        sPoliciesDisplayOrder.add(new PolicyInfo(1, "watch-login", 17040141, 17040142));
        sPoliciesDisplayOrder.add(new PolicyInfo(3, "force-lock", 17040145, 17040146));
        sPoliciesDisplayOrder.add(new PolicyInfo(5, "set-global-proxy", 17040149, 17040150));
        sPoliciesDisplayOrder.add(new PolicyInfo(6, "expire-password", 17040151, 17040152));
        sPoliciesDisplayOrder.add(new PolicyInfo(7, "encrypted-storage", 17040153, 17040154));
        sPoliciesDisplayOrder.add(new PolicyInfo(8, "disable-camera", 17040155, 17040156));
        sPoliciesDisplayOrder.add(new PolicyInfo(9, "disable-keyguard-features", 17040157, 17040158));
        for (int i = 0; i < sPoliciesDisplayOrder.size(); ++i) {
            PolicyInfo policyInfo = sPoliciesDisplayOrder.get(i);
            sRevKnownPolicies.put(policyInfo.ident, policyInfo);
            sKnownPolicies.put(policyInfo.tag, policyInfo.ident);
        }
        CREATOR = new Parcelable.Creator<DeviceAdminInfo>(){

            @Override
            public DeviceAdminInfo createFromParcel(Parcel parcel) {
                return new DeviceAdminInfo(parcel);
            }

            public DeviceAdminInfo[] newArray(int n) {
                return new DeviceAdminInfo[n];
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeviceAdminInfo(Context context, ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        int n;
        int n2;
        XmlResourceParser xmlResourceParser;
        block13: {
            int n3;
            this.mReceiver = resolveInfo;
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            PackageManager packageManager = context.getPackageManager();
            xmlResourceParser = null;
            try {
                xmlResourceParser = activityInfo.loadXmlMetaData(packageManager, "android.app.device_admin");
                if (xmlResourceParser == null) {
                    throw new XmlPullParserException("No android.app.device_admin meta-data");
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                throw new XmlPullParserException("Unable to create context for: " + activityInfo.packageName);
            }
            Resources resources = packageManager.getResourcesForApplication(activityInfo.applicationInfo);
            AttributeSet attributeSet = Xml.asAttributeSet(xmlResourceParser);
            while ((n3 = xmlResourceParser.next()) != 1 && n3 != 2) {
            }
            if (!"device-admin".equals(xmlResourceParser.getName())) {
                throw new XmlPullParserException("Meta-data does not start with device-admin tag");
            }
            TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.DeviceAdmin);
            this.mVisible = typedArray.getBoolean(0, true);
            typedArray.recycle();
            n2 = xmlResourceParser.getDepth();
            break block13;
            finally {
                if (xmlResourceParser != null) {
                    xmlResourceParser.close();
                }
            }
        }
        while ((n = xmlResourceParser.next()) != 1 && (n != 3 || xmlResourceParser.getDepth() > n2)) {
            int n4;
            if (n == 3 || n == 4 || !xmlResourceParser.getName().equals("uses-policies")) continue;
            int n5 = xmlResourceParser.getDepth();
            while ((n4 = xmlResourceParser.next()) != 1 && (n4 != 3 || xmlResourceParser.getDepth() > n5)) {
                if (n4 == 3 || n4 == 4) continue;
                String string2 = xmlResourceParser.getName();
                Integer n6 = sKnownPolicies.get(string2);
                if (n6 != null) {
                    this.mUsesPolicies |= 1 << n6;
                    continue;
                }
                Log.w(TAG, "Unknown tag under uses-policies of " + this.getComponent() + ": " + string2);
            }
        }
    }

    DeviceAdminInfo(Parcel parcel) {
        this.mReceiver = ResolveInfo.CREATOR.createFromParcel(parcel);
        this.mUsesPolicies = parcel.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void dump(Printer printer, String string2) {
        printer.println(string2 + "Receiver:");
        this.mReceiver.dump(printer, string2 + "  ");
    }

    public ActivityInfo getActivityInfo() {
        return this.mReceiver.activityInfo;
    }

    public ComponentName getComponent() {
        return new ComponentName(this.mReceiver.activityInfo.packageName, this.mReceiver.activityInfo.name);
    }

    public String getPackageName() {
        return this.mReceiver.activityInfo.packageName;
    }

    public String getReceiverName() {
        return this.mReceiver.activityInfo.name;
    }

    public String getTagForPolicy(int n) {
        return DeviceAdminInfo.sRevKnownPolicies.get((int)n).tag;
    }

    public ArrayList<PolicyInfo> getUsedPolicies() {
        ArrayList<PolicyInfo> arrayList = new ArrayList<PolicyInfo>();
        for (int i = 0; i < sPoliciesDisplayOrder.size(); ++i) {
            PolicyInfo policyInfo = sPoliciesDisplayOrder.get(i);
            if (!this.usesPolicy(policyInfo.ident)) continue;
            arrayList.add(policyInfo);
        }
        return arrayList;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public CharSequence loadDescription(PackageManager packageManager) throws Resources.NotFoundException {
        if (this.mReceiver.activityInfo.descriptionRes != 0) {
            String string2 = this.mReceiver.resolvePackageName;
            ApplicationInfo applicationInfo = null;
            if (string2 == null) {
                string2 = this.mReceiver.activityInfo.packageName;
                applicationInfo = this.mReceiver.activityInfo.applicationInfo;
            }
            return packageManager.getText(string2, this.mReceiver.activityInfo.descriptionRes, applicationInfo);
        }
        throw new Resources.NotFoundException();
    }

    public Drawable loadIcon(PackageManager packageManager) {
        return this.mReceiver.loadIcon(packageManager);
    }

    public CharSequence loadLabel(PackageManager packageManager) {
        return this.mReceiver.loadLabel(packageManager);
    }

    public void readPoliciesFromXml(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        this.mUsesPolicies = Integer.parseInt(xmlPullParser.getAttributeValue(null, "flags"));
    }

    public String toString() {
        return "DeviceAdminInfo{" + this.mReceiver.activityInfo.name + "}";
    }

    public boolean usesPolicy(int n) {
        return (this.mUsesPolicies & 1 << n) != 0;
    }

    public void writePoliciesToXml(XmlSerializer xmlSerializer) throws IllegalArgumentException, IllegalStateException, IOException {
        xmlSerializer.attribute(null, "flags", Integer.toString(this.mUsesPolicies));
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        this.mReceiver.writeToParcel(parcel, n);
        parcel.writeInt(this.mUsesPolicies);
    }

    public static class PolicyInfo {
        public final int description;
        public final int ident;
        public final int label;
        public final String tag;

        public PolicyInfo(int n, String string2, int n2, int n3) {
            this.ident = n;
            this.tag = string2;
            this.label = n2;
            this.description = n3;
        }
    }
}

