/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.IRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreObserver;
import android.app.backup.RestoreSet;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;

public class RestoreSession {
    static final String TAG = "RestoreSession";
    IRestoreSession mBinder;
    final Context mContext;
    RestoreObserverWrapper mObserver = null;

    RestoreSession(Context context, IRestoreSession iRestoreSession) {
        this.mContext = context;
        this.mBinder = iRestoreSession;
    }

    public void endRestoreSession() {
        try {
            this.mBinder.endRestoreSession();
            return;
        }
        catch (RemoteException remoteException) {
            Log.d(TAG, "Can't contact server to get available sets");
            return;
        }
        finally {
            this.mBinder = null;
        }
    }

    public int getAvailableRestoreSets(RestoreObserver restoreObserver) {
        RestoreObserverWrapper restoreObserverWrapper = new RestoreObserverWrapper(this.mContext, restoreObserver);
        try {
            int n = this.mBinder.getAvailableRestoreSets(restoreObserverWrapper);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.d(TAG, "Can't contact server to get available sets");
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int restoreAll(long l, RestoreObserver restoreObserver) {
        int n = -1;
        if (this.mObserver != null) {
            Log.d(TAG, "restoreAll() called during active restore");
            return -1;
        }
        this.mObserver = new RestoreObserverWrapper(this.mContext, restoreObserver);
        try {
            int n2 = this.mBinder.restoreAll(l, this.mObserver);
            return n2;
        }
        catch (RemoteException remoteException) {
            Log.d(TAG, "Can't contact server to restore");
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int restorePackage(String string2, RestoreObserver restoreObserver) {
        int n = -1;
        if (this.mObserver != null) {
            Log.d(TAG, "restorePackage() called during active restore");
            return -1;
        }
        this.mObserver = new RestoreObserverWrapper(this.mContext, restoreObserver);
        try {
            int n2 = this.mBinder.restorePackage(string2, this.mObserver);
            return n2;
        }
        catch (RemoteException remoteException) {
            Log.d(TAG, "Can't contact server to restore package");
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int restoreSome(long l, RestoreObserver restoreObserver, String[] stringArray) {
        int n = -1;
        if (this.mObserver != null) {
            Log.d(TAG, "restoreAll() called during active restore");
            return -1;
        }
        this.mObserver = new RestoreObserverWrapper(this.mContext, restoreObserver);
        try {
            int n2 = this.mBinder.restoreSome(l, this.mObserver, stringArray);
            return n2;
        }
        catch (RemoteException remoteException) {
            Log.d(TAG, "Can't contact server to restore packages");
            return n;
        }
    }

    private class RestoreObserverWrapper
    extends IRestoreObserver.Stub {
        static final int MSG_RESTORE_FINISHED = 3;
        static final int MSG_RESTORE_SETS_AVAILABLE = 4;
        static final int MSG_RESTORE_STARTING = 1;
        static final int MSG_UPDATE = 2;
        final RestoreObserver mAppObserver;
        final Handler mHandler;

        RestoreObserverWrapper(Context context, RestoreObserver restoreObserver) {
            this.mHandler = new Handler(context.getMainLooper()){

                @Override
                public void handleMessage(Message message) {
                    switch (message.what) {
                        default: {
                            return;
                        }
                        case 1: {
                            RestoreObserverWrapper.this.mAppObserver.restoreStarting(message.arg1);
                            return;
                        }
                        case 2: {
                            RestoreObserverWrapper.this.mAppObserver.onUpdate(message.arg1, (String)message.obj);
                            return;
                        }
                        case 3: {
                            RestoreObserverWrapper.this.mAppObserver.restoreFinished(message.arg1);
                            return;
                        }
                        case 4: 
                    }
                    RestoreObserverWrapper.this.mAppObserver.restoreSetsAvailable((RestoreSet[])message.obj);
                }
            };
            this.mAppObserver = restoreObserver;
        }

        @Override
        public void onUpdate(int n, String string2) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, n, 0, string2));
        }

        @Override
        public void restoreFinished(int n) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, n, 0));
        }

        @Override
        public void restoreSetsAvailable(RestoreSet[] restoreSetArray) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(4, restoreSetArray));
        }

        @Override
        public void restoreStarting(int n) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n, 0));
        }
    }
}

