/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.ParcelUuid;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;

public final class BluetoothUuid {
    public static final ParcelUuid AdvAudioDist;
    public static final ParcelUuid AudioSink;
    public static final ParcelUuid AudioSource;
    public static final ParcelUuid AvrcpController;
    public static final ParcelUuid AvrcpTarget;
    public static final ParcelUuid BASE_UUID;
    public static final ParcelUuid BNEP;
    public static final ParcelUuid HSP;
    public static final ParcelUuid HSP_AG;
    public static final ParcelUuid Handsfree;
    public static final ParcelUuid Handsfree_AG;
    public static final ParcelUuid Hid;
    public static final ParcelUuid Hogp;
    public static final ParcelUuid MAP;
    public static final ParcelUuid MAS;
    public static final ParcelUuid MNS;
    public static final ParcelUuid NAP;
    public static final ParcelUuid ObexObjectPush;
    public static final ParcelUuid PANU;
    public static final ParcelUuid PBAP_PCE;
    public static final ParcelUuid PBAP_PSE;
    public static final ParcelUuid[] RESERVED_UUIDS;
    public static final int UUID_BYTES_128_BIT = 16;
    public static final int UUID_BYTES_16_BIT = 2;
    public static final int UUID_BYTES_32_BIT = 4;

    static {
        AudioSink = ParcelUuid.fromString("0000110B-0000-1000-8000-00805F9B34FB");
        AudioSource = ParcelUuid.fromString("0000110A-0000-1000-8000-00805F9B34FB");
        AdvAudioDist = ParcelUuid.fromString("0000110D-0000-1000-8000-00805F9B34FB");
        HSP = ParcelUuid.fromString("00001108-0000-1000-8000-00805F9B34FB");
        HSP_AG = ParcelUuid.fromString("00001112-0000-1000-8000-00805F9B34FB");
        Handsfree = ParcelUuid.fromString("0000111E-0000-1000-8000-00805F9B34FB");
        Handsfree_AG = ParcelUuid.fromString("0000111F-0000-1000-8000-00805F9B34FB");
        AvrcpController = ParcelUuid.fromString("0000110E-0000-1000-8000-00805F9B34FB");
        AvrcpTarget = ParcelUuid.fromString("0000110C-0000-1000-8000-00805F9B34FB");
        ObexObjectPush = ParcelUuid.fromString("00001105-0000-1000-8000-00805f9b34fb");
        Hid = ParcelUuid.fromString("00001124-0000-1000-8000-00805f9b34fb");
        Hogp = ParcelUuid.fromString("00001812-0000-1000-8000-00805f9b34fb");
        PANU = ParcelUuid.fromString("00001115-0000-1000-8000-00805F9B34FB");
        NAP = ParcelUuid.fromString("00001116-0000-1000-8000-00805F9B34FB");
        BNEP = ParcelUuid.fromString("0000000f-0000-1000-8000-00805F9B34FB");
        PBAP_PCE = ParcelUuid.fromString("0000112e-0000-1000-8000-00805F9B34FB");
        PBAP_PSE = ParcelUuid.fromString("0000112f-0000-1000-8000-00805F9B34FB");
        MAP = ParcelUuid.fromString("00001134-0000-1000-8000-00805F9B34FB");
        MNS = ParcelUuid.fromString("00001133-0000-1000-8000-00805F9B34FB");
        MAS = ParcelUuid.fromString("00001132-0000-1000-8000-00805F9B34FB");
        BASE_UUID = ParcelUuid.fromString("00000000-0000-1000-8000-00805F9B34FB");
        ParcelUuid[] parcelUuidArray = new ParcelUuid[]{AudioSink, AudioSource, AdvAudioDist, HSP, Handsfree, AvrcpController, AvrcpTarget, ObexObjectPush, PANU, NAP, MAP, MNS, MAS};
        RESERVED_UUIDS = parcelUuidArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean containsAllUuids(ParcelUuid[] parcelUuidArray, ParcelUuid[] parcelUuidArray2) {
        if (parcelUuidArray == null && parcelUuidArray2 == null) return true;
        if (parcelUuidArray == null) {
            if (parcelUuidArray2.length == 0) return true;
            return false;
        } else {
            if (parcelUuidArray2 == null) return true;
            HashSet<ParcelUuid> hashSet = new HashSet<ParcelUuid>(Arrays.asList(parcelUuidArray));
            int n = parcelUuidArray2.length;
            for (int i = 0; i < n; ++i) {
                if (hashSet.contains(parcelUuidArray2[i])) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean containsAnyUuid(ParcelUuid[] parcelUuidArray, ParcelUuid[] parcelUuidArray2) {
        if (parcelUuidArray == null && parcelUuidArray2 == null) return true;
        if (parcelUuidArray == null) {
            if (parcelUuidArray2.length == 0) return true;
            return false;
        }
        if (parcelUuidArray2 == null) {
            if (parcelUuidArray.length == 0) return true;
            return false;
        }
        HashSet<ParcelUuid> hashSet = new HashSet<ParcelUuid>(Arrays.asList(parcelUuidArray));
        int n = parcelUuidArray2.length;
        int n2 = 0;
        while (n2 < n) {
            if (hashSet.contains(parcelUuidArray2[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int getServiceIdentifierFromParcelUuid(ParcelUuid parcelUuid) {
        return (int)((0xFFFF00000000L & parcelUuid.getUuid().getMostSignificantBits()) >>> 32);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean is16BitUuid(ParcelUuid parcelUuid) {
        UUID uUID = parcelUuid.getUuid();
        return uUID.getLeastSignificantBits() == BASE_UUID.getUuid().getLeastSignificantBits() && (0xFFFF0000FFFFFFFFL & uUID.getMostSignificantBits()) == 4096L;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean is32BitUuid(ParcelUuid parcelUuid) {
        UUID uUID = parcelUuid.getUuid();
        return uUID.getLeastSignificantBits() == BASE_UUID.getUuid().getLeastSignificantBits() && !BluetoothUuid.is16BitUuid(parcelUuid) && (0xFFFFFFFFL & uUID.getMostSignificantBits()) == 4096L;
    }

    public static boolean isAdvAudioDist(ParcelUuid parcelUuid) {
        return parcelUuid.equals(AdvAudioDist);
    }

    public static boolean isAudioSink(ParcelUuid parcelUuid) {
        return parcelUuid.equals(AudioSink);
    }

    public static boolean isAudioSource(ParcelUuid parcelUuid) {
        return parcelUuid.equals(AudioSource);
    }

    public static boolean isAvrcpController(ParcelUuid parcelUuid) {
        return parcelUuid.equals(AvrcpController);
    }

    public static boolean isAvrcpTarget(ParcelUuid parcelUuid) {
        return parcelUuid.equals(AvrcpTarget);
    }

    public static boolean isBnep(ParcelUuid parcelUuid) {
        return parcelUuid.equals(BNEP);
    }

    public static boolean isHandsfree(ParcelUuid parcelUuid) {
        return parcelUuid.equals(Handsfree);
    }

    public static boolean isHeadset(ParcelUuid parcelUuid) {
        return parcelUuid.equals(HSP);
    }

    public static boolean isInputDevice(ParcelUuid parcelUuid) {
        return parcelUuid.equals(Hid);
    }

    public static boolean isMap(ParcelUuid parcelUuid) {
        return parcelUuid.equals(MAP);
    }

    public static boolean isMas(ParcelUuid parcelUuid) {
        return parcelUuid.equals(MAS);
    }

    public static boolean isMns(ParcelUuid parcelUuid) {
        return parcelUuid.equals(MNS);
    }

    public static boolean isNap(ParcelUuid parcelUuid) {
        return parcelUuid.equals(NAP);
    }

    public static boolean isPanu(ParcelUuid parcelUuid) {
        return parcelUuid.equals(PANU);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isUuidPresent(ParcelUuid[] parcelUuidArray, ParcelUuid parcelUuid) {
        if ((parcelUuidArray == null || parcelUuidArray.length == 0) && parcelUuid == null) {
            return true;
        }
        boolean bl = false;
        if (parcelUuidArray == null) return bl;
        int n = parcelUuidArray.length;
        int n2 = 0;
        while (true) {
            bl = false;
            if (n2 >= n) return bl;
            if (parcelUuidArray[n2].equals(parcelUuid)) {
                return true;
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ParcelUuid parseUuidFrom(byte[] byArray) {
        long l;
        if (byArray == null) {
            throw new IllegalArgumentException("uuidBytes cannot be null");
        }
        int n = byArray.length;
        if (n != 2 && n != 4 && n != 16) {
            throw new IllegalArgumentException("uuidBytes length invalid - " + n);
        }
        if (n == 16) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
            return new ParcelUuid(new UUID(byteBuffer.getLong(8), byteBuffer.getLong(0)));
        }
        if (n == 2) {
            l = (long)(0xFF & byArray[0]) + (long)((0xFF & byArray[1]) << 8);
            return new ParcelUuid(new UUID(BASE_UUID.getUuid().getMostSignificantBits() + (l << 32), BASE_UUID.getUuid().getLeastSignificantBits()));
        }
        l = (long)(0xFF & byArray[0]) + (long)((0xFF & byArray[1]) << 8) + (long)((0xFF & byArray[2]) << 16) + (long)((0xFF & byArray[3]) << 24);
        return new ParcelUuid(new UUID(BASE_UUID.getUuid().getMostSignificantBits() + (l << 32), BASE_UUID.getUuid().getLeastSignificantBits()));
    }
}

