/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothGattCallback;
import android.bluetooth.IBluetoothGattServerCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IBluetoothGatt
extends IInterface {
    public void addCharacteristic(int var1, ParcelUuid var2, int var3, int var4) throws RemoteException;

    public void addDescriptor(int var1, ParcelUuid var2, int var3) throws RemoteException;

    public void addIncludedService(int var1, int var2, int var3, ParcelUuid var4) throws RemoteException;

    public void beginReliableWrite(int var1, String var2) throws RemoteException;

    public void beginServiceDeclaration(int var1, int var2, int var3, int var4, ParcelUuid var5, boolean var6) throws RemoteException;

    public void clearServices(int var1) throws RemoteException;

    public void clientConnect(int var1, String var2, boolean var3, int var4) throws RemoteException;

    public void clientDisconnect(int var1, String var2) throws RemoteException;

    public void configureMTU(int var1, String var2, int var3) throws RemoteException;

    public void connectionParameterUpdate(int var1, String var2, int var3) throws RemoteException;

    public void discoverServices(int var1, String var2) throws RemoteException;

    public void endReliableWrite(int var1, String var2, boolean var3) throws RemoteException;

    public void endServiceDeclaration(int var1) throws RemoteException;

    public void flushPendingBatchResults(int var1, boolean var2) throws RemoteException;

    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] var1) throws RemoteException;

    public void readCharacteristic(int var1, String var2, int var3, int var4, ParcelUuid var5, int var6, ParcelUuid var7, int var8) throws RemoteException;

    public void readDescriptor(int var1, String var2, int var3, int var4, ParcelUuid var5, int var6, ParcelUuid var7, int var8, ParcelUuid var9, int var10) throws RemoteException;

    public void readRemoteRssi(int var1, String var2) throws RemoteException;

    public void refreshDevice(int var1, String var2) throws RemoteException;

    public void registerClient(ParcelUuid var1, IBluetoothGattCallback var2) throws RemoteException;

    public void registerForNotification(int var1, String var2, int var3, int var4, ParcelUuid var5, int var6, ParcelUuid var7, boolean var8) throws RemoteException;

    public void registerServer(ParcelUuid var1, IBluetoothGattServerCallback var2) throws RemoteException;

    public void removeService(int var1, int var2, int var3, ParcelUuid var4) throws RemoteException;

    public void sendNotification(int var1, String var2, int var3, int var4, ParcelUuid var5, int var6, ParcelUuid var7, boolean var8, byte[] var9) throws RemoteException;

    public void sendResponse(int var1, String var2, int var3, int var4, int var5, byte[] var6) throws RemoteException;

    public void serverConnect(int var1, String var2, boolean var3, int var4) throws RemoteException;

    public void serverDisconnect(int var1, String var2) throws RemoteException;

    public void startMultiAdvertising(int var1, AdvertiseData var2, AdvertiseData var3, AdvertiseSettings var4) throws RemoteException;

    public void startScan(int var1, boolean var2, ScanSettings var3, List<ScanFilter> var4, List var5) throws RemoteException;

    public void stopMultiAdvertising(int var1) throws RemoteException;

    public void stopScan(int var1, boolean var2) throws RemoteException;

    public void unregisterClient(int var1) throws RemoteException;

    public void unregisterServer(int var1) throws RemoteException;

    public void writeCharacteristic(int var1, String var2, int var3, int var4, ParcelUuid var5, int var6, ParcelUuid var7, int var8, int var9, byte[] var10) throws RemoteException;

    public void writeDescriptor(int var1, String var2, int var3, int var4, ParcelUuid var5, int var6, ParcelUuid var7, int var8, ParcelUuid var9, int var10, int var11, byte[] var12) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothGatt {
        private static final String DESCRIPTOR = "android.bluetooth.IBluetoothGatt";
        static final int TRANSACTION_addCharacteristic = 29;
        static final int TRANSACTION_addDescriptor = 30;
        static final int TRANSACTION_addIncludedService = 28;
        static final int TRANSACTION_beginReliableWrite = 18;
        static final int TRANSACTION_beginServiceDeclaration = 27;
        static final int TRANSACTION_clearServices = 33;
        static final int TRANSACTION_clientConnect = 9;
        static final int TRANSACTION_clientDisconnect = 10;
        static final int TRANSACTION_configureMTU = 21;
        static final int TRANSACTION_connectionParameterUpdate = 22;
        static final int TRANSACTION_discoverServices = 12;
        static final int TRANSACTION_endReliableWrite = 19;
        static final int TRANSACTION_endServiceDeclaration = 31;
        static final int TRANSACTION_flushPendingBatchResults = 4;
        static final int TRANSACTION_getDevicesMatchingConnectionStates = 1;
        static final int TRANSACTION_readCharacteristic = 13;
        static final int TRANSACTION_readDescriptor = 15;
        static final int TRANSACTION_readRemoteRssi = 20;
        static final int TRANSACTION_refreshDevice = 11;
        static final int TRANSACTION_registerClient = 7;
        static final int TRANSACTION_registerForNotification = 17;
        static final int TRANSACTION_registerServer = 23;
        static final int TRANSACTION_removeService = 32;
        static final int TRANSACTION_sendNotification = 35;
        static final int TRANSACTION_sendResponse = 34;
        static final int TRANSACTION_serverConnect = 25;
        static final int TRANSACTION_serverDisconnect = 26;
        static final int TRANSACTION_startMultiAdvertising = 5;
        static final int TRANSACTION_startScan = 2;
        static final int TRANSACTION_stopMultiAdvertising = 6;
        static final int TRANSACTION_stopScan = 3;
        static final int TRANSACTION_unregisterClient = 8;
        static final int TRANSACTION_unregisterServer = 24;
        static final int TRANSACTION_writeCharacteristic = 14;
        static final int TRANSACTION_writeDescriptor = 16;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothGatt asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IBluetoothGatt) {
                return (IBluetoothGatt)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<BluetoothDevice> list = this.getDevicesMatchingConnectionStates(parcel.createIntArray());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    ScanSettings scanSettings = parcel.readInt() != 0 ? ScanSettings.CREATOR.createFromParcel(parcel) : null;
                    this.startScan(n3, bl, scanSettings, parcel.createTypedArrayList(ScanFilter.CREATOR), parcel.readArrayList(this.getClass().getClassLoader()));
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.stopScan(n4, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n5 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.flushPendingBatchResults(n5, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n6 = parcel.readInt();
                    AdvertiseData advertiseData = parcel.readInt() != 0 ? AdvertiseData.CREATOR.createFromParcel(parcel) : null;
                    AdvertiseData advertiseData2 = parcel.readInt() != 0 ? AdvertiseData.CREATOR.createFromParcel(parcel) : null;
                    AdvertiseSettings advertiseSettings = parcel.readInt() != 0 ? AdvertiseSettings.CREATOR.createFromParcel(parcel) : null;
                    this.startMultiAdvertising(n6, advertiseData, advertiseData2, advertiseSettings);
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.stopMultiAdvertising(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    this.registerClient(parcelUuid, IBluetoothGattCallback.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unregisterClient(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n7 = parcel.readInt();
                    String string2 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    this.clientConnect(n7, string2, bl, parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clientDisconnect(parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.refreshDevice(parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.discoverServices(parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n8 = parcel.readInt();
                    String string3 = parcel.readString();
                    int n9 = parcel.readInt();
                    int n10 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n11 = parcel.readInt();
                    ParcelUuid parcelUuid2 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n12 = parcel.readInt();
                    this.readCharacteristic(n8, string3, n9, n10, parcelUuid, n11, parcelUuid2, n12);
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n13 = parcel.readInt();
                    String string4 = parcel.readString();
                    int n14 = parcel.readInt();
                    int n15 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n16 = parcel.readInt();
                    ParcelUuid parcelUuid3 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n17 = parcel.readInt();
                    int n18 = parcel.readInt();
                    byte[] byArray = parcel.createByteArray();
                    this.writeCharacteristic(n13, string4, n14, n15, parcelUuid, n16, parcelUuid3, n17, n18, byArray);
                    parcel2.writeNoException();
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n19 = parcel.readInt();
                    String string5 = parcel.readString();
                    int n20 = parcel.readInt();
                    int n21 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n22 = parcel.readInt();
                    ParcelUuid parcelUuid4 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n23 = parcel.readInt();
                    ParcelUuid parcelUuid5 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n24 = parcel.readInt();
                    this.readDescriptor(n19, string5, n20, n21, parcelUuid, n22, parcelUuid4, n23, parcelUuid5, n24);
                    parcel2.writeNoException();
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n25 = parcel.readInt();
                    String string6 = parcel.readString();
                    int n26 = parcel.readInt();
                    int n27 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n28 = parcel.readInt();
                    ParcelUuid parcelUuid6 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n29 = parcel.readInt();
                    ParcelUuid parcelUuid7 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n30 = parcel.readInt();
                    int n31 = parcel.readInt();
                    byte[] byArray = parcel.createByteArray();
                    this.writeDescriptor(n25, string6, n26, n27, parcelUuid, n28, parcelUuid6, n29, parcelUuid7, n30, n31, byArray);
                    parcel2.writeNoException();
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n32 = parcel.readInt();
                    String string7 = parcel.readString();
                    int n33 = parcel.readInt();
                    int n34 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    int n35 = parcel.readInt();
                    ParcelUuid parcelUuid8 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    this.registerForNotification(n32, string7, n33, n34, parcelUuid, n35, parcelUuid8, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.beginReliableWrite(parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n36 = parcel.readInt();
                    String string8 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    this.endReliableWrite(n36, string8, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.readRemoteRssi(parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.configureMTU(parcel.readInt(), parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.connectionParameterUpdate(parcel.readInt(), parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    this.registerServer(parcelUuid, IBluetoothGattServerCallback.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unregisterServer(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n37 = parcel.readInt();
                    String string9 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    this.serverConnect(n37, string9, bl, parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.serverDisconnect(parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n38 = parcel.readInt();
                    int n39 = parcel.readInt();
                    int n40 = parcel.readInt();
                    int n41 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    this.beginServiceDeclaration(n38, n39, n40, n41, parcelUuid, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n42 = parcel.readInt();
                    int n43 = parcel.readInt();
                    int n44 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    this.addIncludedService(n42, n43, n44, parcelUuid);
                    parcel2.writeNoException();
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n45 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    this.addCharacteristic(n45, parcelUuid, parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 30: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n46 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    this.addDescriptor(n46, parcelUuid, parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 31: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.endServiceDeclaration(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 32: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n47 = parcel.readInt();
                    int n48 = parcel.readInt();
                    int n49 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    this.removeService(n47, n48, n49, parcelUuid);
                    parcel2.writeNoException();
                    return true;
                }
                case 33: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearServices(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 34: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.sendResponse(parcel.readInt(), parcel.readString(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.createByteArray());
                    parcel2.writeNoException();
                    return true;
                }
                case 35: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            int n50 = parcel.readInt();
            String string10 = parcel.readString();
            int n51 = parcel.readInt();
            int n52 = parcel.readInt();
            ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
            int n53 = parcel.readInt();
            ParcelUuid parcelUuid9 = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
            boolean bl = parcel.readInt() != 0;
            byte[] byArray = parcel.createByteArray();
            this.sendNotification(n50, string10, n51, n52, parcelUuid, n53, parcelUuid9, bl, byArray);
            parcel2.writeNoException();
            return true;
        }

        private static class Proxy
        implements IBluetoothGatt {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addCharacteristic(int n, ParcelUuid parcelUuid, int n2, int n3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    this.mRemote.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addDescriptor(int n, ParcelUuid parcelUuid, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n2);
                    this.mRemote.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addIncludedService(int n, int n2, int n3, ParcelUuid parcelUuid) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void beginReliableWrite(int n, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void beginServiceDeclaration(int n, int n2, int n3, int n4, ParcelUuid parcelUuid, boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                int n5;
                block5: {
                    n5 = 1;
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    try {
                        parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                        parcel2.writeInt(n);
                        parcel2.writeInt(n2);
                        parcel2.writeInt(n3);
                        parcel2.writeInt(n4);
                        if (parcelUuid != null) {
                            parcel2.writeInt(1);
                            parcelUuid.writeToParcel(parcel2, 0);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        parcel.recycle();
                        parcel2.recycle();
                        throw throwable;
                    }
                    {
                        parcel2.writeInt(0);
                    }
                }
                if (!bl) {
                    n5 = 0;
                }
                parcel2.writeInt(n5);
                this.mRemote.transact(27, parcel2, parcel, 0);
                parcel.readException();
                parcel.recycle();
                parcel2.recycle();
            }

            @Override
            public void clearServices(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(33, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void clientConnect(int n, String string2, boolean bl, int n2) throws RemoteException {
                int n3;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    parcel2.writeString(string2);
                    n3 = 0;
                    if (!bl) break block4;
                    n3 = 1;
                }
                try {
                    parcel2.writeInt(n3);
                    parcel2.writeInt(n2);
                    this.mRemote.transact(9, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void clientDisconnect(int n, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void configureMTU(int n, String string2, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    parcel.writeInt(n2);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void connectionParameterUpdate(int n, String string2, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    parcel.writeInt(n2);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void discoverServices(int n, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void endReliableWrite(int n, String string2, boolean bl) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    parcel2.writeString(string2);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    this.mRemote.transact(19, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void endServiceDeclaration(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void flushPendingBatchResults(int n, boolean bl) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    this.mRemote.transact(4, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeIntArray(nArray);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<BluetoothDevice> arrayList = parcel2.createTypedArrayList(BluetoothDevice.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void readCharacteristic(int n, String string2, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, int n5) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n4);
                    if (parcelUuid2 != null) {
                        parcel.writeInt(1);
                        parcelUuid2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n5);
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void readDescriptor(int n, String string2, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, int n5, ParcelUuid parcelUuid3, int n6) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n4);
                    if (parcelUuid2 != null) {
                        parcel.writeInt(1);
                        parcelUuid2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n5);
                    if (parcelUuid3 != null) {
                        parcel.writeInt(1);
                        parcelUuid3.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n6);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void readRemoteRssi(int n, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void refreshDevice(int n, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void registerClient(ParcelUuid parcelUuid, IBluetoothGattCallback iBluetoothGattCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    IBinder iBinder = iBluetoothGattCallback != null ? iBluetoothGattCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void registerForNotification(int n, String string2, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, boolean bl) throws RemoteException {
                int n5 = 1;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n4);
                    if (parcelUuid2 != null) {
                        parcel.writeInt(1);
                        parcelUuid2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                if (!bl) {
                    n5 = 0;
                }
                parcel.writeInt(n5);
                this.mRemote.transact(17, parcel, parcel2, 0);
                parcel2.readException();
                parcel2.recycle();
                parcel.recycle();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void registerServer(ParcelUuid parcelUuid, IBluetoothGattServerCallback iBluetoothGattServerCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    IBinder iBinder = iBluetoothGattServerCallback != null ? iBluetoothGattServerCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeService(int n, int n2, int n3, ParcelUuid parcelUuid) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void sendNotification(int n, String string2, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, boolean bl, byte[] byArray) throws RemoteException {
                int n5 = 1;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n4);
                    if (parcelUuid2 != null) {
                        parcel.writeInt(1);
                        parcelUuid2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                if (!bl) {
                    n5 = 0;
                }
                parcel.writeInt(n5);
                parcel.writeByteArray(byArray);
                this.mRemote.transact(35, parcel, parcel2, 0);
                parcel2.readException();
                parcel2.recycle();
                parcel.recycle();
            }

            @Override
            public void sendResponse(int n, String string2, int n2, int n3, int n4, byte[] byArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    parcel.writeByteArray(byArray);
                    this.mRemote.transact(34, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void serverConnect(int n, String string2, boolean bl, int n2) throws RemoteException {
                int n3;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    parcel2.writeString(string2);
                    n3 = 0;
                    if (!bl) break block4;
                    n3 = 1;
                }
                try {
                    parcel2.writeInt(n3);
                    parcel2.writeInt(n2);
                    this.mRemote.transact(25, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void serverDisconnect(int n, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void startMultiAdvertising(int n, AdvertiseData advertiseData, AdvertiseData advertiseData2, AdvertiseSettings advertiseSettings) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (advertiseData != null) {
                        parcel.writeInt(1);
                        advertiseData.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (advertiseData2 != null) {
                        parcel.writeInt(1);
                        advertiseData2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (advertiseSettings != null) {
                        parcel.writeInt(1);
                        advertiseSettings.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void startScan(int n, boolean bl, ScanSettings scanSettings, List<ScanFilter> list, List list2) throws RemoteException {
                int n2 = 1;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (!bl) {
                        n2 = 0;
                    }
                    parcel.writeInt(n2);
                    if (scanSettings != null) {
                        parcel.writeInt(1);
                        scanSettings.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeTypedList(list);
                    parcel.writeList(list2);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void stopMultiAdvertising(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void stopScan(int n, boolean bl) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    this.mRemote.transact(3, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void unregisterClient(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void unregisterServer(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void writeCharacteristic(int n, String string2, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, int n5, int n6, byte[] byArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n4);
                    if (parcelUuid2 != null) {
                        parcel.writeInt(1);
                        parcelUuid2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n5);
                    parcel.writeInt(n6);
                    parcel.writeByteArray(byArray);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void writeDescriptor(int n, String string2, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, int n5, ParcelUuid parcelUuid3, int n6, int n7, byte[] byArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n4);
                    if (parcelUuid2 != null) {
                        parcel.writeInt(1);
                        parcelUuid2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n5);
                    if (parcelUuid3 != null) {
                        parcel.writeInt(1);
                        parcelUuid3.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n6);
                    parcel.writeInt(n7);
                    parcel.writeByteArray(byArray);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

