/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentValues;
import android.database.ContentObserver;
import android.database.Cursor;
import android.os.Handler;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;

public class ContentQueryMap
extends Observable {
    private String[] mColumnNames;
    private ContentObserver mContentObserver;
    private volatile Cursor mCursor;
    private boolean mDirty = false;
    private Handler mHandlerForUpdateNotifications = null;
    private boolean mKeepUpdated = false;
    private int mKeyColumn;
    private Map<String, ContentValues> mValues = null;

    public ContentQueryMap(Cursor cursor, String string2, boolean bl, Handler handler) {
        this.mCursor = cursor;
        this.mColumnNames = this.mCursor.getColumnNames();
        this.mKeyColumn = this.mCursor.getColumnIndexOrThrow(string2);
        this.mHandlerForUpdateNotifications = handler;
        this.setKeepUpdated(bl);
        if (!bl) {
            this.readCursorIntoCache(cursor);
        }
    }

    static /* synthetic */ boolean access$002(ContentQueryMap contentQueryMap, boolean bl) {
        contentQueryMap.mDirty = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readCursorIntoCache(Cursor cursor) {
        synchronized (this) {
            int n = this.mValues != null ? this.mValues.size() : 0;
            this.mValues = new HashMap<String, ContentValues>(n);
            block2: while (cursor.moveToNext()) {
                ContentValues contentValues = new ContentValues();
                int n2 = 0;
                while (true) {
                    if (n2 < this.mColumnNames.length) {
                        if (n2 != this.mKeyColumn) {
                            contentValues.put(this.mColumnNames[n2], cursor.getString(n2));
                        }
                    } else {
                        this.mValues.put(cursor.getString(this.mKeyColumn), contentValues);
                        continue block2;
                    }
                    ++n2;
                }
                break;
            }
            return;
        }
    }

    public void close() {
        synchronized (this) {
            if (this.mContentObserver != null) {
                this.mCursor.unregisterContentObserver(this.mContentObserver);
                this.mContentObserver = null;
            }
            this.mCursor.close();
            this.mCursor = null;
            return;
        }
    }

    protected void finalize() throws Throwable {
        if (this.mCursor != null) {
            this.close();
        }
        super.finalize();
    }

    public Map<String, ContentValues> getRows() {
        synchronized (this) {
            if (this.mDirty) {
                this.requery();
            }
            Map<String, ContentValues> map = this.mValues;
            return map;
        }
    }

    public ContentValues getValues(String string2) {
        synchronized (this) {
            if (this.mDirty) {
                this.requery();
            }
            ContentValues contentValues = this.mValues.get(string2);
            return contentValues;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void requery() {
        Cursor cursor;
        block3: {
            block2: {
                cursor = this.mCursor;
                if (cursor == null) break block2;
                this.mDirty = false;
                if (cursor.requery()) break block3;
            }
            return;
        }
        this.readCursorIntoCache(cursor);
        this.setChanged();
        this.notifyObservers();
    }

    public void setKeepUpdated(boolean bl) {
        if (bl == this.mKeepUpdated) {
            return;
        }
        this.mKeepUpdated = bl;
        if (!this.mKeepUpdated) {
            this.mCursor.unregisterContentObserver(this.mContentObserver);
            this.mContentObserver = null;
            return;
        }
        if (this.mHandlerForUpdateNotifications == null) {
            this.mHandlerForUpdateNotifications = new Handler();
        }
        if (this.mContentObserver == null) {
            this.mContentObserver = new ContentObserver(this.mHandlerForUpdateNotifications){

                @Override
                public void onChange(boolean bl) {
                    if (ContentQueryMap.this.countObservers() != 0) {
                        ContentQueryMap.this.requery();
                        return;
                    }
                    ContentQueryMap.access$002(ContentQueryMap.this, true);
                }
            };
        }
        this.mCursor.registerContentObserver(this.mContentObserver);
        this.mDirty = true;
    }
}

