/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;

public class RestrictionEntry
implements Parcelable {
    public static final Parcelable.Creator<RestrictionEntry> CREATOR = new Parcelable.Creator<RestrictionEntry>(){

        @Override
        public RestrictionEntry createFromParcel(Parcel parcel) {
            return new RestrictionEntry(parcel);
        }

        public RestrictionEntry[] newArray(int n) {
            return new RestrictionEntry[n];
        }
    };
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_CHOICE = 2;
    public static final int TYPE_CHOICE_LEVEL = 3;
    public static final int TYPE_INTEGER = 5;
    public static final int TYPE_MULTI_SELECT = 4;
    public static final int TYPE_NULL = 0;
    public static final int TYPE_STRING = 6;
    private String[] mChoiceEntries;
    private String[] mChoiceValues;
    private String mCurrentValue;
    private String[] mCurrentValues;
    private String mDescription;
    private String mKey;
    private String mTitle;
    private int mType;

    public RestrictionEntry(int n, String string2) {
        this.mType = n;
        this.mKey = string2;
    }

    public RestrictionEntry(Parcel parcel) {
        this.mType = parcel.readInt();
        this.mKey = parcel.readString();
        this.mTitle = parcel.readString();
        this.mDescription = parcel.readString();
        this.mChoiceEntries = this.readArray(parcel);
        this.mChoiceValues = this.readArray(parcel);
        this.mCurrentValue = parcel.readString();
        this.mCurrentValues = this.readArray(parcel);
    }

    public RestrictionEntry(String string2, int n) {
        this.mKey = string2;
        this.mType = 5;
        this.setIntValue(n);
    }

    public RestrictionEntry(String string2, String string3) {
        this.mKey = string2;
        this.mType = 2;
        this.mCurrentValue = string3;
    }

    public RestrictionEntry(String string2, boolean bl) {
        this.mKey = string2;
        this.mType = 1;
        this.setSelectedState(bl);
    }

    public RestrictionEntry(String string2, String[] stringArray) {
        this.mKey = string2;
        this.mType = 4;
        this.mCurrentValues = stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean equalArrays(String[] stringArray, String[] stringArray2) {
        if (stringArray.length == stringArray2.length) {
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    return true;
                }
                if (!stringArray[n].equals(stringArray2[n])) break;
                ++n;
            }
        }
        return false;
    }

    private String[] readArray(Parcel parcel) {
        int n = parcel.readInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = parcel.readString();
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeArray(Parcel parcel, String[] stringArray) {
        if (stringArray == null) {
            parcel.writeInt(0);
            return;
        } else {
            parcel.writeInt(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                parcel.writeString(stringArray[i]);
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (object == this) break block4;
                if (!(object instanceof RestrictionEntry)) {
                    return false;
                }
                RestrictionEntry restrictionEntry = (RestrictionEntry)object;
                if (this.mType != restrictionEntry.mType || !this.mKey.equals(restrictionEntry.mKey) || (this.mCurrentValues != null || restrictionEntry.mCurrentValues != null || this.mCurrentValue == null || !this.mCurrentValue.equals(restrictionEntry.mCurrentValue)) && (this.mCurrentValue != null || restrictionEntry.mCurrentValue != null || this.mCurrentValues == null || !this.equalArrays(this.mCurrentValues, restrictionEntry.mCurrentValues))) break block5;
            }
            return true;
        }
        return false;
    }

    public String[] getAllSelectedStrings() {
        return this.mCurrentValues;
    }

    public String[] getChoiceEntries() {
        return this.mChoiceEntries;
    }

    public String[] getChoiceValues() {
        return this.mChoiceValues;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public int getIntValue() {
        return Integer.parseInt(this.mCurrentValue);
    }

    public String getKey() {
        return this.mKey;
    }

    public boolean getSelectedState() {
        return Boolean.parseBoolean(this.mCurrentValue);
    }

    public String getSelectedString() {
        return this.mCurrentValue;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public int getType() {
        return this.mType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        int n = 527 + this.mKey.hashCode();
        if (this.mCurrentValue != null) {
            return n * 31 + this.mCurrentValue.hashCode();
        }
        if (this.mCurrentValues == null) return n;
        String[] stringArray = this.mCurrentValues;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            if (string2 != null) {
                n = n * 31 + string2.hashCode();
            }
            ++n3;
        }
        return n;
    }

    public void setAllSelectedStrings(String[] stringArray) {
        this.mCurrentValues = stringArray;
    }

    public void setChoiceEntries(Context context, int n) {
        this.mChoiceEntries = context.getResources().getStringArray(n);
    }

    public void setChoiceEntries(String[] stringArray) {
        this.mChoiceEntries = stringArray;
    }

    public void setChoiceValues(Context context, int n) {
        this.mChoiceValues = context.getResources().getStringArray(n);
    }

    public void setChoiceValues(String[] stringArray) {
        this.mChoiceValues = stringArray;
    }

    public void setDescription(String string2) {
        this.mDescription = string2;
    }

    public void setIntValue(int n) {
        this.mCurrentValue = Integer.toString(n);
    }

    public void setSelectedState(boolean bl) {
        this.mCurrentValue = Boolean.toString(bl);
    }

    public void setSelectedString(String string2) {
        this.mCurrentValue = string2;
    }

    public void setTitle(String string2) {
        this.mTitle = string2;
    }

    public void setType(int n) {
        this.mType = n;
    }

    public String toString() {
        return "RestrictionsEntry {type=" + this.mType + ", key=" + this.mKey + ", value=" + this.mCurrentValue + "}";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mType);
        parcel.writeString(this.mKey);
        parcel.writeString(this.mTitle);
        parcel.writeString(this.mDescription);
        this.writeArray(parcel, this.mChoiceEntries);
        this.writeArray(parcel, this.mChoiceValues);
        parcel.writeString(this.mCurrentValue);
        this.writeArray(parcel, this.mCurrentValues);
    }
}

