/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.SyncStats;
import android.os.Parcel;
import android.os.Parcelable;

public final class SyncResult
implements Parcelable {
    public static final SyncResult ALREADY_IN_PROGRESS = new SyncResult(true);
    public static final Parcelable.Creator<SyncResult> CREATOR = new Parcelable.Creator<SyncResult>(){

        @Override
        public SyncResult createFromParcel(Parcel parcel) {
            return new SyncResult(parcel);
        }

        public SyncResult[] newArray(int n) {
            return new SyncResult[n];
        }
    };
    public boolean databaseError;
    public long delayUntil;
    public boolean fullSyncRequested;
    public boolean moreRecordsToGet;
    public boolean partialSyncUnavailable;
    public final SyncStats stats;
    public final boolean syncAlreadyInProgress;
    public boolean tooManyDeletions;
    public boolean tooManyRetries;

    public SyncResult() {
        this(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private SyncResult(Parcel parcel) {
        boolean bl = true;
        boolean bl2 = parcel.readInt() != 0 ? bl : false;
        this.syncAlreadyInProgress = bl2;
        boolean bl3 = parcel.readInt() != 0 ? bl : false;
        this.tooManyDeletions = bl3;
        boolean bl4 = parcel.readInt() != 0 ? bl : false;
        this.tooManyRetries = bl4;
        boolean bl5 = parcel.readInt() != 0 ? bl : false;
        this.databaseError = bl5;
        boolean bl6 = parcel.readInt() != 0 ? bl : false;
        this.fullSyncRequested = bl6;
        boolean bl7 = parcel.readInt() != 0 ? bl : false;
        this.partialSyncUnavailable = bl7;
        if (parcel.readInt() == 0) {
            bl = false;
        }
        this.moreRecordsToGet = bl;
        this.delayUntil = parcel.readLong();
        this.stats = new SyncStats(parcel);
    }

    private SyncResult(boolean bl) {
        this.syncAlreadyInProgress = bl;
        this.tooManyDeletions = false;
        this.tooManyRetries = false;
        this.fullSyncRequested = false;
        this.partialSyncUnavailable = false;
        this.moreRecordsToGet = false;
        this.delayUntil = 0L;
        this.stats = new SyncStats();
    }

    public void clear() {
        if (this.syncAlreadyInProgress) {
            throw new UnsupportedOperationException("you are not allowed to clear the ALREADY_IN_PROGRESS SyncStats");
        }
        this.tooManyDeletions = false;
        this.tooManyRetries = false;
        this.databaseError = false;
        this.fullSyncRequested = false;
        this.partialSyncUnavailable = false;
        this.moreRecordsToGet = false;
        this.delayUntil = 0L;
        this.stats.clear();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean hasError() {
        return this.hasSoftError() || this.hasHardError();
    }

    public boolean hasHardError() {
        return this.stats.numParseExceptions > 0L || this.stats.numConflictDetectedExceptions > 0L || this.stats.numAuthExceptions > 0L || this.tooManyDeletions || this.tooManyRetries || this.databaseError;
    }

    public boolean hasSoftError() {
        return this.syncAlreadyInProgress || this.stats.numIoExceptions > 0L;
    }

    public boolean madeSomeProgress() {
        return this.stats.numDeletes > 0L && !this.tooManyDeletions || this.stats.numInserts > 0L || this.stats.numUpdates > 0L;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fullSyncRequested) {
            stringBuffer.append("f1");
        }
        if (this.partialSyncUnavailable) {
            stringBuffer.append("r1");
        }
        if (this.hasHardError()) {
            stringBuffer.append("X1");
        }
        if (this.stats.numParseExceptions > 0L) {
            stringBuffer.append("e").append(this.stats.numParseExceptions);
        }
        if (this.stats.numConflictDetectedExceptions > 0L) {
            stringBuffer.append("c").append(this.stats.numConflictDetectedExceptions);
        }
        if (this.stats.numAuthExceptions > 0L) {
            stringBuffer.append("a").append(this.stats.numAuthExceptions);
        }
        if (this.tooManyDeletions) {
            stringBuffer.append("D1");
        }
        if (this.tooManyRetries) {
            stringBuffer.append("R1");
        }
        if (this.databaseError) {
            stringBuffer.append("b1");
        }
        if (this.hasSoftError()) {
            stringBuffer.append("x1");
        }
        if (this.syncAlreadyInProgress) {
            stringBuffer.append("l1");
        }
        if (this.stats.numIoExceptions > 0L) {
            stringBuffer.append("I").append(this.stats.numIoExceptions);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SyncResult:");
        if (this.syncAlreadyInProgress) {
            stringBuilder.append(" syncAlreadyInProgress: ").append(this.syncAlreadyInProgress);
        }
        if (this.tooManyDeletions) {
            stringBuilder.append(" tooManyDeletions: ").append(this.tooManyDeletions);
        }
        if (this.tooManyRetries) {
            stringBuilder.append(" tooManyRetries: ").append(this.tooManyRetries);
        }
        if (this.databaseError) {
            stringBuilder.append(" databaseError: ").append(this.databaseError);
        }
        if (this.fullSyncRequested) {
            stringBuilder.append(" fullSyncRequested: ").append(this.fullSyncRequested);
        }
        if (this.partialSyncUnavailable) {
            stringBuilder.append(" partialSyncUnavailable: ").append(this.partialSyncUnavailable);
        }
        if (this.moreRecordsToGet) {
            stringBuilder.append(" moreRecordsToGet: ").append(this.moreRecordsToGet);
        }
        if (this.delayUntil > 0L) {
            stringBuilder.append(" delayUntil: ").append(this.delayUntil);
        }
        stringBuilder.append(this.stats);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        int n3 = this.syncAlreadyInProgress ? n2 : 0;
        parcel.writeInt(n3);
        int n4 = this.tooManyDeletions ? n2 : 0;
        parcel.writeInt(n4);
        int n5 = this.tooManyRetries ? n2 : 0;
        parcel.writeInt(n5);
        int n6 = this.databaseError ? n2 : 0;
        parcel.writeInt(n6);
        int n7 = this.fullSyncRequested ? n2 : 0;
        parcel.writeInt(n7);
        int n8 = this.partialSyncUnavailable ? n2 : 0;
        parcel.writeInt(n8);
        if (!this.moreRecordsToGet) {
            n2 = 0;
        }
        parcel.writeInt(n2);
        parcel.writeLong(this.delayUntil);
        this.stats.writeToParcel(parcel, n);
    }
}

