/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.UndoOperation;
import android.content.UndoOwner;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ParcelableParcel;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class UndoManager {
    public static final int MERGE_MODE_ANY = 2;
    public static final int MERGE_MODE_NONE = 0;
    public static final int MERGE_MODE_UNIQUE = 1;
    private int mCommitId = 1;
    private int mHistorySize = 20;
    private boolean mInUndo;
    private boolean mMerged;
    private int mNextSavedIdx;
    private final HashMap<String, UndoOwner> mOwners = new HashMap();
    private final ArrayList<UndoState> mRedos;
    private UndoOwner[] mStateOwners;
    private int mStateSeq;
    private final ArrayList<UndoState> mUndos = new ArrayList();
    private int mUpdateCount;
    private UndoState mWorking;

    public UndoManager() {
        this.mRedos = new ArrayList();
    }

    private void createWorkingState() {
        int n = this.mCommitId;
        this.mCommitId = n + 1;
        this.mWorking = new UndoState(this, n);
        if (this.mCommitId < 0) {
            this.mCommitId = 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void pushWorkingState() {
        int n = 1 + this.mUndos.size();
        if (this.mWorking.hasData()) {
            this.mUndos.add(this.mWorking);
            this.forgetRedos(null, -1);
            this.mWorking.commit();
            if (n >= 2) {
                this.mUndos.get(n - 2).makeExecuted();
            }
        } else {
            this.mWorking.destroy();
        }
        this.mWorking = null;
        if (this.mHistorySize >= 0 && n > this.mHistorySize) {
            this.forgetUndos(null, n - this.mHistorySize);
        }
    }

    public void addOperation(UndoOperation<?> undoOperation, int n) {
        UndoState undoState;
        if (this.mWorking == null) {
            throw new IllegalStateException("Must be called during an update");
        }
        if (undoOperation.getOwner().mManager != this) {
            throw new IllegalArgumentException("Given operation's owner is not in this undo manager.");
        }
        if (!(n == 0 || this.mMerged || this.mWorking.hasData() || (undoState = this.getTopUndo(null)) == null || n != 2 && undoState.hasMultipleOwners() || !undoState.canMerge() || !undoState.hasOperation(undoOperation.getOwner()))) {
            this.mWorking.destroy();
            this.mWorking = undoState;
            this.mUndos.remove(undoState);
            this.mMerged = true;
        }
        this.mWorking.addOperation(undoOperation);
    }

    public void beginUpdate(CharSequence charSequence) {
        if (this.mInUndo) {
            throw new IllegalStateException("Can't being update while performing undo/redo");
        }
        if (this.mUpdateCount <= 0) {
            this.createWorkingState();
            this.mMerged = false;
            this.mUpdateCount = 0;
        }
        this.mWorking.updateLabel(charSequence);
        this.mUpdateCount = 1 + this.mUpdateCount;
    }

    public int commitState(UndoOwner undoOwner) {
        if (this.mWorking != null && this.mWorking.hasData()) {
            if (undoOwner == null || this.mWorking.hasOperation(undoOwner)) {
                this.mWorking.setCanMerge(false);
                int n = this.mWorking.getCommitId();
                this.pushWorkingState();
                this.createWorkingState();
                this.mMerged = true;
                return n;
            }
        } else {
            UndoState undoState = this.getTopUndo(null);
            if (undoState != null && (undoOwner == null || undoState.hasOperation(undoOwner))) {
                undoState.setCanMerge(false);
                return undoState.getCommitId();
            }
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int countRedos(UndoOwner[] undoOwnerArray) {
        int n;
        if (undoOwnerArray == null) {
            return this.mRedos.size();
        }
        int n2 = 0;
        int n3 = 0;
        while ((n = this.findNextState(this.mRedos, undoOwnerArray, n3)) >= 0) {
            ++n2;
            n3 = n + 1;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int countUndos(UndoOwner[] undoOwnerArray) {
        int n;
        if (undoOwnerArray == null) {
            return this.mUndos.size();
        }
        int n2 = 0;
        int n3 = 0;
        while ((n = this.findNextState(this.mUndos, undoOwnerArray, n3)) >= 0) {
            ++n2;
            n3 = n + 1;
        }
        return n2;
    }

    public void endUpdate() {
        if (this.mWorking == null) {
            throw new IllegalStateException("Must be called during an update");
        }
        this.mUpdateCount = -1 + this.mUpdateCount;
        if (this.mUpdateCount == 0) {
            this.pushWorkingState();
        }
    }

    /*
     * Unable to fully structure code
     */
    int findNextState(ArrayList<UndoState> var1_1, UndoOwner[] var2_2, int var3_3) {
        var4_4 = var1_1.size();
        if (var3_3 < 0) {
            var3_3 = 0;
        }
        if (var3_3 >= var4_4) {
            return -1;
        }
        if (var2_2 != null) ** GOTO lbl10
        return var3_3;
lbl-1000:
        // 1 sources

        {
            ++var3_3;
lbl10:
            // 2 sources

            if (var3_3 >= var4_4) ** continue;
            ** while (!this.matchOwners((UndoState)var1_1.get((int)var3_3), (UndoOwner[])var2_2))
        }
lbl12:
        // 1 sources

        return var3_3;
    }

    /*
     * Unable to fully structure code
     */
    int findPrevState(ArrayList<UndoState> var1_1, UndoOwner[] var2_2, int var3_3) {
        var4_4 = var1_1.size();
        if (var3_3 == -1) {
            var3_3 = var4_4 - 1;
        }
        if (var3_3 >= var4_4) {
            return -1;
        }
        if (var2_2 != null) ** GOTO lbl10
        return var3_3;
lbl-1000:
        // 1 sources

        {
            --var3_3;
lbl10:
            // 2 sources

            if (var3_3 < 0) ** continue;
            ** while (!this.matchOwners((UndoState)var1_1.get((int)var3_3), (UndoOwner[])var2_2))
        }
lbl12:
        // 1 sources

        return var3_3;
    }

    public int forgetRedos(UndoOwner[] undoOwnerArray, int n) {
        if (n < 0) {
            n = this.mRedos.size();
        }
        int n2 = 0;
        for (int i = 0; i < this.mRedos.size() && n2 < n; ++i) {
            UndoState undoState = this.mRedos.get(i);
            if (n <= 0 || !this.matchOwners(undoState, undoOwnerArray)) continue;
            undoState.destroy();
            this.mRedos.remove(i);
            ++n2;
        }
        return n2;
    }

    public int forgetUndos(UndoOwner[] undoOwnerArray, int n) {
        if (n < 0) {
            n = this.mUndos.size();
        }
        int n2 = 0;
        for (int i = 0; i < this.mUndos.size() && n2 < n; ++i) {
            UndoState undoState = this.mUndos.get(i);
            if (n <= 0 || !this.matchOwners(undoState, undoOwnerArray)) continue;
            undoState.destroy();
            this.mUndos.remove(i);
            ++n2;
        }
        return n2;
    }

    public int getHistorySize() {
        return this.mHistorySize;
    }

    public UndoOperation<?> getLastOperation(int n) {
        return this.getLastOperation(null, null, n);
    }

    public UndoOperation<?> getLastOperation(UndoOwner undoOwner, int n) {
        return this.getLastOperation(null, undoOwner, n);
    }

    public <T extends UndoOperation> T getLastOperation(Class<T> clazz, UndoOwner undoOwner, int n) {
        T t;
        UndoState undoState;
        if (this.mWorking == null) {
            throw new IllegalStateException("Must be called during an update");
        }
        if (!(n == 0 || this.mMerged || this.mWorking.hasData() || (undoState = this.getTopUndo(null)) == null || n != 2 && undoState.hasMultipleOwners() || !undoState.canMerge() || (t = undoState.getLastOperation(clazz, undoOwner)) == null || !((UndoOperation)t).allowMerge())) {
            this.mWorking.destroy();
            this.mWorking = undoState;
            this.mUndos.remove(undoState);
            this.mMerged = true;
            return t;
        }
        return this.mWorking.getLastOperation(clazz, undoOwner);
    }

    public UndoOwner getOwner(String string2, Object object) {
        if (string2 == null) {
            throw new NullPointerException("tag can't be null");
        }
        if (object == null) {
            throw new NullPointerException("data can't be null");
        }
        UndoOwner undoOwner = this.mOwners.get(string2);
        if (undoOwner != null) {
            if (undoOwner.mData != object) {
                if (undoOwner.mData != null) {
                    throw new IllegalStateException("Owner " + undoOwner + " already exists with data " + undoOwner.mData + " but giving different data " + object);
                }
                undoOwner.mData = object;
            }
            return undoOwner;
        }
        UndoOwner undoOwner2 = new UndoOwner(string2);
        undoOwner2.mManager = this;
        undoOwner2.mData = object;
        this.mOwners.put(string2, undoOwner2);
        return undoOwner2;
    }

    public CharSequence getRedoLabel(UndoOwner[] undoOwnerArray) {
        UndoState undoState = this.getTopRedo(undoOwnerArray);
        if (undoState != null) {
            return undoState.getLabel();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    UndoState getTopRedo(UndoOwner[] undoOwnerArray) {
        int n;
        if (this.mRedos.size() <= 0 || (n = this.findPrevState(this.mRedos, undoOwnerArray, -1)) < 0) {
            return null;
        }
        return this.mRedos.get(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    UndoState getTopUndo(UndoOwner[] undoOwnerArray) {
        int n;
        if (this.mUndos.size() <= 0 || (n = this.findPrevState(this.mUndos, undoOwnerArray, -1)) < 0) {
            return null;
        }
        return this.mUndos.get(n);
    }

    public CharSequence getUndoLabel(UndoOwner[] undoOwnerArray) {
        UndoState undoState = this.getTopUndo(undoOwnerArray);
        if (undoState != null) {
            return undoState.getLabel();
        }
        return null;
    }

    public int getUpdateNestingLevel() {
        return this.mUpdateCount;
    }

    public boolean hasOperation(UndoOwner undoOwner) {
        if (this.mWorking == null) {
            throw new IllegalStateException("Must be called during an update");
        }
        return this.mWorking.hasOperation(undoOwner);
    }

    public boolean isInUndo() {
        return this.mInUndo;
    }

    public boolean isInUpdate() {
        return this.mUpdateCount > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean matchOwners(UndoState undoState, UndoOwner[] undoOwnerArray) {
        if (undoOwnerArray != null) {
            int n = 0;
            while (true) {
                if (n >= undoOwnerArray.length) {
                    return false;
                }
                if (undoState.matchOwner(undoOwnerArray[n])) break;
                ++n;
            }
        }
        return true;
    }

    public int redo(UndoOwner[] undoOwnerArray, int n) {
        if (this.mWorking != null) {
            throw new IllegalStateException("Can't be called during an update");
        }
        int n2 = 0;
        int n3 = -1;
        this.mInUndo = true;
        while (n > 0 && (n3 = this.findPrevState(this.mRedos, undoOwnerArray, n3)) >= 0) {
            UndoState undoState = this.mRedos.remove(n3);
            undoState.redo();
            this.mUndos.add(undoState);
            --n;
            ++n2;
        }
        this.mInUndo = false;
        return n2;
    }

    void removeOwner(UndoOwner undoOwner) {
    }

    public void restoreInstanceState(Parcelable parcelable) {
        int n;
        if (this.mUpdateCount > 0) {
            throw new IllegalStateException("Can't save state while updating");
        }
        this.forgetUndos(null, -1);
        this.forgetRedos(null, -1);
        ParcelableParcel parcelableParcel = (ParcelableParcel)parcelable;
        Parcel parcel = parcelableParcel.getParcel();
        this.mHistorySize = parcel.readInt();
        this.mStateOwners = new UndoOwner[parcel.readInt()];
        while ((n = parcel.readInt()) != 0) {
            UndoState undoState = new UndoState(this, parcel, parcelableParcel.getClassLoader());
            if (n == 1) {
                this.mUndos.add(0, undoState);
                continue;
            }
            this.mRedos.add(0, undoState);
        }
    }

    UndoOwner restoreOwner(Parcel parcel) {
        int n = parcel.readInt();
        UndoOwner undoOwner = this.mStateOwners[n];
        if (undoOwner == null) {
            String string2 = parcel.readString();
            this.mStateOwners[n] = undoOwner = new UndoOwner(string2);
            this.mOwners.put(string2, undoOwner);
        }
        return undoOwner;
    }

    public Parcelable saveInstanceState() {
        if (this.mUpdateCount > 0) {
            throw new IllegalStateException("Can't save state while updating");
        }
        ParcelableParcel parcelableParcel = new ParcelableParcel(this.getClass().getClassLoader());
        Parcel parcel = parcelableParcel.getParcel();
        this.mStateSeq = 1 + this.mStateSeq;
        if (this.mStateSeq <= 0) {
            this.mStateSeq = 0;
        }
        this.mNextSavedIdx = 0;
        parcel.writeInt(this.mHistorySize);
        parcel.writeInt(this.mOwners.size());
        int n = this.mUndos.size();
        while (n > 0) {
            parcel.writeInt(1);
            this.mUndos.get(--n).writeToParcel(parcel);
        }
        int n2 = this.mRedos.size();
        parcel.writeInt(n2);
        while (n2 > 0) {
            parcel.writeInt(2);
            this.mRedos.get(--n2).writeToParcel(parcel);
        }
        parcel.writeInt(0);
        return parcelableParcel;
    }

    void saveOwner(UndoOwner undoOwner, Parcel parcel) {
        if (undoOwner.mStateSeq == this.mStateSeq) {
            parcel.writeInt(undoOwner.mSavedIdx);
            return;
        }
        undoOwner.mStateSeq = this.mStateSeq;
        undoOwner.mSavedIdx = this.mNextSavedIdx;
        parcel.writeInt(undoOwner.mSavedIdx);
        parcel.writeString(undoOwner.mTag);
        this.mNextSavedIdx = 1 + this.mNextSavedIdx;
    }

    public void setHistorySize(int n) {
        this.mHistorySize = n;
        if (this.mHistorySize >= 0 && this.countUndos(null) > this.mHistorySize) {
            this.forgetUndos(null, this.countUndos(null) - this.mHistorySize);
        }
    }

    public void setUndoLabel(CharSequence charSequence) {
        if (this.mWorking == null) {
            throw new IllegalStateException("Must be called during an update");
        }
        this.mWorking.setLabel(charSequence);
    }

    public void suggestUndoLabel(CharSequence charSequence) {
        if (this.mWorking == null) {
            throw new IllegalStateException("Must be called during an update");
        }
        this.mWorking.updateLabel(charSequence);
    }

    public boolean uncommitState(int n, UndoOwner undoOwner) {
        if (this.mWorking != null && this.mWorking.getCommitId() == n) {
            if (undoOwner == null || this.mWorking.hasOperation(undoOwner)) {
                return this.mWorking.setCanMerge(true);
            }
        } else {
            UndoState undoState = this.getTopUndo(null);
            if (undoState != null && (undoOwner == null || undoState.hasOperation(undoOwner)) && undoState.getCommitId() == n) {
                return undoState.setCanMerge(true);
            }
        }
        return false;
    }

    public int undo(UndoOwner[] undoOwnerArray, int n) {
        if (this.mWorking != null) {
            throw new IllegalStateException("Can't be called during an update");
        }
        int n2 = -1;
        this.mInUndo = true;
        UndoState undoState = this.getTopUndo(null);
        int n3 = 0;
        if (undoState != null) {
            undoState.makeExecuted();
        }
        while (n > 0 && (n2 = this.findPrevState(this.mUndos, undoOwnerArray, n2)) >= 0) {
            UndoState undoState2 = this.mUndos.remove(n2);
            undoState2.undo();
            this.mRedos.add(undoState2);
            --n;
            ++n3;
        }
        this.mInUndo = false;
        return n3;
    }

    static final class UndoState {
        private boolean mCanMerge;
        private final int mCommitId;
        private boolean mExecuted;
        private CharSequence mLabel;
        private final UndoManager mManager;
        private final ArrayList<UndoOperation<?>> mOperations;
        private ArrayList<UndoOperation<?>> mRecent;

        UndoState(UndoManager undoManager, int n) {
            this.mOperations = new ArrayList();
            this.mCanMerge = true;
            this.mManager = undoManager;
            this.mCommitId = n;
        }

        /*
         * Enabled aggressive block sorting
         */
        UndoState(UndoManager undoManager, Parcel parcel, ClassLoader classLoader) {
            boolean bl = true;
            this.mOperations = new ArrayList();
            this.mCanMerge = bl;
            this.mManager = undoManager;
            this.mCommitId = parcel.readInt();
            boolean bl2 = parcel.readInt() != 0 ? bl : false;
            this.mCanMerge = bl2;
            if (parcel.readInt() == 0) {
                bl = false;
            }
            this.mExecuted = bl;
            this.mLabel = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            int n = parcel.readInt();
            int n2 = 0;
            while (n2 < n) {
                UndoOwner undoOwner = this.mManager.restoreOwner(parcel);
                UndoOperation undoOperation = (UndoOperation)parcel.readParcelable(classLoader);
                undoOperation.mOwner = undoOwner;
                this.mOperations.add(undoOperation);
                ++n2;
            }
            return;
        }

        void addOperation(UndoOperation<?> undoOperation) {
            if (this.mOperations.contains(undoOperation)) {
                throw new IllegalStateException("Already holds " + undoOperation);
            }
            this.mOperations.add(undoOperation);
            if (this.mRecent == null) {
                this.mRecent = new ArrayList();
                this.mRecent.add(undoOperation);
            }
            UndoOwner undoOwner = undoOperation.mOwner;
            undoOwner.mOpCount = 1 + undoOwner.mOpCount;
        }

        boolean canMerge() {
            return this.mCanMerge && !this.mExecuted;
        }

        /*
         * Enabled aggressive block sorting
         */
        void commit() {
            int n = this.mRecent != null ? this.mRecent.size() : 0;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    this.mRecent = null;
                    return;
                }
                this.mRecent.get(n2).commit();
                ++n2;
            }
        }

        int countOperations() {
            return this.mOperations.size();
        }

        void destroy() {
            for (int i = -1 + this.mOperations.size(); i >= 0; --i) {
                UndoOwner undoOwner = this.mOperations.get((int)i).mOwner;
                undoOwner.mOpCount = -1 + undoOwner.mOpCount;
                if (undoOwner.mOpCount > 0) continue;
                if (undoOwner.mOpCount < 0) {
                    throw new IllegalStateException("Underflow of op count on owner " + undoOwner + " in op " + this.mOperations.get(i));
                }
                this.mManager.removeOwner(undoOwner);
            }
        }

        int getCommitId() {
            return this.mCommitId;
        }

        CharSequence getLabel() {
            return this.mLabel;
        }

        /*
         * Enabled aggressive block sorting
         */
        <T extends UndoOperation> T getLastOperation(Class<T> clazz, UndoOwner undoOwner) {
            UndoOperation<?> undoOperation;
            UndoOperation<?> undoOperation2;
            int n = this.mOperations.size();
            if (clazz == null && undoOwner == null) {
                undoOperation2 = null;
                if (n <= 0) return (T)undoOperation2;
                undoOperation2 = this.mOperations.get(n - 1);
                return (T)undoOperation2;
            }
            int n2 = n - 1;
            while (true) {
                undoOperation2 = null;
                if (n2 < 0) return (T)undoOperation2;
                undoOperation = this.mOperations.get(n2);
                if (undoOwner == null || undoOperation.getOwner() == undoOwner) break;
                --n2;
            }
            if (clazz == null) return (T)undoOperation;
            Class<?> clazz2 = undoOperation.getClass();
            undoOperation2 = null;
            if (clazz2 != clazz) return (T)undoOperation2;
            return (T)undoOperation;
        }

        boolean hasData() {
            for (int i = -1 + this.mOperations.size(); i >= 0; --i) {
                if (!this.mOperations.get(i).hasData()) continue;
                return true;
            }
            return false;
        }

        boolean hasMultipleOwners() {
            int n = this.mOperations.size();
            if (n <= 1) {
                return false;
            }
            UndoOwner undoOwner = this.mOperations.get(0).getOwner();
            for (int i = 1; i < n; ++i) {
                if (this.mOperations.get(i).getOwner() == undoOwner) continue;
                return true;
            }
            return false;
        }

        boolean hasOperation(UndoOwner undoOwner) {
            int n = this.mOperations.size();
            if (undoOwner == null) {
                return n != 0;
            }
            for (int i = 0; i < n; ++i) {
                if (this.mOperations.get(i).getOwner() != undoOwner) continue;
                return true;
            }
            return false;
        }

        void makeExecuted() {
            this.mExecuted = true;
        }

        boolean matchOwner(UndoOwner undoOwner) {
            for (int i = -1 + this.mOperations.size(); i >= 0; --i) {
                if (!this.mOperations.get(i).matchOwner(undoOwner)) continue;
                return true;
            }
            return false;
        }

        void redo() {
            int n = this.mOperations.size();
            for (int i = 0; i < n; ++i) {
                this.mOperations.get(i).redo();
            }
        }

        boolean setCanMerge(boolean bl) {
            if (bl && this.mExecuted) {
                return false;
            }
            this.mCanMerge = bl;
            return true;
        }

        void setLabel(CharSequence charSequence) {
            this.mLabel = charSequence;
        }

        void undo() {
            for (int i = -1 + this.mOperations.size(); i >= 0; --i) {
                this.mOperations.get(i).undo();
            }
        }

        void updateLabel(CharSequence charSequence) {
            if (this.mLabel != null) {
                this.mLabel = charSequence;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void writeToParcel(Parcel parcel) {
            int n = 1;
            if (this.mRecent != null) {
                throw new IllegalStateException("Can't save state before committing");
            }
            parcel.writeInt(this.mCommitId);
            int n2 = this.mCanMerge ? n : 0;
            parcel.writeInt(n2);
            if (!this.mExecuted) {
                n = 0;
            }
            parcel.writeInt(n);
            TextUtils.writeToParcel(this.mLabel, parcel, 0);
            int n3 = this.mOperations.size();
            parcel.writeInt(n3);
            int n4 = 0;
            while (n4 < n3) {
                UndoOperation<?> undoOperation = this.mOperations.get(n4);
                this.mManager.saveOwner(undoOperation.mOwner, parcel);
                parcel.writeParcelable(undoOperation, 0);
                ++n4;
            }
            return;
        }
    }
}

