/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class LimitedLengthInputStream
extends FilterInputStream {
    private final long mEnd;
    private long mOffset;

    public LimitedLengthInputStream(InputStream inputStream, long l, long l2) throws IOException {
        super(inputStream);
        if (inputStream == null) {
            throw new IOException("in == null");
        }
        if (l < 0L) {
            throw new IOException("offset < 0");
        }
        if (l2 < 0L) {
            throw new IOException("length < 0");
        }
        if (l2 > Long.MAX_VALUE - l) {
            throw new IOException("offset + length > Long.MAX_VALUE");
        }
        this.mEnd = l + l2;
        this.skip(l);
        this.mOffset = l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        synchronized (this) {
            block4: {
                long l = this.mOffset;
                long l2 = this.mEnd;
                if (l < l2) break block4;
                return -1;
            }
            this.mOffset = 1L + this.mOffset;
            int n = super.read();
            return n;
        }
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.mOffset >= this.mEnd) {
            return -1;
        }
        Arrays.checkOffsetAndCount((int)byArray.length, (int)n, (int)n2);
        if (this.mOffset > Long.MAX_VALUE - (long)n2) {
            throw new IOException("offset out of bounds: " + this.mOffset + " + " + n2);
        }
        if (this.mOffset + (long)n2 > this.mEnd) {
            n2 = (int)(this.mEnd - this.mOffset);
        }
        int n3 = super.read(byArray, n, n2);
        this.mOffset += (long)n3;
        return n3;
    }
}

