/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.WindowManager;

public class CompatibilityInfo
implements Parcelable {
    private static final int ALWAYS_NEEDS_COMPAT = 2;
    public static final Parcelable.Creator<CompatibilityInfo> CREATOR;
    public static final CompatibilityInfo DEFAULT_COMPATIBILITY_INFO;
    public static final int DEFAULT_NORMAL_SHORT_DIMENSION = 320;
    public static final float MAXIMUM_ASPECT_RATIO = 1.7791667f;
    private static final int NEEDS_SCREEN_COMPAT = 8;
    private static final int NEVER_NEEDS_COMPAT = 4;
    private static final int SCALING_REQUIRED = 1;
    public final int applicationDensity;
    public final float applicationInvertedScale;
    public final float applicationScale;
    public final boolean isThemeable;
    private final int mCompatibilityFlags;

    static {
        DEFAULT_COMPATIBILITY_INFO = new CompatibilityInfo(){};
        CREATOR = new Parcelable.Creator<CompatibilityInfo>(){

            @Override
            public CompatibilityInfo createFromParcel(Parcel parcel) {
                return new CompatibilityInfo(parcel);
            }

            public CompatibilityInfo[] newArray(int n) {
                return new CompatibilityInfo[n];
            }
        };
    }

    private CompatibilityInfo() {
        this(4, DisplayMetrics.DENSITY_DEVICE, 1.0f, 1.0f, true);
    }

    private CompatibilityInfo(int n, int n2, float f, float f2, boolean bl) {
        this.mCompatibilityFlags = n;
        this.applicationDensity = n2;
        this.applicationScale = f;
        this.applicationInvertedScale = f2;
        this.isThemeable = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CompatibilityInfo(ApplicationInfo applicationInfo, int n, int n2, boolean bl) {
        int n3;
        block27: {
            block29: {
                block28: {
                    block26: {
                        int n4;
                        this.isThemeable = applicationInfo.isThemeable;
                        if (applicationInfo.requiresSmallestWidthDp == 0 && applicationInfo.compatibleWidthLimitDp == 0 && applicationInfo.largestWidthLimitDp == 0) break block26;
                        int n5 = applicationInfo.requiresSmallestWidthDp != 0 ? applicationInfo.requiresSmallestWidthDp : applicationInfo.compatibleWidthLimitDp;
                        if (n5 == 0) {
                            n5 = applicationInfo.largestWidthLimitDp;
                        }
                        if ((n4 = applicationInfo.compatibleWidthLimitDp != 0 ? applicationInfo.compatibleWidthLimitDp : n5) < n5) {
                            n4 = n5;
                        }
                        int n6 = applicationInfo.largestWidthLimitDp;
                        if (n5 > 320) {
                            n3 = 0 | 4;
                        } else if (n6 != 0 && n2 > n6) {
                            n3 = 0 | 0xA;
                        } else if (n4 >= n2) {
                            n3 = 0 | 4;
                        } else {
                            n3 = 0;
                            if (bl) {
                                n3 = 0 | 8;
                            }
                        }
                        this.applicationDensity = DisplayMetrics.DENSITY_DEVICE;
                        this.applicationScale = 1.0f;
                        this.applicationInvertedScale = 1.0f;
                        break block27;
                    }
                    int n7 = 0x800 & applicationInfo.flags;
                    boolean bl2 = false;
                    int n8 = 0;
                    if (n7 != 0) {
                        n8 = 0 | 8;
                        bl2 = true;
                        if (!bl) {
                            n8 |= 0x22;
                        }
                    }
                    if ((0x80000 & applicationInfo.flags) != 0) {
                        bl2 = true;
                        if (!bl) {
                            n8 |= 0x22;
                        }
                    }
                    if ((0x1000 & applicationInfo.flags) != 0) {
                        bl2 = true;
                        n8 |= 2;
                    }
                    if (bl) {
                        n8 &= 0xFFFFFFFD;
                    }
                    n3 = 0 | 8;
                    switch (n & 0xF) {
                        case 4: {
                            if ((n8 & 0x20) != 0) {
                                n3 &= 0xFFFFFFF7;
                            }
                            if ((0x80000 & applicationInfo.flags) == 0) break;
                            n3 |= 4;
                            break;
                        }
                        case 3: {
                            if ((n8 & 8) != 0) {
                                n3 &= 0xFFFFFFF7;
                            }
                            if ((0x800 & applicationInfo.flags) == 0) break;
                            n3 |= 4;
                        }
                    }
                    if ((0x10000000 & n) == 0) break block28;
                    if ((n8 & 2) != 0) {
                        n3 &= 0xFFFFFFF7;
                        break block29;
                    } else if (!bl2) {
                        n3 |= 2;
                    }
                    break block29;
                }
                n3 = 4 | n3 & 0xFFFFFFF7;
            }
            if ((0x2000 & applicationInfo.flags) != 0) {
                this.applicationDensity = DisplayMetrics.DENSITY_DEVICE;
                this.applicationScale = 1.0f;
                this.applicationInvertedScale = 1.0f;
            } else {
                this.applicationDensity = 160;
                this.applicationScale = (float)DisplayMetrics.DENSITY_DEVICE / 160.0f;
                this.applicationInvertedScale = 1.0f / this.applicationScale;
                n3 |= 1;
            }
        }
        this.mCompatibilityFlags = n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CompatibilityInfo(Parcel parcel) {
        int n = 1;
        this.mCompatibilityFlags = parcel.readInt();
        this.applicationDensity = parcel.readInt();
        this.applicationScale = parcel.readFloat();
        this.applicationInvertedScale = parcel.readFloat();
        if (parcel.readInt() != n) {
            n = 0;
        }
        this.isThemeable = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static float computeCompatibleScaling(DisplayMetrics displayMetrics, DisplayMetrics displayMetrics2) {
        float f;
        float f2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = displayMetrics.noncompatWidthPixels;
        int n6 = displayMetrics.noncompatHeightPixels;
        if (n5 < n6) {
            n4 = n5;
            n3 = n6;
        } else {
            n4 = n6;
            n3 = n5;
        }
        int n7 = (int)(0.5f + 320.0f * displayMetrics.density);
        float f3 = (float)n3 / (float)n4;
        if (f3 > 1.7791667f) {
            f3 = 1.7791667f;
        }
        int n8 = (int)(0.5f + f3 * (float)n7);
        if (n5 < n6) {
            n2 = n7;
            n = n8;
        } else {
            n2 = n8;
            n = n7;
        }
        float f4 = (f2 = (float)n5 / (float)n2) < (f = (float)n6 / (float)n) ? f2 : f;
        if (f4 < 1.0f) {
            f4 = 1.0f;
        }
        if (displayMetrics2 != null) {
            displayMetrics2.widthPixels = n2;
            displayMetrics2.heightPixels = n;
        }
        return f4;
    }

    public boolean alwaysSupportsScreen() {
        return (4 & this.mCompatibilityFlags) != 0;
    }

    public void applyToConfiguration(int n, Configuration configuration) {
        if (!this.supportsScreen()) {
            configuration.screenLayout = 2 | 0xFFFFFFF0 & configuration.screenLayout;
            configuration.screenWidthDp = configuration.compatScreenWidthDp;
            configuration.screenHeightDp = configuration.compatScreenHeightDp;
            configuration.smallestScreenWidthDp = configuration.compatSmallestScreenWidthDp;
        }
        configuration.densityDpi = n;
        if (this.isScalingRequired()) {
            configuration.densityDpi = (int)(0.5f + this.applicationInvertedScale * (float)configuration.densityDpi);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void applyToDisplayMetrics(DisplayMetrics displayMetrics) {
        if (!this.supportsScreen()) {
            CompatibilityInfo.computeCompatibleScaling(displayMetrics, displayMetrics);
        } else {
            displayMetrics.widthPixels = displayMetrics.noncompatWidthPixels;
            displayMetrics.heightPixels = displayMetrics.noncompatHeightPixels;
        }
        if (this.isScalingRequired()) {
            float f = this.applicationInvertedScale;
            displayMetrics.density = f * displayMetrics.noncompatDensity;
            displayMetrics.densityDpi = (int)(0.5f + f * (float)displayMetrics.noncompatDensityDpi);
            displayMetrics.scaledDensity = f * displayMetrics.noncompatScaledDensity;
            displayMetrics.xdpi = f * displayMetrics.noncompatXdpi;
            displayMetrics.ydpi = f * displayMetrics.noncompatYdpi;
            displayMetrics.widthPixels = (int)(0.5f + f * (float)displayMetrics.widthPixels);
            displayMetrics.heightPixels = (int)(0.5f + f * (float)displayMetrics.heightPixels);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        try {
            CompatibilityInfo compatibilityInfo = (CompatibilityInfo)object;
            if (this.mCompatibilityFlags != compatibilityInfo.mCompatibilityFlags) {
                return false;
            }
            if (this.applicationDensity != compatibilityInfo.applicationDensity) {
                return false;
            }
            if (this.applicationScale != compatibilityInfo.applicationScale) {
                return false;
            }
            if (this.applicationInvertedScale != compatibilityInfo.applicationInvertedScale) {
                return false;
            }
            boolean bl = this.isThemeable;
            boolean bl2 = compatibilityInfo.isThemeable;
            if (bl == bl2) return true;
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public Translator getTranslator() {
        if (this.isScalingRequired()) {
            return new Translator();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        int n;
        int n2 = 31 * (31 * (31 * (31 * (527 + this.mCompatibilityFlags) + this.applicationDensity) + Float.floatToIntBits(this.applicationScale)) + Float.floatToIntBits(this.applicationInvertedScale));
        if (this.isThemeable) {
            n = 1;
            return n2 + n;
        }
        n = 0;
        return n2 + n;
    }

    public boolean isScalingRequired() {
        return (1 & this.mCompatibilityFlags) != 0;
    }

    public boolean neverSupportsScreen() {
        return (2 & this.mCompatibilityFlags) != 0;
    }

    public boolean supportsScreen() {
        return (8 & this.mCompatibilityFlags) == 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("{");
        stringBuilder.append(this.applicationDensity);
        stringBuilder.append("dpi");
        if (this.isScalingRequired()) {
            stringBuilder.append(" ");
            stringBuilder.append(this.applicationScale);
            stringBuilder.append("x");
        }
        if (!this.supportsScreen()) {
            stringBuilder.append(" resizing");
        }
        if (this.neverSupportsScreen()) {
            stringBuilder.append(" never-compat");
        }
        if (this.alwaysSupportsScreen()) {
            stringBuilder.append(" always-compat");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mCompatibilityFlags);
        parcel.writeInt(this.applicationDensity);
        parcel.writeFloat(this.applicationScale);
        parcel.writeFloat(this.applicationInvertedScale);
        int n2 = this.isThemeable ? 1 : 0;
        parcel.writeInt(n2);
    }

    public class Translator {
        public final float applicationInvertedScale;
        public final float applicationScale;
        private Rect mContentInsetsBuffer = null;
        private Region mTouchableAreaBuffer = null;
        private Rect mVisibleInsetsBuffer = null;

        Translator() {
            this(compatibilityInfo.applicationScale, compatibilityInfo.applicationInvertedScale);
        }

        Translator(float f, float f2) {
            this.applicationScale = f;
            this.applicationInvertedScale = f2;
        }

        public Rect getTranslatedContentInsets(Rect rect) {
            if (this.mContentInsetsBuffer == null) {
                this.mContentInsetsBuffer = new Rect();
            }
            this.mContentInsetsBuffer.set(rect);
            this.translateRectInAppWindowToScreen(this.mContentInsetsBuffer);
            return this.mContentInsetsBuffer;
        }

        public Region getTranslatedTouchableArea(Region region) {
            if (this.mTouchableAreaBuffer == null) {
                this.mTouchableAreaBuffer = new Region();
            }
            this.mTouchableAreaBuffer.set(region);
            this.mTouchableAreaBuffer.scale(this.applicationScale);
            return this.mTouchableAreaBuffer;
        }

        public Rect getTranslatedVisibleInsets(Rect rect) {
            if (this.mVisibleInsetsBuffer == null) {
                this.mVisibleInsetsBuffer = new Rect();
            }
            this.mVisibleInsetsBuffer.set(rect);
            this.translateRectInAppWindowToScreen(this.mVisibleInsetsBuffer);
            return this.mVisibleInsetsBuffer;
        }

        public void translateCanvas(Canvas canvas) {
            if (this.applicationScale == 1.5f) {
                canvas.translate(0.0026143792f, 0.0026143792f);
            }
            canvas.scale(this.applicationScale, this.applicationScale);
        }

        public void translateEventInScreenToAppWindow(MotionEvent motionEvent) {
            motionEvent.scale(this.applicationInvertedScale);
        }

        public void translateLayoutParamsInAppWindowToScreen(WindowManager.LayoutParams layoutParams) {
            layoutParams.scale(this.applicationScale);
        }

        public void translatePointInScreenToAppWindow(PointF pointF) {
            float f = this.applicationInvertedScale;
            if (f != 1.0f) {
                pointF.x = f * pointF.x;
                pointF.y = f * pointF.y;
            }
        }

        public void translateRectInAppWindowToScreen(Rect rect) {
            rect.scale(this.applicationScale);
        }

        public void translateRectInScreenToAppWinFrame(Rect rect) {
            rect.scale(this.applicationInvertedScale);
        }

        public void translateRectInScreenToAppWindow(Rect rect) {
            rect.scale(this.applicationInvertedScale);
        }

        public void translateRegionInWindowToScreen(Region region) {
            region.scale(this.applicationScale);
        }

        public void translateWindowLayout(WindowManager.LayoutParams layoutParams) {
            layoutParams.scale(this.applicationScale);
        }
    }
}

