/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.BulkCursorProxy;
import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.IBulkCursor;
import android.database.IContentObserver;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;

public abstract class BulkCursorNative
extends Binder
implements IBulkCursor {
    public BulkCursorNative() {
        this.attachInterface(this, "android.content.IBulkCursor");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IBulkCursor asInterface(IBinder iBinder) {
        if (iBinder == null) {
            return null;
        }
        IBulkCursor iBulkCursor = (IBulkCursor)iBinder.queryLocalInterface("android.content.IBulkCursor");
        if (iBulkCursor != null) return iBulkCursor;
        return new BulkCursorProxy(iBinder);
    }

    @Override
    public IBinder asBinder() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        switch (n) {
            default: {
                return super.onTransact(n, parcel, parcel2, n2);
            }
            case 1: {
                try {
                    parcel.enforceInterface("android.content.IBulkCursor");
                    CursorWindow cursorWindow = this.getWindow(parcel.readInt());
                    parcel2.writeNoException();
                    if (cursorWindow == null) {
                        parcel2.writeInt(0);
                        return true;
                    }
                    parcel2.writeInt(1);
                    cursorWindow.writeToParcel(parcel2, 1);
                    return true;
                }
                catch (Exception exception) {
                    DatabaseUtils.writeExceptionToParcel(parcel2, exception);
                    return true;
                }
            }
            case 2: {
                parcel.enforceInterface("android.content.IBulkCursor");
                this.deactivate();
                parcel2.writeNoException();
                return true;
            }
            case 7: {
                parcel.enforceInterface("android.content.IBulkCursor");
                this.close();
                parcel2.writeNoException();
                return true;
            }
            case 3: {
                parcel.enforceInterface("android.content.IBulkCursor");
                int n3 = this.requery(IContentObserver.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                parcel2.writeInt(n3);
                parcel2.writeBundle(this.getExtras());
                return true;
            }
            case 4: {
                parcel.enforceInterface("android.content.IBulkCursor");
                this.onMove(parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 5: {
                parcel.enforceInterface("android.content.IBulkCursor");
                Bundle bundle = this.getExtras();
                parcel2.writeNoException();
                parcel2.writeBundle(bundle);
                return true;
            }
            case 6: 
        }
        parcel.enforceInterface("android.content.IBulkCursor");
        Bundle bundle = this.respond(parcel.readBundle());
        parcel2.writeNoException();
        parcel2.writeBundle(bundle);
        return true;
    }
}

