/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.content.res.Resources;
import android.database.CharArrayBuffer;
import android.database.CursorWindowAllocationException;
import android.database.sqlite.SQLiteClosable;
import android.os.Binder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.SparseIntArray;
import dalvik.system.CloseGuard;

public class CursorWindow
extends SQLiteClosable
implements Parcelable {
    public static final Parcelable.Creator<CursorWindow> CREATOR;
    private static final String STATS_TAG = "CursorWindowStats";
    private static int sCursorWindowSize;
    private static final LongSparseArray<Integer> sWindowToPidMap;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final String mName;
    private int mStartPos;
    public long mWindowPtr;

    static {
        sCursorWindowSize = -1;
        CREATOR = new Parcelable.Creator<CursorWindow>(){

            @Override
            public CursorWindow createFromParcel(Parcel parcel) {
                return new CursorWindow(parcel);
            }

            public CursorWindow[] newArray(int n) {
                return new CursorWindow[n];
            }
        };
        sWindowToPidMap = new LongSparseArray();
    }

    private CursorWindow(Parcel parcel) {
        this.mStartPos = parcel.readInt();
        this.mWindowPtr = CursorWindow.nativeCreateFromParcel(parcel);
        if (this.mWindowPtr == 0L) {
            throw new CursorWindowAllocationException("Cursor window could not be created from binder.");
        }
        this.mName = CursorWindow.nativeGetName(this.mWindowPtr);
        this.mCloseGuard.open("close");
    }

    /*
     * Enabled aggressive block sorting
     */
    public CursorWindow(String string2) {
        this.mStartPos = 0;
        if (string2 == null || string2.length() == 0) {
            string2 = "<unnamed>";
        }
        this.mName = string2;
        if (sCursorWindowSize < 0) {
            sCursorWindowSize = 1024 * Resources.getSystem().getInteger(17694816);
        }
        this.mWindowPtr = CursorWindow.nativeCreate(this.mName, sCursorWindowSize);
        if (this.mWindowPtr == 0L) {
            throw new CursorWindowAllocationException("Cursor window allocation of " + sCursorWindowSize / 1024 + " kb failed. " + this.printStats());
        }
        this.mCloseGuard.open("close");
        this.recordNewWindow(Binder.getCallingPid(), this.mWindowPtr);
    }

    @Deprecated
    public CursorWindow(boolean bl) {
        this((String)null);
    }

    private void dispose() {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.close();
        }
        if (this.mWindowPtr != 0L) {
            this.recordClosingOfWindow(this.mWindowPtr);
            CursorWindow.nativeDispose(this.mWindowPtr);
            this.mWindowPtr = 0L;
        }
    }

    private static native boolean nativeAllocRow(long var0);

    private static native void nativeClear(long var0);

    private static native void nativeCopyStringToBuffer(long var0, int var2, int var3, CharArrayBuffer var4);

    private static native long nativeCreate(String var0, int var1);

    private static native long nativeCreateFromParcel(Parcel var0);

    private static native void nativeDispose(long var0);

    private static native void nativeFreeLastRow(long var0);

    private static native byte[] nativeGetBlob(long var0, int var2, int var3);

    private static native double nativeGetDouble(long var0, int var2, int var3);

    private static native long nativeGetLong(long var0, int var2, int var3);

    private static native String nativeGetName(long var0);

    private static native int nativeGetNumRows(long var0);

    private static native String nativeGetString(long var0, int var2, int var3);

    private static native int nativeGetType(long var0, int var2, int var3);

    private static native boolean nativePutBlob(long var0, byte[] var2, int var3, int var4);

    private static native boolean nativePutDouble(long var0, double var2, int var4, int var5);

    private static native boolean nativePutLong(long var0, long var2, int var4, int var5);

    private static native boolean nativePutNull(long var0, int var2, int var3);

    private static native boolean nativePutString(long var0, String var2, int var3, int var4);

    private static native boolean nativeSetNumColumns(long var0, int var2);

    private static native void nativeWriteToParcel(long var0, Parcel var2);

    public static CursorWindow newFromParcel(Parcel parcel) {
        return CREATOR.createFromParcel(parcel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String printStats() {
        String string2;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = Process.myPid();
        int n3 = 0;
        SparseIntArray sparseIntArray = new SparseIntArray();
        LongSparseArray<Integer> longSparseArray = sWindowToPidMap;
        synchronized (longSparseArray) {
            int n4 = sWindowToPidMap.size();
            if (n4 == 0) {
                return "";
            }
            for (int i = 0; i < n4; ++i) {
                int n5 = sWindowToPidMap.valueAt(i);
                sparseIntArray.put(n5, 1 + sparseIntArray.get(n5));
            }
        }
        int n6 = sparseIntArray.size();
        for (int i = 0; i < n6; n3 += n, ++i) {
            stringBuilder.append(" (# cursors opened by ");
            int n7 = sparseIntArray.keyAt(i);
            if (n7 == n2) {
                stringBuilder.append("this proc=");
            } else {
                stringBuilder.append("pid " + n7 + "=");
            }
            n = sparseIntArray.get(n7);
            stringBuilder.append(n + ")");
        }
        if (stringBuilder.length() > 980) {
            string2 = stringBuilder.substring(0, 980);
            return "# Open Cursors=" + n3 + string2;
        }
        string2 = stringBuilder.toString();
        return "# Open Cursors=" + n3 + string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recordClosingOfWindow(long l) {
        LongSparseArray<Integer> longSparseArray = sWindowToPidMap;
        synchronized (longSparseArray) {
            if (sWindowToPidMap.size() == 0) {
                return;
            }
            sWindowToPidMap.delete(l);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recordNewWindow(int n, long l) {
        LongSparseArray<Integer> longSparseArray = sWindowToPidMap;
        synchronized (longSparseArray) {
            sWindowToPidMap.put(l, n);
            if (Log.isLoggable(STATS_TAG, 2)) {
                Log.i(STATS_TAG, "Created a new Cursor. " + this.printStats());
            }
            return;
        }
    }

    public boolean allocRow() {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativeAllocRow(this.mWindowPtr);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public void clear() {
        this.acquireReference();
        try {
            this.mStartPos = 0;
            CursorWindow.nativeClear(this.mWindowPtr);
            return;
        }
        finally {
            this.releaseReference();
        }
    }

    public void copyStringToBuffer(int n, int n2, CharArrayBuffer charArrayBuffer) {
        if (charArrayBuffer == null) {
            throw new IllegalArgumentException("CharArrayBuffer should not be null");
        }
        this.acquireReference();
        try {
            CursorWindow.nativeCopyStringToBuffer(this.mWindowPtr, n - this.mStartPos, n2, charArrayBuffer);
            return;
        }
        finally {
            this.releaseReference();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.dispose();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public void freeLastRow() {
        this.acquireReference();
        try {
            CursorWindow.nativeFreeLastRow(this.mWindowPtr);
            return;
        }
        finally {
            this.releaseReference();
        }
    }

    public byte[] getBlob(int n, int n2) {
        this.acquireReference();
        try {
            byte[] byArray = CursorWindow.nativeGetBlob(this.mWindowPtr, n - this.mStartPos, n2);
            return byArray;
        }
        finally {
            this.releaseReference();
        }
    }

    public double getDouble(int n, int n2) {
        this.acquireReference();
        try {
            double d = CursorWindow.nativeGetDouble(this.mWindowPtr, n - this.mStartPos, n2);
            return d;
        }
        finally {
            this.releaseReference();
        }
    }

    public float getFloat(int n, int n2) {
        return (float)this.getDouble(n, n2);
    }

    public int getInt(int n, int n2) {
        return (int)this.getLong(n, n2);
    }

    public long getLong(int n, int n2) {
        this.acquireReference();
        try {
            long l = CursorWindow.nativeGetLong(this.mWindowPtr, n - this.mStartPos, n2);
            return l;
        }
        finally {
            this.releaseReference();
        }
    }

    public String getName() {
        return this.mName;
    }

    public int getNumRows() {
        this.acquireReference();
        try {
            int n = CursorWindow.nativeGetNumRows(this.mWindowPtr);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    public short getShort(int n, int n2) {
        return (short)this.getLong(n, n2);
    }

    public int getStartPosition() {
        return this.mStartPos;
    }

    public String getString(int n, int n2) {
        this.acquireReference();
        try {
            String string2 = CursorWindow.nativeGetString(this.mWindowPtr, n - this.mStartPos, n2);
            return string2;
        }
        finally {
            this.releaseReference();
        }
    }

    public int getType(int n, int n2) {
        this.acquireReference();
        try {
            int n3 = CursorWindow.nativeGetType(this.mWindowPtr, n - this.mStartPos, n2);
            return n3;
        }
        finally {
            this.releaseReference();
        }
    }

    @Deprecated
    public boolean isBlob(int n, int n2) {
        int n3 = this.getType(n, n2);
        return n3 == 4 || n3 == 0;
    }

    @Deprecated
    public boolean isFloat(int n, int n2) {
        return this.getType(n, n2) == 2;
    }

    @Deprecated
    public boolean isLong(int n, int n2) {
        return this.getType(n, n2) == 1;
    }

    @Deprecated
    public boolean isNull(int n, int n2) {
        return this.getType(n, n2) == 0;
    }

    @Deprecated
    public boolean isString(int n, int n2) {
        int n3 = this.getType(n, n2);
        return n3 == 3 || n3 == 0;
    }

    @Override
    protected void onAllReferencesReleased() {
        this.dispose();
    }

    public boolean putBlob(byte[] byArray, int n, int n2) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutBlob(this.mWindowPtr, byArray, n - this.mStartPos, n2);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean putDouble(double d, int n, int n2) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutDouble(this.mWindowPtr, d, n - this.mStartPos, n2);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean putLong(long l, int n, int n2) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutLong(this.mWindowPtr, l, n - this.mStartPos, n2);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean putNull(int n, int n2) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutNull(this.mWindowPtr, n - this.mStartPos, n2);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean putString(String string2, int n, int n2) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutString(this.mWindowPtr, string2, n - this.mStartPos, n2);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean setNumColumns(int n) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativeSetNumColumns(this.mWindowPtr, n);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public void setStartPosition(int n) {
        this.mStartPos = n;
    }

    public String toString() {
        return this.getName() + " {" + Long.toHexString(this.mWindowPtr) + "}";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        block3: {
            this.acquireReference();
            parcel.writeInt(this.mStartPos);
            CursorWindow.nativeWriteToParcel(this.mWindowPtr, parcel);
            if ((n & 1) == 0) break block3;
            this.releaseReference();
        }
        return;
        finally {
            this.releaseReference();
        }
    }
}

