/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.content.Context;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.util.Log;

public abstract class SQLiteOpenHelper {
    private static final boolean DEBUG_STRICT_READONLY;
    private static final String TAG;
    private final Context mContext;
    private SQLiteDatabase mDatabase;
    private boolean mEnableWriteAheadLogging;
    private final DatabaseErrorHandler mErrorHandler;
    private final SQLiteDatabase.CursorFactory mFactory;
    private boolean mIsInitializing;
    private final String mName;
    private final int mNewVersion;

    static {
        TAG = SQLiteOpenHelper.class.getSimpleName();
    }

    public SQLiteOpenHelper(Context context, String string2, SQLiteDatabase.CursorFactory cursorFactory, int n) {
        this(context, string2, cursorFactory, n, null);
    }

    public SQLiteOpenHelper(Context context, String string2, SQLiteDatabase.CursorFactory cursorFactory, int n, DatabaseErrorHandler databaseErrorHandler) {
        if (n < 1) {
            throw new IllegalArgumentException("Version must be >= 1, was " + n);
        }
        this.mContext = context;
        this.mName = string2;
        this.mFactory = cursorFactory;
        this.mNewVersion = n;
        this.mErrorHandler = databaseErrorHandler;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SQLiteDatabase getDatabaseLocked(boolean var1_1) {
        block21: {
            if (this.mDatabase != null) {
                if (!this.mDatabase.isOpen()) {
                    this.mDatabase = null;
                } else {
                    if (var1_1 == false) return this.mDatabase;
                    if (!this.mDatabase.isReadOnly()) {
                        return this.mDatabase;
                    }
                }
            }
            if (this.mIsInitializing) {
                throw new IllegalStateException("getDatabase called recursively");
            }
            var2_2 = this.mDatabase;
            this.mIsInitializing = true;
            if (var2_2 == null) break block21;
            if (var1_1 && var2_2.isReadOnly()) {
                var2_2.reopenReadWrite();
            }
            ** GOTO lbl39
        }
        if (this.mName != null) ** GOTO lbl27
        var2_2 = var13_5 = SQLiteDatabase.create(null);
        ** GOTO lbl39
        {
            block22: {
                catch (Throwable var3_4) {
                    this.mIsInitializing = false;
                    if (var2_2 == null) throw var3_4;
                    if (var2_2 == this.mDatabase) throw var3_4;
                    var2_2.close();
                    throw var3_4;
                }
lbl27:
                // 1 sources

                try {
                    var9_6 = this.mContext;
                    var10_7 = this.mName;
                    var11_8 = this.mEnableWriteAheadLogging != false ? 8 : 0;
                    var2_2 = var12_9 = var9_6.openOrCreateDatabase(var10_7, var11_8, this.mFactory, this.mErrorHandler);
                }
                catch (SQLiteException var4_10) {
                    if (var1_1) {
                        throw var4_10;
                    }
                    Log.e(SQLiteOpenHelper.TAG, "Couldn't open " + this.mName + " for writing (will try read-only):", var4_10);
                    var2_2 = SQLiteDatabase.openDatabase(this.mContext.getDatabasePath(this.mName).getPath(), this.mFactory, 1, this.mErrorHandler);
                }
lbl39:
                // 4 sources

                this.onConfigure(var2_2);
                var6_3 = var2_2.getVersion();
                if (var6_3 == this.mNewVersion) break block22;
                if (var2_2.isReadOnly()) {
                    throw new SQLiteException("Can't upgrade read-only database from version " + var2_2.getVersion() + " to " + this.mNewVersion + ": " + this.mName);
                }
                var2_2.beginTransaction();
                if (var6_3 != 0) ** GOTO lbl49
                try {
                    block23: {
                        this.onCreate(var2_2);
                        ** GOTO lbl55
lbl49:
                        // 1 sources

                        if (var6_3 <= this.mNewVersion) break block23;
                        this.onDowngrade(var2_2, var6_3, this.mNewVersion);
                        ** GOTO lbl55
                    }
                    this.onUpgrade(var2_2, var6_3, this.mNewVersion);
lbl55:
                    // 3 sources

                    var2_2.setVersion(this.mNewVersion);
                    var2_2.setTransactionSuccessful();
                }
                catch (Throwable var8_11) {}
            }
            this.onOpen(var2_2);
            if (var2_2.isReadOnly()) {
                Log.w(SQLiteOpenHelper.TAG, "Opened " + this.mName + " in read-only mode");
            }
            this.mDatabase = var2_2;
            this.mIsInitializing = false;
            if (var2_2 == null) return var2_2;
            if (var2_2 == this.mDatabase) return var2_2;
            var2_2.close();
            return var2_2;
            throw var8_11;
        }
        finally {
            ** try [egrp 4[TRYBLOCK] [13 : 368->423)] { 
lbl72:
            // 1 sources

            var2_2.endTransaction();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        synchronized (this) {
            if (this.mIsInitializing) {
                throw new IllegalStateException("Closed during initialization");
            }
            if (this.mDatabase != null && this.mDatabase.isOpen()) {
                this.mDatabase.close();
                this.mDatabase = null;
            }
            return;
        }
    }

    public String getDatabaseName() {
        return this.mName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLiteDatabase getReadableDatabase() {
        synchronized (this) {
            return this.getDatabaseLocked(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLiteDatabase getWritableDatabase() {
        synchronized (this) {
            return this.getDatabaseLocked(true);
        }
    }

    public void onConfigure(SQLiteDatabase sQLiteDatabase) {
    }

    public abstract void onCreate(SQLiteDatabase var1);

    public void onDowngrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        throw new SQLiteException("Can't downgrade database from version " + n + " to " + n2);
    }

    public void onOpen(SQLiteDatabase sQLiteDatabase) {
    }

    public abstract void onUpgrade(SQLiteDatabase var1, int var2, int var3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setWriteAheadLoggingEnabled(boolean bl) {
        synchronized (this) {
            if (this.mEnableWriteAheadLogging != bl) {
                if (this.mDatabase != null && this.mDatabase.isOpen() && !this.mDatabase.isReadOnly()) {
                    if (bl) {
                        this.mDatabase.enableWriteAheadLogging();
                    } else {
                        this.mDatabase.disableWriteAheadLogging();
                    }
                }
                this.mEnableWriteAheadLogging = bl;
            }
            return;
        }
    }
}

