/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.NativeAllocatorTag;
import android.graphics.SurfaceTexture;
import android.media.MediaRecorder;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;

public class GLEnvironment {
    private int glEnvId;
    private boolean mManageContext = true;

    static {
        System.loadLibrary("filterfw");
    }

    public GLEnvironment() {
        this.nativeAllocate();
    }

    private GLEnvironment(NativeAllocatorTag nativeAllocatorTag) {
    }

    public static boolean isAnyContextActive() {
        return GLEnvironment.nativeIsAnyContextActive();
    }

    private native boolean nativeActivate();

    private native boolean nativeActivateSurfaceId(int var1);

    private native int nativeAddSurface(Surface var1);

    private native int nativeAddSurfaceFromMediaRecorder(MediaRecorder var1);

    private native int nativeAddSurfaceWidthHeight(Surface var1, int var2, int var3);

    private native boolean nativeAllocate();

    private native boolean nativeDeactivate();

    private native boolean nativeDeallocate();

    private native boolean nativeDisconnectSurfaceMediaSource(MediaRecorder var1);

    private native boolean nativeInitWithCurrentContext();

    private native boolean nativeInitWithNewContext();

    private native boolean nativeIsActive();

    private static native boolean nativeIsAnyContextActive();

    private native boolean nativeIsContextActive();

    private native boolean nativeRemoveSurfaceId(int var1);

    private native boolean nativeSetSurfaceTimestamp(long var1);

    private native boolean nativeSwapBuffers();

    public void activate() {
        if (Looper.myLooper() != null && Looper.myLooper().equals(Looper.getMainLooper())) {
            Log.e("FilterFramework", "Activating GL context in UI thread!");
        }
        if (this.mManageContext && !this.nativeActivate()) {
            throw new RuntimeException("Could not activate GLEnvironment!");
        }
    }

    public void activateSurfaceWithId(int n) {
        if (!this.nativeActivateSurfaceId(n)) {
            throw new RuntimeException("Could not activate surface " + n + "!");
        }
    }

    public void deactivate() {
        if (this.mManageContext && !this.nativeDeactivate()) {
            throw new RuntimeException("Could not deactivate GLEnvironment!");
        }
    }

    protected void finalize() throws Throwable {
        this.tearDown();
    }

    public void initWithCurrentContext() {
        this.mManageContext = false;
        if (!this.nativeInitWithCurrentContext()) {
            throw new RuntimeException("Could not initialize GLEnvironment with current context!");
        }
    }

    public void initWithNewContext() {
        this.mManageContext = true;
        if (!this.nativeInitWithNewContext()) {
            throw new RuntimeException("Could not initialize GLEnvironment with new context!");
        }
    }

    public boolean isActive() {
        return this.nativeIsActive();
    }

    public boolean isContextActive() {
        return this.nativeIsContextActive();
    }

    public int registerSurface(Surface surface) {
        int n = this.nativeAddSurface(surface);
        if (n < 0) {
            throw new RuntimeException("Error registering surface " + surface + "!");
        }
        return n;
    }

    public int registerSurfaceFromMediaRecorder(MediaRecorder mediaRecorder) {
        int n = this.nativeAddSurfaceFromMediaRecorder(mediaRecorder);
        if (n < 0) {
            throw new RuntimeException("Error registering surface from MediaRecorder" + mediaRecorder + "!");
        }
        return n;
    }

    public int registerSurfaceTexture(SurfaceTexture surfaceTexture, int n, int n2) {
        Surface surface = new Surface(surfaceTexture);
        int n3 = this.nativeAddSurfaceWidthHeight(surface, n, n2);
        surface.release();
        if (n3 < 0) {
            throw new RuntimeException("Error registering surfaceTexture " + surfaceTexture + "!");
        }
        return n3;
    }

    public void setSurfaceTimestamp(long l) {
        if (!this.nativeSetSurfaceTimestamp(l)) {
            throw new RuntimeException("Could not set timestamp for current surface!");
        }
    }

    public void swapBuffers() {
        if (!this.nativeSwapBuffers()) {
            throw new RuntimeException("Error swapping EGL buffers!");
        }
    }

    public void tearDown() {
        synchronized (this) {
            if (this.glEnvId != -1) {
                this.nativeDeallocate();
                this.glEnvId = -1;
            }
            return;
        }
    }

    public void unregisterSurfaceId(int n) {
        if (!this.nativeRemoveSurfaceId(n)) {
            throw new RuntimeException("Could not unregister surface " + n + "!");
        }
    }
}

