/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Shader;

public class RadialGradient
extends Shader {
    private static final int TYPE_COLORS_AND_POSITIONS = 1;
    private static final int TYPE_COLOR_CENTER_AND_COLOR_EDGE = 2;
    private int mCenterColor;
    private int[] mColors;
    private int mEdgeColor;
    private float[] mPositions;
    private float mRadius;
    private Shader.TileMode mTileMode;
    private int mType;
    private float mX;
    private float mY;

    public RadialGradient(float f, float f2, float f3, int n, int n2, Shader.TileMode tileMode) {
        if (f3 <= 0.0f) {
            throw new IllegalArgumentException("radius must be > 0");
        }
        this.mType = 2;
        this.mX = f;
        this.mY = f2;
        this.mRadius = f3;
        this.mCenterColor = n;
        this.mEdgeColor = n2;
        this.mTileMode = tileMode;
        this.init(RadialGradient.nativeCreate2(f, f2, f3, n, n2, tileMode.nativeInt));
    }

    public RadialGradient(float f, float f2, float f3, int[] nArray, float[] fArray, Shader.TileMode tileMode) {
        if (f3 <= 0.0f) {
            throw new IllegalArgumentException("radius must be > 0");
        }
        if (nArray.length < 2) {
            throw new IllegalArgumentException("needs >= 2 number of colors");
        }
        if (fArray != null && nArray.length != fArray.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
        this.mType = 1;
        this.mX = f;
        this.mY = f2;
        this.mRadius = f3;
        this.mColors = nArray;
        this.mPositions = fArray;
        this.mTileMode = tileMode;
        this.init(RadialGradient.nativeCreate1(f, f2, f3, nArray, fArray, tileMode.nativeInt));
    }

    private static native long nativeCreate1(float var0, float var1, float var2, int[] var3, float[] var4, int var5);

    private static native long nativeCreate2(float var0, float var1, float var2, int var3, int var4, int var5);

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Shader copy() {
        RadialGradient radialGradient;
        switch (this.mType) {
            default: {
                throw new IllegalArgumentException("RadialGradient should be created with either colors and positions or center color and edge color");
            }
            case 1: {
                float f = this.mX;
                float f2 = this.mY;
                float f3 = this.mRadius;
                int[] nArray = (int[])this.mColors.clone();
                float[] fArray = this.mPositions != null ? (float[])this.mPositions.clone() : null;
                radialGradient = new RadialGradient(f, f2, f3, nArray, fArray, this.mTileMode);
                break;
            }
            case 2: {
                radialGradient = new RadialGradient(this.mX, this.mY, this.mRadius, this.mCenterColor, this.mEdgeColor, this.mTileMode);
            }
        }
        this.copyLocalMatrix(radialGradient);
        return radialGradient;
    }
}

