/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Rect
implements Parcelable {
    public static final Parcelable.Creator<Rect> CREATOR = new Parcelable.Creator<Rect>(){

        @Override
        public Rect createFromParcel(Parcel parcel) {
            Rect rect = new Rect();
            rect.readFromParcel(parcel);
            return rect;
        }

        public Rect[] newArray(int n) {
            return new Rect[n];
        }
    };
    public int bottom;
    public int left;
    public int right;
    public int top;

    public Rect() {
    }

    public Rect(int n, int n2, int n3, int n4) {
        this.left = n;
        this.top = n2;
        this.right = n3;
        this.bottom = n4;
    }

    public Rect(Rect rect) {
        if (rect == null) {
            this.bottom = 0;
            this.right = 0;
            this.top = 0;
            this.left = 0;
            return;
        }
        this.left = rect.left;
        this.top = rect.top;
        this.right = rect.right;
        this.bottom = rect.bottom;
    }

    public static boolean intersects(Rect rect, Rect rect2) {
        return rect.left < rect2.right && rect2.left < rect.right && rect.top < rect2.bottom && rect2.top < rect.bottom;
    }

    public static Rect unflattenFromString(String string2) {
        Matcher matcher = UnflattenHelper.getMatcher(string2);
        if (!matcher.matches()) {
            return null;
        }
        return new Rect(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
    }

    public final int centerX() {
        return this.left + this.right >> 1;
    }

    public final int centerY() {
        return this.top + this.bottom >> 1;
    }

    public boolean contains(int n, int n2) {
        return this.left < this.right && this.top < this.bottom && n >= this.left && n < this.right && n2 >= this.top && n2 < this.bottom;
    }

    public boolean contains(int n, int n2, int n3, int n4) {
        return this.left < this.right && this.top < this.bottom && this.left <= n && this.top <= n2 && this.right >= n3 && this.bottom >= n4;
    }

    public boolean contains(Rect rect) {
        return this.left < this.right && this.top < this.bottom && this.left <= rect.left && this.top <= rect.top && this.right >= rect.right && this.bottom >= rect.bottom;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Rect rect = (Rect)object;
                if (this.left != rect.left || this.top != rect.top || this.right != rect.right || this.bottom != rect.bottom) break block5;
            }
            return true;
        }
        return false;
    }

    public final float exactCenterX() {
        return 0.5f * (float)(this.left + this.right);
    }

    public final float exactCenterY() {
        return 0.5f * (float)(this.top + this.bottom);
    }

    public String flattenToString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.left);
        stringBuilder.append(' ');
        stringBuilder.append(this.top);
        stringBuilder.append(' ');
        stringBuilder.append(this.right);
        stringBuilder.append(' ');
        stringBuilder.append(this.bottom);
        return stringBuilder.toString();
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.left + this.top) + this.right) + this.bottom;
    }

    public final int height() {
        return this.bottom - this.top;
    }

    public void inset(int n, int n2) {
        this.left = n + this.left;
        this.top = n2 + this.top;
        this.right -= n;
        this.bottom -= n2;
    }

    public boolean intersect(int n, int n2, int n3, int n4) {
        if (this.left < n3 && n < this.right && this.top < n4 && n2 < this.bottom) {
            if (this.left < n) {
                this.left = n;
            }
            if (this.top < n2) {
                this.top = n2;
            }
            if (this.right > n3) {
                this.right = n3;
            }
            if (this.bottom > n4) {
                this.bottom = n4;
            }
            return true;
        }
        return false;
    }

    public boolean intersect(Rect rect) {
        return this.intersect(rect.left, rect.top, rect.right, rect.bottom);
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        return this.left < n3 && n < this.right && this.top < n4 && n2 < this.bottom;
    }

    public final boolean isEmpty() {
        return this.left >= this.right || this.top >= this.bottom;
    }

    public void offset(int n, int n2) {
        this.left = n + this.left;
        this.top = n2 + this.top;
        this.right = n + this.right;
        this.bottom = n2 + this.bottom;
    }

    public void offsetTo(int n, int n2) {
        this.right += n - this.left;
        this.bottom += n2 - this.top;
        this.left = n;
        this.top = n2;
    }

    public void printShortString(PrintWriter printWriter) {
        printWriter.print('[');
        printWriter.print(this.left);
        printWriter.print(',');
        printWriter.print(this.top);
        printWriter.print("][");
        printWriter.print(this.right);
        printWriter.print(',');
        printWriter.print(this.bottom);
        printWriter.print(']');
    }

    public void readFromParcel(Parcel parcel) {
        this.left = parcel.readInt();
        this.top = parcel.readInt();
        this.right = parcel.readInt();
        this.bottom = parcel.readInt();
    }

    public void scale(float f) {
        if (f != 1.0f) {
            this.left = (int)(0.5f + f * (float)this.left);
            this.top = (int)(0.5f + f * (float)this.top);
            this.right = (int)(0.5f + f * (float)this.right);
            this.bottom = (int)(0.5f + f * (float)this.bottom);
        }
    }

    public void scaleRoundIn(float f) {
        if (f != 1.0f) {
            this.left = (int)Math.ceil(f * (float)this.left);
            this.top = (int)Math.ceil(f * (float)this.top);
            this.right = (int)Math.floor(f * (float)this.right);
            this.bottom = (int)Math.floor(f * (float)this.bottom);
        }
    }

    public void set(int n, int n2, int n3, int n4) {
        this.left = n;
        this.top = n2;
        this.right = n3;
        this.bottom = n4;
    }

    public void set(Rect rect) {
        this.left = rect.left;
        this.top = rect.top;
        this.right = rect.right;
        this.bottom = rect.bottom;
    }

    public void setEmpty() {
        this.bottom = 0;
        this.top = 0;
        this.right = 0;
        this.left = 0;
    }

    public boolean setIntersect(Rect rect, Rect rect2) {
        if (rect.left < rect2.right && rect2.left < rect.right && rect.top < rect2.bottom && rect2.top < rect.bottom) {
            this.left = Math.max(rect.left, rect2.left);
            this.top = Math.max(rect.top, rect2.top);
            this.right = Math.min(rect.right, rect2.right);
            this.bottom = Math.min(rect.bottom, rect2.bottom);
            return true;
        }
        return false;
    }

    public void sort() {
        if (this.left > this.right) {
            int n = this.left;
            this.left = this.right;
            this.right = n;
        }
        if (this.top > this.bottom) {
            int n = this.top;
            this.top = this.bottom;
            this.bottom = n;
        }
    }

    public String toShortString() {
        return this.toShortString(new StringBuilder(32));
    }

    public String toShortString(StringBuilder stringBuilder) {
        stringBuilder.setLength(0);
        stringBuilder.append('[');
        stringBuilder.append(this.left);
        stringBuilder.append(',');
        stringBuilder.append(this.top);
        stringBuilder.append("][");
        stringBuilder.append(this.right);
        stringBuilder.append(',');
        stringBuilder.append(this.bottom);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("Rect(");
        stringBuilder.append(this.left);
        stringBuilder.append(", ");
        stringBuilder.append(this.top);
        stringBuilder.append(" - ");
        stringBuilder.append(this.right);
        stringBuilder.append(", ");
        stringBuilder.append(this.bottom);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void union(int n, int n2) {
        if (n < this.left) {
            this.left = n;
        } else if (n > this.right) {
            this.right = n;
        }
        if (n2 < this.top) {
            this.top = n2;
            return;
        } else {
            if (n2 <= this.bottom) return;
            this.bottom = n2;
            return;
        }
    }

    public void union(int n, int n2, int n3, int n4) {
        block8: {
            block7: {
                if (n >= n3 || n2 >= n4) break block7;
                if (this.left >= this.right || this.top >= this.bottom) break block8;
                if (this.left > n) {
                    this.left = n;
                }
                if (this.top > n2) {
                    this.top = n2;
                }
                if (this.right < n3) {
                    this.right = n3;
                }
                if (this.bottom < n4) {
                    this.bottom = n4;
                }
            }
            return;
        }
        this.left = n;
        this.top = n2;
        this.right = n3;
        this.bottom = n4;
    }

    public void union(Rect rect) {
        this.union(rect.left, rect.top, rect.right, rect.bottom);
    }

    public final int width() {
        return this.right - this.left;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.left);
        parcel.writeInt(this.top);
        parcel.writeInt(this.right);
        parcel.writeInt(this.bottom);
    }

    private static final class UnflattenHelper {
        private static final Pattern FLATTENED_PATTERN = Pattern.compile("(-?\\d+) (-?\\d+) (-?\\d+) (-?\\d+)");

        private UnflattenHelper() {
        }

        static Matcher getMatcher(String string2) {
            return FLATTENED_PATTERN.matcher(string2);
        }
    }
}

