/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayerDrawable
extends Drawable
implements Drawable.Callback {
    public static final int PADDING_MODE_NEST = 0;
    public static final int PADDING_MODE_STACK = 1;
    private Rect mHotspotBounds;
    LayerState mLayerState;
    private boolean mMutated;
    private int mOpacityOverride = 0;
    private int[] mPaddingB;
    private int[] mPaddingL;
    private int[] mPaddingR;
    private int[] mPaddingT;
    private final Rect mTmpRect = new Rect();

    LayerDrawable() {
        this(null, null, null);
    }

    LayerDrawable(LayerState layerState, Resources resources, Resources.Theme theme) {
        LayerState layerState2;
        this.mLayerState = layerState2 = this.createConstantState(layerState, resources);
        if (layerState2.mNum > 0) {
            this.ensurePadding();
        }
        if (theme != null && this.canApplyTheme()) {
            this.applyTheme(theme);
        }
    }

    public LayerDrawable(Drawable[] drawableArray) {
        this(drawableArray, null);
    }

    LayerDrawable(Drawable[] drawableArray, LayerState layerState) {
        this(layerState, null, null);
        int n = drawableArray.length;
        ChildDrawable[] childDrawableArray = new ChildDrawable[n];
        for (int i = 0; i < n; ++i) {
            childDrawableArray[i] = new ChildDrawable();
            childDrawableArray[i].mDrawable = drawableArray[i];
            drawableArray[i].setCallback(this);
            LayerState layerState2 = this.mLayerState;
            layerState2.mChildrenChangingConfigurations |= drawableArray[i].getChangingConfigurations();
        }
        this.mLayerState.mNum = n;
        this.mLayerState.mChildren = childDrawableArray;
        this.ensurePadding();
    }

    private void computeNestedPadding(Rect rect) {
        rect.left = 0;
        rect.top = 0;
        rect.right = 0;
        rect.bottom = 0;
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        for (int i = 0; i < n; ++i) {
            this.refreshChildPadding(i, childDrawableArray[i]);
            rect.left += this.mPaddingL[i];
            rect.top += this.mPaddingT[i];
            rect.right += this.mPaddingR[i];
            rect.bottom += this.mPaddingB[i];
        }
    }

    private void computeStackedPadding(Rect rect) {
        rect.left = 0;
        rect.top = 0;
        rect.right = 0;
        rect.bottom = 0;
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        for (int i = 0; i < n; ++i) {
            this.refreshChildPadding(i, childDrawableArray[i]);
            rect.left = Math.max(rect.left, this.mPaddingL[i]);
            rect.top = Math.max(rect.top, this.mPaddingT[i]);
            rect.right = Math.max(rect.right, this.mPaddingR[i]);
            rect.bottom = Math.max(rect.bottom, this.mPaddingB[i]);
        }
    }

    private void inflateLayers(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        int n;
        int n2;
        LayerState layerState = this.mLayerState;
        int n3 = 1 + xmlPullParser.getDepth();
        while ((n2 = xmlPullParser.next()) != 1 && ((n = xmlPullParser.getDepth()) >= n3 || n2 != 3)) {
            if (n2 != 2 || n > n3 || !xmlPullParser.getName().equals("item")) continue;
            ChildDrawable childDrawable = new ChildDrawable();
            TypedArray typedArray = LayerDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.LayerDrawableItem);
            this.updateLayerFromTypedArray(childDrawable, typedArray);
            typedArray.recycle();
            if (childDrawable.mDrawable == null) {
                int n4;
                while ((n4 = xmlPullParser.next()) == 4) {
                }
                if (n4 != 2) {
                    throw new XmlPullParserException(xmlPullParser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
                }
                childDrawable.mDrawable = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet, theme);
            }
            if (childDrawable.mDrawable != null) {
                layerState.mChildrenChangingConfigurations |= childDrawable.mDrawable.getChangingConfigurations();
                childDrawable.mDrawable.setCallback(this);
            }
            this.addLayer(childDrawable);
        }
    }

    private boolean refreshChildPadding(int n, ChildDrawable childDrawable) {
        Rect rect = this.mTmpRect;
        childDrawable.mDrawable.getPadding(rect);
        if (rect.left != this.mPaddingL[n] || rect.top != this.mPaddingT[n] || rect.right != this.mPaddingR[n] || rect.bottom != this.mPaddingB[n]) {
            this.mPaddingL[n] = rect.left;
            this.mPaddingT[n] = rect.top;
            this.mPaddingR[n] = rect.right;
            this.mPaddingB[n] = rect.bottom;
            return true;
        }
        return false;
    }

    private void updateLayerFromTypedArray(ChildDrawable childDrawable, TypedArray typedArray) {
        LayerState layerState = this.mLayerState;
        layerState.mChildrenChangingConfigurations |= typedArray.getChangingConfigurations();
        childDrawable.mThemeAttrs = typedArray.extractThemeAttrs();
        childDrawable.mInsetL = typedArray.getDimensionPixelOffset(2, childDrawable.mInsetL);
        childDrawable.mInsetT = typedArray.getDimensionPixelOffset(3, childDrawable.mInsetT);
        childDrawable.mInsetR = typedArray.getDimensionPixelOffset(4, childDrawable.mInsetR);
        childDrawable.mInsetB = typedArray.getDimensionPixelOffset(5, childDrawable.mInsetB);
        childDrawable.mId = typedArray.getResourceId(0, childDrawable.mId);
        Drawable drawable2 = typedArray.getDrawable(1);
        if (drawable2 != null) {
            childDrawable.mDrawable = drawable2;
        }
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        LayerState layerState = this.mLayerState;
        layerState.mChangingConfigurations |= typedArray.getChangingConfigurations();
        layerState.mThemeAttrs = typedArray.extractThemeAttrs();
        this.mOpacityOverride = typedArray.getInt(0, this.mOpacityOverride);
        LayerState.access$002(layerState, typedArray.getBoolean(1, layerState.mAutoMirrored));
        LayerState.access$102(layerState, typedArray.getInteger(2, layerState.mPaddingMode));
    }

    ChildDrawable addLayer(Drawable drawable2, int[] nArray, int n, int n2, int n3, int n4, int n5) {
        ChildDrawable childDrawable = new ChildDrawable();
        childDrawable.mId = n;
        childDrawable.mThemeAttrs = nArray;
        childDrawable.mDrawable = drawable2;
        childDrawable.mDrawable.setAutoMirrored(this.isAutoMirrored());
        childDrawable.mInsetL = n2;
        childDrawable.mInsetT = n3;
        childDrawable.mInsetR = n4;
        childDrawable.mInsetB = n5;
        this.addLayer(childDrawable);
        LayerState layerState = this.mLayerState;
        layerState.mChildrenChangingConfigurations |= drawable2.getChangingConfigurations();
        drawable2.setCallback(this);
        return childDrawable;
    }

    /*
     * Enabled aggressive block sorting
     */
    void addLayer(ChildDrawable childDrawable) {
        LayerState layerState = this.mLayerState;
        int n = layerState.mNum;
        int n2 = layerState.mChildren != null ? layerState.mChildren.length : 0;
        if (n >= n2) {
            ChildDrawable[] childDrawableArray = new ChildDrawable[n2 + 10];
            if (n > 0) {
                System.arraycopy(layerState.mChildren, 0, childDrawableArray, 0, n);
            }
            layerState.mChildren = childDrawableArray;
        }
        layerState.mChildren[n] = childDrawable;
        layerState.mNum = 1 + layerState.mNum;
        layerState.invalidateCache();
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        super.applyTheme(theme);
        LayerState layerState = this.mLayerState;
        if (layerState == null) {
            return;
        }
        if (layerState.mThemeAttrs != null) {
            TypedArray typedArray = theme.resolveAttributes(layerState.mThemeAttrs, R.styleable.LayerDrawable);
            this.updateStateFromTypedArray(typedArray);
            typedArray.recycle();
        }
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        for (int i = 0; i < n; ++i) {
            Drawable drawable2;
            ChildDrawable childDrawable = childDrawableArray[i];
            if (childDrawable.mThemeAttrs != null) {
                TypedArray typedArray = theme.resolveAttributes(childDrawable.mThemeAttrs, R.styleable.LayerDrawableItem);
                this.updateLayerFromTypedArray(childDrawable, typedArray);
                typedArray.recycle();
            }
            if (!(drawable2 = childDrawable.mDrawable).canApplyTheme()) continue;
            drawable2.applyTheme(theme);
        }
        this.ensurePadding();
        this.onStateChange(this.getState());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean canApplyTheme() {
        LayerState layerState = this.mLayerState;
        if (layerState != null) {
            if (layerState.mThemeAttrs != null) {
                return true;
            }
            ChildDrawable[] childDrawableArray = layerState.mChildren;
            int n = layerState.mNum;
            for (int i = 0; i < n; ++i) {
                ChildDrawable childDrawable = childDrawableArray[i];
                if (childDrawable.mThemeAttrs == null && !childDrawable.mDrawable.canApplyTheme()) continue;
                return true;
            }
        }
        return false;
    }

    LayerState createConstantState(LayerState layerState, Resources resources) {
        return new LayerState(layerState, this, resources);
    }

    @Override
    public void draw(Canvas canvas) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        for (int i = 0; i < n; ++i) {
            childDrawableArray[i].mDrawable.draw(canvas);
        }
    }

    void ensurePadding() {
        int n = this.mLayerState.mNum;
        if (this.mPaddingL != null && this.mPaddingL.length >= n) {
            return;
        }
        this.mPaddingL = new int[n];
        this.mPaddingT = new int[n];
        this.mPaddingR = new int[n];
        this.mPaddingB = new int[n];
    }

    public Drawable findDrawableByLayerId(int n) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        for (int i = -1 + this.mLayerState.mNum; i >= 0; --i) {
            if (childDrawableArray[i].mId != n) continue;
            return childDrawableArray[i].mDrawable;
        }
        return null;
    }

    @Override
    public int getAlpha() {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        if (this.mLayerState.mNum > 0) {
            return childDrawableArray[0].mDrawable.getAlpha();
        }
        return super.getAlpha();
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mLayerState.mChangingConfigurations | this.mLayerState.mChildrenChangingConfigurations;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        if (this.mLayerState.canConstantState()) {
            this.mLayerState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mLayerState;
        }
        return null;
    }

    public Drawable getDrawable(int n) {
        return this.mLayerState.mChildren[n].mDrawable;
    }

    @Override
    public void getHotspotBounds(Rect rect) {
        if (this.mHotspotBounds != null) {
            rect.set(this.mHotspotBounds);
            return;
        }
        super.getHotspotBounds(rect);
    }

    public int getId(int n) {
        return this.mLayerState.mChildren[n].mId;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getIntrinsicHeight() {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        boolean bl = this.mLayerState.mPaddingMode == 0;
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n4 = this.mLayerState.mNum;
        int n5 = 0;
        while (n5 < n4) {
            ChildDrawable childDrawable = childDrawableArray[n5];
            int n6 = n3 + (n2 + (childDrawable.mDrawable.getIntrinsicHeight() + childDrawable.mInsetT + childDrawable.mInsetB));
            if (n6 > n) {
                n = n6;
            }
            if (bl) {
                n2 += this.mPaddingT[n5];
                n3 += this.mPaddingB[n5];
            }
            ++n5;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getIntrinsicWidth() {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        boolean bl = this.mLayerState.mPaddingMode == 0;
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n4 = this.mLayerState.mNum;
        int n5 = 0;
        while (n5 < n4) {
            ChildDrawable childDrawable = childDrawableArray[n5];
            int n6 = n3 + (n2 + (childDrawable.mDrawable.getIntrinsicWidth() + childDrawable.mInsetL + childDrawable.mInsetR));
            if (n6 > n) {
                n = n6;
            }
            if (bl) {
                n2 += this.mPaddingL[n5];
                n3 += this.mPaddingR[n5];
            }
            ++n5;
        }
        return n;
    }

    public int getNumberOfLayers() {
        return this.mLayerState.mNum;
    }

    @Override
    public int getOpacity() {
        if (this.mOpacityOverride != 0) {
            return this.mOpacityOverride;
        }
        return this.mLayerState.getOpacity();
    }

    @Override
    public void getOutline(Outline outline) {
        LayerState layerState = this.mLayerState;
        ChildDrawable[] childDrawableArray = layerState.mChildren;
        int n = layerState.mNum;
        int n2 = 0;
        while (true) {
            block4: {
                block3: {
                    if (n2 >= n) break block3;
                    childDrawableArray[n2].mDrawable.getOutline(outline);
                    if (outline.isEmpty()) break block4;
                }
                return;
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getPadding(Rect rect) {
        if (this.mLayerState.mPaddingMode == 0) {
            this.computeNestedPadding(rect);
            return rect.left != 0 || rect.top != 0 || rect.right != 0 || rect.bottom != 0;
        }
        this.computeStackedPadding(rect);
        return rect.left != 0 || rect.top != 0 || rect.right != 0 || rect.bottom != 0;
    }

    public int getPaddingMode() {
        return this.mLayerState.mPaddingMode;
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(resources, xmlPullParser, attributeSet, theme);
        TypedArray typedArray = LayerDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.LayerDrawable);
        this.updateStateFromTypedArray(typedArray);
        typedArray.recycle();
        this.inflateLayers(resources, xmlPullParser, attributeSet, theme);
        this.ensurePadding();
        this.onStateChange(this.getState());
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        this.invalidateSelf();
    }

    @Override
    public boolean isAutoMirrored() {
        return this.mLayerState.mAutoMirrored;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isProjected() {
        if (!super.isProjected()) {
            ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
            int n = this.mLayerState.mNum;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                if (childDrawableArray[n2].mDrawable.isProjected()) break;
                ++n2;
            }
        }
        return true;
    }

    @Override
    public boolean isStateful() {
        return this.mLayerState.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mLayerState = this.createConstantState(this.mLayerState, null);
            ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
            int n = this.mLayerState.mNum;
            for (int i = 0; i < n; ++i) {
                childDrawableArray[i].mDrawable.mutate();
            }
            this.mMutated = true;
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onBoundsChange(Rect rect) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = this.mLayerState.mPaddingMode == 0;
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n5 = this.mLayerState.mNum;
        int n6 = 0;
        while (n6 < n5) {
            ChildDrawable childDrawable = childDrawableArray[n6];
            childDrawable.mDrawable.setBounds(n + (rect.left + childDrawable.mInsetL), n2 + (rect.top + childDrawable.mInsetT), rect.right - childDrawable.mInsetR - n3, rect.bottom - childDrawable.mInsetB - n4);
            if (bl) {
                n += this.mPaddingL[n6];
                n3 += this.mPaddingR[n6];
                n2 += this.mPaddingT[n6];
                n4 += this.mPaddingB[n6];
            }
            ++n6;
        }
        return;
    }

    @Override
    protected boolean onLevelChange(int n) {
        boolean bl = false;
        boolean bl2 = false;
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n2 = this.mLayerState.mNum;
        for (int i = 0; i < n2; ++i) {
            ChildDrawable childDrawable = childDrawableArray[i];
            if (childDrawable.mDrawable.setLevel(n)) {
                bl2 = true;
            }
            if (!this.refreshChildPadding(i, childDrawable)) continue;
            bl = true;
        }
        if (bl) {
            this.onBoundsChange(this.getBounds());
        }
        return bl2;
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        boolean bl = false;
        boolean bl2 = false;
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        for (int i = 0; i < n; ++i) {
            ChildDrawable childDrawable = childDrawableArray[i];
            if (childDrawable.mDrawable.isStateful() && childDrawable.mDrawable.setState(nArray)) {
                bl2 = true;
            }
            if (!this.refreshChildPadding(i, childDrawable)) continue;
            bl = true;
        }
        if (bl) {
            this.onBoundsChange(this.getBounds());
        }
        return bl2;
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        this.scheduleSelf(runnable, l);
    }

    @Override
    public void setAlpha(int n) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n2 = this.mLayerState.mNum;
        for (int i = 0; i < n2; ++i) {
            childDrawableArray[i].mDrawable.setAlpha(n);
        }
    }

    @Override
    public void setAutoMirrored(boolean bl) {
        LayerState.access$002(this.mLayerState, bl);
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        for (int i = 0; i < n; ++i) {
            childDrawableArray[i].mDrawable.setAutoMirrored(bl);
        }
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        for (int i = 0; i < n; ++i) {
            childDrawableArray[i].mDrawable.setColorFilter(colorFilter);
        }
    }

    @Override
    public void setDither(boolean bl) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        for (int i = 0; i < n; ++i) {
            childDrawableArray[i].mDrawable.setDither(bl);
        }
    }

    public boolean setDrawableByLayerId(int n, Drawable drawable2) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n2 = this.mLayerState.mNum;
        for (int i = 0; i < n2; ++i) {
            ChildDrawable childDrawable = childDrawableArray[i];
            if (childDrawable.mId != n) continue;
            if (childDrawable.mDrawable != null) {
                if (drawable2 != null) {
                    drawable2.setBounds(childDrawable.mDrawable.getBounds());
                }
                childDrawable.mDrawable.setCallback(null);
            }
            if (drawable2 != null) {
                drawable2.setCallback(this);
            }
            childDrawable.mDrawable = drawable2;
            this.mLayerState.invalidateCache();
            return true;
        }
        return false;
    }

    @Override
    public void setHotspot(float f, float f2) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        for (int i = 0; i < n; ++i) {
            childDrawableArray[i].mDrawable.setHotspot(f, f2);
        }
    }

    @Override
    public void setHotspotBounds(int n, int n2, int n3, int n4) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n5 = this.mLayerState.mNum;
        for (int i = 0; i < n5; ++i) {
            childDrawableArray[i].mDrawable.setHotspotBounds(n, n2, n3, n4);
        }
        if (this.mHotspotBounds == null) {
            this.mHotspotBounds = new Rect(n, n2, n3, n4);
            return;
        }
        this.mHotspotBounds.set(n, n2, n3, n4);
    }

    public void setId(int n, int n2) {
        this.mLayerState.mChildren[n].mId = n2;
    }

    public void setLayerInset(int n, int n2, int n3, int n4, int n5) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[n];
        childDrawable.mInsetL = n2;
        childDrawable.mInsetT = n3;
        childDrawable.mInsetR = n4;
        childDrawable.mInsetB = n5;
    }

    @Override
    public void setLayoutDirection(int n) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n2 = this.mLayerState.mNum;
        for (int i = 0; i < n2; ++i) {
            childDrawableArray[i].mDrawable.setLayoutDirection(n);
        }
        super.setLayoutDirection(n);
    }

    public void setOpacity(int n) {
        this.mOpacityOverride = n;
    }

    public void setPaddingMode(int n) {
        if (this.mLayerState.mPaddingMode != n) {
            LayerState.access$102(this.mLayerState, n);
        }
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        for (int i = 0; i < n; ++i) {
            childDrawableArray[i].mDrawable.setTintList(colorStateList);
        }
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        for (int i = 0; i < n; ++i) {
            childDrawableArray[i].mDrawable.setTintMode(mode);
        }
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        boolean bl3 = super.setVisible(bl, bl2);
        ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        int n = this.mLayerState.mNum;
        for (int i = 0; i < n; ++i) {
            childDrawableArray[i].mDrawable.setVisible(bl, bl2);
        }
        return bl3;
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        this.unscheduleSelf(runnable);
    }

    static class ChildDrawable {
        public Drawable mDrawable;
        public int mId = -1;
        public int mInsetB;
        public int mInsetL;
        public int mInsetR;
        public int mInsetT;
        public int[] mThemeAttrs;

        ChildDrawable() {
        }

        /*
         * Enabled aggressive block sorting
         */
        ChildDrawable(ChildDrawable childDrawable, LayerDrawable layerDrawable, Resources resources) {
            this.mDrawable = resources != null ? childDrawable.mDrawable.getConstantState().newDrawable(resources) : childDrawable.mDrawable.getConstantState().newDrawable();
            this.mDrawable.setCallback(layerDrawable);
            this.mDrawable.setLayoutDirection(childDrawable.mDrawable.getLayoutDirection());
            this.mDrawable.setBounds(childDrawable.mDrawable.getBounds());
            this.mDrawable.setLevel(childDrawable.mDrawable.getLevel());
            this.mThemeAttrs = childDrawable.mThemeAttrs;
            this.mInsetL = childDrawable.mInsetL;
            this.mInsetT = childDrawable.mInsetT;
            this.mInsetR = childDrawable.mInsetR;
            this.mInsetB = childDrawable.mInsetB;
            this.mId = childDrawable.mId;
        }
    }

    static class LayerState
    extends Drawable.ConstantState {
        private boolean mAutoMirrored = false;
        int mChangingConfigurations;
        ChildDrawable[] mChildren;
        int mChildrenChangingConfigurations;
        private boolean mHaveIsStateful;
        private boolean mHaveOpacity;
        private boolean mIsStateful;
        int mNum;
        private int mOpacity;
        private int mPaddingMode = 0;
        int[] mThemeAttrs;

        LayerState(LayerState layerState, LayerDrawable layerDrawable, Resources resources) {
            if (layerState != null) {
                int n;
                ChildDrawable[] childDrawableArray = layerState.mChildren;
                this.mNum = n = layerState.mNum;
                this.mChildren = new ChildDrawable[n];
                this.mChangingConfigurations = layerState.mChangingConfigurations;
                this.mChildrenChangingConfigurations = layerState.mChildrenChangingConfigurations;
                for (int i = 0; i < n; ++i) {
                    ChildDrawable childDrawable = childDrawableArray[i];
                    this.mChildren[i] = new ChildDrawable(childDrawable, layerDrawable, resources);
                }
                this.mHaveOpacity = layerState.mHaveOpacity;
                this.mOpacity = layerState.mOpacity;
                this.mHaveIsStateful = layerState.mHaveIsStateful;
                this.mIsStateful = layerState.mIsStateful;
                this.mAutoMirrored = layerState.mAutoMirrored;
                this.mPaddingMode = layerState.mPaddingMode;
                this.mThemeAttrs = layerState.mThemeAttrs;
                return;
            }
            this.mNum = 0;
            this.mChildren = null;
        }

        static /* synthetic */ boolean access$002(LayerState layerState, boolean bl) {
            layerState.mAutoMirrored = bl;
            return bl;
        }

        static /* synthetic */ int access$102(LayerState layerState, int n) {
            layerState.mPaddingMode = n;
            return n;
        }

        @Override
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        public final boolean canConstantState() {
            ChildDrawable[] childDrawableArray = this.mChildren;
            int n = this.mNum;
            for (int i = 0; i < n; ++i) {
                if (childDrawableArray[i].mDrawable.getConstantState() != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        /*
         * Enabled aggressive block sorting
         */
        public final int getOpacity() {
            if (this.mHaveOpacity) {
                return this.mOpacity;
            }
            ChildDrawable[] childDrawableArray = this.mChildren;
            int n = this.mNum;
            int n2 = n > 0 ? childDrawableArray[0].mDrawable.getOpacity() : -2;
            int n3 = 1;
            while (true) {
                if (n3 >= n) {
                    this.mOpacity = n2;
                    this.mHaveOpacity = true;
                    return n2;
                }
                n2 = Drawable.resolveOpacity(n2, childDrawableArray[n3].mDrawable.getOpacity());
                ++n3;
            }
        }

        public void invalidateCache() {
            this.mHaveOpacity = false;
            this.mHaveIsStateful = false;
        }

        public final boolean isStateful() {
            if (this.mHaveIsStateful) {
                return this.mIsStateful;
            }
            ChildDrawable[] childDrawableArray = this.mChildren;
            int n = this.mNum;
            int n2 = 0;
            while (true) {
                block6: {
                    boolean bl;
                    block5: {
                        bl = false;
                        if (n2 >= n) break block5;
                        if (!childDrawableArray[n2].mDrawable.isStateful()) break block6;
                        bl = true;
                    }
                    this.mIsStateful = bl;
                    this.mHaveIsStateful = true;
                    return bl;
                }
                ++n2;
            }
        }

        @Override
        public Drawable newDrawable() {
            return new LayerDrawable(this, null, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new LayerDrawable(this, resources, null);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return new LayerDrawable(this, resources, theme);
        }
    }
}

