/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable.shapes;

import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.shapes.RectShape;

public class RoundRectShape
extends RectShape {
    private float[] mInnerRadii;
    private RectF mInnerRect;
    private RectF mInset;
    private float[] mOuterRadii;
    private Path mPath;

    public RoundRectShape(float[] fArray, RectF rectF, float[] fArray2) {
        if (fArray != null && fArray.length < 8) {
            throw new ArrayIndexOutOfBoundsException("outer radii must have >= 8 values");
        }
        if (fArray2 != null && fArray2.length < 8) {
            throw new ArrayIndexOutOfBoundsException("inner radii must have >= 8 values");
        }
        this.mOuterRadii = fArray;
        this.mInset = rectF;
        this.mInnerRadii = fArray2;
        if (rectF != null) {
            this.mInnerRect = new RectF();
        }
        this.mPath = new Path();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public RoundRectShape clone() throws CloneNotSupportedException {
        RoundRectShape roundRectShape = (RoundRectShape)super.clone();
        float[] fArray = this.mOuterRadii != null ? (float[])this.mOuterRadii.clone() : null;
        roundRectShape.mOuterRadii = fArray;
        float[] fArray2 = this.mInnerRadii != null ? (float[])this.mInnerRadii.clone() : null;
        roundRectShape.mInnerRadii = fArray2;
        roundRectShape.mInset = new RectF(this.mInset);
        roundRectShape.mInnerRect = new RectF(this.mInnerRect);
        roundRectShape.mPath = new Path(this.mPath);
        return roundRectShape;
    }

    @Override
    public void draw(Canvas canvas, Paint paint) {
        canvas.drawPath(this.mPath, paint);
    }

    @Override
    public void getOutline(Outline outline) {
        if (this.mInnerRect != null) {
            return;
        }
        float[] fArray = this.mOuterRadii;
        float f = 0.0f;
        if (fArray != null) {
            f = this.mOuterRadii[0];
            for (int i = 1; i < 8; ++i) {
                if (this.mOuterRadii[i] == f) continue;
                outline.setConvexPath(this.mPath);
                return;
            }
        }
        RectF rectF = this.rect();
        outline.setRoundRect((int)Math.ceil(rectF.left), (int)Math.ceil(rectF.top), (int)Math.floor(rectF.right), (int)Math.floor(rectF.bottom), f);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onResize(float f, float f2) {
        super.onResize(f, f2);
        RectF rectF = this.rect();
        this.mPath.reset();
        if (this.mOuterRadii != null) {
            this.mPath.addRoundRect(rectF, this.mOuterRadii, Path.Direction.CW);
        } else {
            this.mPath.addRect(rectF, Path.Direction.CW);
        }
        if (this.mInnerRect != null) {
            this.mInnerRect.set(rectF.left + this.mInset.left, rectF.top + this.mInset.top, rectF.right - this.mInset.right, rectF.bottom - this.mInset.bottom);
            if (this.mInnerRect.width() < f && this.mInnerRect.height() < f2) {
                if (this.mInnerRadii == null) {
                    this.mPath.addRect(this.mInnerRect, Path.Direction.CCW);
                    return;
                }
                this.mPath.addRoundRect(this.mInnerRect, this.mInnerRadii, Path.Direction.CCW);
            }
        }
    }
}

