/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.content.Context;
import android.hardware.IConsumerIrService;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public final class ConsumerIrManager {
    private static final String TAG = "ConsumerIr";
    private final String mPackageName;
    private final IConsumerIrService mService;

    public ConsumerIrManager(Context context) {
        this.mPackageName = context.getPackageName();
        this.mService = IConsumerIrService.Stub.asInterface(ServiceManager.getService("consumer_ir"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CarrierFrequencyRange[] getCarrierFrequencies() {
        int n;
        CarrierFrequencyRange[] carrierFrequencyRangeArray;
        int[] nArray;
        block6: {
            if (this.mService == null) {
                Log.w(TAG, "no consumer ir service.");
                return null;
            }
            nArray = this.mService.getCarrierFrequencies();
            if (nArray.length % 2 == 0) break block6;
            Log.w(TAG, "consumer ir service returned an uneven number of frequencies.");
            return null;
        }
        try {
            carrierFrequencyRangeArray = new CarrierFrequencyRange[nArray.length / 2];
            n = 0;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        while (true) {
            if (n >= nArray.length) return carrierFrequencyRangeArray;
            carrierFrequencyRangeArray[n / 2] = new CarrierFrequencyRange(nArray[n], nArray[n + 1]);
            n += 2;
            continue;
            break;
        }
    }

    public boolean hasIrEmitter() {
        if (this.mService == null) {
            Log.w(TAG, "no consumer ir service.");
            return false;
        }
        try {
            boolean bl = this.mService.hasIrEmitter();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void transmit(int n, int[] nArray) {
        if (this.mService == null) {
            Log.w(TAG, "failed to transmit; no consumer ir service.");
            return;
        }
        try {
            this.mService.transmit(this.mPackageName, n, nArray);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "failed to transmit.", remoteException);
            return;
        }
    }

    public final class CarrierFrequencyRange {
        private final int mMaxFrequency;
        private final int mMinFrequency;

        public CarrierFrequencyRange(int n, int n2) {
            this.mMinFrequency = n;
            this.mMaxFrequency = n2;
        }

        public int getMaxFrequency() {
            return this.mMaxFrequency;
        }

        public int getMinFrequency() {
            return this.mMinFrequency;
        }
    }
}

