/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.dispatch;

import android.hardware.camera2.dispatch.Dispatchable;
import com.android.internal.util.Preconditions;
import java.lang.reflect.Method;

public class ArgumentReplacingDispatcher<T, TArg>
implements Dispatchable<T> {
    private final int mArgumentIndex;
    private final TArg mReplaceWith;
    private final Dispatchable<T> mTarget;

    public ArgumentReplacingDispatcher(Dispatchable<T> dispatchable, int n, TArg TArg) {
        this.mTarget = Preconditions.checkNotNull(dispatchable, "target must not be null");
        this.mArgumentIndex = Preconditions.checkArgumentNonnegative(n, "argumentIndex must not be negative");
        this.mReplaceWith = Preconditions.checkNotNull(TArg, "replaceWith must not be null");
    }

    private static Object[] arrayCopy(Object[] objectArray) {
        int n = objectArray.length;
        Object[] objectArray2 = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray2[i] = objectArray[i];
        }
        return objectArray2;
    }

    @Override
    public Object dispatch(Method method, Object[] objectArray) throws Throwable {
        if (objectArray.length > this.mArgumentIndex) {
            objectArray = ArgumentReplacingDispatcher.arrayCopy(objectArray);
            objectArray[this.mArgumentIndex] = this.mReplaceWith;
        }
        return this.mTarget.dispatch(method, objectArray);
    }
}

