/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.legacy.RequestHolder;
import android.os.Handler;
import android.util.Log;

public class CameraDeviceState {
    private static final boolean DEBUG = false;
    public static final int NO_CAPTURE_ERROR = -1;
    private static final int STATE_CAPTURING = 4;
    private static final int STATE_CONFIGURING = 2;
    private static final int STATE_ERROR = 0;
    private static final int STATE_IDLE = 3;
    private static final int STATE_UNCONFIGURED = 1;
    private static final String TAG = "CameraDeviceState";
    private static final String[] sStateNames;
    private int mCurrentError = -1;
    private Handler mCurrentHandler = null;
    private CameraDeviceStateListener mCurrentListener = null;
    private RequestHolder mCurrentRequest = null;
    private int mCurrentState = 1;

    static {
        DEBUG = Log.isLoggable("HAL1ShimLogging", 3);
        sStateNames = new String[]{"ERROR", "UNCONFIGURED", "CONFIGURING", "IDLE", "CAPTURING"};
    }

    private void doStateTransition(int n) {
        this.doStateTransition(n, 0L, -1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doStateTransition(int n, final long l, final int n2) {
        if (n != this.mCurrentState) {
            String string2 = "UNKNOWN";
            if (n >= 0 && n < sStateNames.length) {
                string2 = sStateNames[n];
            }
            Log.i(TAG, "Legacy camera service transitioning to state " + string2);
        }
        if (n != 0 && n != 3 && this.mCurrentState != n && this.mCurrentHandler != null && this.mCurrentListener != null) {
            this.mCurrentHandler.post(new Runnable(){

                @Override
                public void run() {
                    CameraDeviceState.this.mCurrentListener.onBusy();
                }
            });
        }
        switch (n) {
            default: {
                throw new IllegalStateException("Transition to unknown state: " + n);
            }
            case 0: {
                if (this.mCurrentState != 0 && this.mCurrentHandler != null && this.mCurrentListener != null) {
                    this.mCurrentHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CameraDeviceState.this.mCurrentListener.onError(CameraDeviceState.this.mCurrentError, CameraDeviceState.this.mCurrentRequest);
                        }
                    });
                }
                this.mCurrentState = 0;
                return;
            }
            case 2: {
                if (this.mCurrentState != 1 && this.mCurrentState != 3) {
                    Log.e(TAG, "Cannot call configure while in state: " + this.mCurrentState);
                    this.mCurrentError = 1;
                    this.doStateTransition(0);
                    return;
                }
                if (this.mCurrentState != 2 && this.mCurrentHandler != null && this.mCurrentListener != null) {
                    this.mCurrentHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CameraDeviceState.this.mCurrentListener.onConfiguring();
                        }
                    });
                }
                this.mCurrentState = 2;
                return;
            }
            case 3: {
                if (this.mCurrentState == 3) return;
                if (this.mCurrentState != 2 && this.mCurrentState != 4) {
                    Log.e(TAG, "Cannot call idle while in state: " + this.mCurrentState);
                    this.mCurrentError = 1;
                    this.doStateTransition(0);
                    return;
                }
                if (this.mCurrentState != 3 && this.mCurrentHandler != null && this.mCurrentListener != null) {
                    this.mCurrentHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CameraDeviceState.this.mCurrentListener.onIdle();
                        }
                    });
                }
                this.mCurrentState = 3;
                return;
            }
            case 4: 
        }
        if (this.mCurrentState != 3 && this.mCurrentState != 4) {
            Log.e(TAG, "Cannot call capture while in state: " + this.mCurrentState);
            this.mCurrentError = 1;
            this.doStateTransition(0);
            return;
        }
        if (this.mCurrentHandler != null && this.mCurrentListener != null) {
            if (n2 != -1) {
                this.mCurrentHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CameraDeviceState.this.mCurrentListener.onError(n2, CameraDeviceState.this.mCurrentRequest);
                    }
                });
            } else {
                this.mCurrentHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CameraDeviceState.this.mCurrentListener.onCaptureStarted(CameraDeviceState.this.mCurrentRequest, l);
                    }
                });
            }
        }
        this.mCurrentState = 4;
    }

    public void setCameraDeviceCallbacks(Handler handler, CameraDeviceStateListener cameraDeviceStateListener) {
        synchronized (this) {
            this.mCurrentHandler = handler;
            this.mCurrentListener = cameraDeviceStateListener;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setCaptureResult(final RequestHolder requestHolder, final CameraMetadataNative cameraMetadataNative, final int n) {
        boolean bl = true;
        synchronized (this) {
            if (this.mCurrentState != 4) {
                Log.e(TAG, "Cannot receive result while in state: " + this.mCurrentState);
                this.mCurrentError = 1;
                this.doStateTransition(0);
                int n2 = this.mCurrentError;
                if (n2 == -1) return bl;
                return false;
            }
            if (this.mCurrentHandler != null && this.mCurrentListener != null) {
                if (n != -1) {
                    this.mCurrentHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CameraDeviceState.this.mCurrentListener.onError(n, requestHolder);
                        }
                    });
                } else {
                    this.mCurrentHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CameraDeviceState.this.mCurrentListener.onCaptureResult(cameraMetadataNative, requestHolder);
                        }
                    });
                }
            }
            if (this.mCurrentError == -1) return bl;
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setCaptureStart(RequestHolder requestHolder, long l, int n) {
        synchronized (this) {
            this.mCurrentRequest = requestHolder;
            this.doStateTransition(4, l, n);
            int n2 = this.mCurrentError;
            if (n2 != -1) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setConfiguring() {
        synchronized (this) {
            this.doStateTransition(2);
            int n = this.mCurrentError;
            if (n != -1) return false;
            return true;
        }
    }

    public void setError(int n) {
        synchronized (this) {
            this.mCurrentError = n;
            this.doStateTransition(0);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setIdle() {
        synchronized (this) {
            this.doStateTransition(3);
            int n = this.mCurrentError;
            if (n != -1) return false;
            return true;
        }
    }

    public static interface CameraDeviceStateListener {
        public void onBusy();

        public void onCaptureResult(CameraMetadataNative var1, RequestHolder var2);

        public void onCaptureStarted(RequestHolder var1, long var2);

        public void onConfiguring();

        public void onError(int var1, RequestHolder var2);

        public void onIdle();
    }
}

