/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.Rect;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.legacy.LegacyRequest;
import android.hardware.camera2.legacy.ParameterUtils;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.utils.ListUtils;
import android.hardware.camera2.utils.ParamsUtils;
import android.util.Log;
import android.util.Size;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;

public class LegacyFaceDetectMapper {
    private static String TAG = "LegacyFaceDetectMapper";
    private static final boolean VERBOSE = Log.isLoggable(TAG, 2);
    private final Camera mCamera;
    private boolean mFaceDetectEnabled = false;
    private boolean mFaceDetectReporting = false;
    private boolean mFaceDetectScenePriority = false;
    private final boolean mFaceDetectSupported;
    private Camera.Face[] mFaces;
    private Camera.Face[] mFacesPrev;
    private final Object mLock = new Object();

    public LegacyFaceDetectMapper(Camera camera, CameraCharacteristics cameraCharacteristics) {
        this.mCamera = Preconditions.checkNotNull(camera, "camera must not be null");
        Preconditions.checkNotNull(cameraCharacteristics, "characteristics must not be null");
        this.mFaceDetectSupported = ArrayUtils.contains(cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES), 1);
        if (!this.mFaceDetectSupported) {
            return;
        }
        this.mCamera.setFaceDetectionListener(new Camera.FaceDetectionListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void onFaceDetection(Camera.Face[] faceArray, Camera camera) {
                int n = faceArray == null ? 0 : faceArray.length;
                Object object = LegacyFaceDetectMapper.this.mLock;
                // MONITORENTER : object
                if (LegacyFaceDetectMapper.this.mFaceDetectEnabled) {
                    LegacyFaceDetectMapper.access$202(LegacyFaceDetectMapper.this, faceArray);
                } else if (n > 0) {
                    Log.d(TAG, "onFaceDetection - Ignored some incoming faces sinceface detection was disabled");
                }
                // MONITOREXIT : object
                if (!VERBOSE) return;
                Log.v(TAG, "onFaceDetection - read " + n + " faces");
            }
        });
    }

    static /* synthetic */ Camera.Face[] access$202(LegacyFaceDetectMapper legacyFaceDetectMapper, Camera.Face[] faceArray) {
        legacyFaceDetectMapper.mFaces = faceArray;
        return faceArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mapResultFaces(CameraMetadataNative cameraMetadataNative, LegacyRequest legacyRequest) {
        Camera.Face[] faceArray;
        boolean bl;
        Camera.Face[] faceArray2;
        int n;
        Preconditions.checkNotNull(cameraMetadataNative, "result must not be null");
        Preconditions.checkNotNull(legacyRequest, "legacyRequest must not be null");
        Object object = this.mLock;
        synchronized (object) {
            n = this.mFaceDetectReporting ? 1 : 0;
            faceArray2 = this.mFaceDetectReporting ? this.mFaces : null;
            bl = this.mFaceDetectScenePriority;
            faceArray = this.mFacesPrev;
            this.mFacesPrev = faceArray2;
        }
        CameraCharacteristics cameraCharacteristics = legacyRequest.characteristics;
        CaptureRequest captureRequest = legacyRequest.captureRequest;
        Size size = legacyRequest.previewSize;
        Camera.Parameters parameters = legacyRequest.parameters;
        Rect rect = cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        ParameterUtils.ZoomData zoomData = ParameterUtils.convertScalerCropRegion(rect, captureRequest.get(CaptureRequest.SCALER_CROP_REGION), size, parameters);
        ArrayList<Face> arrayList = new ArrayList<Face>();
        if (faceArray2 != null) {
            for (Camera.Face face : faceArray2) {
                if (face != null) {
                    arrayList.add(ParameterUtils.convertFaceFromLegacy(face, rect, zoomData));
                    continue;
                }
                Log.w(TAG, "mapResultFaces - read NULL face from camera1 device");
            }
        }
        if (VERBOSE && faceArray != faceArray2) {
            Log.v(TAG, "mapResultFaces - changed to " + ListUtils.listToString(arrayList));
        }
        cameraMetadataNative.set(CaptureResult.STATISTICS_FACES, arrayList.toArray(new Face[0]));
        cameraMetadataNative.set(CaptureResult.STATISTICS_FACE_DETECT_MODE, Integer.valueOf(n));
        if (bl) {
            cameraMetadataNative.set(CaptureResult.CONTROL_SCENE_MODE, Integer.valueOf(1));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processFaceDetectMode(CaptureRequest captureRequest, Camera.Parameters parameters) {
        int n = 1;
        Preconditions.checkNotNull(captureRequest, "captureRequest must not be null");
        int n2 = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.STATISTICS_FACE_DETECT_MODE, 0);
        if (n2 != 0 && !this.mFaceDetectSupported) {
            Log.w(TAG, "processFaceDetectMode - Ignoring statistics.faceDetectMode; face detection is not available");
            return;
        }
        int n3 = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.CONTROL_SCENE_MODE, 0);
        if (n3 == n && !this.mFaceDetectSupported) {
            Log.w(TAG, "processFaceDetectMode - ignoring control.sceneMode == FACE_PRIORITY; face detection is not available");
            return;
        }
        switch (n2) {
            default: {
                Log.w(TAG, "processFaceDetectMode - ignoring unknown statistics.faceDetectMode = " + n2);
                return;
            }
            case 2: {
                Log.w(TAG, "processFaceDetectMode - statistics.faceDetectMode == FULL unsupported, downgrading to SIMPLE");
                break;
            }
            case 0: 
            case 1: 
        }
        int n4 = n2 != 0 || n3 == n ? n : 0;
        Object object = this.mLock;
        synchronized (object) {
            if (n4 != this.mFaceDetectEnabled) {
                if (n4 != 0) {
                    this.mCamera.startFaceDetection();
                    if (VERBOSE) {
                        Log.v(TAG, "processFaceDetectMode - start face detection");
                    }
                } else {
                    this.mCamera.stopFaceDetection();
                    if (VERBOSE) {
                        Log.v(TAG, "processFaceDetectMode - stop face detection");
                    }
                    this.mFaces = null;
                }
                this.mFaceDetectEnabled = n4;
                int n5 = n3 == n ? n : 0;
                this.mFaceDetectScenePriority = n5;
                if (n2 == 0) {
                    n = 0;
                }
                this.mFaceDetectReporting = n;
            }
            return;
        }
    }
}

