/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.MessageQueue;

public class RequestHandlerThread
extends HandlerThread {
    public static final int MSG_POKE_IDLE_HANDLER = -1;
    private Handler.Callback mCallback;
    private volatile Handler mHandler;
    private final ConditionVariable mIdle;
    private final MessageQueue.IdleHandler mIdleHandler;
    private final ConditionVariable mStarted = new ConditionVariable(false);

    public RequestHandlerThread(String string2, Handler.Callback callback) {
        super(string2, 10);
        this.mIdle = new ConditionVariable(true);
        this.mIdleHandler = new MessageQueue.IdleHandler(){

            @Override
            public boolean queueIdle() {
                RequestHandlerThread.this.mIdle.open();
                return false;
            }
        };
        this.mCallback = callback;
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasAnyMessages(int[] nArray) {
        MessageQueue messageQueue = this.mHandler.getLooper().getQueue();
        synchronized (messageQueue) {
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                if (this.mHandler.hasMessages(n3)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    @Override
    protected void onLooperPrepared() {
        this.mHandler = new Handler(this.getLooper(), this.mCallback);
        this.mStarted.open();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeMessages(int[] nArray) {
        MessageQueue messageQueue = this.mHandler.getLooper().getQueue();
        synchronized (messageQueue) {
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                this.mHandler.removeMessages(n3);
                ++n2;
            }
            return;
        }
    }

    public Handler waitAndGetHandler() {
        this.waitUntilStarted();
        return this.getHandler();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void waitUntilIdle() {
        block3: {
            block2: {
                Handler handler = this.waitAndGetHandler();
                Looper looper = handler.getLooper();
                if (looper.isIdling()) break block2;
                this.mIdle.close();
                looper.getQueue().addIdleHandler(this.mIdleHandler);
                handler.sendEmptyMessage(-1);
                if (!looper.isIdling()) break block3;
            }
            return;
        }
        this.mIdle.block();
    }

    public void waitUntilStarted() {
        this.mStarted.block();
    }
}

