/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.utils.HashCodeHelpers;
import android.util.Range;
import android.util.Size;
import com.android.internal.util.Preconditions;

public final class HighSpeedVideoConfiguration {
    private final int mFpsMax;
    private final int mFpsMin;
    private final Range<Integer> mFpsRange;
    private final int mHeight;
    private final Size mSize;
    private final int mWidth;

    public HighSpeedVideoConfiguration(int n, int n2, int n3, int n4) {
        if (n4 < 60) {
            throw new IllegalArgumentException("fpsMax must be at least 60");
        }
        this.mFpsMax = n4;
        this.mWidth = Preconditions.checkArgumentPositive(n, "width must be positive");
        this.mHeight = Preconditions.checkArgumentPositive(n2, "height must be positive");
        this.mFpsMin = Preconditions.checkArgumentPositive(n3, "fpsMin must be positive");
        this.mSize = new Size(this.mWidth, this.mHeight);
        this.mFpsRange = new Range<Integer>(this.mFpsMin, this.mFpsMax);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return bl;
        }
        if (!(object instanceof HighSpeedVideoConfiguration)) return false;
        HighSpeedVideoConfiguration highSpeedVideoConfiguration = (HighSpeedVideoConfiguration)object;
        if (this.mWidth != highSpeedVideoConfiguration.mWidth) return false;
        if (this.mHeight != highSpeedVideoConfiguration.mHeight) return false;
        if (this.mFpsMin != highSpeedVideoConfiguration.mFpsMin) return false;
        if (this.mFpsMax != highSpeedVideoConfiguration.mFpsMax) return false;
        return bl;
    }

    public int getFpsMax() {
        return this.mFpsMax;
    }

    public int getFpsMin() {
        return this.mFpsMin;
    }

    public Range<Integer> getFpsRange() {
        return this.mFpsRange;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public Size getSize() {
        return this.mSize;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(this.mWidth, this.mHeight, this.mFpsMin, this.mFpsMax);
    }
}

