/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.graphics.PointF;
import android.hardware.camera2.utils.HashCodeHelpers;
import com.android.internal.util.Preconditions;
import java.util.Arrays;

public final class TonemapCurve {
    public static final int CHANNEL_BLUE = 2;
    public static final int CHANNEL_GREEN = 1;
    public static final int CHANNEL_RED = 0;
    public static final float LEVEL_BLACK = 0.0f;
    public static final float LEVEL_WHITE = 1.0f;
    private static final int MIN_CURVE_LENGTH = 4;
    private static final int OFFSET_POINT_IN = 0;
    private static final int OFFSET_POINT_OUT = 1;
    public static final int POINT_SIZE = 2;
    private static final int TONEMAP_MIN_CURVE_POINTS = 2;
    private final float[] mBlue;
    private final float[] mGreen;
    private boolean mHashCalculated = false;
    private int mHashCode;
    private final float[] mRed;

    public TonemapCurve(float[] fArray, float[] fArray2, float[] fArray3) {
        Preconditions.checkNotNull(fArray, "red must not be null");
        Preconditions.checkNotNull(fArray2, "green must not be null");
        Preconditions.checkNotNull(fArray3, "blue must not be null");
        TonemapCurve.checkArgumentArrayLengthDivisibleBy(fArray, 2, "red");
        TonemapCurve.checkArgumentArrayLengthDivisibleBy(fArray2, 2, "green");
        TonemapCurve.checkArgumentArrayLengthDivisibleBy(fArray3, 2, "blue");
        TonemapCurve.checkArgumentArrayLengthNoLessThan(fArray, 4, "red");
        TonemapCurve.checkArgumentArrayLengthNoLessThan(fArray2, 4, "green");
        TonemapCurve.checkArgumentArrayLengthNoLessThan(fArray3, 4, "blue");
        Preconditions.checkArrayElementsInRange(fArray, 0.0f, 1.0f, "red");
        Preconditions.checkArrayElementsInRange(fArray2, 0.0f, 1.0f, "green");
        Preconditions.checkArrayElementsInRange(fArray3, 0.0f, 1.0f, "blue");
        this.mRed = Arrays.copyOf(fArray, fArray.length);
        this.mGreen = Arrays.copyOf(fArray2, fArray2.length);
        this.mBlue = Arrays.copyOf(fArray3, fArray3.length);
    }

    private static void checkArgumentArrayLengthDivisibleBy(float[] fArray, int n, String string2) {
        if (fArray.length % n != 0) {
            throw new IllegalArgumentException(string2 + " size must be divisible by " + n);
        }
    }

    private static void checkArgumentArrayLengthNoLessThan(float[] fArray, int n, String string2) {
        if (fArray.length < n) {
            throw new IllegalArgumentException(string2 + " size must be at least " + n);
        }
    }

    private static int checkArgumentColorChannel(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("colorChannel out of range");
            }
            case 0: 
            case 1: 
            case 2: 
        }
        return n;
    }

    private String curveToString(int n) {
        TonemapCurve.checkArgumentColorChannel(n);
        StringBuilder stringBuilder = new StringBuilder("[");
        float[] fArray = this.getCurve(n);
        int n2 = fArray.length / 2;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            stringBuilder.append("(");
            stringBuilder.append(fArray[n4]);
            stringBuilder.append(", ");
            stringBuilder.append(fArray[n4 + 1]);
            stringBuilder.append("), ");
            ++n3;
            n4 += 2;
        }
        stringBuilder.setLength(-2 + stringBuilder.length());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private float[] getCurve(int n) {
        switch (n) {
            default: {
                throw new AssertionError((Object)"colorChannel out of range");
            }
            case 0: {
                return this.mRed;
            }
            case 1: {
                return this.mGreen;
            }
            case 2: 
        }
        return this.mBlue;
    }

    public void copyColorCurve(int n, float[] fArray, int n2) {
        Preconditions.checkArgumentNonnegative(n2, "offset must not be negative");
        Preconditions.checkNotNull(fArray, "destination must not be null");
        if (n2 + fArray.length < 2 * this.getPointCount(n)) {
            throw new ArrayIndexOutOfBoundsException("destination too small to fit elements");
        }
        float[] fArray2 = this.getCurve(n);
        System.arraycopy((float[])fArray2, (int)0, (float[])fArray, (int)n2, (int)fArray2.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return bl;
        }
        if (!(object instanceof TonemapCurve)) return false;
        TonemapCurve tonemapCurve = (TonemapCurve)object;
        if (!Arrays.equals(this.mRed, tonemapCurve.mRed)) return false;
        if (!Arrays.equals(this.mGreen, tonemapCurve.mGreen)) return false;
        if (!Arrays.equals(this.mBlue, tonemapCurve.mBlue)) return false;
        return bl;
    }

    public PointF getPoint(int n, int n2) {
        TonemapCurve.checkArgumentColorChannel(n);
        if (n2 < 0 || n2 >= this.getPointCount(n)) {
            throw new IllegalArgumentException("index out of range");
        }
        float[] fArray = this.getCurve(n);
        return new PointF(fArray[0 + n2 * 2], fArray[1 + n2 * 2]);
    }

    public int getPointCount(int n) {
        TonemapCurve.checkArgumentColorChannel(n);
        return this.getCurve(n).length / 2;
    }

    public int hashCode() {
        if (this.mHashCalculated) {
            return this.mHashCode;
        }
        this.mHashCode = HashCodeHelpers.hashCode(this.mRed, this.mGreen, this.mBlue);
        this.mHashCalculated = true;
        return this.mHashCode;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TonemapCurve{");
        stringBuilder.append("R:");
        stringBuilder.append(this.curveToString(0));
        stringBuilder.append(", G:");
        stringBuilder.append(this.curveToString(1));
        stringBuilder.append(", B:");
        stringBuilder.append(this.curveToString(2));
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

