/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

public class GpsClock
implements Parcelable {
    public static final Parcelable.Creator<GpsClock> CREATOR = new Parcelable.Creator<GpsClock>(){

        @Override
        public GpsClock createFromParcel(Parcel parcel) {
            GpsClock gpsClock = new GpsClock();
            GpsClock.access$002(gpsClock, (short)parcel.readInt());
            GpsClock.access$102(gpsClock, (short)parcel.readInt());
            GpsClock.access$202(gpsClock, parcel.readByte());
            GpsClock.access$302(gpsClock, parcel.readLong());
            GpsClock.access$402(gpsClock, parcel.readDouble());
            GpsClock.access$502(gpsClock, parcel.readLong());
            GpsClock.access$602(gpsClock, parcel.readDouble());
            GpsClock.access$702(gpsClock, parcel.readDouble());
            GpsClock.access$802(gpsClock, parcel.readDouble());
            GpsClock.access$902(gpsClock, parcel.readDouble());
            return gpsClock;
        }

        public GpsClock[] newArray(int n) {
            return new GpsClock[n];
        }
    };
    private static final short HAS_BIAS = 8;
    private static final short HAS_BIAS_UNCERTAINTY = 16;
    private static final short HAS_DRIFT = 32;
    private static final short HAS_DRIFT_UNCERTAINTY = 64;
    private static final short HAS_FULL_BIAS = 4;
    private static final short HAS_LEAP_SECOND = 1;
    private static final short HAS_NO_FLAGS = 0;
    private static final short HAS_TIME_UNCERTAINTY = 2;
    private static final String TAG = "GpsClock";
    public static final byte TYPE_GPS_TIME = 2;
    public static final byte TYPE_LOCAL_HW_TIME = 1;
    public static final byte TYPE_UNKNOWN;
    private double mBiasInNs;
    private double mBiasUncertaintyInNs;
    private double mDriftInNsPerSec;
    private double mDriftUncertaintyInNsPerSec;
    private short mFlags;
    private long mFullBiasInNs;
    private short mLeapSecond;
    private long mTimeInNs;
    private double mTimeUncertaintyInNs;
    private byte mType;

    GpsClock() {
        this.initialize();
    }

    static /* synthetic */ short access$002(GpsClock gpsClock, short s) {
        gpsClock.mFlags = s;
        return s;
    }

    static /* synthetic */ short access$102(GpsClock gpsClock, short s) {
        gpsClock.mLeapSecond = s;
        return s;
    }

    static /* synthetic */ byte access$202(GpsClock gpsClock, byte by) {
        gpsClock.mType = by;
        return by;
    }

    static /* synthetic */ long access$302(GpsClock gpsClock, long l) {
        gpsClock.mTimeInNs = l;
        return l;
    }

    static /* synthetic */ double access$402(GpsClock gpsClock, double d) {
        gpsClock.mTimeUncertaintyInNs = d;
        return d;
    }

    static /* synthetic */ long access$502(GpsClock gpsClock, long l) {
        gpsClock.mFullBiasInNs = l;
        return l;
    }

    static /* synthetic */ double access$602(GpsClock gpsClock, double d) {
        gpsClock.mBiasInNs = d;
        return d;
    }

    static /* synthetic */ double access$702(GpsClock gpsClock, double d) {
        gpsClock.mBiasUncertaintyInNs = d;
        return d;
    }

    static /* synthetic */ double access$802(GpsClock gpsClock, double d) {
        gpsClock.mDriftInNsPerSec = d;
        return d;
    }

    static /* synthetic */ double access$902(GpsClock gpsClock, double d) {
        gpsClock.mDriftUncertaintyInNsPerSec = d;
        return d;
    }

    private String getTypeString() {
        switch (this.mType) {
            default: {
                return "<Invalid>";
            }
            case 0: {
                return "Unknown";
            }
            case 2: {
                return "GpsTime";
            }
            case 1: 
        }
        return "LocalHwClock";
    }

    private void initialize() {
        this.mFlags = 0;
        this.resetLeapSecond();
        this.setType((byte)0);
        this.setTimeInNs(Long.MIN_VALUE);
        this.resetTimeUncertaintyInNs();
        this.resetBiasInNs();
        this.resetBiasUncertaintyInNs();
        this.resetDriftInNsPerSec();
        this.resetDriftUncertaintyInNsPerSec();
    }

    private boolean isFlagSet(short s) {
        return (s & this.mFlags) == s;
    }

    private void resetFlag(short s) {
        this.mFlags = (short)(this.mFlags & ~s);
    }

    private void setFlag(short s) {
        this.mFlags = (short)(s | this.mFlags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public double getBiasInNs() {
        return this.mBiasInNs;
    }

    public double getBiasUncertaintyInNs() {
        return this.mBiasUncertaintyInNs;
    }

    public double getDriftInNsPerSec() {
        return this.mDriftInNsPerSec;
    }

    public double getDriftUncertaintyInNsPerSec() {
        return this.mDriftUncertaintyInNsPerSec;
    }

    public long getFullBiasInNs() {
        return this.mFullBiasInNs;
    }

    public short getLeapSecond() {
        return this.mLeapSecond;
    }

    public long getTimeInNs() {
        return this.mTimeInNs;
    }

    public double getTimeUncertaintyInNs() {
        return this.mTimeUncertaintyInNs;
    }

    public byte getType() {
        return this.mType;
    }

    public boolean hasBiasInNs() {
        return this.isFlagSet((short)8);
    }

    public boolean hasBiasUncertaintyInNs() {
        return this.isFlagSet((short)16);
    }

    public boolean hasDriftInNsPerSec() {
        return this.isFlagSet((short)32);
    }

    public boolean hasDriftUncertaintyInNsPerSec() {
        return this.isFlagSet((short)64);
    }

    public boolean hasFullBiasInNs() {
        return this.isFlagSet((short)4);
    }

    public boolean hasLeapSecond() {
        return this.isFlagSet((short)1);
    }

    public boolean hasTimeUncertaintyInNs() {
        return this.isFlagSet((short)2);
    }

    public void reset() {
        this.initialize();
    }

    public void resetBiasInNs() {
        this.resetFlag((short)8);
        this.mBiasInNs = Double.NaN;
    }

    public void resetBiasUncertaintyInNs() {
        this.resetFlag((short)16);
        this.mBiasUncertaintyInNs = Double.NaN;
    }

    public void resetDriftInNsPerSec() {
        this.resetFlag((short)32);
        this.mDriftInNsPerSec = Double.NaN;
    }

    public void resetDriftUncertaintyInNsPerSec() {
        this.resetFlag((short)64);
        this.mDriftUncertaintyInNsPerSec = Double.NaN;
    }

    public void resetFullBiasInNs() {
        this.resetFlag((short)4);
        this.mFullBiasInNs = Long.MIN_VALUE;
    }

    public void resetLeapSecond() {
        this.resetFlag((short)1);
        this.mLeapSecond = Short.MIN_VALUE;
    }

    public void resetTimeUncertaintyInNs() {
        this.resetFlag((short)2);
        this.mTimeUncertaintyInNs = Double.NaN;
    }

    public void set(GpsClock gpsClock) {
        this.mFlags = gpsClock.mFlags;
        this.mLeapSecond = gpsClock.mLeapSecond;
        this.mType = gpsClock.mType;
        this.mTimeInNs = gpsClock.mTimeInNs;
        this.mTimeUncertaintyInNs = gpsClock.mTimeUncertaintyInNs;
        this.mFullBiasInNs = gpsClock.mFullBiasInNs;
        this.mBiasInNs = gpsClock.mBiasInNs;
        this.mBiasUncertaintyInNs = gpsClock.mBiasUncertaintyInNs;
        this.mDriftInNsPerSec = gpsClock.mDriftInNsPerSec;
        this.mDriftUncertaintyInNsPerSec = gpsClock.mDriftUncertaintyInNsPerSec;
    }

    public void setBiasInNs(double d) {
        this.setFlag((short)8);
        this.mBiasInNs = d;
    }

    public void setBiasUncertaintyInNs(double d) {
        this.setFlag((short)16);
        this.mBiasUncertaintyInNs = d;
    }

    public void setDriftInNsPerSec(double d) {
        this.setFlag((short)32);
        this.mDriftInNsPerSec = d;
    }

    public void setDriftUncertaintyInNsPerSec(double d) {
        this.setFlag((short)64);
        this.mDriftUncertaintyInNsPerSec = d;
    }

    public void setFullBiasInNs(long l) {
        this.setFlag((short)4);
        this.mFullBiasInNs = l;
    }

    public void setLeapSecond(short s) {
        this.setFlag((short)1);
        this.mLeapSecond = s;
    }

    public void setTimeInNs(long l) {
        this.mTimeInNs = l;
    }

    public void setTimeUncertaintyInNs(double d) {
        this.setFlag((short)2);
        this.mTimeUncertaintyInNs = d;
    }

    public void setType(byte by) {
        switch (by) {
            default: {
                Log.d(TAG, "Sanitizing invalid 'type': " + by);
                this.mType = 0;
                return;
            }
            case 0: 
            case 1: 
            case 2: 
        }
        this.mType = by;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("GpsClock:\n");
        Object[] objectArray = new Object[]{"Type", this.getTypeString()};
        stringBuilder.append(String.format("   %-15s = %s\n", objectArray));
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "LeapSecond";
        Short s = this.hasLeapSecond() ? Short.valueOf(this.mLeapSecond) : null;
        objectArray2[1] = s;
        stringBuilder.append(String.format("   %-15s = %s\n", objectArray2));
        Object[] objectArray3 = new Object[4];
        objectArray3[0] = "TimeInNs";
        objectArray3[1] = this.mTimeInNs;
        objectArray3[2] = "TimeUncertaintyInNs";
        Double d = this.hasTimeUncertaintyInNs() ? Double.valueOf(this.mTimeUncertaintyInNs) : null;
        objectArray3[3] = d;
        stringBuilder.append(String.format("   %-15s = %-25s   %-26s = %s\n", objectArray3));
        Object[] objectArray4 = new Object[2];
        objectArray4[0] = "FullBiasInNs";
        Long l = this.hasFullBiasInNs() ? Long.valueOf(this.mFullBiasInNs) : null;
        objectArray4[1] = l;
        stringBuilder.append(String.format("   %-15s = %s\n", objectArray4));
        Object[] objectArray5 = new Object[4];
        objectArray5[0] = "BiasInNs";
        Double d2 = this.hasBiasInNs() ? Double.valueOf(this.mBiasInNs) : null;
        objectArray5[1] = d2;
        objectArray5[2] = "BiasUncertaintyInNs";
        Double d3 = this.hasBiasUncertaintyInNs() ? Double.valueOf(this.mBiasUncertaintyInNs) : null;
        objectArray5[3] = d3;
        stringBuilder.append(String.format("   %-15s = %-25s   %-26s = %s\n", objectArray5));
        Object[] objectArray6 = new Object[4];
        objectArray6[0] = "DriftInNsPerSec";
        Double d4 = this.hasDriftInNsPerSec() ? Double.valueOf(this.mDriftInNsPerSec) : null;
        objectArray6[1] = d4;
        objectArray6[2] = "DriftUncertaintyInNsPerSec";
        boolean bl = this.hasDriftUncertaintyInNsPerSec();
        Double d5 = null;
        if (bl) {
            d5 = this.mDriftUncertaintyInNsPerSec;
        }
        objectArray6[3] = d5;
        stringBuilder.append(String.format("   %-15s = %-25s   %-26s = %s\n", objectArray6));
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mFlags);
        parcel.writeInt(this.mLeapSecond);
        parcel.writeByte(this.mType);
        parcel.writeLong(this.mTimeInNs);
        parcel.writeDouble(this.mTimeUncertaintyInNs);
        parcel.writeLong(this.mFullBiasInNs);
        parcel.writeDouble(this.mBiasInNs);
        parcel.writeDouble(this.mBiasUncertaintyInNs);
        parcel.writeDouble(this.mDriftInNsPerSec);
        parcel.writeDouble(this.mDriftUncertaintyInNsPerSec);
    }
}

