/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

public class GpsMeasurement
implements Parcelable {
    public static final short ADR_STATE_CYCLE_SLIP = 4;
    public static final short ADR_STATE_RESET = 2;
    public static final short ADR_STATE_UNKNOWN = 0;
    public static final short ADR_STATE_VALID = 1;
    public static final Parcelable.Creator<GpsMeasurement> CREATOR = new Parcelable.Creator<GpsMeasurement>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public GpsMeasurement createFromParcel(Parcel parcel) {
            GpsMeasurement gpsMeasurement = new GpsMeasurement();
            GpsMeasurement.access$002(gpsMeasurement, parcel.readInt());
            GpsMeasurement.access$102(gpsMeasurement, parcel.readByte());
            GpsMeasurement.access$202(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$302(gpsMeasurement, (short)parcel.readInt());
            GpsMeasurement.access$402(gpsMeasurement, parcel.readLong());
            GpsMeasurement.access$502(gpsMeasurement, parcel.readLong());
            GpsMeasurement.access$602(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$702(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$802(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$902(gpsMeasurement, (short)parcel.readInt());
            GpsMeasurement.access$1002(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$1102(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$1202(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$1302(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$1402(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$1502(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$1602(gpsMeasurement, parcel.readFloat());
            GpsMeasurement.access$1702(gpsMeasurement, parcel.readLong());
            GpsMeasurement.access$1802(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$1902(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$2002(gpsMeasurement, parcel.readByte());
            GpsMeasurement.access$2102(gpsMeasurement, parcel.readInt());
            GpsMeasurement.access$2202(gpsMeasurement, (short)parcel.readInt());
            GpsMeasurement.access$2302(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$2402(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$2502(gpsMeasurement, parcel.readByte());
            GpsMeasurement.access$2602(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$2702(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$2802(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$2902(gpsMeasurement, parcel.readDouble());
            GpsMeasurement.access$3002(gpsMeasurement, parcel.readDouble());
            boolean bl = parcel.readInt() != 0;
            GpsMeasurement.access$3102(gpsMeasurement, bl);
            return gpsMeasurement;
        }

        public GpsMeasurement[] newArray(int n) {
            return new GpsMeasurement[n];
        }
    };
    private static final int HAS_AZIMUTH = 8;
    private static final int HAS_AZIMUTH_UNCERTAINTY = 16;
    private static final int HAS_BIT_NUMBER = 8192;
    private static final int HAS_CARRIER_CYCLES = 1024;
    private static final int HAS_CARRIER_FREQUENCY = 512;
    private static final int HAS_CARRIER_PHASE = 2048;
    private static final int HAS_CARRIER_PHASE_UNCERTAINTY = 4096;
    private static final int HAS_CODE_PHASE = 128;
    private static final int HAS_CODE_PHASE_UNCERTAINTY = 256;
    private static final int HAS_DOPPLER_SHIFT = 32768;
    private static final int HAS_DOPPLER_SHIFT_UNCERTAINTY = 65536;
    private static final int HAS_ELEVATION = 2;
    private static final int HAS_ELEVATION_UNCERTAINTY = 4;
    private static final int HAS_NO_FLAGS = 0;
    private static final int HAS_PSEUDORANGE = 32;
    private static final int HAS_PSEUDORANGE_UNCERTAINTY = 64;
    private static final int HAS_SNR = 1;
    private static final int HAS_TIME_FROM_LAST_BIT = 16384;
    public static final byte LOSS_OF_LOCK_CYCLE_SLIP = 2;
    public static final byte LOSS_OF_LOCK_OK = 1;
    public static final byte LOSS_OF_LOCK_UNKNOWN = 0;
    public static final byte MULTIPATH_INDICATOR_DETECTED = 1;
    public static final byte MULTIPATH_INDICATOR_NOT_USED = 2;
    public static final byte MULTIPATH_INDICATOR_UNKNOWN = 0;
    public static final short STATE_BIT_SYNC = 2;
    public static final short STATE_CODE_LOCK = 1;
    public static final short STATE_SUBFRAME_SYNC = 4;
    public static final short STATE_TOW_DECODED = 8;
    public static final short STATE_UNKNOWN = 0;
    private static final String TAG = "GpsMeasurement";
    private double mAccumulatedDeltaRangeInMeters;
    private short mAccumulatedDeltaRangeState;
    private double mAccumulatedDeltaRangeUncertaintyInMeters;
    private double mAzimuthInDeg;
    private double mAzimuthUncertaintyInDeg;
    private int mBitNumber;
    private long mCarrierCycles;
    private float mCarrierFrequencyInHz;
    private double mCarrierPhase;
    private double mCarrierPhaseUncertainty;
    private double mCn0InDbHz;
    private double mCodePhaseInChips;
    private double mCodePhaseUncertaintyInChips;
    private double mDopplerShiftInHz;
    private double mDopplerShiftUncertaintyInHz;
    private double mElevationInDeg;
    private double mElevationUncertaintyInDeg;
    private int mFlags;
    private byte mLossOfLock;
    private byte mMultipathIndicator;
    private byte mPrn;
    private double mPseudorangeInMeters;
    private double mPseudorangeRateInMetersPerSec;
    private double mPseudorangeRateUncertaintyInMetersPerSec;
    private double mPseudorangeUncertaintyInMeters;
    private long mReceivedGpsTowInNs;
    private long mReceivedGpsTowUncertaintyInNs;
    private double mSnrInDb;
    private short mState;
    private short mTimeFromLastBitInMs;
    private double mTimeOffsetInNs;
    private boolean mUsedInFix;

    GpsMeasurement() {
        this.initialize();
    }

    static /* synthetic */ int access$002(GpsMeasurement gpsMeasurement, int n) {
        gpsMeasurement.mFlags = n;
        return n;
    }

    static /* synthetic */ double access$1002(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mAccumulatedDeltaRangeInMeters = d;
        return d;
    }

    static /* synthetic */ byte access$102(GpsMeasurement gpsMeasurement, byte by) {
        gpsMeasurement.mPrn = by;
        return by;
    }

    static /* synthetic */ double access$1102(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mAccumulatedDeltaRangeUncertaintyInMeters = d;
        return d;
    }

    static /* synthetic */ double access$1202(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mPseudorangeInMeters = d;
        return d;
    }

    static /* synthetic */ double access$1302(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mPseudorangeUncertaintyInMeters = d;
        return d;
    }

    static /* synthetic */ double access$1402(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mCodePhaseInChips = d;
        return d;
    }

    static /* synthetic */ double access$1502(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mCodePhaseUncertaintyInChips = d;
        return d;
    }

    static /* synthetic */ float access$1602(GpsMeasurement gpsMeasurement, float f) {
        gpsMeasurement.mCarrierFrequencyInHz = f;
        return f;
    }

    static /* synthetic */ long access$1702(GpsMeasurement gpsMeasurement, long l) {
        gpsMeasurement.mCarrierCycles = l;
        return l;
    }

    static /* synthetic */ double access$1802(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mCarrierPhase = d;
        return d;
    }

    static /* synthetic */ double access$1902(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mCarrierPhaseUncertainty = d;
        return d;
    }

    static /* synthetic */ byte access$2002(GpsMeasurement gpsMeasurement, byte by) {
        gpsMeasurement.mLossOfLock = by;
        return by;
    }

    static /* synthetic */ double access$202(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mTimeOffsetInNs = d;
        return d;
    }

    static /* synthetic */ int access$2102(GpsMeasurement gpsMeasurement, int n) {
        gpsMeasurement.mBitNumber = n;
        return n;
    }

    static /* synthetic */ short access$2202(GpsMeasurement gpsMeasurement, short s) {
        gpsMeasurement.mTimeFromLastBitInMs = s;
        return s;
    }

    static /* synthetic */ double access$2302(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mDopplerShiftInHz = d;
        return d;
    }

    static /* synthetic */ double access$2402(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mDopplerShiftUncertaintyInHz = d;
        return d;
    }

    static /* synthetic */ byte access$2502(GpsMeasurement gpsMeasurement, byte by) {
        gpsMeasurement.mMultipathIndicator = by;
        return by;
    }

    static /* synthetic */ double access$2602(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mSnrInDb = d;
        return d;
    }

    static /* synthetic */ double access$2702(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mElevationInDeg = d;
        return d;
    }

    static /* synthetic */ double access$2802(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mElevationUncertaintyInDeg = d;
        return d;
    }

    static /* synthetic */ double access$2902(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mAzimuthInDeg = d;
        return d;
    }

    static /* synthetic */ double access$3002(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mAzimuthUncertaintyInDeg = d;
        return d;
    }

    static /* synthetic */ short access$302(GpsMeasurement gpsMeasurement, short s) {
        gpsMeasurement.mState = s;
        return s;
    }

    static /* synthetic */ boolean access$3102(GpsMeasurement gpsMeasurement, boolean bl) {
        gpsMeasurement.mUsedInFix = bl;
        return bl;
    }

    static /* synthetic */ long access$402(GpsMeasurement gpsMeasurement, long l) {
        gpsMeasurement.mReceivedGpsTowInNs = l;
        return l;
    }

    static /* synthetic */ long access$502(GpsMeasurement gpsMeasurement, long l) {
        gpsMeasurement.mReceivedGpsTowUncertaintyInNs = l;
        return l;
    }

    static /* synthetic */ double access$602(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mCn0InDbHz = d;
        return d;
    }

    static /* synthetic */ double access$702(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mPseudorangeRateInMetersPerSec = d;
        return d;
    }

    static /* synthetic */ double access$802(GpsMeasurement gpsMeasurement, double d) {
        gpsMeasurement.mPseudorangeRateUncertaintyInMetersPerSec = d;
        return d;
    }

    static /* synthetic */ short access$902(GpsMeasurement gpsMeasurement, short s) {
        gpsMeasurement.mAccumulatedDeltaRangeState = s;
        return s;
    }

    private String getAccumulatedDeltaRangeStateString() {
        switch (this.mAccumulatedDeltaRangeState) {
            default: {
                return "<Invalid>";
            }
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Valid";
            }
            case 2: {
                return "Reset";
            }
            case 4: 
        }
        return "CycleSlip";
    }

    private String getLossOfLockString() {
        switch (this.mLossOfLock) {
            default: {
                return "<Invalid>";
            }
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Ok";
            }
            case 2: 
        }
        return "CycleSlip";
    }

    private String getMultipathIndicatorString() {
        switch (this.mMultipathIndicator) {
            default: {
                return "<Invalid>";
            }
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Detected";
            }
            case 2: 
        }
        return "NotUsed";
    }

    private String getStateString() {
        switch (this.mState) {
            default: {
                return "<Invalid>";
            }
            case 0: {
                return "Unknown";
            }
            case 2: {
                return "BitSync";
            }
            case 1: {
                return "CodeLock";
            }
            case 4: {
                return "SubframeSync";
            }
            case 8: 
        }
        return "TowDecoded";
    }

    private void initialize() {
        this.mFlags = 0;
        this.setPrn((byte)-128);
        this.setTimeOffsetInNs(-9.223372036854776E18);
        this.setState((short)0);
        this.setReceivedGpsTowInNs(Long.MIN_VALUE);
        this.setReceivedGpsTowUncertaintyInNs(Long.MAX_VALUE);
        this.setCn0InDbHz(Double.MIN_VALUE);
        this.setPseudorangeRateInMetersPerSec(Double.MIN_VALUE);
        this.setPseudorangeRateUncertaintyInMetersPerSec(Double.MIN_VALUE);
        this.setAccumulatedDeltaRangeState((short)0);
        this.setAccumulatedDeltaRangeInMeters(Double.MIN_VALUE);
        this.setAccumulatedDeltaRangeUncertaintyInMeters(Double.MIN_VALUE);
        this.resetPseudorangeInMeters();
        this.resetPseudorangeUncertaintyInMeters();
        this.resetCodePhaseInChips();
        this.resetCodePhaseUncertaintyInChips();
        this.resetCarrierFrequencyInHz();
        this.resetCarrierCycles();
        this.resetCarrierPhase();
        this.resetCarrierPhaseUncertainty();
        this.setLossOfLock((byte)0);
        this.resetBitNumber();
        this.resetTimeFromLastBitInMs();
        this.resetDopplerShiftInHz();
        this.resetDopplerShiftUncertaintyInHz();
        this.setMultipathIndicator((byte)0);
        this.resetSnrInDb();
        this.resetElevationInDeg();
        this.resetElevationUncertaintyInDeg();
        this.resetAzimuthInDeg();
        this.resetAzimuthUncertaintyInDeg();
        this.setUsedInFix(false);
    }

    private boolean isFlagSet(int n) {
        return (n & this.mFlags) == n;
    }

    private void resetFlag(int n) {
        this.mFlags &= ~n;
    }

    private void setFlag(int n) {
        this.mFlags = n | this.mFlags;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public double getAccumulatedDeltaRangeInMeters() {
        return this.mAccumulatedDeltaRangeInMeters;
    }

    public short getAccumulatedDeltaRangeState() {
        return this.mAccumulatedDeltaRangeState;
    }

    public double getAccumulatedDeltaRangeUncertaintyInMeters() {
        return this.mAccumulatedDeltaRangeUncertaintyInMeters;
    }

    public double getAzimuthInDeg() {
        return this.mAzimuthInDeg;
    }

    public double getAzimuthUncertaintyInDeg() {
        return this.mAzimuthUncertaintyInDeg;
    }

    public int getBitNumber() {
        return this.mBitNumber;
    }

    public long getCarrierCycles() {
        return this.mCarrierCycles;
    }

    public float getCarrierFrequencyInHz() {
        return this.mCarrierFrequencyInHz;
    }

    public double getCarrierPhase() {
        return this.mCarrierPhase;
    }

    public double getCarrierPhaseUncertainty() {
        return this.mCarrierPhaseUncertainty;
    }

    public double getCn0InDbHz() {
        return this.mCn0InDbHz;
    }

    public double getCodePhaseInChips() {
        return this.mCodePhaseInChips;
    }

    public double getCodePhaseUncertaintyInChips() {
        return this.mCodePhaseUncertaintyInChips;
    }

    public double getDopplerShiftInHz() {
        return this.mDopplerShiftInHz;
    }

    public double getDopplerShiftUncertaintyInHz() {
        return this.mDopplerShiftUncertaintyInHz;
    }

    public double getElevationInDeg() {
        return this.mElevationInDeg;
    }

    public double getElevationUncertaintyInDeg() {
        return this.mElevationUncertaintyInDeg;
    }

    public byte getLossOfLock() {
        return this.mLossOfLock;
    }

    public byte getMultipathIndicator() {
        return this.mMultipathIndicator;
    }

    public byte getPrn() {
        return this.mPrn;
    }

    public double getPseudorangeInMeters() {
        return this.mPseudorangeInMeters;
    }

    public double getPseudorangeRateInMetersPerSec() {
        return this.mPseudorangeRateInMetersPerSec;
    }

    public double getPseudorangeRateUncertaintyInMetersPerSec() {
        return this.mPseudorangeRateUncertaintyInMetersPerSec;
    }

    public double getPseudorangeUncertaintyInMeters() {
        return this.mPseudorangeUncertaintyInMeters;
    }

    public long getReceivedGpsTowInNs() {
        return this.mReceivedGpsTowInNs;
    }

    public long getReceivedGpsTowUncertaintyInNs() {
        return this.mReceivedGpsTowUncertaintyInNs;
    }

    public double getSnrInDb() {
        return this.mSnrInDb;
    }

    public short getState() {
        return this.mState;
    }

    public short getTimeFromLastBitInMs() {
        return this.mTimeFromLastBitInMs;
    }

    public double getTimeOffsetInNs() {
        return this.mTimeOffsetInNs;
    }

    public boolean hasAzimuthInDeg() {
        return this.isFlagSet(8);
    }

    public boolean hasAzimuthUncertaintyInDeg() {
        return this.isFlagSet(16);
    }

    public boolean hasBitNumber() {
        return this.isFlagSet(8192);
    }

    public boolean hasCarrierCycles() {
        return this.isFlagSet(1024);
    }

    public boolean hasCarrierFrequencyInHz() {
        return this.isFlagSet(512);
    }

    public boolean hasCarrierPhase() {
        return this.isFlagSet(2048);
    }

    public boolean hasCarrierPhaseUncertainty() {
        return this.isFlagSet(4096);
    }

    public boolean hasCodePhaseInChips() {
        return this.isFlagSet(128);
    }

    public boolean hasCodePhaseUncertaintyInChips() {
        return this.isFlagSet(256);
    }

    public boolean hasDopplerShiftInHz() {
        return this.isFlagSet(32768);
    }

    public boolean hasDopplerShiftUncertaintyInHz() {
        return this.isFlagSet(65536);
    }

    public boolean hasElevationInDeg() {
        return this.isFlagSet(2);
    }

    public boolean hasElevationUncertaintyInDeg() {
        return this.isFlagSet(4);
    }

    public boolean hasPseudorangeInMeters() {
        return this.isFlagSet(32);
    }

    public boolean hasPseudorangeUncertaintyInMeters() {
        return this.isFlagSet(64);
    }

    public boolean hasSnrInDb() {
        return this.isFlagSet(1);
    }

    public boolean hasTimeFromLastBitInMs() {
        return this.isFlagSet(16384);
    }

    public boolean isUsedInFix() {
        return this.mUsedInFix;
    }

    public void reset() {
        this.initialize();
    }

    public void resetAzimuthInDeg() {
        this.resetFlag(8);
        this.mAzimuthInDeg = Double.NaN;
    }

    public void resetAzimuthUncertaintyInDeg() {
        this.resetFlag(16);
        this.mAzimuthUncertaintyInDeg = Double.NaN;
    }

    public void resetBitNumber() {
        this.resetFlag(8192);
        this.mBitNumber = Integer.MIN_VALUE;
    }

    public void resetCarrierCycles() {
        this.resetFlag(1024);
        this.mCarrierCycles = Long.MIN_VALUE;
    }

    public void resetCarrierFrequencyInHz() {
        this.resetFlag(512);
        this.mCarrierFrequencyInHz = Float.NaN;
    }

    public void resetCarrierPhase() {
        this.resetFlag(2048);
        this.mCarrierPhase = Double.NaN;
    }

    public void resetCarrierPhaseUncertainty() {
        this.resetFlag(4096);
        this.mCarrierPhaseUncertainty = Double.NaN;
    }

    public void resetCodePhaseInChips() {
        this.resetFlag(128);
        this.mCodePhaseInChips = Double.NaN;
    }

    public void resetCodePhaseUncertaintyInChips() {
        this.resetFlag(256);
        this.mCodePhaseUncertaintyInChips = Double.NaN;
    }

    public void resetDopplerShiftInHz() {
        this.resetFlag(32768);
        this.mDopplerShiftInHz = Double.NaN;
    }

    public void resetDopplerShiftUncertaintyInHz() {
        this.resetFlag(65536);
        this.mDopplerShiftUncertaintyInHz = Double.NaN;
    }

    public void resetElevationInDeg() {
        this.resetFlag(2);
        this.mElevationInDeg = Double.NaN;
    }

    public void resetElevationUncertaintyInDeg() {
        this.resetFlag(4);
        this.mElevationUncertaintyInDeg = Double.NaN;
    }

    public void resetPseudorangeInMeters() {
        this.resetFlag(32);
        this.mPseudorangeInMeters = Double.NaN;
    }

    public void resetPseudorangeUncertaintyInMeters() {
        this.resetFlag(64);
        this.mPseudorangeUncertaintyInMeters = Double.NaN;
    }

    public void resetSnrInDb() {
        this.resetFlag(1);
        this.mSnrInDb = Double.NaN;
    }

    public void resetTimeFromLastBitInMs() {
        this.resetFlag(16384);
        this.mTimeFromLastBitInMs = Short.MIN_VALUE;
    }

    public void set(GpsMeasurement gpsMeasurement) {
        this.mFlags = gpsMeasurement.mFlags;
        this.mPrn = gpsMeasurement.mPrn;
        this.mTimeOffsetInNs = gpsMeasurement.mTimeOffsetInNs;
        this.mState = gpsMeasurement.mState;
        this.mReceivedGpsTowInNs = gpsMeasurement.mReceivedGpsTowInNs;
        this.mReceivedGpsTowUncertaintyInNs = gpsMeasurement.mReceivedGpsTowUncertaintyInNs;
        this.mCn0InDbHz = gpsMeasurement.mCn0InDbHz;
        this.mPseudorangeRateInMetersPerSec = gpsMeasurement.mPseudorangeRateInMetersPerSec;
        this.mPseudorangeRateUncertaintyInMetersPerSec = gpsMeasurement.mPseudorangeRateUncertaintyInMetersPerSec;
        this.mAccumulatedDeltaRangeState = gpsMeasurement.mAccumulatedDeltaRangeState;
        this.mAccumulatedDeltaRangeInMeters = gpsMeasurement.mAccumulatedDeltaRangeInMeters;
        this.mAccumulatedDeltaRangeUncertaintyInMeters = gpsMeasurement.mAccumulatedDeltaRangeUncertaintyInMeters;
        this.mPseudorangeInMeters = gpsMeasurement.mPseudorangeInMeters;
        this.mPseudorangeUncertaintyInMeters = gpsMeasurement.mPseudorangeUncertaintyInMeters;
        this.mCodePhaseInChips = gpsMeasurement.mCodePhaseInChips;
        this.mCodePhaseUncertaintyInChips = gpsMeasurement.mCodePhaseUncertaintyInChips;
        this.mCarrierFrequencyInHz = gpsMeasurement.mCarrierFrequencyInHz;
        this.mCarrierCycles = gpsMeasurement.mCarrierCycles;
        this.mCarrierPhase = gpsMeasurement.mCarrierPhase;
        this.mCarrierPhaseUncertainty = gpsMeasurement.mCarrierPhaseUncertainty;
        this.mLossOfLock = gpsMeasurement.mLossOfLock;
        this.mBitNumber = gpsMeasurement.mBitNumber;
        this.mTimeFromLastBitInMs = gpsMeasurement.mTimeFromLastBitInMs;
        this.mDopplerShiftInHz = gpsMeasurement.mDopplerShiftInHz;
        this.mDopplerShiftUncertaintyInHz = gpsMeasurement.mDopplerShiftUncertaintyInHz;
        this.mMultipathIndicator = gpsMeasurement.mMultipathIndicator;
        this.mSnrInDb = gpsMeasurement.mSnrInDb;
        this.mElevationInDeg = gpsMeasurement.mElevationInDeg;
        this.mElevationUncertaintyInDeg = gpsMeasurement.mElevationUncertaintyInDeg;
        this.mAzimuthInDeg = gpsMeasurement.mAzimuthInDeg;
        this.mAzimuthUncertaintyInDeg = gpsMeasurement.mAzimuthUncertaintyInDeg;
        this.mUsedInFix = gpsMeasurement.mUsedInFix;
    }

    public void setAccumulatedDeltaRangeInMeters(double d) {
        this.mAccumulatedDeltaRangeInMeters = d;
    }

    public void setAccumulatedDeltaRangeState(short s) {
        switch (s) {
            default: {
                Log.d(TAG, "Sanitizing invalid 'Accumulated Delta Range state': " + s);
                this.mAccumulatedDeltaRangeState = 0;
                return;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
        }
        this.mAccumulatedDeltaRangeState = s;
    }

    public void setAccumulatedDeltaRangeUncertaintyInMeters(double d) {
        this.mAccumulatedDeltaRangeUncertaintyInMeters = d;
    }

    public void setAzimuthInDeg(double d) {
        this.setFlag(8);
        this.mAzimuthInDeg = d;
    }

    public void setAzimuthUncertaintyInDeg(double d) {
        this.setFlag(16);
        this.mAzimuthUncertaintyInDeg = d;
    }

    public void setBitNumber(int n) {
        this.setFlag(8192);
        this.mBitNumber = n;
    }

    public void setCarrierCycles(long l) {
        this.setFlag(1024);
        this.mCarrierCycles = l;
    }

    public void setCarrierFrequencyInHz(float f) {
        this.setFlag(512);
        this.mCarrierFrequencyInHz = f;
    }

    public void setCarrierPhase(double d) {
        this.setFlag(2048);
        this.mCarrierPhase = d;
    }

    public void setCarrierPhaseUncertainty(double d) {
        this.setFlag(4096);
        this.mCarrierPhaseUncertainty = d;
    }

    public void setCn0InDbHz(double d) {
        this.mCn0InDbHz = d;
    }

    public void setCodePhaseInChips(double d) {
        this.setFlag(128);
        this.mCodePhaseInChips = d;
    }

    public void setCodePhaseUncertaintyInChips(double d) {
        this.setFlag(256);
        this.mCodePhaseUncertaintyInChips = d;
    }

    public void setDopplerShiftInHz(double d) {
        this.setFlag(32768);
        this.mDopplerShiftInHz = d;
    }

    public void setDopplerShiftUncertaintyInHz(double d) {
        this.setFlag(65536);
        this.mDopplerShiftUncertaintyInHz = d;
    }

    public void setElevationInDeg(double d) {
        this.setFlag(2);
        this.mElevationInDeg = d;
    }

    public void setElevationUncertaintyInDeg(double d) {
        this.setFlag(4);
        this.mElevationUncertaintyInDeg = d;
    }

    public void setLossOfLock(byte by) {
        switch (by) {
            default: {
                Log.d(TAG, "Sanitizing invalid 'loss of lock': " + by);
                this.mLossOfLock = 0;
                return;
            }
            case 0: 
            case 1: 
            case 2: 
        }
        this.mLossOfLock = by;
    }

    public void setMultipathIndicator(byte by) {
        switch (by) {
            default: {
                Log.d(TAG, "Sanitizing invalid 'muti-path indicator': " + by);
                this.mMultipathIndicator = 0;
                return;
            }
            case 0: 
            case 1: 
            case 2: 
        }
        this.mMultipathIndicator = by;
    }

    public void setPrn(byte by) {
        this.mPrn = by;
    }

    public void setPseudorangeInMeters(double d) {
        this.setFlag(32);
        this.mPseudorangeInMeters = d;
    }

    public void setPseudorangeRateInMetersPerSec(double d) {
        this.mPseudorangeRateInMetersPerSec = d;
    }

    public void setPseudorangeRateUncertaintyInMetersPerSec(double d) {
        this.mPseudorangeRateUncertaintyInMetersPerSec = d;
    }

    public void setPseudorangeUncertaintyInMeters(double d) {
        this.setFlag(64);
        this.mPseudorangeUncertaintyInMeters = d;
    }

    public void setReceivedGpsTowInNs(long l) {
        this.mReceivedGpsTowInNs = l;
    }

    public void setReceivedGpsTowUncertaintyInNs(long l) {
        this.mReceivedGpsTowUncertaintyInNs = l;
    }

    public void setSnrInDb(double d) {
        this.setFlag(1);
        this.mSnrInDb = d;
    }

    public void setState(short s) {
        switch (s) {
            default: {
                Log.d(TAG, "Sanitizing invalid 'sync state': " + s);
                this.mState = 0;
                return;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: 
        }
        this.mState = s;
    }

    public void setTimeFromLastBitInMs(short s) {
        this.setFlag(16384);
        this.mTimeFromLastBitInMs = s;
    }

    public void setTimeOffsetInNs(double d) {
        this.mTimeOffsetInNs = d;
    }

    public void setUsedInFix(boolean bl) {
        this.mUsedInFix = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("GpsMeasurement:\n");
        Object[] objectArray = new Object[]{"Prn", this.mPrn};
        stringBuilder.append(String.format("   %-29s = %s\n", objectArray));
        Object[] objectArray2 = new Object[]{"TimeOffsetInNs", this.mTimeOffsetInNs};
        stringBuilder.append(String.format("   %-29s = %s\n", objectArray2));
        Object[] objectArray3 = new Object[]{"State", this.getStateString()};
        stringBuilder.append(String.format("   %-29s = %s\n", objectArray3));
        Object[] objectArray4 = new Object[]{"ReceivedGpsTowInNs", this.mReceivedGpsTowInNs, "ReceivedGpsTowUncertaintyInNs", this.mReceivedGpsTowUncertaintyInNs};
        stringBuilder.append(String.format("   %-29s = %-25s   %-40s = %s\n", objectArray4));
        Object[] objectArray5 = new Object[]{"Cn0InDbHz", this.mCn0InDbHz};
        stringBuilder.append(String.format("   %-29s = %s\n", objectArray5));
        Object[] objectArray6 = new Object[]{"PseudorangeRateInMetersPerSec", this.mPseudorangeRateInMetersPerSec, "PseudorangeRateUncertaintyInMetersPerSec", this.mPseudorangeRateUncertaintyInMetersPerSec};
        stringBuilder.append(String.format("   %-29s = %-25s   %-40s = %s\n", objectArray6));
        Object[] objectArray7 = new Object[]{"AccumulatedDeltaRangeState", this.getAccumulatedDeltaRangeStateString()};
        stringBuilder.append(String.format("   %-29s = %s\n", objectArray7));
        Object[] objectArray8 = new Object[]{"AccumulatedDeltaRangeInMeters", this.mAccumulatedDeltaRangeInMeters, "AccumulatedDeltaRangeUncertaintyInMeters", this.mAccumulatedDeltaRangeUncertaintyInMeters};
        stringBuilder.append(String.format("   %-29s = %-25s   %-40s = %s\n", objectArray8));
        Object[] objectArray9 = new Object[4];
        objectArray9[0] = "PseudorangeInMeters";
        Double d = this.hasPseudorangeInMeters() ? Double.valueOf(this.mPseudorangeInMeters) : null;
        objectArray9[1] = d;
        objectArray9[2] = "PseudorangeUncertaintyInMeters";
        Double d2 = this.hasPseudorangeUncertaintyInMeters() ? Double.valueOf(this.mPseudorangeUncertaintyInMeters) : null;
        objectArray9[3] = d2;
        stringBuilder.append(String.format("   %-29s = %-25s   %-40s = %s\n", objectArray9));
        Object[] objectArray10 = new Object[4];
        objectArray10[0] = "CodePhaseInChips";
        Double d3 = this.hasCodePhaseInChips() ? Double.valueOf(this.mCodePhaseInChips) : null;
        objectArray10[1] = d3;
        objectArray10[2] = "CodePhaseUncertaintyInChips";
        Double d4 = this.hasCodePhaseUncertaintyInChips() ? Double.valueOf(this.mCodePhaseUncertaintyInChips) : null;
        objectArray10[3] = d4;
        stringBuilder.append(String.format("   %-29s = %-25s   %-40s = %s\n", objectArray10));
        Object[] objectArray11 = new Object[2];
        objectArray11[0] = "CarrierFrequencyInHz";
        Float f = this.hasCarrierFrequencyInHz() ? Float.valueOf(this.mCarrierFrequencyInHz) : null;
        objectArray11[1] = f;
        stringBuilder.append(String.format("   %-29s = %s\n", objectArray11));
        Object[] objectArray12 = new Object[2];
        objectArray12[0] = "CarrierCycles";
        Long l = this.hasCarrierCycles() ? Long.valueOf(this.mCarrierCycles) : null;
        objectArray12[1] = l;
        stringBuilder.append(String.format("   %-29s = %s\n", objectArray12));
        Object[] objectArray13 = new Object[4];
        objectArray13[0] = "CarrierPhase";
        Double d5 = this.hasCarrierPhase() ? Double.valueOf(this.mCarrierPhase) : null;
        objectArray13[1] = d5;
        objectArray13[2] = "CarrierPhaseUncertainty";
        Double d6 = this.hasCarrierPhaseUncertainty() ? Double.valueOf(this.mCarrierPhaseUncertainty) : null;
        objectArray13[3] = d6;
        stringBuilder.append(String.format("   %-29s = %-25s   %-40s = %s\n", objectArray13));
        Object[] objectArray14 = new Object[]{"LossOfLock", this.getLossOfLockString()};
        stringBuilder.append(String.format("   %-29s = %s\n", objectArray14));
        Object[] objectArray15 = new Object[2];
        objectArray15[0] = "BitNumber";
        Integer n = this.hasBitNumber() ? Integer.valueOf(this.mBitNumber) : null;
        objectArray15[1] = n;
        stringBuilder.append(String.format("   %-29s = %s\n", objectArray15));
        Object[] objectArray16 = new Object[2];
        objectArray16[0] = "TimeFromLastBitInMs";
        Short s = this.hasTimeFromLastBitInMs() ? Short.valueOf(this.mTimeFromLastBitInMs) : null;
        objectArray16[1] = s;
        stringBuilder.append(String.format("   %-29s = %s\n", objectArray16));
        Object[] objectArray17 = new Object[4];
        objectArray17[0] = "DopplerShiftInHz";
        Double d7 = this.hasDopplerShiftInHz() ? Double.valueOf(this.mDopplerShiftInHz) : null;
        objectArray17[1] = d7;
        objectArray17[2] = "DopplerShiftUncertaintyInHz";
        Double d8 = this.hasDopplerShiftUncertaintyInHz() ? Double.valueOf(this.mDopplerShiftUncertaintyInHz) : null;
        objectArray17[3] = d8;
        stringBuilder.append(String.format("   %-29s = %-25s   %-40s = %s\n", objectArray17));
        Object[] objectArray18 = new Object[]{"MultipathIndicator", this.getMultipathIndicatorString()};
        stringBuilder.append(String.format("   %-29s = %s\n", objectArray18));
        Object[] objectArray19 = new Object[2];
        objectArray19[0] = "SnrInDb";
        Double d9 = this.hasSnrInDb() ? Double.valueOf(this.mSnrInDb) : null;
        objectArray19[1] = d9;
        stringBuilder.append(String.format("   %-29s = %s\n", objectArray19));
        Object[] objectArray20 = new Object[4];
        objectArray20[0] = "ElevationInDeg";
        Double d10 = this.hasElevationInDeg() ? Double.valueOf(this.mElevationInDeg) : null;
        objectArray20[1] = d10;
        objectArray20[2] = "ElevationUncertaintyInDeg";
        Double d11 = this.hasElevationUncertaintyInDeg() ? Double.valueOf(this.mElevationUncertaintyInDeg) : null;
        objectArray20[3] = d11;
        stringBuilder.append(String.format("   %-29s = %-25s   %-40s = %s\n", objectArray20));
        Object[] objectArray21 = new Object[4];
        objectArray21[0] = "AzimuthInDeg";
        Double d12 = this.hasAzimuthInDeg() ? Double.valueOf(this.mAzimuthInDeg) : null;
        objectArray21[1] = d12;
        objectArray21[2] = "AzimuthUncertaintyInDeg";
        boolean bl = this.hasAzimuthUncertaintyInDeg();
        Double d13 = null;
        if (bl) {
            d13 = this.mAzimuthUncertaintyInDeg;
        }
        objectArray21[3] = d13;
        stringBuilder.append(String.format("   %-29s = %-25s   %-40s = %s\n", objectArray21));
        Object[] objectArray22 = new Object[]{"UsedInFix", this.mUsedInFix};
        stringBuilder.append(String.format("   %-29s = %s\n", objectArray22));
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mFlags);
        parcel.writeByte(this.mPrn);
        parcel.writeDouble(this.mTimeOffsetInNs);
        parcel.writeInt(this.mState);
        parcel.writeLong(this.mReceivedGpsTowInNs);
        parcel.writeLong(this.mReceivedGpsTowUncertaintyInNs);
        parcel.writeDouble(this.mCn0InDbHz);
        parcel.writeDouble(this.mPseudorangeRateInMetersPerSec);
        parcel.writeDouble(this.mPseudorangeRateUncertaintyInMetersPerSec);
        parcel.writeInt(this.mAccumulatedDeltaRangeState);
        parcel.writeDouble(this.mAccumulatedDeltaRangeInMeters);
        parcel.writeDouble(this.mAccumulatedDeltaRangeUncertaintyInMeters);
        parcel.writeDouble(this.mPseudorangeInMeters);
        parcel.writeDouble(this.mPseudorangeUncertaintyInMeters);
        parcel.writeDouble(this.mCodePhaseInChips);
        parcel.writeDouble(this.mCodePhaseUncertaintyInChips);
        parcel.writeFloat(this.mCarrierFrequencyInHz);
        parcel.writeLong(this.mCarrierCycles);
        parcel.writeDouble(this.mCarrierPhase);
        parcel.writeDouble(this.mCarrierPhaseUncertainty);
        parcel.writeByte(this.mLossOfLock);
        parcel.writeInt(this.mBitNumber);
        parcel.writeInt(this.mTimeFromLastBitInMs);
        parcel.writeDouble(this.mDopplerShiftInHz);
        parcel.writeDouble(this.mDopplerShiftUncertaintyInHz);
        parcel.writeByte(this.mMultipathIndicator);
        parcel.writeDouble(this.mSnrInDb);
        parcel.writeDouble(this.mElevationInDeg);
        parcel.writeDouble(this.mElevationUncertaintyInDeg);
        parcel.writeDouble(this.mAzimuthInDeg);
        parcel.writeDouble(this.mAzimuthUncertaintyInDeg);
        int n2 = this.mUsedInFix ? 1 : 0;
        parcel.writeInt(n2);
    }
}

