/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;

public class ExifInterface {
    public static final int ORIENTATION_FLIP_HORIZONTAL = 2;
    public static final int ORIENTATION_FLIP_VERTICAL = 4;
    public static final int ORIENTATION_NORMAL = 1;
    public static final int ORIENTATION_ROTATE_180 = 3;
    public static final int ORIENTATION_ROTATE_270 = 8;
    public static final int ORIENTATION_ROTATE_90 = 6;
    public static final int ORIENTATION_TRANSPOSE = 5;
    public static final int ORIENTATION_TRANSVERSE = 7;
    public static final int ORIENTATION_UNDEFINED = 0;
    public static final String TAG_APERTURE = "FNumber";
    public static final String TAG_DATETIME = "DateTime";
    public static final String TAG_EXPOSURE_TIME = "ExposureTime";
    public static final String TAG_FLASH = "Flash";
    public static final String TAG_FOCAL_LENGTH = "FocalLength";
    public static final String TAG_GPS_ALTITUDE = "GPSAltitude";
    public static final String TAG_GPS_ALTITUDE_REF = "GPSAltitudeRef";
    public static final String TAG_GPS_DATESTAMP = "GPSDateStamp";
    public static final String TAG_GPS_LATITUDE = "GPSLatitude";
    public static final String TAG_GPS_LATITUDE_REF = "GPSLatitudeRef";
    public static final String TAG_GPS_LONGITUDE = "GPSLongitude";
    public static final String TAG_GPS_LONGITUDE_REF = "GPSLongitudeRef";
    public static final String TAG_GPS_PROCESSING_METHOD = "GPSProcessingMethod";
    public static final String TAG_GPS_TIMESTAMP = "GPSTimeStamp";
    public static final String TAG_IMAGE_LENGTH = "ImageLength";
    public static final String TAG_IMAGE_WIDTH = "ImageWidth";
    public static final String TAG_ISO = "ISOSpeedRatings";
    public static final String TAG_MAKE = "Make";
    public static final String TAG_MODEL = "Model";
    public static final String TAG_ORIENTATION = "Orientation";
    public static final String TAG_WHITE_BALANCE = "WhiteBalance";
    public static final int WHITEBALANCE_AUTO = 0;
    public static final int WHITEBALANCE_MANUAL = 1;
    private static SimpleDateFormat sFormatter;
    private static final Object sLock;
    private HashMap<String, String> mAttributes;
    private String mFilename;
    private boolean mHasThumbnail;

    static {
        System.loadLibrary("jhead_jni");
        sFormatter = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        sFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        sLock = new Object();
    }

    public ExifInterface(String string2) throws IOException {
        if (string2 == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        this.mFilename = string2;
        this.loadAttributes();
    }

    private native boolean appendThumbnailNative(String var1, String var2);

    private native void commitChangesNative(String var1);

    private static float convertRationalLatLonToFloat(String string2, String string3) {
        double d;
        block3: {
            try {
                boolean bl;
                String[] stringArray = string2.split(",");
                String[] stringArray2 = stringArray[0].split("/");
                double d2 = Double.parseDouble(stringArray2[0].trim()) / Double.parseDouble(stringArray2[1].trim());
                String[] stringArray3 = stringArray[1].split("/");
                double d3 = Double.parseDouble(stringArray3[0].trim()) / Double.parseDouble(stringArray3[1].trim());
                String[] stringArray4 = stringArray[2].split("/");
                double d4 = Double.parseDouble(stringArray4[0].trim()) / Double.parseDouble(stringArray4[1].trim());
                d = d2 + d3 / 60.0 + d4 / 3600.0;
                if (!string3.equals("S") && !(bl = string3.equals("W"))) break block3;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException();
            }
            return (float)(-d);
        }
        return (float)d;
    }

    private native String getAttributesNative(String var1);

    private native byte[] getThumbnailNative(String var1);

    private native long[] getThumbnailRangeNative(String var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadAttributes() throws IOException {
        String string2;
        this.mAttributes = new HashMap();
        Object object = sLock;
        synchronized (object) {
            string2 = this.getAttributesNative(this.mFilename);
        }
        int n = string2.indexOf(32);
        int n2 = Integer.parseInt(string2.substring(0, n));
        int n3 = n + 1;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = string2.indexOf(61, n3);
            String string3 = string2.substring(n3, n5);
            int n6 = n5 + 1;
            int n7 = string2.indexOf(32, n6);
            int n8 = Integer.parseInt(string2.substring(n6, n7));
            int n9 = n7 + 1;
            String string4 = string2.substring(n9, n9 + n8);
            n3 = n9 + n8;
            if (string3.equals("hasThumbnail")) {
                this.mHasThumbnail = string4.equalsIgnoreCase("true");
            } else {
                this.mAttributes.put(string3, string4);
            }
            ++n4;
        }
        return;
    }

    private native void saveAttributesNative(String var1, String var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getAltitude(double d) {
        int n = -1;
        double d2 = this.getAttributeDouble(TAG_GPS_ALTITUDE, -1.0);
        int n2 = this.getAttributeInt(TAG_GPS_ALTITUDE_REF, n);
        if (!(d2 >= 0.0)) return d;
        if (n2 < 0) return d;
        if (n2 == 1) {
            return d2 * (double)n;
        }
        n = 1;
        return d2 * (double)n;
    }

    public String getAttribute(String string2) {
        return this.mAttributes.get(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double getAttributeDouble(String string2, double d) {
        double d2;
        int n;
        String string3;
        block4: {
            string3 = this.mAttributes.get(string2);
            if (string3 != null) {
                n = string3.indexOf("/");
                if (n != -1 && (d2 = Double.parseDouble(string3.substring(n + 1))) != 0.0) break block4;
            }
            return d;
        }
        try {
            double d3 = Double.parseDouble(string3.substring(0, n));
            return d3 / d2;
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public int getAttributeInt(String string2, int n) {
        String string3 = this.mAttributes.get(string2);
        if (string3 == null) {
            return n;
        }
        try {
            int n2 = Integer.valueOf(string3);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getDateTime() {
        Date date;
        String string2 = this.mAttributes.get(TAG_DATETIME);
        if (string2 == null) {
            return -1L;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        try {
            date = sFormatter.parse(string2, parsePosition);
            if (date == null) return -1L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1L;
        }
        return date.getTime();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getGpsDateTime() {
        Date date;
        String string2 = this.mAttributes.get(TAG_GPS_DATESTAMP);
        String string3 = this.mAttributes.get(TAG_GPS_TIMESTAMP);
        if (string2 == null) return -1L;
        if (string3 == null) {
            return -1L;
        }
        String string4 = string2 + ' ' + string3;
        if (string4 == null) return -1L;
        ParsePosition parsePosition = new ParsePosition(0);
        try {
            date = sFormatter.parse(string4, parsePosition);
            if (date == null) return -1L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1L;
        }
        return date.getTime();
    }

    public boolean getLatLong(float[] fArray) {
        String string2 = this.mAttributes.get(TAG_GPS_LATITUDE);
        String string3 = this.mAttributes.get(TAG_GPS_LATITUDE_REF);
        String string4 = this.mAttributes.get(TAG_GPS_LONGITUDE);
        String string5 = this.mAttributes.get(TAG_GPS_LONGITUDE_REF);
        if (string2 != null && string3 != null && string4 != null && string5 != null) {
            try {
                fArray[0] = ExifInterface.convertRationalLatLonToFloat(string2, string3);
                fArray[1] = ExifInterface.convertRationalLatLonToFloat(string4, string5);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getThumbnail() {
        Object object = sLock;
        synchronized (object) {
            return this.getThumbnailNative(this.mFilename);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long[] getThumbnailRange() {
        Object object = sLock;
        synchronized (object) {
            return this.getThumbnailRangeNative(this.mFilename);
        }
    }

    public boolean hasThumbnail() {
        return this.mHasThumbnail;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveAttributes() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.mAttributes.size();
        if (this.mAttributes.containsKey("hasThumbnail")) {
            --n;
        }
        stringBuilder.append(n + " ");
        Iterator<Map.Entry<String, String>> iterator = this.mAttributes.entrySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                String string2 = stringBuilder.toString();
                Object object = sLock;
                synchronized (object) {
                    this.saveAttributesNative(this.mFilename, string2);
                    this.commitChangesNative(this.mFilename);
                    return;
                }
            }
            Map.Entry<String, String> entry = iterator.next();
            String string3 = entry.getKey();
            if (string3.equals("hasThumbnail")) continue;
            String string4 = entry.getValue();
            stringBuilder.append(string3 + "=");
            stringBuilder.append(string4.length() + " ");
            stringBuilder.append(string4);
        }
    }

    public void setAttribute(String string2, String string3) {
        this.mAttributes.put(string2, string3);
    }
}

