/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.KeyguardManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.media.AudioService;
import android.media.FocusRequester;
import android.media.IAudioFocusDispatcher;
import android.media.IRemoteControlClient;
import android.media.IRemoteControlDisplay;
import android.media.IRemoteVolumeObserver;
import android.media.PlayerRecord;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.util.Slog;
import android.view.KeyEvent;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class MediaFocusControl
implements PendingIntent.OnFinished {
    protected static final boolean DEBUG_RC = false;
    protected static final boolean DEBUG_VOL = false;
    private static final Uri ENABLED_NOTIFICATION_LISTENERS_URI = Settings.Secure.getUriFor("enabled_notification_listeners");
    private static final String EXTRA_WAKELOCK_ACQUIRED = "android.media.AudioService.WAKELOCK_ACQUIRED";
    protected static final String IN_VOICE_COMM_FOCUS_ID = "AudioFocus_For_Phone_Ring_And_Calls";
    private static final int MSG_RCC_NEW_PLAYBACK_INFO = 4;
    private static final int MSG_RCC_NEW_PLAYBACK_STATE = 6;
    private static final int MSG_RCC_NEW_VOLUME_OBS = 5;
    private static final int MSG_RCC_SEEK_REQUEST = 7;
    private static final int MSG_RCC_UPDATE_METADATA = 8;
    private static final int MSG_RCDISPLAY_CLEAR = 1;
    private static final int MSG_RCDISPLAY_INIT_INFO = 9;
    private static final int MSG_RCDISPLAY_UPDATE = 2;
    private static final int MSG_REEVALUATE_RCD = 10;
    private static final int MSG_REEVALUATE_REMOTE = 3;
    private static final int MSG_UNREGISTER_MEDIABUTTONINTENT = 11;
    private static final int RCD_REG_FAILURE = 0;
    private static final int RCD_REG_SUCCESS_ENABLED_NOTIF = 2;
    private static final int RCD_REG_SUCCESS_PERMISSION = 1;
    private static final int RC_INFO_ALL = 15;
    private static final int RC_INFO_NONE = 0;
    private static final int SENDMSG_NOOP = 1;
    private static final int SENDMSG_QUEUE = 2;
    private static final int SENDMSG_REPLACE = 0;
    private static final String TAG = "MediaFocusControl";
    private static final int VOICEBUTTON_ACTION_DISCARD_CURRENT_KEY_PRESS = 1;
    private static final int VOICEBUTTON_ACTION_SIMULATE_KEY_PRESS = 3;
    private static final int VOICEBUTTON_ACTION_START_VOICE_INPUT = 2;
    private static final int WAKELOCK_RELEASE_ON_FINISHED = 1980;
    private static final Object mAudioFocusLock = new Object();
    private static final Object mRingingLock = new Object();
    private final AppOpsManager mAppOps;
    private final AudioService mAudioService;
    private final ContentResolver mContentResolver;
    private final Context mContext;
    private IRemoteControlClient mCurrentRcClient = null;
    private int mCurrentRcClientGen = 0;
    private PendingIntent mCurrentRcClientIntent = null;
    private final Object mCurrentRcLock;
    private final MediaEventHandler mEventHandler;
    private final Stack<FocusRequester> mFocusStack;
    private boolean mHasRemotePlayback;
    private boolean mIsRinging = false;
    BroadcastReceiver mKeyEventDone;
    private final KeyguardManager mKeyguardManager;
    private PlayerRecord.RemotePlaybackState mMainRemote;
    private boolean mMainRemoteIsActive;
    private final PowerManager.WakeLock mMediaEventWakeLock;
    private ComponentName mMediaReceiverForCalls = null;
    private final NotificationListenerObserver mNotifListenerObserver;
    private final Stack<PlayerRecord> mPRStack;
    private PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onCallStateChanged(int n, String string2) {
            if (n == 1) {
                Object object = mRingingLock;
                synchronized (object) {
                    MediaFocusControl.access$1602(MediaFocusControl.this, true);
                    return;
                }
            }
            if (n != 2 && n != 0) {
                return;
            }
            Object object = mRingingLock;
            synchronized (object) {
                MediaFocusControl.access$1602(MediaFocusControl.this, false);
                return;
            }
        }
    };
    private ArrayList<DisplayInfoForServer> mRcDisplays;
    private boolean mVoiceButtonDown;
    private boolean mVoiceButtonHandled;
    private final Object mVoiceEventLock;
    private final AudioService.VolumeController mVolumeController;

    protected MediaFocusControl(Looper looper, Context context, AudioService.VolumeController volumeController, AudioService audioService) {
        this.mFocusStack = new Stack();
        this.mVoiceEventLock = new Object();
        this.mKeyEventDone = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                Bundle bundle;
                if (intent == null || (bundle = intent.getExtras()) == null || !bundle.containsKey(MediaFocusControl.EXTRA_WAKELOCK_ACQUIRED)) {
                    return;
                }
                MediaFocusControl.this.mMediaEventWakeLock.release();
            }
        };
        this.mCurrentRcLock = new Object();
        this.mPRStack = new Stack();
        this.mRcDisplays = new ArrayList(1);
        this.mEventHandler = new MediaEventHandler(looper);
        this.mContext = context;
        this.mContentResolver = this.mContext.getContentResolver();
        this.mVolumeController = volumeController;
        this.mAudioService = audioService;
        this.mMediaEventWakeLock = ((PowerManager)this.mContext.getSystemService("power")).newWakeLock(1, "handleMediaEvent");
        this.mMainRemote = new PlayerRecord.RemotePlaybackState(-1, AudioService.getMaxStreamVolume(3), AudioService.getMaxStreamVolume(3));
        ((TelephonyManager)this.mContext.getSystemService("phone")).listen(this.mPhoneStateListener, 32);
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
        this.mKeyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
        this.mNotifListenerObserver = new NotificationListenerObserver();
        this.mHasRemotePlayback = false;
        this.mMainRemoteIsActive = false;
        PlayerRecord.setMediaFocusControl(this);
        this.postReevaluateRemote();
    }

    static /* synthetic */ boolean access$1602(MediaFocusControl mediaFocusControl, boolean bl) {
        mediaFocusControl.mIsRinging = bl;
        return bl;
    }

    private boolean canReassignAudioFocus() {
        return this.mFocusStack.isEmpty() || !this.mFocusStack.peek().hasSameClient(IN_VOICE_COMM_FOCUS_ID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int checkRcdRegistrationAuthorization(ComponentName componentName) {
        long l;
        block7: {
            int n2;
            String[] stringArray;
            if (this.mContext.checkCallingOrSelfPermission("android.permission.MEDIA_CONTENT_CONTROL") == 0) {
                return 1;
            }
            if (componentName == null) return 0;
            l = Binder.clearCallingIdentity();
            int n = ActivityManager.getCurrentUser();
            String string2 = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "enabled_notification_listeners", n);
            if (string2 == null) break block7;
            try {
                stringArray = string2.split(":");
                n2 = 0;
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(l);
                throw throwable;
            }
            while (true) {
                block8: {
                    if (n2 >= stringArray.length) break;
                    ComponentName componentName2 = ComponentName.unflattenFromString(stringArray[n2]);
                    if (componentName2 == null) break block8;
                    boolean bl = componentName.equals(componentName2);
                    if (!bl) break block8;
                    Binder.restoreCallingIdentity(l);
                    return 2;
                }
                ++n2;
            }
        }
        Binder.restoreCallingIdentity(l);
        return 0;
    }

    private void checkUpdateRemoteControlDisplay_syncPrs(int n) {
        if (this.mPRStack.isEmpty()) {
            this.clearRemoteControlDisplay_syncPrs();
            return;
        }
        this.updateRemoteControlDisplay_syncPrs(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void clearRemoteControlDisplay_syncPrs() {
        Object object = this.mCurrentRcLock;
        synchronized (object) {
            this.mCurrentRcClient = null;
        }
        this.mEventHandler.sendMessage(this.mEventHandler.obtainMessage(1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispatchMediaKeyEvent(KeyEvent keyEvent, boolean bl) {
        if (bl) {
            this.mMediaEventWakeLock.acquire();
        }
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON", null);
        intent.putExtra("android.intent.extra.KEY_EVENT", keyEvent);
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            block13: {
                int n;
                Context context;
                PendingIntent pendingIntent;
                boolean bl2 = this.mPRStack.empty();
                if (!bl2) {
                    try {
                        pendingIntent = this.mPRStack.peek().getMediaButtonIntent();
                        context = this.mContext;
                        n = bl ? 1980 : 0;
                    }
                    catch (PendingIntent.CanceledException canceledException) {
                        Log.e(TAG, "Error sending pending intent " + this.mPRStack.peek());
                        canceledException.printStackTrace();
                    }
                } else {
                    if (bl) {
                        intent.putExtra(EXTRA_WAKELOCK_ACQUIRED, 1980);
                    }
                    long l = Binder.clearCallingIdentity();
                    try {
                        this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.ALL, null, this.mKeyEventDone, this.mEventHandler, -1, null, null);
                    }
                    finally {
                        Binder.restoreCallingIdentity(l);
                    }
                }
                break block13;
                pendingIntent.send(context, n, intent, this, this.mEventHandler);
            }
            return;
        }
    }

    private void dispatchMediaKeyEventForCalls(KeyEvent keyEvent, boolean bl) {
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON", null);
        intent.putExtra("android.intent.extra.KEY_EVENT", keyEvent);
        intent.setPackage(this.mMediaReceiverForCalls.getPackageName());
        if (bl) {
            this.mMediaEventWakeLock.acquire();
            intent.putExtra(EXTRA_WAKELOCK_ACQUIRED, 1980);
        }
        long l = Binder.clearCallingIdentity();
        try {
            this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.ALL, null, this.mKeyEventDone, this.mEventHandler, -1, null, null);
            return;
        }
        finally {
            Binder.restoreCallingIdentity(l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpFocusStack(PrintWriter printWriter) {
        printWriter.println("\nAudio Focus stack entries (last is top of stack):");
        Object object = mAudioFocusLock;
        synchronized (object) {
            Iterator iterator = this.mFocusStack.iterator();
            while (iterator.hasNext()) {
                ((FocusRequester)iterator.next()).dump(printWriter);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpRCCStack(PrintWriter printWriter) {
        printWriter.println("\nRemote Control Client stack entries (last is top of stack):");
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Iterator iterator = this.mPRStack.iterator();
            while (iterator.hasNext()) {
                ((PlayerRecord)iterator.next()).dump(printWriter, false);
            }
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                printWriter.println("\nCurrent remote control generation ID = " + this.mCurrentRcClientGen);
            }
        }
        PlayerRecord.RemotePlaybackState remotePlaybackState = this.mMainRemote;
        synchronized (remotePlaybackState) {
            printWriter.println("\nRemote Volume State:");
            printWriter.println("  has remote: " + this.mHasRemotePlayback);
            printWriter.println("  is remote active: " + this.mMainRemoteIsActive);
            printWriter.println("  rccId: " + this.mMainRemote.mRccId);
            StringBuilder stringBuilder = new StringBuilder().append("  volume handling: ");
            String string2 = this.mMainRemote.mVolumeHandling == 0 ? "PLAYBACK_VOLUME_FIXED(0)" : "PLAYBACK_VOLUME_VARIABLE(1)";
            printWriter.println(stringBuilder.append(string2).toString());
            printWriter.println("  volume: " + this.mMainRemote.mVolume);
            printWriter.println("  volume steps: " + this.mMainRemote.mVolumeMax);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpRCDList(PrintWriter printWriter) {
        printWriter.println("\nRemote Control Display list entries:");
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Iterator<DisplayInfoForServer> iterator = this.mRcDisplays.iterator();
            while (iterator.hasNext()) {
                DisplayInfoForServer displayInfoForServer = iterator.next();
                StringBuilder stringBuilder = new StringBuilder().append("  IRCD: ").append(displayInfoForServer.mRcDisplay).append("  -- w:").append(displayInfoForServer.mArtworkExpectedWidth).append("  -- h:").append(displayInfoForServer.mArtworkExpectedHeight).append("  -- wantsPosSync:").append(displayInfoForServer.mWantsPositionSync).append("  -- ");
                String string2 = displayInfoForServer.mEnabled ? "enabled" : "disabled";
                printWriter.println(stringBuilder.append(string2).toString());
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpRCStack(PrintWriter printWriter) {
        printWriter.println("\nRemote Control stack entries (last is top of stack):");
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Iterator iterator = this.mPRStack.iterator();
            while (iterator.hasNext()) {
                ((PlayerRecord)iterator.next()).dump(printWriter, true);
            }
            return;
        }
    }

    private void enableRemoteControlDisplayForClient_syncRcStack(IRemoteControlDisplay iRemoteControlDisplay, boolean bl) {
        for (PlayerRecord playerRecord : this.mPRStack) {
            if (playerRecord.getRcc() == null) continue;
            try {
                playerRecord.getRcc().enableRemoteControlDisplay(iRemoteControlDisplay, bl);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Error connecting RCD to client: ", remoteException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void filterMediaKeyEvent(KeyEvent keyEvent, boolean bl) {
        if (!MediaFocusControl.isValidMediaKeyEvent(keyEvent)) {
            Log.e(TAG, "not dispatching invalid media key event " + keyEvent);
            return;
        }
        Object object = mRingingLock;
        // MONITORENTER : object
        Stack<PlayerRecord> stack = this.mPRStack;
        // MONITORENTER : stack
        if (this.mMediaReceiverForCalls != null && (this.mIsRinging || this.mAudioService.getMode() == 2)) {
            this.dispatchMediaKeyEventForCalls(keyEvent, bl);
            // MONITOREXIT : stack
            // MONITOREXIT : object
            return;
        }
        // MONITOREXIT : stack
        // MONITOREXIT : object
        if (MediaFocusControl.isValidVoiceInputKeyCode(keyEvent.getKeyCode())) {
            this.filterVoiceInputKeyEvent(keyEvent, bl);
            return;
        }
        this.dispatchMediaKeyEvent(keyEvent, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void filterVoiceInputKeyEvent(KeyEvent keyEvent, boolean bl) {
        int n;
        block13: {
            n = 1;
            int n2 = keyEvent.getAction();
            Object object = this.mVoiceEventLock;
            synchronized (object) {
                block12: {
                    if (n2 != 0) break block12;
                    if (keyEvent.getRepeatCount() == 0) {
                        this.mVoiceButtonDown = true;
                        this.mVoiceButtonHandled = false;
                        break block13;
                    } else if (this.mVoiceButtonDown && !this.mVoiceButtonHandled && (0x80 & keyEvent.getFlags()) != 0) {
                        this.mVoiceButtonHandled = true;
                        n = 2;
                    }
                    break block13;
                }
                if (n2 == 1 && this.mVoiceButtonDown) {
                    this.mVoiceButtonDown = false;
                    if (!this.mVoiceButtonHandled && !keyEvent.isCanceled()) {
                        n = 3;
                    }
                }
            }
        }
        switch (n) {
            case 2: {
                this.startVoiceBasedInteractions(bl);
                return;
            }
            case 3: {
                this.sendSimulatedMediaButtonEvent(keyEvent, bl);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isComponentInStringArray(ComponentName componentName, String[] stringArray) {
        if (stringArray != null && stringArray.length != 0) {
            String string2 = componentName.flattenToString();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCurrentRcController(PendingIntent pendingIntent) {
        return !this.mPRStack.empty() && this.mPRStack.peek().hasMatchingMediaButtonIntent(pendingIntent);
    }

    protected static boolean isPlaystateActive(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
        }
        return true;
    }

    private static boolean isValidMediaKeyEvent(KeyEvent keyEvent) {
        if (keyEvent == null) {
            return false;
        }
        return KeyEvent.isMediaKey(keyEvent.getKeyCode());
    }

    private static boolean isValidVoiceInputKeyCode(int n) {
        return n == 79;
    }

    private void notifyTopOfAudioFocusStack() {
        if (!this.mFocusStack.empty() && this.canReassignAudioFocus()) {
            this.mFocusStack.peek().handleFocusGain(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onRcDisplayClear() {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                this.mCurrentRcClientGen = 1 + this.mCurrentRcClientGen;
                this.setNewRcClient_syncRcsCurrc(this.mCurrentRcClientGen, null, true);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onRcDisplayInitInfo(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                IRemoteControlClient iRemoteControlClient = this.mCurrentRcClient;
                if (iRemoteControlClient != null) {
                    iRemoteControlDisplay.setCurrentClientId(this.mCurrentRcClientGen, this.mCurrentRcClientIntent, false);
                    try {
                        this.mCurrentRcClient.informationRequestForDisplay(iRemoteControlDisplay, n, n2);
                    }
                    catch (RemoteException remoteException) {
                        try {
                            Log.e(TAG, "Current valid remote client is dead: ", remoteException);
                            this.mCurrentRcClient = null;
                        }
                        catch (RemoteException remoteException2) {
                            Log.e(TAG, "Dead display in onRcDisplayInitInfo()", remoteException2);
                        }
                    }
                }
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onRcDisplayUpdate(PlayerRecord playerRecord, int n) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                if (this.mCurrentRcClient != null && this.mCurrentRcClient.equals(playerRecord.getRcc())) {
                    this.mCurrentRcClientGen = 1 + this.mCurrentRcClientGen;
                    this.setNewRcClient_syncRcsCurrc(this.mCurrentRcClientGen, playerRecord.getMediaButtonIntent(), false);
                    try {
                        this.mCurrentRcClient.onInformationRequested(this.mCurrentRcClientGen, n);
                    }
                    catch (RemoteException remoteException) {
                        Log.e(TAG, "Current valid remote client is dead: " + remoteException);
                        this.mCurrentRcClient = null;
                    }
                }
                return;
            }
        }
    }

    private void onReevaluateRemote() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onReevaluateRemoteControlDisplays() {
        int n = ActivityManager.getCurrentUser();
        String string2 = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "enabled_notification_listeners", n);
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<PlayerRecord> stack = this.mPRStack;
            synchronized (stack) {
                String[] stringArray = string2 == null ? null : string2.split(":");
                Iterator<DisplayInfoForServer> iterator = this.mRcDisplays.iterator();
                while (iterator.hasNext()) {
                    DisplayInfoForServer displayInfoForServer = iterator.next();
                    if (displayInfoForServer.mClientNotifListComp == null) continue;
                    boolean bl = displayInfoForServer.mEnabled;
                    DisplayInfoForServer.access$502(displayInfoForServer, this.isComponentInStringArray(displayInfoForServer.mClientNotifListComp, stringArray));
                    boolean bl2 = displayInfoForServer.mEnabled;
                    if (bl == bl2) continue;
                    try {
                        displayInfoForServer.mRcDisplay.setEnabled(displayInfoForServer.mEnabled);
                        this.enableRemoteControlDisplayForClient_syncRcStack(displayInfoForServer.mRcDisplay, displayInfoForServer.mEnabled);
                        if (!displayInfoForServer.mEnabled) continue;
                        MediaFocusControl.sendMsg(this.mEventHandler, 9, 2, displayInfoForServer.mArtworkExpectedWidth, displayInfoForServer.mArtworkExpectedHeight, displayInfoForServer.mRcDisplay, 0);
                    }
                    catch (RemoteException remoteException) {
                        Log.e(TAG, "Error en/disabling RCD: ", remoteException);
                        continue;
                    }
                    break;
                }
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void onRegisterVolumeObserverForRcc(int n, IRemoteVolumeObserver iRemoteVolumeObserver) {
        int n2;
        Stack<PlayerRecord> stack = this.mPRStack;
        // MONITORENTER : stack
        try {
            n2 = -1 + this.mPRStack.size();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Log.e(TAG, "Wrong index accessing media button stack, lock error? ", arrayIndexOutOfBoundsException);
            return;
        }
        while (true) {
            block8: {
                block7: {
                    if (n2 < 0) break block7;
                    PlayerRecord playerRecord = (PlayerRecord)this.mPRStack.elementAt(n2);
                    if (playerRecord.getRccId() != n) break block8;
                    playerRecord.mRemoteVolumeObs = iRemoteVolumeObserver;
                }
                // MONITOREXIT : stack
                return;
            }
            --n2;
        }
    }

    private void plugRemoteControlDisplaysIntoClient_syncPrs(IRemoteControlClient iRemoteControlClient) {
        for (DisplayInfoForServer displayInfoForServer : this.mRcDisplays) {
            try {
                iRemoteControlClient.plugRemoteControlDisplay(displayInfoForServer.mRcDisplay, displayInfoForServer.mArtworkExpectedWidth, displayInfoForServer.mArtworkExpectedHeight);
                if (!displayInfoForServer.mWantsPositionSync) continue;
                iRemoteControlClient.setWantsSyncForDisplay(displayInfoForServer.mRcDisplay, true);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Error connecting RCD to RCC in RCC registration", remoteException);
            }
        }
    }

    private void postReevaluateRemoteControlDisplays() {
        MediaFocusControl.sendMsg(this.mEventHandler, 10, 2, 0, 0, null, 0);
    }

    private void propagateFocusLossFromGain_syncAf(int n) {
        Iterator iterator = this.mFocusStack.iterator();
        while (iterator.hasNext()) {
            ((FocusRequester)iterator.next()).handleExternalFocusGain(n);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean pushMediaButtonReceiver_syncPrs(PendingIntent var1_1, ComponentName var2_2, IBinder var3_3) {
        block18: {
            if (this.mPRStack.empty()) {
                this.mPRStack.push(new PlayerRecord(var1_1, var2_2, var3_3));
                return true;
            }
            if (this.mPRStack.peek().hasMatchingMediaButtonIntent(var1_1)) {
                return false;
            }
            if (this.mAppOps.noteOp(31, Binder.getCallingUid(), var1_1.getCreatorPackage()) != 0) {
                return false;
            }
            (PlayerRecord)this.mPRStack.lastElement();
            var5_4 = this.mPRStack.size();
            var6_5 = -1;
            var9_6 = this.mPRStack.size();
            var11_8 = null;
            for (var10_7 = var9_6 - 1; var10_7 >= 0; --var10_7) {
                var17_9 = (PlayerRecord)this.mPRStack.elementAt(var10_7);
                if (var17_9.isPlaybackActive()) {
                    var5_4 = var10_7;
                }
                if (var18_10 = var17_9.hasMatchingMediaButtonIntent(var1_1)) {
                    var6_5 = var10_7;
                }
                var11_8 = var17_9;
                continue;
            }
            if (var6_5 != -1) ** GOTO lbl-1000
            try {
                var16_11 = new PlayerRecord(var1_1, var2_2, var3_3);
            }
            catch (ArrayIndexOutOfBoundsException var7_14) {
                ** continue;
            }
            try {
                this.mPRStack.add(var5_4, var16_11);
                return false;
            }
            catch (ArrayIndexOutOfBoundsException var7_12) lbl-1000:
            // 2 sources

            {
                while (true) {
                    Log.e("MediaFocusControl", "Wrong index (inStack=" + var6_5 + " lastPlaying=" + var5_4 + " size=" + this.mPRStack.size() + " accessing media button stack", (Throwable)var7_13);
                    return false;
                }
            }
lbl-1000:
            // 1 sources

            {
                if (this.mPRStack.size() <= 1) break block18;
                var14_15 = (PlayerRecord)this.mPRStack.elementAt(var6_5);
            }
            {
                this.mPRStack.removeElementAt(var6_5);
                if (var14_15.isPlaybackActive()) {
                    this.mPRStack.push(var14_15);
                    return false;
                }
                if (var6_5 > var5_4) {
                    this.mPRStack.add(var5_4, var14_15);
                    return false;
                }
                this.mPRStack.add(var5_4 - 1, var14_15);
                return false;
            }
        }
        return false;
    }

    private boolean rcDisplayIsPluggedIn_syncRcStack(IRemoteControlDisplay iRemoteControlDisplay) {
        Iterator<DisplayInfoForServer> iterator = this.mRcDisplays.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().mRcDisplay.asBinder().equals(iRemoteControlDisplay.asBinder())) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerRemoteControlDisplay_int(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2, ComponentName componentName) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<PlayerRecord> stack = this.mPRStack;
            synchronized (stack) {
                if (iRemoteControlDisplay == null || this.rcDisplayIsPluggedIn_syncRcStack(iRemoteControlDisplay)) {
                    return;
                }
                DisplayInfoForServer displayInfoForServer = new DisplayInfoForServer(iRemoteControlDisplay, n, n2);
                DisplayInfoForServer.access$502(displayInfoForServer, true);
                DisplayInfoForServer.access$402(displayInfoForServer, componentName);
                if (!displayInfoForServer.init()) {
                    return;
                }
                this.mRcDisplays.add(displayInfoForServer);
                Iterator iterator = this.mPRStack.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        MediaFocusControl.sendMsg(this.mEventHandler, 9, 2, n, n2, iRemoteControlDisplay, 0);
                        return;
                    }
                    PlayerRecord playerRecord = (PlayerRecord)iterator.next();
                    IRemoteControlClient iRemoteControlClient = playerRecord.getRcc();
                    if (iRemoteControlClient == null) continue;
                    try {
                        playerRecord.getRcc().plugRemoteControlDisplay(iRemoteControlDisplay, n, n2);
                    }
                    catch (RemoteException remoteException) {
                        Log.e(TAG, "Error connecting RCD to client: ", remoteException);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeFocusStackEntry(String string2, boolean bl) {
        if (!this.mFocusStack.empty() && this.mFocusStack.peek().hasSameClient(string2)) {
            this.mFocusStack.pop().release();
            if (!bl) return;
            this.notifyTopOfAudioFocusStack();
            return;
        } else {
            Iterator iterator = this.mFocusStack.iterator();
            while (iterator.hasNext()) {
                FocusRequester focusRequester = (FocusRequester)iterator.next();
                if (!focusRequester.hasSameClient(string2)) continue;
                Log.i(TAG, "AudioFocus  removeFocusStackEntry(): removing entry for " + string2);
                iterator.remove();
                focusRequester.release();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeFocusStackEntryForClient(IBinder iBinder) {
        boolean bl = !this.mFocusStack.isEmpty() && this.mFocusStack.peek().hasSameBinder(iBinder);
        Iterator iterator = this.mFocusStack.iterator();
        while (iterator.hasNext()) {
            if (!((FocusRequester)iterator.next()).hasSameBinder(iBinder)) continue;
            Log.i(TAG, "AudioFocus  removeFocusStackEntry(): removing entry for " + iBinder);
            iterator.remove();
        }
        if (bl) {
            this.notifyTopOfAudioFocusStack();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeMediaButtonReceiver_syncPrs(PendingIntent pendingIntent) {
        int n;
        try {
            n = -1 + this.mPRStack.size();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Log.e(TAG, "Wrong index accessing media button stack, lock error? ", arrayIndexOutOfBoundsException);
            return;
        }
        while (n >= 0) {
            PlayerRecord playerRecord = (PlayerRecord)this.mPRStack.elementAt(n);
            if (playerRecord.hasMatchingMediaButtonIntent(pendingIntent)) {
                playerRecord.destroy();
                this.mPRStack.removeElementAt(n);
                return;
            }
            --n;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void sendMsg(Handler handler, int n, int n2, int n3, int n4, Object object, int n5) {
        if (n2 == 0) {
            handler.removeMessages(n);
        } else if (n2 == 1 && handler.hasMessages(n)) {
            return;
        }
        handler.sendMessageDelayed(handler.obtainMessage(n, n3, n4, object), n5);
    }

    private void sendSimulatedMediaButtonEvent(KeyEvent keyEvent, boolean bl) {
        this.dispatchMediaKeyEvent(KeyEvent.changeAction(keyEvent, 0), bl);
        this.dispatchMediaKeyEvent(KeyEvent.changeAction(keyEvent, 1), bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendVolumeUpdateToRemote(int n, int n2) {
        if (n2 == 0) return;
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            int n3;
            try {
                n3 = -1 + this.mPRStack.size();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Log.e(TAG, "Wrong index accessing media button stack, lock error? ", arrayIndexOutOfBoundsException);
                return;
            }
            while (true) {
                block12: {
                    IRemoteVolumeObserver iRemoteVolumeObserver;
                    block11: {
                        iRemoteVolumeObserver = null;
                        if (n3 < 0) break block11;
                        PlayerRecord playerRecord = (PlayerRecord)this.mPRStack.elementAt(n3);
                        if (playerRecord.getRccId() != n) break block12;
                        iRemoteVolumeObserver = playerRecord.mRemoteVolumeObs;
                    }
                    // MONITOREXIT @DISABLED, blocks:[3, 6] lbl17 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (iRemoteVolumeObserver == null) {
                        return;
                    }
                    try {
                        iRemoteVolumeObserver.dispatchRemoteVolumeUpdate(n2, -1);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.e(TAG, "Error dispatching relative volume update", remoteException);
                        return;
                    }
                }
                --n3;
            }
        }
    }

    private void setNewRcClientGenerationOnClients_syncRcsCurrc(int n) {
        Iterator iterator = this.mPRStack.iterator();
        while (iterator.hasNext()) {
            PlayerRecord playerRecord = (PlayerRecord)iterator.next();
            if (playerRecord == null || playerRecord.getRcc() == null) continue;
            try {
                playerRecord.getRcc().setCurrentClientGenerationId(n);
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Dead client in setNewRcClientGenerationOnClients_syncRcsCurrc()", remoteException);
                iterator.remove();
                playerRecord.unlinkToRcClientDeath();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setNewRcClientOnDisplays_syncRcsCurrc(int n, PendingIntent pendingIntent, boolean bl) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            if (this.mRcDisplays.size() > 0) {
                Iterator<DisplayInfoForServer> iterator = this.mRcDisplays.iterator();
                while (iterator.hasNext()) {
                    DisplayInfoForServer displayInfoForServer = iterator.next();
                    try {
                        displayInfoForServer.mRcDisplay.setCurrentClientId(n, pendingIntent, bl);
                    }
                    catch (RemoteException remoteException) {
                        Log.e(TAG, "Dead display in setNewRcClientOnDisplays_syncRcsCurrc()", remoteException);
                        displayInfoForServer.release();
                        iterator.remove();
                    }
                }
            }
            return;
        }
    }

    private void setNewRcClient_syncRcsCurrc(int n, PendingIntent pendingIntent, boolean bl) {
        this.setNewRcClientOnDisplays_syncRcsCurrc(n, pendingIntent, bl);
        this.setNewRcClientGenerationOnClients_syncRcsCurrc(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startVoiceBasedInteractions(boolean bl) {
        Intent intent;
        boolean bl2 = true;
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        boolean bl3 = this.mKeyguardManager != null && this.mKeyguardManager.isKeyguardLocked() ? bl2 : false;
        if (!bl3 && powerManager.isScreenOn()) {
            intent = new Intent("android.speech.action.WEB_SEARCH");
            Log.i(TAG, "voice-based interactions: about to use ACTION_WEB_SEARCH");
        } else {
            intent = new Intent("android.speech.action.VOICE_SEARCH_HANDS_FREE");
            if (!bl3 || !this.mKeyguardManager.isKeyguardSecure()) {
                bl2 = false;
            }
            intent.putExtra("android.speech.extras.EXTRA_SECURE", bl2);
            Log.i(TAG, "voice-based interactions: about to use ACTION_VOICE_SEARCH_HANDS_FREE");
        }
        if (bl) {
            this.mMediaEventWakeLock.acquire();
        }
        long l = Binder.clearCallingIdentity();
        if (intent == null) return;
        try {
            intent.setFlags(0x10800000);
            this.mContext.startActivityAsUser(intent, UserHandle.CURRENT);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.w(TAG, "No activity for search: " + activityNotFoundException);
            return;
        }
        finally {
            Binder.restoreCallingIdentity(l);
            if (!bl) return;
            this.mMediaEventWakeLock.release();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateRemoteControlDisplay_syncPrs(int n) {
        PlayerRecord playerRecord = this.mPRStack.peek();
        int n2 = n;
        if (playerRecord.getRcc() == null) {
            this.clearRemoteControlDisplay_syncPrs();
            return;
        }
        Object object = this.mCurrentRcLock;
        synchronized (object) {
            if (!playerRecord.getRcc().equals(this.mCurrentRcClient)) {
                n2 = 15;
            }
            this.mCurrentRcClient = playerRecord.getRcc();
            this.mCurrentRcClientIntent = playerRecord.getMediaButtonIntent();
        }
        this.mEventHandler.sendMessage(this.mEventHandler.obtainMessage(2, n2, 0, playerRecord));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int abandonAudioFocus(IAudioFocusDispatcher iAudioFocusDispatcher, String string2) {
        Log.i(TAG, " AudioFocus  abandonAudioFocus() from " + string2);
        try {
            Object object = mAudioFocusLock;
            synchronized (object) {
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            Log.e(TAG, "FATAL EXCEPTION AudioFocus  abandonAudioFocus() caused " + concurrentModificationException);
            concurrentModificationException.printStackTrace();
            return 1;
        }
        {
            this.removeFocusStackEntry(string2, true);
            return 1;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkUpdateRemoteStateIfActive(int var1_1) {
        var2_2 = this.mPRStack;
        synchronized (var2_2) {
            try {
                var8_3 = -1 + this.mPRStack.size();
            }
            catch (ArrayIndexOutOfBoundsException var4_6) {
                Log.e("MediaFocusControl", "Wrong index accessing RC stack, lock error? ", var4_6);
                ** GOTO lbl-1000
            }
            while (true) {
                if (var8_3 >= 0) {
                    var9_4 = (PlayerRecord)this.mPRStack.elementAt(var8_3);
                    if (var9_4.mPlaybackType == 1 && MediaFocusControl.isPlaystateActive(var9_4.mPlaybackState.mState) && var9_4.mPlaybackStream == var1_1) {
                        var10_5 = this.mMainRemote;
                        synchronized (var10_5) {
                            this.mMainRemote.mRccId = var9_4.getRccId();
                            this.mMainRemote.mVolume = var9_4.mPlaybackVolume;
                            this.mMainRemote.mVolumeMax = var9_4.mPlaybackVolumeMax;
                            this.mMainRemote.mVolumeHandling = var9_4.mPlaybackVolumeHandling;
                            this.mMainRemoteIsActive = true;
                            return true;
                        }
                    }
                } else lbl-1000:
                // 2 sources

                {
                    // MONITOREXIT @DISABLED, blocks:[7, 11, 13] lbl25 : MonitorExitStatement: MONITOREXIT : var2_2
                    var6_7 = this.mMainRemote;
                    synchronized (var6_7) {
                        this.mMainRemoteIsActive = false;
                        return false;
                    }
                }
                --var8_3;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void discardAudioFocusOwner() {
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (!this.mFocusStack.empty()) {
                FocusRequester focusRequester = this.mFocusStack.pop();
                focusRequester.handleFocusLoss(-1);
                focusRequester.release();
            }
            return;
        }
    }

    protected void dispatchMediaKeyEvent(KeyEvent keyEvent) {
        this.filterMediaKeyEvent(keyEvent, false);
    }

    protected void dispatchMediaKeyEventUnderWakelock(KeyEvent keyEvent) {
        this.filterMediaKeyEvent(keyEvent, true);
    }

    protected void dump(PrintWriter printWriter) {
        this.dumpFocusStack(printWriter);
        this.dumpRCStack(printWriter);
        this.dumpRCCStack(printWriter);
        this.dumpRCDList(printWriter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getCurrentAudioFocus() {
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (!this.mFocusStack.empty()) return this.mFocusStack.peek().getGainRequest();
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getRemoteStreamMaxVolume() {
        PlayerRecord.RemotePlaybackState remotePlaybackState = this.mMainRemote;
        synchronized (remotePlaybackState) {
            if (this.mMainRemote.mRccId != -1) return this.mMainRemote.mVolumeMax;
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getRemoteStreamVolume() {
        PlayerRecord.RemotePlaybackState remotePlaybackState = this.mMainRemote;
        synchronized (remotePlaybackState) {
            if (this.mMainRemote.mRccId != -1) return this.mMainRemote.mVolume;
            return 0;
        }
    }

    @Override
    public void onSendFinished(PendingIntent pendingIntent, Intent intent, int n, String string2, Bundle bundle) {
        if (n == 1980) {
            this.mMediaEventWakeLock.release();
        }
    }

    protected void postReevaluateRemote() {
        MediaFocusControl.sendMsg(this.mEventHandler, 3, 2, 0, 0, null, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void registerMediaButtonEventReceiverForCalls(ComponentName componentName) {
        if (this.mContext.checkCallingPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            Log.e(TAG, "Invalid permissions to register media button receiver for calls");
            return;
        }
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            this.mMediaReceiverForCalls = componentName;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void registerMediaButtonIntent(PendingIntent pendingIntent, ComponentName componentName, IBinder iBinder) {
        Log.i(TAG, "  Remote Control   registerMediaButtonIntent() for " + pendingIntent);
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            if (this.pushMediaButtonReceiver_syncPrs(pendingIntent, componentName, iBinder)) {
                this.checkUpdateRemoteControlDisplay_syncPrs(15);
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int registerRemoteControlClient(PendingIntent var1_1, IRemoteControlClient var2_2, String var3_3) {
        var4_4 = -1;
        var5_5 = this.mPRStack;
        synchronized (var5_5) {
            block10: {
                try {
                    var9_6 = -1 + this.mPRStack.size();
lbl6:
                    // 2 sources

                    while (true) {
                        if (var9_6 < 0) break;
                        var10_7 = (PlayerRecord)this.mPRStack.elementAt(var9_6);
                        if (!var10_7.hasMatchingMediaButtonIntent(var1_1)) break block10;
                        var10_7.resetControllerInfoForRcc(var2_2, var3_3, Binder.getCallingUid());
                        if (var2_2 != null) {
                            var4_4 = var10_7.getRccId();
                            if (this.mRcDisplays.size() > 0) {
                                this.plugRemoteControlDisplaysIntoClient_syncPrs(var10_7.getRcc());
                            }
                        }
                        break;
                    }
                }
                catch (ArrayIndexOutOfBoundsException var7_8) {
                    Log.e("MediaFocusControl", "Wrong index accessing RC stack, lock error? ", var7_8);
                }
                if (this.isCurrentRcController(var1_1)) {
                    this.checkUpdateRemoteControlDisplay_syncPrs(15);
                }
                return var4_4;
            }
            --var9_6;
            ** continue;
        }
    }

    protected boolean registerRemoteControlDisplay(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
        if (this.checkRcdRegistrationAuthorization(null) != 0) {
            this.registerRemoteControlDisplay_int(iRemoteControlDisplay, n, n2, null);
            return true;
        }
        Slog.w(TAG, "Access denied to process: " + Binder.getCallingPid() + ", must have permission " + "android.permission.MEDIA_CONTENT_CONTROL" + " to register IRemoteControlDisplay");
        return false;
    }

    protected boolean registerRemoteController(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2, ComponentName componentName) {
        if (this.checkRcdRegistrationAuthorization(componentName) != 0) {
            this.registerRemoteControlDisplay_int(iRemoteControlDisplay, n, n2, componentName);
            return true;
        }
        Slog.w(TAG, "Access denied to process: " + Binder.getCallingPid() + ", must have permission " + "android.permission.MEDIA_CONTENT_CONTROL" + " or be an enabled NotificationListenerService for registerRemoteController");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Iterator<DisplayInfoForServer> iterator = this.mRcDisplays.iterator();
            boolean bl = false;
            while (iterator.hasNext() && !bl) {
                DisplayInfoForServer displayInfoForServer = iterator.next();
                if (!displayInfoForServer.mRcDisplay.asBinder().equals(iRemoteControlDisplay.asBinder()) || displayInfoForServer.mArtworkExpectedWidth == n && displayInfoForServer.mArtworkExpectedHeight == n2) continue;
                DisplayInfoForServer.access$702(displayInfoForServer, n);
                DisplayInfoForServer.access$802(displayInfoForServer, n2);
                bl = true;
            }
            if (bl) {
                for (PlayerRecord playerRecord : this.mPRStack) {
                    IRemoteControlClient iRemoteControlClient = playerRecord.getRcc();
                    if (iRemoteControlClient == null) continue;
                    try {
                        playerRecord.getRcc().setBitmapSizeForDisplay(iRemoteControlDisplay, n, n2);
                    }
                    catch (RemoteException remoteException) {
                        Log.e(TAG, "Error setting bitmap size for RCD on RCC: ", remoteException);
                    }
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void remoteControlDisplayWantsPlaybackPositionSync(IRemoteControlDisplay iRemoteControlDisplay, boolean bl) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            boolean bl2;
            block9: {
                DisplayInfoForServer displayInfoForServer;
                Iterator<DisplayInfoForServer> iterator = this.mRcDisplays.iterator();
                do {
                    boolean bl3 = iterator.hasNext();
                    bl2 = false;
                    if (!bl3) break block9;
                } while (!(displayInfoForServer = iterator.next()).mRcDisplay.asBinder().equals(iRemoteControlDisplay.asBinder()));
                DisplayInfoForServer.access$2002(displayInfoForServer, bl);
                bl2 = true;
            }
            if (!bl2) {
                return;
            }
            Iterator iterator = this.mPRStack.iterator();
            while (iterator.hasNext()) {
                PlayerRecord playerRecord = (PlayerRecord)iterator.next();
                IRemoteControlClient iRemoteControlClient = playerRecord.getRcc();
                if (iRemoteControlClient == null) continue;
                try {
                    playerRecord.getRcc().setWantsSyncForDisplay(iRemoteControlDisplay, bl);
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "Error setting position sync flag for RCD on RCC: ", remoteException);
                    continue;
                }
                break;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int requestAudioFocus(int n, int n2, IBinder iBinder, IAudioFocusDispatcher iAudioFocusDispatcher, String string2, String string3) {
        Log.i(TAG, " AudioFocus  requestAudioFocus() from " + string2);
        if (!iBinder.pingBinder()) {
            Log.e(TAG, " AudioFocus DOA client for requestAudioFocus(), aborting.");
            return 0;
        }
        if (this.mAppOps.noteOp(32, Binder.getCallingUid(), string3) != 0) {
            return 0;
        }
        Object object = mAudioFocusLock;
        synchronized (object) {
            AudioFocusDeathHandler audioFocusDeathHandler;
            block9: {
                block10: {
                    if (!this.canReassignAudioFocus()) {
                        return 0;
                    }
                    audioFocusDeathHandler = new AudioFocusDeathHandler(iBinder);
                    try {
                        iBinder.linkToDeath(audioFocusDeathHandler, 0);
                        if (this.mFocusStack.empty() || !this.mFocusStack.peek().hasSameClient(string2)) break block9;
                        if (this.mFocusStack.peek().getGainRequest() != n2) break block10;
                        iBinder.unlinkToDeath(audioFocusDeathHandler, 0);
                    }
                    catch (RemoteException remoteException) {
                        Log.w(TAG, "AudioFocus  requestAudioFocus() could not link to " + iBinder + " binder death");
                        return 0;
                    }
                    return 1;
                }
                this.mFocusStack.pop().release();
            }
            this.removeFocusStackEntry(string2, false);
            if (!this.mFocusStack.empty()) {
                this.propagateFocusLossFromGain_syncAf(n2);
            }
            this.mFocusStack.push(new FocusRequester(n, n2, iAudioFocusDispatcher, iBinder, string2, audioFocusDeathHandler, string3, Binder.getCallingUid()));
            return 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setRemoteStreamVolume(int n) {
        int n2;
        PlayerRecord.RemotePlaybackState remotePlaybackState = this.mMainRemote;
        synchronized (remotePlaybackState) {
            if (this.mMainRemote.mRccId == -1) {
                return;
            }
            n2 = this.mMainRemote.mRccId;
        }
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            int n3;
            try {
                n3 = -1 + this.mPRStack.size();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Log.e(TAG, "Wrong index accessing media button stack, lock error? ", arrayIndexOutOfBoundsException);
                return;
            }
            while (true) {
                block15: {
                    IRemoteVolumeObserver iRemoteVolumeObserver;
                    block14: {
                        iRemoteVolumeObserver = null;
                        if (n3 < 0) break block14;
                        PlayerRecord playerRecord = (PlayerRecord)this.mPRStack.elementAt(n3);
                        if (playerRecord.getRccId() != n2) break block15;
                        iRemoteVolumeObserver = playerRecord.mRemoteVolumeObs;
                    }
                    // MONITOREXIT @DISABLED, blocks:[6, 9] lbl23 : MonitorExitStatement: MONITOREXIT : var5_4
                    if (iRemoteVolumeObserver == null) return;
                    try {
                        iRemoteVolumeObserver.dispatchRemoteVolumeUpdate(0, n);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.e(TAG, "Error dispatching absolute volume update", remoteException);
                        return;
                    }
                }
                --n3;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void unregisterAudioFocusClient(String string2) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            this.removeFocusStackEntry(string2, false);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void unregisterMediaButtonEventReceiverForCalls() {
        if (this.mContext.checkCallingPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            Log.e(TAG, "Invalid permissions to unregister media button receiver for calls");
            return;
        }
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            this.mMediaReceiverForCalls = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void unregisterMediaButtonIntent(PendingIntent pendingIntent) {
        Log.i(TAG, "  Remote Control   unregisterMediaButtonIntent() for " + pendingIntent);
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            boolean bl = this.isCurrentRcController(pendingIntent);
            this.removeMediaButtonReceiver_syncPrs(pendingIntent);
            if (bl) {
                this.checkUpdateRemoteControlDisplay_syncPrs(15);
            }
            return;
        }
    }

    protected void unregisterMediaButtonIntentAsync(PendingIntent pendingIntent) {
        this.mEventHandler.sendMessage(this.mEventHandler.obtainMessage(11, 0, 0, pendingIntent));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void unregisterRemoteControlClient(PendingIntent pendingIntent, IRemoteControlClient iRemoteControlClient) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            int n;
            try {
                n = -1 + this.mPRStack.size();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Log.e(TAG, "Wrong index accessing RC stack, lock error? ", arrayIndexOutOfBoundsException);
                return;
            }
            while (true) {
                block8: {
                    boolean bl;
                    block7: {
                        bl = false;
                        if (n < 0) break block7;
                        PlayerRecord playerRecord = (PlayerRecord)this.mPRStack.elementAt(n);
                        if (!playerRecord.hasMatchingMediaButtonIntent(pendingIntent) || !iRemoteControlClient.equals(playerRecord.getRcc())) break block8;
                        playerRecord.resetControllerInfoForNoRcc();
                        int n2 = this.mPRStack.size();
                        if (n != n2 - 1) return;
                        bl = true;
                    }
                    if (!bl) return;
                    this.checkUpdateRemoteControlDisplay_syncPrs(15);
                    return;
                }
                --n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void unregisterRemoteControlDisplay(IRemoteControlDisplay iRemoteControlDisplay) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            if (iRemoteControlDisplay == null) {
                return;
            }
            boolean bl = false;
            Iterator<DisplayInfoForServer> iterator = this.mRcDisplays.iterator();
            while (iterator.hasNext() && !bl) {
                DisplayInfoForServer displayInfoForServer = iterator.next();
                if (!displayInfoForServer.mRcDisplay.asBinder().equals(iRemoteControlDisplay.asBinder())) continue;
                bl = true;
                displayInfoForServer.release();
                iterator.remove();
            }
            if (bl) {
                for (PlayerRecord playerRecord : this.mPRStack) {
                    IRemoteControlClient iRemoteControlClient = playerRecord.getRcc();
                    if (iRemoteControlClient == null) continue;
                    try {
                        playerRecord.getRcc().unplugRemoteControlDisplay(iRemoteControlDisplay);
                    }
                    catch (RemoteException remoteException) {
                        Log.e(TAG, "Error disconnecting remote control display to client: ", remoteException);
                    }
                }
            }
            return;
        }
    }

    protected class AudioFocusDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;

        AudioFocusDeathHandler(IBinder iBinder) {
            this.mCb = iBinder;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void binderDied() {
            Object object = mAudioFocusLock;
            synchronized (object) {
                Log.w(MediaFocusControl.TAG, "  AudioFocus   audio focus client died");
                MediaFocusControl.this.removeFocusStackEntryForClient(this.mCb);
                return;
            }
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }

    private class DisplayInfoForServer
    implements IBinder.DeathRecipient {
        private int mArtworkExpectedHeight = -1;
        private int mArtworkExpectedWidth = -1;
        private ComponentName mClientNotifListComp;
        private boolean mEnabled = true;
        private final IRemoteControlDisplay mRcDisplay;
        private final IBinder mRcDisplayBinder;
        private boolean mWantsPositionSync = false;

        public DisplayInfoForServer(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
            this.mRcDisplay = iRemoteControlDisplay;
            this.mRcDisplayBinder = iRemoteControlDisplay.asBinder();
            this.mArtworkExpectedWidth = n;
            this.mArtworkExpectedHeight = n2;
        }

        static /* synthetic */ boolean access$2002(DisplayInfoForServer displayInfoForServer, boolean bl) {
            displayInfoForServer.mWantsPositionSync = bl;
            return bl;
        }

        static /* synthetic */ ComponentName access$402(DisplayInfoForServer displayInfoForServer, ComponentName componentName) {
            displayInfoForServer.mClientNotifListComp = componentName;
            return componentName;
        }

        static /* synthetic */ boolean access$502(DisplayInfoForServer displayInfoForServer, boolean bl) {
            displayInfoForServer.mEnabled = bl;
            return bl;
        }

        static /* synthetic */ int access$702(DisplayInfoForServer displayInfoForServer, int n) {
            displayInfoForServer.mArtworkExpectedWidth = n;
            return n;
        }

        static /* synthetic */ int access$802(DisplayInfoForServer displayInfoForServer, int n) {
            displayInfoForServer.mArtworkExpectedHeight = n;
            return n;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void binderDied() {
            Stack stack = MediaFocusControl.this.mPRStack;
            synchronized (stack) {
                Log.w(MediaFocusControl.TAG, "RemoteControl: display " + this.mRcDisplay + " died");
                Iterator iterator = MediaFocusControl.this.mRcDisplays.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return;
                } while (((DisplayInfoForServer)iterator.next()).mRcDisplay != this.mRcDisplay);
                iterator.remove();
                return;
            }
        }

        public boolean init() {
            try {
                this.mRcDisplayBinder.linkToDeath(this, 0);
                return true;
            }
            catch (RemoteException remoteException) {
                Log.w(MediaFocusControl.TAG, "registerRemoteControlDisplay() has a dead client " + this.mRcDisplayBinder);
                return false;
            }
        }

        public void release() {
            try {
                this.mRcDisplayBinder.unlinkToDeath(this, 0);
                return;
            }
            catch (NoSuchElementException noSuchElementException) {
                Log.e(MediaFocusControl.TAG, "Error in DisplaInfoForServer.relase()", noSuchElementException);
                return;
            }
        }
    }

    private class MediaEventHandler
    extends Handler {
        MediaEventHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    MediaFocusControl.this.onRcDisplayClear();
                    return;
                }
                case 2: {
                    MediaFocusControl.this.onRcDisplayUpdate((PlayerRecord)message.obj, message.arg1);
                    return;
                }
                case 3: {
                    MediaFocusControl.this.onReevaluateRemote();
                    return;
                }
                case 5: {
                    MediaFocusControl.this.onRegisterVolumeObserverForRcc(message.arg1, (IRemoteVolumeObserver)message.obj);
                    return;
                }
                case 9: {
                    MediaFocusControl.this.onRcDisplayInitInfo((IRemoteControlDisplay)message.obj, message.arg1, message.arg2);
                    return;
                }
                case 10: {
                    MediaFocusControl.this.onReevaluateRemoteControlDisplays();
                    return;
                }
                case 11: 
            }
            MediaFocusControl.this.unregisterMediaButtonIntent((PendingIntent)message.obj);
        }
    }

    private class NotificationListenerObserver
    extends ContentObserver {
        NotificationListenerObserver() {
            super(MediaFocusControl.this.mEventHandler);
            MediaFocusControl.this.mContentResolver.registerContentObserver(Settings.Secure.getUriFor("enabled_notification_listeners"), false, this);
        }

        @Override
        public void onChange(boolean bl, Uri uri) {
            if (!ENABLED_NOTIFICATION_LISTENERS_URI.equals(uri) || bl) {
                return;
            }
            MediaFocusControl.this.postReevaluateRemoteControlDisplays();
        }
    }
}

