/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import com.asus.cta.CtaChecker;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;

public class MediaRecorder {
    public static final int MEDIA_ERROR_SERVER_DIED = 100;
    public static final int MEDIA_RECORDER_ERROR_UNKNOWN = 1;
    public static final int MEDIA_RECORDER_INFO_MAX_DURATION_REACHED = 800;
    public static final int MEDIA_RECORDER_INFO_MAX_FILESIZE_REACHED = 801;
    public static final int MEDIA_RECORDER_INFO_UNKNOWN = 1;
    public static final int MEDIA_RECORDER_TRACK_INFO_COMPLETION_STATUS = 1000;
    public static final int MEDIA_RECORDER_TRACK_INFO_DATA_KBYTES = 1009;
    public static final int MEDIA_RECORDER_TRACK_INFO_DURATION_MS = 1003;
    public static final int MEDIA_RECORDER_TRACK_INFO_ENCODED_FRAMES = 1005;
    public static final int MEDIA_RECORDER_TRACK_INFO_INITIAL_DELAY_MS = 1007;
    public static final int MEDIA_RECORDER_TRACK_INFO_LIST_END = 2000;
    public static final int MEDIA_RECORDER_TRACK_INFO_LIST_START = 1000;
    public static final int MEDIA_RECORDER_TRACK_INFO_MAX_CHUNK_DUR_MS = 1004;
    public static final int MEDIA_RECORDER_TRACK_INFO_PROGRESS_IN_TIME = 1001;
    public static final int MEDIA_RECORDER_TRACK_INFO_START_OFFSET_MS = 1008;
    public static final int MEDIA_RECORDER_TRACK_INFO_TYPE = 1002;
    public static final int MEDIA_RECORDER_TRACK_INTER_CHUNK_TIME_MS = 1006;
    private static final String TAG = "MediaRecorder";
    private int mAudioSource = -1;
    private EventHandler mEventHandler;
    private FileDescriptor mFd;
    private long mNativeContext;
    private OnErrorListener mOnErrorListener;
    private OnInfoListener mOnInfoListener;
    private String mPath;
    private Surface mSurface;
    private int mVideoSource = -1;

    static {
        System.loadLibrary("media_jni");
        MediaRecorder.native_init();
    }

    /*
     * Enabled aggressive block sorting
     */
    public MediaRecorder() {
        Looper looper;
        Looper looper2 = Looper.myLooper();
        this.mEventHandler = looper2 != null ? new EventHandler(this, looper2) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        String string2 = ActivityThread.currentPackageName();
        this.native_setup(new WeakReference<MediaRecorder>(this), string2);
    }

    private native void _prepare() throws IllegalStateException, IOException;

    private native void _setAudioSource(int var1) throws IllegalStateException;

    private native void _setOutputFile(FileDescriptor var1, long var2, long var4) throws IllegalStateException, IOException;

    private native void _setVideoSource(int var1) throws IllegalStateException;

    public static final int getAudioSourceMax() {
        return 8;
    }

    private final native void native_finalize();

    private static final native void native_init();

    private native void native_reset();

    private final native void native_setup(Object var1, String var2) throws IllegalStateException;

    /*
     * Enabled aggressive block sorting
     */
    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        MediaRecorder mediaRecorder = (MediaRecorder)((WeakReference)object).get();
        if (mediaRecorder == null || mediaRecorder.mEventHandler == null) {
            return;
        }
        Message message = mediaRecorder.mEventHandler.obtainMessage(n, n2, n3, object2);
        mediaRecorder.mEventHandler.sendMessage(message);
    }

    private native void setParameter(String var1);

    protected void finalize() {
        this.native_finalize();
    }

    public native int getMaxAmplitude() throws IllegalStateException;

    public native Surface getSurface();

    public native void pause() throws IllegalStateException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepare() throws IllegalStateException, IOException {
        if (Build.CTA) {
            int n = -1;
            switch (this.mAudioSource) {
                default: {
                    n = 12;
                    break;
                }
                case 5: {
                    Log.d("CtaService", "Skip CAMCORDER");
                }
            }
            if (this.mVideoSource == 1) {
                n = 13;
            }
            if (n != -1 && !new CtaChecker(null).checkPermission(n, ActivityThread.currentPackageName())) {
                return;
            }
        }
        if (this.mPath != null) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.mPath, "rws");
            try {
                this._setOutputFile(randomAccessFile.getFD(), 0L, 0L);
            }
            finally {
                randomAccessFile.close();
            }
        } else {
            if (this.mFd == null) {
                throw new IOException("No valid output file");
            }
            this._setOutputFile(this.mFd, 0L, 0L);
        }
        this._prepare();
    }

    public native void release();

    public void reset() {
        this.native_reset();
        this.mEventHandler.removeCallbacksAndMessages(null);
    }

    public native void resume() throws IllegalStateException;

    public void setAudioChannels(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of channels is not positive");
        }
        this.setParameter("audio-param-number-of-channels=" + n);
    }

    public native void setAudioEncoder(int var1) throws IllegalStateException;

    public void setAudioEncodingBitRate(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Audio encoding bit rate is not positive");
        }
        this.setParameter("audio-param-encoding-bitrate=" + n);
    }

    public void setAudioSamplingRate(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Audio sampling rate is not positive");
        }
        this.setParameter("audio-param-sampling-rate=" + n);
    }

    public void setAudioSource(int n) throws IllegalStateException {
        this.mAudioSource = n;
        this._setAudioSource(n);
    }

    public void setAuxiliaryOutputFile(FileDescriptor fileDescriptor) {
        Log.w(TAG, "setAuxiliaryOutputFile(FileDescriptor) is no longer supported.");
    }

    public void setAuxiliaryOutputFile(String string2) {
        Log.w(TAG, "setAuxiliaryOutputFile(String) is no longer supported.");
    }

    @Deprecated
    public native void setCamera(Camera var1);

    public void setCaptureRate(double d) {
        this.setParameter("time-lapse-enable=1");
        long l = (long)(1000000.0 * (1.0 / d));
        this.setParameter("time-between-time-lapse-frame-capture=" + l);
    }

    public void setLocation(float f, float f2) {
        int n = (int)(0.5 + (double)(f * 10000.0f));
        int n2 = (int)(0.5 + (double)(f2 * 10000.0f));
        if (n > 900000 || n < -900000) {
            throw new IllegalArgumentException("Latitude: " + f + " out of range.");
        }
        if (n2 > 1800000 || n2 < -1800000) {
            throw new IllegalArgumentException("Longitude: " + f2 + " out of range");
        }
        this.setParameter("param-geotag-latitude=" + n);
        this.setParameter("param-geotag-longitude=" + n2);
    }

    public native void setMaxDuration(int var1) throws IllegalArgumentException;

    public native void setMaxFileSize(long var1) throws IllegalArgumentException;

    public void setOnErrorListener(OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    public void setOnInfoListener(OnInfoListener onInfoListener) {
        this.mOnInfoListener = onInfoListener;
    }

    public void setOrientationHint(int n) {
        if (n != 0 && n != 90 && n != 180 && n != 270) {
            throw new IllegalArgumentException("Unsupported angle: " + n);
        }
        this.setParameter("video-param-rotation-angle-degrees=" + n);
    }

    public void setOutputFile(FileDescriptor fileDescriptor) throws IllegalStateException {
        this.mPath = null;
        this.mFd = fileDescriptor;
    }

    public void setOutputFile(String string2) throws IllegalStateException {
        this.mFd = null;
        this.mPath = string2;
    }

    public native void setOutputFormat(int var1) throws IllegalStateException;

    public void setPreviewDisplay(Surface surface) {
        this.mSurface = surface;
    }

    public void setProfile(CamcorderProfile camcorderProfile) {
        this.setOutputFormat(camcorderProfile.fileFormat);
        this.setVideoFrameRate(camcorderProfile.videoFrameRate);
        this.setVideoSize(camcorderProfile.videoFrameWidth, camcorderProfile.videoFrameHeight);
        this.setVideoEncodingBitRate(camcorderProfile.videoBitRate);
        this.setVideoEncoder(camcorderProfile.videoCodec);
        if (camcorderProfile.quality >= 1000 && camcorderProfile.quality <= 1007) {
            return;
        }
        this.setAudioEncodingBitRate(camcorderProfile.audioBitRate);
        this.setAudioChannels(camcorderProfile.audioChannels);
        this.setAudioSamplingRate(camcorderProfile.audioSampleRate);
        this.setAudioEncoder(camcorderProfile.audioCodec);
    }

    public native void setVideoEncoder(int var1) throws IllegalStateException;

    public void setVideoEncodingBitRate(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Video encoding bit rate is not positive");
        }
        this.setParameter("video-param-encoding-bitrate=" + n);
    }

    public native void setVideoFrameRate(int var1) throws IllegalStateException;

    public native void setVideoSize(int var1, int var2) throws IllegalStateException;

    public void setVideoSource(int n) throws IllegalStateException {
        this.mVideoSource = n;
        this._setVideoSource(n);
    }

    public native void start() throws IllegalStateException;

    public native void stop() throws IllegalStateException;

    public final class AudioEncoder {
        public static final int AAC = 3;
        public static final int AAC_ELD = 5;
        public static final int AMR_NB = 1;
        public static final int AMR_WB = 2;
        public static final int DEFAULT = 0;
        public static final int HE_AAC = 4;
        public static final int VORBIS = 6;

        private AudioEncoder() {
        }
    }

    public final class AudioSource {
        public static final int AUDIO_SOURCE_INVALID = -1;
        public static final int CAMCORDER = 5;
        public static final int DEFAULT = 0;
        protected static final int HOTWORD = 1999;
        public static final int MIC = 1;
        public static final int REMOTE_SUBMIX = 8;
        public static final int VOICE_CALL = 4;
        public static final int VOICE_COMMUNICATION = 7;
        public static final int VOICE_DOWNLINK = 3;
        public static final int VOICE_RECOGNITION = 6;
        public static final int VOICE_UPLINK = 2;

        private AudioSource() {
        }
    }

    private class EventHandler
    extends Handler {
        private static final int MEDIA_RECORDER_EVENT_ERROR = 1;
        private static final int MEDIA_RECORDER_EVENT_INFO = 2;
        private static final int MEDIA_RECORDER_EVENT_LIST_END = 99;
        private static final int MEDIA_RECORDER_EVENT_LIST_START = 1;
        private static final int MEDIA_RECORDER_TRACK_EVENT_ERROR = 100;
        private static final int MEDIA_RECORDER_TRACK_EVENT_INFO = 101;
        private static final int MEDIA_RECORDER_TRACK_EVENT_LIST_END = 1000;
        private static final int MEDIA_RECORDER_TRACK_EVENT_LIST_START = 100;
        private MediaRecorder mMediaRecorder;

        public EventHandler(MediaRecorder mediaRecorder2, Looper looper) {
            super(looper);
            this.mMediaRecorder = mediaRecorder2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            if (this.mMediaRecorder.mNativeContext == 0L) {
                Log.w(MediaRecorder.TAG, "mediarecorder went away with unhandled events");
                return;
            } else {
                switch (message.what) {
                    default: {
                        Log.e(MediaRecorder.TAG, "Unknown message type " + message.what);
                        return;
                    }
                    case 1: 
                    case 100: {
                        if (MediaRecorder.this.mOnErrorListener == null) return;
                        MediaRecorder.this.mOnErrorListener.onError(this.mMediaRecorder, message.arg1, message.arg2);
                        return;
                    }
                    case 2: 
                    case 101: {
                        if (MediaRecorder.this.mOnInfoListener == null) return;
                        MediaRecorder.this.mOnInfoListener.onInfo(this.mMediaRecorder, message.arg1, message.arg2);
                        return;
                    }
                }
            }
        }
    }

    public static interface OnErrorListener {
        public void onError(MediaRecorder var1, int var2, int var3);
    }

    public static interface OnInfoListener {
        public void onInfo(MediaRecorder var1, int var2, int var3);
    }

    public final class OutputFormat {
        public static final int AAC_ADIF = 5;
        public static final int AAC_ADTS = 6;
        public static final int AMR_NB = 3;
        public static final int AMR_WB = 4;
        public static final int DEFAULT = 0;
        public static final int MPEG_4 = 2;
        public static final int OUTPUT_FORMAT_MPEG2TS = 8;
        public static final int OUTPUT_FORMAT_RTP_AVP = 7;
        public static final int RAW_AMR = 3;
        public static final int THREE_GPP = 1;
        public static final int WEBM = 9;

        private OutputFormat() {
        }
    }

    public final class VideoEncoder {
        public static final int DEFAULT = 0;
        public static final int H263 = 1;
        public static final int H264 = 2;
        public static final int MPEG_4_SP = 3;
        public static final int VP8 = 4;

        private VideoEncoder() {
        }
    }

    public final class VideoSource {
        public static final int CAMERA = 1;
        public static final int DEFAULT = 0;
        public static final int SURFACE = 2;

        private VideoSource() {
        }
    }
}

