/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.hardware.display.WifiDisplay;
import android.hardware.display.WifiDisplayStatus;
import android.media.AudioAttributes;
import android.media.AudioRoutesInfo;
import android.media.IAudioRoutesObserver;
import android.media.IAudioService;
import android.media.IMediaRouterClient;
import android.media.IMediaRouterService;
import android.media.IRemoteVolumeObserver;
import android.media.MediaRouterClientState;
import android.media.RemoteControlClient;
import android.media.VolumeProvider;
import android.media.session.MediaSession;
import android.os.Handler;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class MediaRouter {
    public static final int AVAILABILITY_FLAG_IGNORE_DEFAULT_ROUTE = 1;
    public static final int CALLBACK_FLAG_PASSIVE_DISCOVERY = 8;
    public static final int CALLBACK_FLAG_PERFORM_ACTIVE_SCAN = 1;
    public static final int CALLBACK_FLAG_REQUEST_DISCOVERY = 4;
    public static final int CALLBACK_FLAG_UNFILTERED_EVENTS = 2;
    private static final boolean DEBUG = false;
    static final int ROUTE_TYPE_ANY = 0x800007;
    public static final int ROUTE_TYPE_LIVE_AUDIO = 1;
    public static final int ROUTE_TYPE_LIVE_VIDEO = 2;
    public static final int ROUTE_TYPE_REMOTE_DISPLAY = 4;
    public static final int ROUTE_TYPE_USER = 0x800000;
    private static final String TAG = "MediaRouter";
    static final HashMap<Context, MediaRouter> sRouters;
    static Static sStatic;

    static {
        DEBUG = Log.isLoggable(TAG, 3);
        sRouters = new HashMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaRouter(Context context) {
        synchronized (Static.class) {
            if (sStatic == null) {
                Context context2 = context.getApplicationContext();
                sStatic = new Static(context2);
                sStatic.startMonitoringRoutes(context2);
            }
            return;
        }
    }

    static void addRouteStatic(RouteInfo routeInfo) {
        RouteCategory routeCategory = routeInfo.getCategory();
        if (!MediaRouter.sStatic.mCategories.contains(routeCategory)) {
            MediaRouter.sStatic.mCategories.add(routeCategory);
        }
        if (routeCategory.isGroupable() && !(routeInfo instanceof RouteGroup)) {
            RouteGroup routeGroup = new RouteGroup(routeInfo.getCategory());
            routeGroup.mSupportedTypes = routeInfo.mSupportedTypes;
            MediaRouter.sStatic.mRoutes.add(routeGroup);
            MediaRouter.dispatchRouteAdded(routeGroup);
            routeGroup.addRoute(routeInfo);
            return;
        }
        MediaRouter.sStatic.mRoutes.add(routeInfo);
        MediaRouter.dispatchRouteAdded(routeInfo);
    }

    static void dispatchRouteAdded(RouteInfo routeInfo) {
        for (CallbackInfo callbackInfo : MediaRouter.sStatic.mCallbacks) {
            if (!callbackInfo.filterRouteEvent(routeInfo)) continue;
            callbackInfo.cb.onRouteAdded(callbackInfo.router, routeInfo);
        }
    }

    static void dispatchRouteChanged(RouteInfo routeInfo) {
        MediaRouter.dispatchRouteChanged(routeInfo, routeInfo.mSupportedTypes);
    }

    static void dispatchRouteChanged(RouteInfo routeInfo, int n) {
        int n2 = routeInfo.mSupportedTypes;
        for (CallbackInfo callbackInfo : MediaRouter.sStatic.mCallbacks) {
            boolean bl = callbackInfo.filterRouteEvent(n);
            boolean bl2 = callbackInfo.filterRouteEvent(n2);
            if (!bl && bl2) {
                callbackInfo.cb.onRouteAdded(callbackInfo.router, routeInfo);
                if (routeInfo.isSelected()) {
                    callbackInfo.cb.onRouteSelected(callbackInfo.router, n2, routeInfo);
                }
            }
            if (bl || bl2) {
                callbackInfo.cb.onRouteChanged(callbackInfo.router, routeInfo);
            }
            if (!bl || bl2) continue;
            if (routeInfo.isSelected()) {
                callbackInfo.cb.onRouteUnselected(callbackInfo.router, n, routeInfo);
            }
            callbackInfo.cb.onRouteRemoved(callbackInfo.router, routeInfo);
        }
    }

    static void dispatchRouteGrouped(RouteInfo routeInfo, RouteGroup routeGroup, int n) {
        for (CallbackInfo callbackInfo : MediaRouter.sStatic.mCallbacks) {
            if (!callbackInfo.filterRouteEvent(routeGroup)) continue;
            callbackInfo.cb.onRouteGrouped(callbackInfo.router, routeInfo, routeGroup, n);
        }
    }

    static void dispatchRoutePresentationDisplayChanged(RouteInfo routeInfo) {
        for (CallbackInfo callbackInfo : MediaRouter.sStatic.mCallbacks) {
            if (!callbackInfo.filterRouteEvent(routeInfo)) continue;
            callbackInfo.cb.onRoutePresentationDisplayChanged(callbackInfo.router, routeInfo);
        }
    }

    static void dispatchRouteRemoved(RouteInfo routeInfo) {
        for (CallbackInfo callbackInfo : MediaRouter.sStatic.mCallbacks) {
            if (!callbackInfo.filterRouteEvent(routeInfo)) continue;
            callbackInfo.cb.onRouteRemoved(callbackInfo.router, routeInfo);
        }
    }

    static void dispatchRouteSelected(int n, RouteInfo routeInfo) {
        for (CallbackInfo callbackInfo : MediaRouter.sStatic.mCallbacks) {
            if (!callbackInfo.filterRouteEvent(routeInfo)) continue;
            callbackInfo.cb.onRouteSelected(callbackInfo.router, n, routeInfo);
        }
    }

    static void dispatchRouteUngrouped(RouteInfo routeInfo, RouteGroup routeGroup) {
        for (CallbackInfo callbackInfo : MediaRouter.sStatic.mCallbacks) {
            if (!callbackInfo.filterRouteEvent(routeGroup)) continue;
            callbackInfo.cb.onRouteUngrouped(callbackInfo.router, routeInfo, routeGroup);
        }
    }

    static void dispatchRouteUnselected(int n, RouteInfo routeInfo) {
        for (CallbackInfo callbackInfo : MediaRouter.sStatic.mCallbacks) {
            if (!callbackInfo.filterRouteEvent(routeInfo)) continue;
            callbackInfo.cb.onRouteUnselected(callbackInfo.router, n, routeInfo);
        }
    }

    static void dispatchRouteVolumeChanged(RouteInfo routeInfo) {
        for (CallbackInfo callbackInfo : MediaRouter.sStatic.mCallbacks) {
            if (!callbackInfo.filterRouteEvent(routeInfo)) continue;
            callbackInfo.cb.onRouteVolumeChanged(callbackInfo.router, routeInfo);
        }
    }

    private int findCallbackInfo(Callback callback) {
        int n = MediaRouter.sStatic.mCallbacks.size();
        for (int i = 0; i < n; ++i) {
            if (MediaRouter.sStatic.mCallbacks.get((int)i).cb != callback) continue;
            return i;
        }
        return -1;
    }

    private static WifiDisplay findWifiDisplay(WifiDisplay[] wifiDisplayArray, String string2) {
        for (int i = 0; i < wifiDisplayArray.length; ++i) {
            WifiDisplay wifiDisplay = wifiDisplayArray[i];
            if (!wifiDisplay.getDeviceAddress().equals(string2)) continue;
            return wifiDisplay;
        }
        return null;
    }

    private static RouteInfo findWifiDisplayRoute(WifiDisplay wifiDisplay) {
        int n = MediaRouter.sStatic.mRoutes.size();
        for (int i = 0; i < n; ++i) {
            RouteInfo routeInfo = MediaRouter.sStatic.mRoutes.get(i);
            if (!wifiDisplay.getDeviceAddress().equals(routeInfo.mDeviceAddress)) continue;
            return routeInfo;
        }
        return null;
    }

    static RouteInfo getRouteAtStatic(int n) {
        return MediaRouter.sStatic.mRoutes.get(n);
    }

    static int getRouteCountStatic() {
        return MediaRouter.sStatic.mRoutes.size();
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    static int getWifiDisplayStatusCode(WifiDisplay wifiDisplay, WifiDisplayStatus wifiDisplayStatus) {
        int n = wifiDisplayStatus.getScanState() == 1 ? 1 : (wifiDisplay.isAvailable() ? (wifiDisplay.canConnect() ? 3 : 5) : 4);
        if (!wifiDisplay.equals(wifiDisplayStatus.getActiveDisplay())) return n;
        switch (wifiDisplayStatus.getActiveDisplayState()) {
            default: {
                return n;
            }
            case 2: {
                return 6;
            }
            case 1: {
                return 2;
            }
            case 0: 
        }
        Log.e(TAG, "Active display is not connected!");
        return n;
    }

    static boolean isWifiDisplayEnabled(WifiDisplay wifiDisplay, WifiDisplayStatus wifiDisplayStatus) {
        return wifiDisplay.isAvailable() && (wifiDisplay.canConnect() || wifiDisplay.equals(wifiDisplayStatus.getActiveDisplay()));
    }

    static RouteInfo makeWifiDisplayRoute(WifiDisplay wifiDisplay, WifiDisplayStatus wifiDisplayStatus) {
        RouteInfo routeInfo = new RouteInfo(MediaRouter.sStatic.mSystemCategory);
        routeInfo.mDeviceAddress = wifiDisplay.getDeviceAddress();
        routeInfo.mSupportedTypes = 7;
        routeInfo.mVolumeHandling = 0;
        routeInfo.mPlaybackType = 1;
        routeInfo.setRealStatusCode(MediaRouter.getWifiDisplayStatusCode(wifiDisplay, wifiDisplayStatus));
        routeInfo.mEnabled = MediaRouter.isWifiDisplayEnabled(wifiDisplay, wifiDisplayStatus);
        routeInfo.mName = wifiDisplay.getFriendlyDisplayName();
        routeInfo.mDescription = MediaRouter.sStatic.mResources.getText(17040834);
        routeInfo.updatePresentationDisplay();
        return routeInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean matchesDeviceAddress(WifiDisplay wifiDisplay, RouteInfo routeInfo) {
        boolean bl = routeInfo != null && routeInfo.mDeviceAddress != null;
        if (wifiDisplay == null && !bl) {
            return true;
        }
        if (wifiDisplay != null && bl) {
            return wifiDisplay.getDeviceAddress().equals(routeInfo.mDeviceAddress);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void removeRouteStatic(RouteInfo routeInfo) {
        if (!MediaRouter.sStatic.mRoutes.remove(routeInfo)) return;
        RouteCategory routeCategory = routeInfo.getCategory();
        int n = MediaRouter.sStatic.mRoutes.size();
        int n2 = 0;
        while (true) {
            block7: {
                boolean bl;
                block6: {
                    bl = false;
                    if (n2 >= n) break block6;
                    if (routeCategory != MediaRouter.sStatic.mRoutes.get(n2).getCategory()) break block7;
                    bl = true;
                }
                if (routeInfo.isSelected()) {
                    MediaRouter.selectDefaultRouteStatic();
                }
                if (!bl) {
                    MediaRouter.sStatic.mCategories.remove(routeCategory);
                }
                MediaRouter.dispatchRouteRemoved(routeInfo);
                return;
            }
            ++n2;
        }
    }

    static void selectDefaultRouteStatic() {
        if (MediaRouter.sStatic.mSelectedRoute != MediaRouter.sStatic.mBluetoothA2dpRoute && MediaRouter.sStatic.mBluetoothA2dpRoute != null && sStatic.isBluetoothA2dpOn()) {
            MediaRouter.selectRouteStatic(0x800007, MediaRouter.sStatic.mBluetoothA2dpRoute, false);
            return;
        }
        MediaRouter.selectRouteStatic(0x800007, MediaRouter.sStatic.mDefaultAudioVideo, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void selectRouteStatic(int n, RouteInfo routeInfo, boolean bl) {
        boolean bl2 = true;
        RouteInfo routeInfo2 = MediaRouter.sStatic.mSelectedRoute;
        if (routeInfo2 == routeInfo) {
            return;
        }
        if (!routeInfo.matchesTypes(n)) {
            Log.w(TAG, "selectRoute ignored; cannot select route with supported types " + MediaRouter.typesToString(routeInfo.getSupportedTypes()) + " into route types " + MediaRouter.typesToString(n));
            return;
        }
        RouteInfo routeInfo3 = MediaRouter.sStatic.mBluetoothA2dpRoute;
        if (routeInfo3 != null && (n & 1) != 0 && (routeInfo == routeInfo3 || routeInfo == MediaRouter.sStatic.mDefaultAudioVideo)) {
            IAudioService iAudioService = MediaRouter.sStatic.mAudioService;
            boolean bl3 = routeInfo == routeInfo3 ? bl2 : false;
            try {
                iAudioService.setBluetoothA2dpOn(bl3);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Error changing Bluetooth A2DP state", remoteException);
            }
        }
        WifiDisplay wifiDisplay = MediaRouter.sStatic.mDisplayService.getWifiDisplayStatus().getActiveDisplay();
        boolean bl4 = routeInfo2 != null && routeInfo2.mDeviceAddress != null ? bl2 : false;
        if (routeInfo == null || routeInfo.mDeviceAddress == null) {
            bl2 = false;
        }
        if (wifiDisplay != null || bl4 || bl2) {
            if (bl2 && !MediaRouter.matchesDeviceAddress(wifiDisplay, routeInfo)) {
                if (MediaRouter.sStatic.mCanConfigureWifiDisplays) {
                    MediaRouter.sStatic.mDisplayService.connectWifiDisplay(routeInfo.mDeviceAddress);
                } else {
                    Log.e(TAG, "Cannot connect to wifi displays because this process is not allowed to do so.");
                }
            } else if (wifiDisplay != null && !bl2) {
                MediaRouter.sStatic.mDisplayService.disconnectWifiDisplay();
            }
        }
        sStatic.setSelectedRoute(routeInfo, bl);
        if (routeInfo2 != null) {
            MediaRouter.dispatchRouteUnselected(n & routeInfo2.getSupportedTypes(), routeInfo2);
            if (routeInfo2.resolveStatusCode()) {
                MediaRouter.dispatchRouteChanged(routeInfo2);
            }
        }
        if (routeInfo != null) {
            if (routeInfo.resolveStatusCode()) {
                MediaRouter.dispatchRouteChanged(routeInfo);
            }
            MediaRouter.dispatchRouteSelected(n & routeInfo.getSupportedTypes(), routeInfo);
        }
        sStatic.updateDiscoveryRequest();
    }

    private static boolean shouldShowWifiDisplay(WifiDisplay wifiDisplay, WifiDisplay wifiDisplay2) {
        return wifiDisplay.isRemembered() || wifiDisplay.equals(wifiDisplay2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void systemVolumeChanged(int n) {
        RouteInfo routeInfo = MediaRouter.sStatic.mSelectedRoute;
        if (routeInfo == null) {
            return;
        }
        if (routeInfo == MediaRouter.sStatic.mBluetoothA2dpRoute || routeInfo == MediaRouter.sStatic.mDefaultAudioVideo) {
            MediaRouter.dispatchRouteVolumeChanged(routeInfo);
            return;
        }
        if (MediaRouter.sStatic.mBluetoothA2dpRoute == null) {
            MediaRouter.dispatchRouteVolumeChanged(MediaRouter.sStatic.mDefaultAudioVideo);
            return;
        }
        try {
            RouteInfo routeInfo2 = MediaRouter.sStatic.mAudioService.isBluetoothA2dpOn() ? MediaRouter.sStatic.mBluetoothA2dpRoute : MediaRouter.sStatic.mDefaultAudioVideo;
            MediaRouter.dispatchRouteVolumeChanged(routeInfo2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error checking Bluetooth A2DP state to report volume change", remoteException);
            return;
        }
    }

    static String typesToString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 1) != 0) {
            stringBuilder.append("ROUTE_TYPE_LIVE_AUDIO ");
        }
        if ((n & 2) != 0) {
            stringBuilder.append("ROUTE_TYPE_LIVE_VIDEO ");
        }
        if ((n & 4) != 0) {
            stringBuilder.append("ROUTE_TYPE_REMOTE_DISPLAY ");
        }
        if ((0x800000 & n) != 0) {
            stringBuilder.append("ROUTE_TYPE_USER ");
        }
        return stringBuilder.toString();
    }

    static void updateRoute(RouteInfo routeInfo) {
        MediaRouter.dispatchRouteChanged(routeInfo);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void updateWifiDisplayRoute(RouteInfo routeInfo, WifiDisplay wifiDisplay, WifiDisplayStatus wifiDisplayStatus, boolean bl) {
        boolean bl2;
        String string2 = wifiDisplay.getFriendlyDisplayName();
        boolean bl3 = routeInfo.getName().equals(string2);
        boolean bl4 = false;
        if (!bl3) {
            routeInfo.mName = string2;
            bl4 = true;
        }
        boolean bl5 = routeInfo.mEnabled != (bl2 = MediaRouter.isWifiDisplayEnabled(wifiDisplay, wifiDisplayStatus));
        boolean bl6 = bl4 | bl5;
        routeInfo.mEnabled = bl2;
        if (bl6 | routeInfo.setRealStatusCode(MediaRouter.getWifiDisplayStatusCode(wifiDisplay, wifiDisplayStatus))) {
            MediaRouter.dispatchRouteChanged(routeInfo);
        }
        if ((!bl2 || bl) && routeInfo.isSelected()) {
            MediaRouter.selectDefaultRouteStatic();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void updateWifiDisplayStatus(WifiDisplayStatus wifiDisplayStatus) {
        WifiDisplay wifiDisplay;
        WifiDisplay[] wifiDisplayArray;
        if (wifiDisplayStatus.getFeatureState() == 3) {
            wifiDisplayArray = wifiDisplayStatus.getDisplays();
            wifiDisplay = wifiDisplayStatus.getActiveDisplay();
            if (!MediaRouter.sStatic.mCanConfigureWifiDisplays) {
                wifiDisplayArray = wifiDisplay != null ? new WifiDisplay[]{wifiDisplay} : WifiDisplay.EMPTY_ARRAY;
            }
        } else {
            wifiDisplayArray = WifiDisplay.EMPTY_ARRAY;
            wifiDisplay = null;
        }
        String string2 = wifiDisplay != null ? wifiDisplay.getDeviceAddress() : null;
        for (int i = 0; i < wifiDisplayArray.length; ++i) {
            WifiDisplay wifiDisplay2 = wifiDisplayArray[i];
            if (!MediaRouter.shouldShowWifiDisplay(wifiDisplay2, wifiDisplay)) continue;
            RouteInfo routeInfo = MediaRouter.findWifiDisplayRoute(wifiDisplay2);
            if (routeInfo == null) {
                routeInfo = MediaRouter.makeWifiDisplayRoute(wifiDisplay2, wifiDisplayStatus);
                MediaRouter.addRouteStatic(routeInfo);
            } else {
                String string3 = wifiDisplay2.getDeviceAddress();
                boolean bl = !string3.equals(string2) && string3.equals(MediaRouter.sStatic.mPreviousActiveWifiDisplayAddress);
                MediaRouter.updateWifiDisplayRoute(routeInfo, wifiDisplay2, wifiDisplayStatus, bl);
            }
            if (!wifiDisplay2.equals(wifiDisplay)) continue;
            MediaRouter.selectRouteStatic(routeInfo.getSupportedTypes(), routeInfo, false);
        }
        int n = MediaRouter.sStatic.mRoutes.size();
        while (true) {
            WifiDisplay wifiDisplay3;
            int n2 = n - 1;
            if (n <= 0) {
                MediaRouter.sStatic.mPreviousActiveWifiDisplayAddress = string2;
                return;
            }
            RouteInfo routeInfo = MediaRouter.sStatic.mRoutes.get(n2);
            if (!(routeInfo.mDeviceAddress == null || (wifiDisplay3 = MediaRouter.findWifiDisplay(wifiDisplayArray, routeInfo.mDeviceAddress)) != null && MediaRouter.shouldShowWifiDisplay(wifiDisplay3, wifiDisplay))) {
                MediaRouter.removeRouteStatic(routeInfo);
            }
            n = n2;
        }
    }

    public void addCallback(int n, Callback callback) {
        this.addCallback(n, callback, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addCallback(int n, Callback callback, int n2) {
        int n3 = this.findCallbackInfo(callback);
        if (n3 >= 0) {
            CallbackInfo callbackInfo = MediaRouter.sStatic.mCallbacks.get(n3);
            callbackInfo.type = n | callbackInfo.type;
            callbackInfo.flags = n2 | callbackInfo.flags;
        } else {
            CallbackInfo callbackInfo = new CallbackInfo(callback, n, n2, this);
            MediaRouter.sStatic.mCallbacks.add(callbackInfo);
        }
        sStatic.updateDiscoveryRequest();
    }

    public void addRouteInt(RouteInfo routeInfo) {
        MediaRouter.addRouteStatic(routeInfo);
    }

    public void addUserRoute(UserRouteInfo userRouteInfo) {
        MediaRouter.addRouteStatic(userRouteInfo);
    }

    public void clearUserRoutes() {
        for (int i = 0; i < MediaRouter.sStatic.mRoutes.size(); ++i) {
            RouteInfo routeInfo = MediaRouter.sStatic.mRoutes.get(i);
            if (!(routeInfo instanceof UserRouteInfo) && !(routeInfo instanceof RouteGroup)) continue;
            MediaRouter.removeRouteStatic(routeInfo);
            --i;
        }
    }

    public RouteCategory createRouteCategory(int n, boolean bl) {
        return new RouteCategory(n, 0x800000, bl);
    }

    public RouteCategory createRouteCategory(CharSequence charSequence, boolean bl) {
        return new RouteCategory(charSequence, 0x800000, bl);
    }

    public UserRouteInfo createUserRoute(RouteCategory routeCategory) {
        return new UserRouteInfo(routeCategory);
    }

    public RouteCategory getCategoryAt(int n) {
        return MediaRouter.sStatic.mCategories.get(n);
    }

    public int getCategoryCount() {
        return MediaRouter.sStatic.mCategories.size();
    }

    public RouteInfo getDefaultRoute() {
        return MediaRouter.sStatic.mDefaultAudioVideo;
    }

    public RouteInfo getRouteAt(int n) {
        return MediaRouter.sStatic.mRoutes.get(n);
    }

    public int getRouteCount() {
        return MediaRouter.sStatic.mRoutes.size();
    }

    public RouteInfo getSelectedRoute() {
        return this.getSelectedRoute(0x800007);
    }

    public RouteInfo getSelectedRoute(int n) {
        if (MediaRouter.sStatic.mSelectedRoute != null && (n & MediaRouter.sStatic.mSelectedRoute.mSupportedTypes) != 0) {
            return MediaRouter.sStatic.mSelectedRoute;
        }
        if (n == 0x800000) {
            return null;
        }
        return MediaRouter.sStatic.mDefaultAudioVideo;
    }

    public RouteCategory getSystemCategory() {
        return MediaRouter.sStatic.mSystemCategory;
    }

    public boolean isRouteAvailable(int n, int n2) {
        int n3 = MediaRouter.sStatic.mRoutes.size();
        for (int i = 0; i < n3; ++i) {
            RouteInfo routeInfo = MediaRouter.sStatic.mRoutes.get(i);
            if (!routeInfo.matchesTypes(n) || (n2 & 1) != 0 && routeInfo == MediaRouter.sStatic.mDefaultAudioVideo) continue;
            return true;
        }
        return false;
    }

    public void rebindAsUser(int n) {
        sStatic.rebindAsUser(n);
    }

    public void removeCallback(Callback callback) {
        int n = this.findCallbackInfo(callback);
        if (n >= 0) {
            MediaRouter.sStatic.mCallbacks.remove(n);
            sStatic.updateDiscoveryRequest();
            return;
        }
        Log.w(TAG, "removeCallback(" + callback + "): callback not registered");
    }

    public void removeRouteInt(RouteInfo routeInfo) {
        MediaRouter.removeRouteStatic(routeInfo);
    }

    public void removeUserRoute(UserRouteInfo userRouteInfo) {
        MediaRouter.removeRouteStatic(userRouteInfo);
    }

    public void selectRoute(int n, RouteInfo routeInfo) {
        MediaRouter.selectRouteStatic(n, routeInfo, true);
    }

    public void selectRouteInt(int n, RouteInfo routeInfo, boolean bl) {
        MediaRouter.selectRouteStatic(n, routeInfo, bl);
    }

    public static abstract class Callback {
        public abstract void onRouteAdded(MediaRouter var1, RouteInfo var2);

        public abstract void onRouteChanged(MediaRouter var1, RouteInfo var2);

        public abstract void onRouteGrouped(MediaRouter var1, RouteInfo var2, RouteGroup var3, int var4);

        public void onRoutePresentationDisplayChanged(MediaRouter mediaRouter, RouteInfo routeInfo) {
        }

        public abstract void onRouteRemoved(MediaRouter var1, RouteInfo var2);

        public abstract void onRouteSelected(MediaRouter var1, int var2, RouteInfo var3);

        public abstract void onRouteUngrouped(MediaRouter var1, RouteInfo var2, RouteGroup var3);

        public abstract void onRouteUnselected(MediaRouter var1, int var2, RouteInfo var3);

        public abstract void onRouteVolumeChanged(MediaRouter var1, RouteInfo var2);
    }

    static class CallbackInfo {
        public final Callback cb;
        public int flags;
        public final MediaRouter router;
        public int type;

        public CallbackInfo(Callback callback, int n, int n2, MediaRouter mediaRouter) {
            this.cb = callback;
            this.type = n;
            this.flags = n2;
            this.router = mediaRouter;
        }

        public boolean filterRouteEvent(int n) {
            return (2 & this.flags) != 0 || (n & this.type) != 0;
        }

        public boolean filterRouteEvent(RouteInfo routeInfo) {
            return this.filterRouteEvent(routeInfo.mSupportedTypes);
        }
    }

    public static class RouteCategory {
        final boolean mGroupable;
        boolean mIsSystem;
        CharSequence mName;
        int mNameResId;
        int mTypes;

        RouteCategory(int n, int n2, boolean bl) {
            this.mNameResId = n;
            this.mTypes = n2;
            this.mGroupable = bl;
        }

        RouteCategory(CharSequence charSequence, int n, boolean bl) {
            this.mName = charSequence;
            this.mTypes = n;
            this.mGroupable = bl;
        }

        public CharSequence getName() {
            return this.getName(MediaRouter.sStatic.mResources);
        }

        public CharSequence getName(Context context) {
            return this.getName(context.getResources());
        }

        CharSequence getName(Resources resources) {
            if (this.mNameResId != 0) {
                return resources.getText(this.mNameResId);
            }
            return this.mName;
        }

        /*
         * Enabled aggressive block sorting
         */
        public List<RouteInfo> getRoutes(List<RouteInfo> list) {
            if (list == null) {
                list = new ArrayList<RouteInfo>();
            } else {
                list.clear();
            }
            int n = MediaRouter.getRouteCountStatic();
            int n2 = 0;
            while (n2 < n) {
                RouteInfo routeInfo = MediaRouter.getRouteAtStatic(n2);
                if (routeInfo.mCategory == this) {
                    list.add(routeInfo);
                }
                ++n2;
            }
            return list;
        }

        public int getSupportedTypes() {
            return this.mTypes;
        }

        public boolean isGroupable() {
            return this.mGroupable;
        }

        public boolean isSystem() {
            return this.mIsSystem;
        }

        public String toString() {
            return "RouteCategory{ name=" + this.mName + " types=" + MediaRouter.typesToString(this.mTypes) + " groupable=" + this.mGroupable + " }";
        }
    }

    public static class RouteGroup
    extends RouteInfo {
        final ArrayList<RouteInfo> mRoutes = new ArrayList();
        private boolean mUpdateName;

        RouteGroup(RouteCategory routeCategory) {
            super(routeCategory);
            this.mGroup = this;
            this.mVolumeHandling = 0;
        }

        public void addRoute(RouteInfo routeInfo) {
            if (routeInfo.getGroup() != null) {
                throw new IllegalStateException("Route " + routeInfo + " is already part of a group.");
            }
            if (routeInfo.getCategory() != this.mCategory) {
                throw new IllegalArgumentException("Route cannot be added to a group with a different category. (Route category=" + routeInfo.getCategory() + " group category=" + this.mCategory + ")");
            }
            int n = this.mRoutes.size();
            this.mRoutes.add(routeInfo);
            routeInfo.mGroup = this;
            this.mUpdateName = true;
            this.updateVolume();
            this.routeUpdated();
            MediaRouter.dispatchRouteGrouped(routeInfo, this, n);
        }

        public void addRoute(RouteInfo routeInfo, int n) {
            if (routeInfo.getGroup() != null) {
                throw new IllegalStateException("Route " + routeInfo + " is already part of a group.");
            }
            if (routeInfo.getCategory() != this.mCategory) {
                throw new IllegalArgumentException("Route cannot be added to a group with a different category. (Route category=" + routeInfo.getCategory() + " group category=" + this.mCategory + ")");
            }
            this.mRoutes.add(n, routeInfo);
            routeInfo.mGroup = this;
            this.mUpdateName = true;
            this.updateVolume();
            this.routeUpdated();
            MediaRouter.dispatchRouteGrouped(routeInfo, this, n);
        }

        @Override
        CharSequence getName(Resources resources) {
            if (this.mUpdateName) {
                this.updateName();
            }
            return super.getName(resources);
        }

        public RouteInfo getRouteAt(int n) {
            return this.mRoutes.get(n);
        }

        public int getRouteCount() {
            return this.mRoutes.size();
        }

        void memberNameChanged(RouteInfo routeInfo, CharSequence charSequence) {
            this.mUpdateName = true;
            this.routeUpdated();
        }

        void memberStatusChanged(RouteInfo routeInfo, CharSequence charSequence) {
            this.setStatusInt(charSequence);
        }

        void memberVolumeChanged(RouteInfo routeInfo) {
            this.updateVolume();
        }

        public void removeRoute(int n) {
            RouteInfo routeInfo = this.mRoutes.remove(n);
            routeInfo.mGroup = null;
            this.mUpdateName = true;
            this.updateVolume();
            MediaRouter.dispatchRouteUngrouped(routeInfo, this);
            this.routeUpdated();
        }

        public void removeRoute(RouteInfo routeInfo) {
            if (routeInfo.getGroup() != this) {
                throw new IllegalArgumentException("Route " + routeInfo + " is not a member of this group.");
            }
            this.mRoutes.remove(routeInfo);
            routeInfo.mGroup = null;
            this.mUpdateName = true;
            this.updateVolume();
            MediaRouter.dispatchRouteUngrouped(routeInfo, this);
            this.routeUpdated();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void requestSetVolume(int n) {
            block4: {
                block3: {
                    int n2 = this.getVolumeMax();
                    if (n2 == 0) break block3;
                    float f = (float)n / (float)n2;
                    int n3 = this.getRouteCount();
                    for (int i = 0; i < n3; ++i) {
                        RouteInfo routeInfo = this.getRouteAt(i);
                        routeInfo.requestSetVolume((int)(f * (float)routeInfo.getVolumeMax()));
                    }
                    if (n != this.mVolume) break block4;
                }
                return;
            }
            this.mVolume = n;
            MediaRouter.dispatchRouteVolumeChanged(this);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void requestUpdateVolume(int n) {
            int n2;
            block4: {
                block3: {
                    if (this.getVolumeMax() == 0) break block3;
                    int n3 = this.getRouteCount();
                    n2 = 0;
                    for (int i = 0; i < n3; ++i) {
                        RouteInfo routeInfo = this.getRouteAt(i);
                        routeInfo.requestUpdateVolume(n);
                        int n4 = routeInfo.getVolume();
                        if (n4 <= n2) continue;
                        n2 = n4;
                    }
                    if (n2 != this.mVolume) break block4;
                }
                return;
            }
            this.mVolume = n2;
            MediaRouter.dispatchRouteVolumeChanged(this);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        void routeUpdated() {
            boolean bl;
            boolean bl2;
            int n = 0;
            int n2 = this.mRoutes.size();
            if (n2 == 0) {
                MediaRouter.removeRouteStatic(this);
                return;
            }
            int n3 = 0;
            boolean bl3 = true;
            boolean bl4 = true;
            for (int i = 0; i < n2; bl3 &= bl2, bl4 &= bl, ++i) {
                RouteInfo routeInfo = this.mRoutes.get(i);
                n |= routeInfo.mSupportedTypes;
                int n4 = routeInfo.getVolumeMax();
                if (n4 > n3) {
                    n3 = n4;
                }
                bl2 = routeInfo.getPlaybackType() == 0;
                bl = routeInfo.getVolumeHandling() == 0;
            }
            int n5 = bl3 ? 0 : 1;
            this.mPlaybackType = n5;
            int n6 = bl4 ? 0 : 1;
            this.mVolumeHandling = n6;
            this.mSupportedTypes = n;
            this.mVolumeMax = n3;
            Drawable drawable2 = n2 == 1 ? this.mRoutes.get(0).getIconDrawable() : null;
            this.mIcon = drawable2;
            super.routeUpdated();
        }

        public void setIconDrawable(Drawable drawable2) {
            this.mIcon = drawable2;
        }

        public void setIconResource(int n) {
            this.setIconDrawable(MediaRouter.sStatic.mResources.getDrawable(n));
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(super.toString());
            stringBuilder.append('[');
            int n = this.mRoutes.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.mRoutes.get(i));
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        void updateName() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.mRoutes.size();
            for (int i = 0; i < n; ++i) {
                RouteInfo routeInfo = this.mRoutes.get(i);
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(routeInfo.mName);
            }
            this.mName = stringBuilder.toString();
            this.mUpdateName = false;
        }

        void updateVolume() {
            int n = this.getRouteCount();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = this.getRouteAt(i).getVolume();
                if (n3 <= n2) continue;
                n2 = n3;
            }
            if (n2 != this.mVolume) {
                this.mVolume = n2;
                MediaRouter.dispatchRouteVolumeChanged(this);
            }
        }
    }

    public static class RouteInfo {
        public static final int PLAYBACK_TYPE_LOCAL = 0;
        public static final int PLAYBACK_TYPE_REMOTE = 1;
        public static final int PLAYBACK_VOLUME_FIXED = 0;
        public static final int PLAYBACK_VOLUME_VARIABLE = 1;
        public static final int STATUS_AVAILABLE = 3;
        public static final int STATUS_CONNECTED = 6;
        public static final int STATUS_CONNECTING = 2;
        public static final int STATUS_IN_USE = 5;
        public static final int STATUS_NONE = 0;
        public static final int STATUS_NOT_AVAILABLE = 4;
        public static final int STATUS_SCANNING = 1;
        final RouteCategory mCategory;
        CharSequence mDescription;
        String mDeviceAddress;
        boolean mEnabled = true;
        String mGlobalRouteId;
        RouteGroup mGroup;
        Drawable mIcon;
        CharSequence mName;
        int mNameResId;
        int mPlaybackStream = 3;
        int mPlaybackType = 0;
        Display mPresentationDisplay;
        int mPresentationDisplayId = -1;
        private int mRealStatusCode;
        final IRemoteVolumeObserver.Stub mRemoteVolObserver = new IRemoteVolumeObserver.Stub(){

            @Override
            public void dispatchRemoteVolumeUpdate(final int n, final int n2) {
                MediaRouter.sStatic.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            block2: {
                                if (RouteInfo.this.mVcb == null) break block2;
                                if (n == 0) break block3;
                                RouteInfo.this.mVcb.vcb.onVolumeUpdateRequest(RouteInfo.this.mVcb.route, n);
                            }
                            return;
                        }
                        RouteInfo.this.mVcb.vcb.onVolumeSetRequest(RouteInfo.this.mVcb.route, n2);
                    }
                });
            }
        };
        private int mResolvedStatusCode;
        private CharSequence mStatus;
        int mSupportedTypes;
        private Object mTag;
        VolumeCallbackInfo mVcb;
        int mVolume = 15;
        int mVolumeHandling = 1;
        int mVolumeMax = 15;

        RouteInfo(RouteCategory routeCategory) {
            this.mCategory = routeCategory;
        }

        /*
         * Enabled aggressive block sorting
         */
        private Display choosePresentationDisplay() {
            Display display;
            if ((2 & this.mSupportedTypes) == 0) return null;
            Display[] displayArray = sStatic.getAllPresentationDisplays();
            if (this.mPresentationDisplayId >= 0) {
                int n = displayArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return null;
                    }
                    display = displayArray[n2];
                    if (display.getDisplayId() == this.mPresentationDisplayId) return display;
                    ++n2;
                }
            }
            if (this.mDeviceAddress == null) {
                if (this != MediaRouter.sStatic.mDefaultAudioVideo || displayArray.length <= 0) return null;
                return displayArray[0];
            }
            int n = displayArray.length;
            int n3 = 0;
            while (n3 < n) {
                display = displayArray[n3];
                if (display.getType() == 3 && this.mDeviceAddress.equals(display.getAddress())) {
                    return display;
                }
                ++n3;
            }
            return null;
        }

        public RouteCategory getCategory() {
            return this.mCategory;
        }

        public CharSequence getDescription() {
            return this.mDescription;
        }

        public String getDeviceAddress() {
            return this.mDeviceAddress;
        }

        public RouteGroup getGroup() {
            return this.mGroup;
        }

        public Drawable getIconDrawable() {
            return this.mIcon;
        }

        public CharSequence getName() {
            return this.getName(MediaRouter.sStatic.mResources);
        }

        public CharSequence getName(Context context) {
            return this.getName(context.getResources());
        }

        CharSequence getName(Resources resources) {
            if (this.mNameResId != 0) {
                CharSequence charSequence;
                this.mName = charSequence = resources.getText(this.mNameResId);
                return charSequence;
            }
            return this.mName;
        }

        public int getPlaybackStream() {
            return this.mPlaybackStream;
        }

        public int getPlaybackType() {
            return this.mPlaybackType;
        }

        public Display getPresentationDisplay() {
            return this.mPresentationDisplay;
        }

        public CharSequence getStatus() {
            return this.mStatus;
        }

        public int getStatusCode() {
            return this.mResolvedStatusCode;
        }

        public int getSupportedTypes() {
            return this.mSupportedTypes;
        }

        public Object getTag() {
            return this.mTag;
        }

        public int getVolume() {
            if (this.mPlaybackType == 0) {
                try {
                    int n = MediaRouter.sStatic.mAudioService.getStreamVolume(this.mPlaybackStream);
                    return n;
                }
                catch (RemoteException remoteException) {
                    Log.e(MediaRouter.TAG, "Error getting local stream volume", remoteException);
                    return 0;
                }
            }
            return this.mVolume;
        }

        public int getVolumeHandling() {
            return this.mVolumeHandling;
        }

        public int getVolumeMax() {
            if (this.mPlaybackType == 0) {
                try {
                    int n = MediaRouter.sStatic.mAudioService.getStreamMaxVolume(this.mPlaybackStream);
                    return n;
                }
                catch (RemoteException remoteException) {
                    Log.e(MediaRouter.TAG, "Error getting local stream volume", remoteException);
                    return 0;
                }
            }
            return this.mVolumeMax;
        }

        public boolean isConnecting() {
            return this.mResolvedStatusCode == 2;
        }

        public boolean isDefault() {
            return this == MediaRouter.sStatic.mDefaultAudioVideo;
        }

        public boolean isEnabled() {
            return this.mEnabled;
        }

        public boolean isSelected() {
            return this == MediaRouter.sStatic.mSelectedRoute;
        }

        public boolean matchesTypes(int n) {
            return (n & this.mSupportedTypes) != 0;
        }

        public void requestSetVolume(int n) {
            if (this.mPlaybackType == 0) {
                try {
                    MediaRouter.sStatic.mAudioService.setStreamVolume(this.mPlaybackStream, n, 0, ActivityThread.currentPackageName());
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.e(MediaRouter.TAG, "Error setting local stream volume", remoteException);
                    return;
                }
            }
            sStatic.requestSetVolume(this, n);
        }

        public void requestUpdateVolume(int n) {
            if (this.mPlaybackType == 0) {
                try {
                    int n2 = Math.max(0, Math.min(n + this.getVolume(), this.getVolumeMax()));
                    MediaRouter.sStatic.mAudioService.setStreamVolume(this.mPlaybackStream, n2, 0, ActivityThread.currentPackageName());
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.e(MediaRouter.TAG, "Error setting local stream volume", remoteException);
                    return;
                }
            }
            sStatic.requestUpdateVolume(this, n);
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean resolveStatusCode() {
            int n;
            int n2 = this.mRealStatusCode;
            if (this.isSelected()) {
                switch (n2) {
                    case 1: 
                    case 3: {
                        n2 = 2;
                    }
                }
            }
            if (this.mResolvedStatusCode == n2) {
                return false;
            }
            this.mResolvedStatusCode = n2;
            switch (n2) {
                default: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 17040841;
                    break;
                }
                case 2: {
                    n = 17040842;
                    break;
                }
                case 3: {
                    n = 17040843;
                    break;
                }
                case 4: {
                    n = 17040844;
                    break;
                }
                case 5: {
                    n = 17040845;
                }
            }
            CharSequence charSequence = n != 0 ? MediaRouter.sStatic.mResources.getText(n) : null;
            this.mStatus = charSequence;
            return true;
        }

        void routeUpdated() {
            MediaRouter.updateRoute(this);
        }

        public void select() {
            MediaRouter.selectRouteStatic(this.mSupportedTypes, this, true);
        }

        boolean setRealStatusCode(int n) {
            if (this.mRealStatusCode != n) {
                this.mRealStatusCode = n;
                return this.resolveStatusCode();
            }
            return false;
        }

        void setStatusInt(CharSequence charSequence) {
            if (!charSequence.equals(this.mStatus)) {
                this.mStatus = charSequence;
                if (this.mGroup != null) {
                    this.mGroup.memberStatusChanged(this, charSequence);
                }
                this.routeUpdated();
            }
        }

        public void setTag(Object object) {
            this.mTag = object;
            this.routeUpdated();
        }

        public String toString() {
            String string2 = MediaRouter.typesToString(this.getSupportedTypes());
            return this.getClass().getSimpleName() + "{ name=" + this.getName() + ", description=" + this.getDescription() + ", status=" + this.getStatus() + ", category=" + this.getCategory() + ", supportedTypes=" + string2 + ", presentationDisplay=" + this.mPresentationDisplay + " }";
        }

        boolean updatePresentationDisplay() {
            Display display = this.choosePresentationDisplay();
            if (this.mPresentationDisplay != display) {
                this.mPresentationDisplay = display;
                return true;
            }
            return false;
        }
    }

    public static class SimpleCallback
    extends Callback {
        @Override
        public void onRouteAdded(MediaRouter mediaRouter, RouteInfo routeInfo) {
        }

        @Override
        public void onRouteChanged(MediaRouter mediaRouter, RouteInfo routeInfo) {
        }

        @Override
        public void onRouteGrouped(MediaRouter mediaRouter, RouteInfo routeInfo, RouteGroup routeGroup, int n) {
        }

        @Override
        public void onRouteRemoved(MediaRouter mediaRouter, RouteInfo routeInfo) {
        }

        @Override
        public void onRouteSelected(MediaRouter mediaRouter, int n, RouteInfo routeInfo) {
        }

        @Override
        public void onRouteUngrouped(MediaRouter mediaRouter, RouteInfo routeInfo, RouteGroup routeGroup) {
        }

        @Override
        public void onRouteUnselected(MediaRouter mediaRouter, int n, RouteInfo routeInfo) {
        }

        @Override
        public void onRouteVolumeChanged(MediaRouter mediaRouter, RouteInfo routeInfo) {
        }
    }

    static class Static
    implements DisplayManager.DisplayListener {
        boolean mActivelyScanningWifiDisplays;
        final Context mAppContext;
        final IAudioRoutesObserver.Stub mAudioRoutesObserver;
        final IAudioService mAudioService;
        RouteInfo mBluetoothA2dpRoute;
        final CopyOnWriteArrayList<CallbackInfo> mCallbacks = new CopyOnWriteArrayList();
        final boolean mCanConfigureWifiDisplays;
        final ArrayList<RouteCategory> mCategories;
        IMediaRouterClient mClient;
        MediaRouterClientState mClientState;
        final AudioRoutesInfo mCurAudioRoutesInfo;
        int mCurrentUserId = -1;
        RouteInfo mDefaultAudioVideo;
        boolean mDiscoverRequestActiveScan;
        int mDiscoveryRequestRouteTypes;
        final DisplayManager mDisplayService;
        final Handler mHandler;
        final IMediaRouterService mMediaRouterService;
        String mPreviousActiveWifiDisplayAddress;
        final Resources mResources;
        final ArrayList<RouteInfo> mRoutes = new ArrayList();
        RouteInfo mSelectedRoute;
        final RouteCategory mSystemCategory;

        /*
         * Enabled aggressive block sorting
         */
        Static(Context context) {
            this.mCategories = new ArrayList();
            this.mCurAudioRoutesInfo = new AudioRoutesInfo();
            this.mAudioRoutesObserver = new IAudioRoutesObserver.Stub(){

                @Override
                public void dispatchAudioRoutesChanged(final AudioRoutesInfo audioRoutesInfo) {
                    Static.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            Static.this.updateAudioRoutes(audioRoutesInfo);
                        }
                    });
                }
            };
            this.mAppContext = context;
            this.mResources = Resources.getSystem();
            this.mHandler = new Handler(context.getMainLooper());
            this.mAudioService = IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
            this.mDisplayService = (DisplayManager)context.getSystemService("display");
            this.mMediaRouterService = IMediaRouterService.Stub.asInterface(ServiceManager.getService("media_router"));
            this.mSystemCategory = new RouteCategory(17040832, 3, false);
            this.mSystemCategory.mIsSystem = true;
            boolean bl = DisplayManager.isPlayToExist(context) && DisplayManager.callingFromPlayTo(context) || context.checkPermission("android.permission.CONFIGURE_WIFI_DISPLAY", Process.myPid(), Process.myUid()) == 0;
            this.mCanConfigureWifiDisplays = bl;
        }

        private void updatePresentationDisplays(int n) {
            int n2 = this.mRoutes.size();
            for (int i = 0; i < n2; ++i) {
                RouteInfo routeInfo = this.mRoutes.get(i);
                if (!routeInfo.updatePresentationDisplay() && (routeInfo.mPresentationDisplay == null || routeInfo.mPresentationDisplay.getDisplayId() != n)) continue;
                MediaRouter.dispatchRoutePresentationDisplayChanged(routeInfo);
            }
        }

        RouteInfo findGlobalRoute(String string2) {
            int n = this.mRoutes.size();
            for (int i = 0; i < n; ++i) {
                RouteInfo routeInfo = this.mRoutes.get(i);
                if (!string2.equals(routeInfo.mGlobalRouteId)) continue;
                return routeInfo;
            }
            return null;
        }

        public Display[] getAllPresentationDisplays() {
            return this.mDisplayService.getDisplays("android.hardware.display.category.PRESENTATION");
        }

        boolean isBluetoothA2dpOn() {
            try {
                boolean bl = this.mAudioService.isBluetoothA2dpOn();
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(MediaRouter.TAG, "Error querying Bluetooth A2DP state", remoteException);
                return false;
            }
        }

        RouteInfo makeGlobalRoute(MediaRouterClientState.RouteInfo routeInfo) {
            RouteInfo routeInfo2 = new RouteInfo(MediaRouter.sStatic.mSystemCategory);
            routeInfo2.mGlobalRouteId = routeInfo.id;
            routeInfo2.mName = routeInfo.name;
            routeInfo2.mDescription = routeInfo.description;
            routeInfo2.mSupportedTypes = routeInfo.supportedTypes;
            routeInfo2.mEnabled = routeInfo.enabled;
            routeInfo2.setRealStatusCode(routeInfo.statusCode);
            routeInfo2.mPlaybackType = routeInfo.playbackType;
            routeInfo2.mPlaybackStream = routeInfo.playbackStream;
            routeInfo2.mVolume = routeInfo.volume;
            routeInfo2.mVolumeMax = routeInfo.volumeMax;
            routeInfo2.mVolumeHandling = routeInfo.volumeHandling;
            routeInfo2.mPresentationDisplayId = routeInfo.presentationDisplayId;
            routeInfo2.updatePresentationDisplay();
            return routeInfo2;
        }

        @Override
        public void onDisplayAdded(int n) {
            this.updatePresentationDisplays(n);
        }

        @Override
        public void onDisplayChanged(int n) {
            this.updatePresentationDisplays(n);
        }

        @Override
        public void onDisplayRemoved(int n) {
            this.updatePresentationDisplays(n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void publishClientDiscoveryRequest() {
            if (this.mClient == null) return;
            try {
                this.mMediaRouterService.setDiscoveryRequest(this.mClient, this.mDiscoveryRequestRouteTypes, this.mDiscoverRequestActiveScan);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(MediaRouter.TAG, "Unable to publish media router client discovery request.", remoteException);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        void publishClientSelectedRoute(boolean bl) {
            if (this.mClient == null) return;
            try {
                IMediaRouterService iMediaRouterService = this.mMediaRouterService;
                IMediaRouterClient iMediaRouterClient = this.mClient;
                String string2 = this.mSelectedRoute != null ? this.mSelectedRoute.mGlobalRouteId : null;
                iMediaRouterService.setSelectedRoute(iMediaRouterClient, string2, bl);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(MediaRouter.TAG, "Unable to publish media router client selected route.", remoteException);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void rebindAsUser(int n) {
            if (this.mCurrentUserId != n || n < 0 || this.mClient == null) {
                if (this.mClient != null) {
                    try {
                        this.mMediaRouterService.unregisterClient(this.mClient);
                    }
                    catch (RemoteException remoteException) {
                        Log.e(MediaRouter.TAG, "Unable to unregister media router client.", remoteException);
                    }
                    this.mClient = null;
                }
                this.mCurrentUserId = n;
                try {
                    Client client = new Client();
                    this.mMediaRouterService.registerClientAsUser(client, this.mAppContext.getPackageName(), n);
                    this.mClient = client;
                }
                catch (RemoteException remoteException) {
                    Log.e(MediaRouter.TAG, "Unable to register media router client.", remoteException);
                }
                this.publishClientDiscoveryRequest();
                this.publishClientSelectedRoute(false);
                this.updateClientState();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void requestSetVolume(RouteInfo routeInfo, int n) {
            if (routeInfo.mGlobalRouteId == null || this.mClient == null) return;
            try {
                this.mMediaRouterService.requestSetVolume(this.mClient, routeInfo.mGlobalRouteId, n);
                return;
            }
            catch (RemoteException remoteException) {
                Log.w(MediaRouter.TAG, "Unable to request volume change.", remoteException);
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void requestUpdateVolume(RouteInfo routeInfo, int n) {
            if (routeInfo.mGlobalRouteId == null || this.mClient == null) return;
            try {
                this.mMediaRouterService.requestUpdateVolume(this.mClient, routeInfo.mGlobalRouteId, n);
                return;
            }
            catch (RemoteException remoteException) {
                Log.w(MediaRouter.TAG, "Unable to request volume change.", remoteException);
                return;
            }
        }

        void setSelectedRoute(RouteInfo routeInfo, boolean bl) {
            this.mSelectedRoute = routeInfo;
            this.publishClientSelectedRoute(bl);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void startMonitoringRoutes(Context context) {
            AudioRoutesInfo audioRoutesInfo;
            this.mDefaultAudioVideo = new RouteInfo(this.mSystemCategory);
            this.mDefaultAudioVideo.mNameResId = 17040828;
            this.mDefaultAudioVideo.mSupportedTypes = 3;
            this.mDefaultAudioVideo.updatePresentationDisplay();
            MediaRouter.addRouteStatic(this.mDefaultAudioVideo);
            MediaRouter.updateWifiDisplayStatus(this.mDisplayService.getWifiDisplayStatus());
            context.registerReceiver(new WifiDisplayStatusChangedReceiver(), new IntentFilter("android.hardware.display.action.WIFI_DISPLAY_STATUS_CHANGED"));
            context.registerReceiver(new VolumeChangeReceiver(), new IntentFilter("android.media.VOLUME_CHANGED_ACTION"));
            this.mDisplayService.registerDisplayListener(this, this.mHandler);
            try {
                AudioRoutesInfo audioRoutesInfo2;
                audioRoutesInfo = audioRoutesInfo2 = this.mAudioService.startWatchingRoutes(this.mAudioRoutesObserver);
            }
            catch (RemoteException remoteException) {
                audioRoutesInfo = null;
            }
            if (audioRoutesInfo != null) {
                this.updateAudioRoutes(audioRoutesInfo);
            }
            this.rebindAsUser(UserHandle.myUserId());
            if (this.mSelectedRoute == null) {
                MediaRouter.selectDefaultRouteStatic();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void updateAudioRoutes(AudioRoutesInfo audioRoutesInfo) {
            if (audioRoutesInfo.mMainType != this.mCurAudioRoutesInfo.mMainType) {
                this.mCurAudioRoutesInfo.mMainType = audioRoutesInfo.mMainType;
                int n = (2 & audioRoutesInfo.mMainType) != 0 || (1 & audioRoutesInfo.mMainType) != 0 ? 17040829 : ((4 & audioRoutesInfo.mMainType) != 0 ? 17040830 : ((8 & audioRoutesInfo.mMainType) != 0 ? 17040831 : 17040828));
                MediaRouter.sStatic.mDefaultAudioVideo.mNameResId = n;
                MediaRouter.dispatchRouteChanged(MediaRouter.sStatic.mDefaultAudioVideo);
            }
            int n = this.mCurAudioRoutesInfo.mMainType;
            if (!TextUtils.equals(audioRoutesInfo.mBluetoothName, this.mCurAudioRoutesInfo.mBluetoothName)) {
                this.mCurAudioRoutesInfo.mBluetoothName = audioRoutesInfo.mBluetoothName;
                if (this.mCurAudioRoutesInfo.mBluetoothName != null) {
                    if (MediaRouter.sStatic.mBluetoothA2dpRoute == null) {
                        RouteInfo routeInfo = new RouteInfo(MediaRouter.sStatic.mSystemCategory);
                        routeInfo.mName = this.mCurAudioRoutesInfo.mBluetoothName;
                        routeInfo.mDescription = MediaRouter.sStatic.mResources.getText(17040833);
                        routeInfo.mSupportedTypes = 1;
                        MediaRouter.sStatic.mBluetoothA2dpRoute = routeInfo;
                        MediaRouter.addRouteStatic(MediaRouter.sStatic.mBluetoothA2dpRoute);
                    } else {
                        MediaRouter.sStatic.mBluetoothA2dpRoute.mName = this.mCurAudioRoutesInfo.mBluetoothName;
                        MediaRouter.dispatchRouteChanged(MediaRouter.sStatic.mBluetoothA2dpRoute);
                    }
                } else if (MediaRouter.sStatic.mBluetoothA2dpRoute != null) {
                    MediaRouter.removeRouteStatic(MediaRouter.sStatic.mBluetoothA2dpRoute);
                    MediaRouter.sStatic.mBluetoothA2dpRoute = null;
                }
            }
            if (this.mBluetoothA2dpRoute == null) return;
            boolean bl = this.isBluetoothA2dpOn();
            if (n != 0 && this.mSelectedRoute == this.mBluetoothA2dpRoute && !bl) {
                MediaRouter.selectRouteStatic(1, this.mDefaultAudioVideo, false);
                return;
            } else {
                if (this.mSelectedRoute != this.mDefaultAudioVideo && this.mSelectedRoute != null || !bl) return;
                MediaRouter.selectRouteStatic(1, this.mBluetoothA2dpRoute, false);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void updateClientState() {
            int n;
            ArrayList<MediaRouterClientState.RouteInfo> arrayList;
            block16: {
                block15: {
                    this.mClientState = null;
                    if (this.mClient != null) {
                        try {
                            this.mClientState = this.mMediaRouterService.getState(this.mClient);
                        }
                        catch (RemoteException remoteException) {
                            Log.e(MediaRouter.TAG, "Unable to retrieve media router client state.", remoteException);
                        }
                    }
                    arrayList = this.mClientState != null ? this.mClientState.routes : null;
                    String string2 = this.mClientState != null ? this.mClientState.globallySelectedRouteId : null;
                    n = arrayList != null ? arrayList.size() : 0;
                    for (int i = 0; i < n; ++i) {
                        MediaRouterClientState.RouteInfo routeInfo = arrayList.get(i);
                        RouteInfo routeInfo2 = this.findGlobalRoute(routeInfo.id);
                        if (routeInfo2 == null) {
                            MediaRouter.addRouteStatic(this.makeGlobalRoute(routeInfo));
                            continue;
                        }
                        this.updateGlobalRoute(routeInfo2, routeInfo);
                    }
                    if (string2 == null) break block15;
                    RouteInfo routeInfo = this.findGlobalRoute(string2);
                    if (routeInfo == null) {
                        Log.w(MediaRouter.TAG, "Could not find new globally selected route: " + string2);
                        break block16;
                    } else if (routeInfo != this.mSelectedRoute) {
                        if (DEBUG) {
                            Log.d(MediaRouter.TAG, "Selecting new globally selected route: " + routeInfo);
                        }
                        MediaRouter.selectRouteStatic(routeInfo.mSupportedTypes, routeInfo, false);
                    }
                    break block16;
                }
                if (this.mSelectedRoute != null && this.mSelectedRoute.mGlobalRouteId != null) {
                    if (DEBUG) {
                        Log.d(MediaRouter.TAG, "Unselecting previous globally selected route: " + this.mSelectedRoute);
                    }
                    MediaRouter.selectDefaultRouteStatic();
                }
            }
            int n2 = this.mRoutes.size();
            block3: while (true) {
                int n3 = n2 - 1;
                if (n2 <= 0) {
                    return;
                }
                RouteInfo routeInfo = this.mRoutes.get(n3);
                String string3 = routeInfo.mGlobalRouteId;
                if (string3 != null) {
                    for (int i = 0; i < n; ++i) {
                        if (!string3.equals(arrayList.get((int)i).id)) continue;
                        n2 = n3;
                        continue block3;
                    }
                    MediaRouter.removeRouteStatic(routeInfo);
                }
                n2 = n3;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void updateDiscoveryRequest() {
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            boolean bl2 = false;
            int n3 = this.mCallbacks.size();
            for (int i = 0; i < n3; ++i) {
                CallbackInfo callbackInfo = this.mCallbacks.get(i);
                if ((5 & callbackInfo.flags) != 0) {
                    n |= callbackInfo.type;
                } else if ((8 & callbackInfo.flags) != 0) {
                    n2 |= callbackInfo.type;
                } else {
                    n |= callbackInfo.type;
                }
                if ((1 & callbackInfo.flags) == 0) continue;
                bl = true;
                if ((4 & callbackInfo.type) == 0) continue;
                bl2 = true;
            }
            if (n != 0 || bl) {
                n |= n2;
            }
            if (this.mCanConfigureWifiDisplays) {
                if (this.mSelectedRoute != null && this.mSelectedRoute.matchesTypes(4)) {
                    bl2 = false;
                }
                if (bl2) {
                    if (!this.mActivelyScanningWifiDisplays) {
                        this.mActivelyScanningWifiDisplays = true;
                        this.mDisplayService.startWifiDisplayScan();
                    }
                } else if (this.mActivelyScanningWifiDisplays) {
                    this.mActivelyScanningWifiDisplays = false;
                    this.mDisplayService.stopWifiDisplayScan();
                }
            }
            if (n != this.mDiscoveryRequestRouteTypes || bl != this.mDiscoverRequestActiveScan) {
                this.mDiscoveryRequestRouteTypes = n;
                this.mDiscoverRequestActiveScan = bl;
                this.publishClientDiscoveryRequest();
            }
        }

        void updateGlobalRoute(RouteInfo routeInfo, MediaRouterClientState.RouteInfo routeInfo2) {
            int n;
            boolean bl = Objects.equals(routeInfo.mName, routeInfo2.name);
            boolean bl2 = false;
            if (!bl) {
                routeInfo.mName = routeInfo2.name;
                bl2 = true;
            }
            if (!Objects.equals(routeInfo.mDescription, routeInfo2.description)) {
                routeInfo.mDescription = routeInfo2.description;
                bl2 = true;
            }
            if ((n = routeInfo.mSupportedTypes) != routeInfo2.supportedTypes) {
                routeInfo.mSupportedTypes = routeInfo2.supportedTypes;
                bl2 = true;
            }
            if (routeInfo.mEnabled != routeInfo2.enabled) {
                routeInfo.mEnabled = routeInfo2.enabled;
                bl2 = true;
            }
            if (routeInfo.mRealStatusCode != routeInfo2.statusCode) {
                routeInfo.setRealStatusCode(routeInfo2.statusCode);
                bl2 = true;
            }
            if (routeInfo.mPlaybackType != routeInfo2.playbackType) {
                routeInfo.mPlaybackType = routeInfo2.playbackType;
                bl2 = true;
            }
            if (routeInfo.mPlaybackStream != routeInfo2.playbackStream) {
                routeInfo.mPlaybackStream = routeInfo2.playbackStream;
                bl2 = true;
            }
            int n2 = routeInfo.mVolume;
            int n3 = routeInfo2.volume;
            boolean bl3 = false;
            if (n2 != n3) {
                routeInfo.mVolume = routeInfo2.volume;
                bl2 = true;
                bl3 = true;
            }
            if (routeInfo.mVolumeMax != routeInfo2.volumeMax) {
                routeInfo.mVolumeMax = routeInfo2.volumeMax;
                bl2 = true;
                bl3 = true;
            }
            if (routeInfo.mVolumeHandling != routeInfo2.volumeHandling) {
                routeInfo.mVolumeHandling = routeInfo2.volumeHandling;
                bl2 = true;
                bl3 = true;
            }
            int n4 = routeInfo.mPresentationDisplayId;
            int n5 = routeInfo2.presentationDisplayId;
            boolean bl4 = false;
            if (n4 != n5) {
                routeInfo.mPresentationDisplayId = routeInfo2.presentationDisplayId;
                routeInfo.updatePresentationDisplay();
                bl2 = true;
                bl4 = true;
            }
            if (bl2) {
                MediaRouter.dispatchRouteChanged(routeInfo, n);
            }
            if (bl3) {
                MediaRouter.dispatchRouteVolumeChanged(routeInfo);
            }
            if (bl4) {
                MediaRouter.dispatchRoutePresentationDisplayChanged(routeInfo);
            }
        }

        final class Client
        extends IMediaRouterClient.Stub {
            Client() {
            }

            @Override
            public void onStateChanged() {
                Static.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (Client.this == Static.this.mClient) {
                            Static.this.updateClientState();
                        }
                    }
                });
            }
        }
    }

    public static class UserRouteInfo
    extends RouteInfo {
        RemoteControlClient mRcc;
        SessionVolumeProvider mSvp;

        UserRouteInfo(RouteCategory routeCategory) {
            super(routeCategory);
            this.mSupportedTypes = 0x800000;
            this.mPlaybackType = 1;
            this.mVolumeHandling = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void configureSessionVolume() {
            if (this.mRcc == null) {
                if (!DEBUG) return;
                Log.d(MediaRouter.TAG, "No Rcc to configure volume for route " + this.mName);
                return;
            }
            MediaSession mediaSession = this.mRcc.getMediaSession();
            if (mediaSession == null) {
                if (!DEBUG) return;
                Log.d(MediaRouter.TAG, "Rcc has no session to configure volume");
                return;
            } else {
                if (this.mPlaybackType != 1) {
                    AudioAttributes.Builder builder = new AudioAttributes.Builder();
                    builder.setLegacyStreamType(this.mPlaybackStream);
                    mediaSession.setPlaybackToLocal(builder.build());
                    this.mSvp = null;
                    return;
                }
                int n = this.mVolumeHandling;
                int n2 = 0;
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        n2 = 2;
                    }
                }
                if (this.mSvp != null && this.mSvp.getVolumeControl() == n2 && this.mSvp.getMaxVolume() == this.mVolumeMax) return;
                this.mSvp = new SessionVolumeProvider(n2, this.mVolumeMax, this.mVolume);
                mediaSession.setPlaybackToRemote(this.mSvp);
                return;
            }
        }

        private void updatePlaybackInfoOnRcc() {
            this.configureSessionVolume();
        }

        public RemoteControlClient getRemoteControlClient() {
            return this.mRcc;
        }

        @Override
        public void requestSetVolume(int n) {
            block3: {
                block2: {
                    if (this.mVolumeHandling != 1) break block2;
                    if (this.mVcb != null) break block3;
                    Log.e(MediaRouter.TAG, "Cannot requestSetVolume on user route - no volume callback set");
                }
                return;
            }
            this.mVcb.vcb.onVolumeSetRequest(this, n);
        }

        @Override
        public void requestUpdateVolume(int n) {
            block3: {
                block2: {
                    if (this.mVolumeHandling != 1) break block2;
                    if (this.mVcb != null) break block3;
                    Log.e(MediaRouter.TAG, "Cannot requestChangeVolume on user route - no volumec callback set");
                }
                return;
            }
            this.mVcb.vcb.onVolumeUpdateRequest(this, n);
        }

        public void setDescription(CharSequence charSequence) {
            this.mDescription = charSequence;
            this.routeUpdated();
        }

        public void setIconDrawable(Drawable drawable2) {
            this.mIcon = drawable2;
        }

        public void setIconResource(int n) {
            this.setIconDrawable(MediaRouter.sStatic.mResources.getDrawable(n));
        }

        public void setName(int n) {
            this.mNameResId = n;
            this.mName = null;
            this.routeUpdated();
        }

        public void setName(CharSequence charSequence) {
            this.mName = charSequence;
            this.routeUpdated();
        }

        public void setPlaybackStream(int n) {
            if (this.mPlaybackStream != n) {
                this.mPlaybackStream = n;
                this.configureSessionVolume();
            }
        }

        public void setPlaybackType(int n) {
            if (this.mPlaybackType != n) {
                this.mPlaybackType = n;
                this.configureSessionVolume();
            }
        }

        public void setRemoteControlClient(RemoteControlClient remoteControlClient) {
            this.mRcc = remoteControlClient;
            this.updatePlaybackInfoOnRcc();
        }

        public void setStatus(CharSequence charSequence) {
            this.setStatusInt(charSequence);
        }

        public void setVolume(int n) {
            int n2 = Math.max(0, Math.min(n, this.getVolumeMax()));
            if (this.mVolume != n2) {
                this.mVolume = n2;
                if (this.mSvp != null) {
                    this.mSvp.setCurrentVolume(this.mVolume);
                }
                MediaRouter.dispatchRouteVolumeChanged(this);
                if (this.mGroup != null) {
                    this.mGroup.memberVolumeChanged(this);
                }
            }
        }

        public void setVolumeCallback(VolumeCallback volumeCallback) {
            this.mVcb = new VolumeCallbackInfo(volumeCallback, this);
        }

        public void setVolumeHandling(int n) {
            if (this.mVolumeHandling != n) {
                this.mVolumeHandling = n;
                this.configureSessionVolume();
            }
        }

        public void setVolumeMax(int n) {
            if (this.mVolumeMax != n) {
                this.mVolumeMax = n;
                this.configureSessionVolume();
            }
        }

        class SessionVolumeProvider
        extends VolumeProvider {
            public SessionVolumeProvider(int n, int n2, int n3) {
                super(n, n2, n3);
            }

            @Override
            public void onAdjustVolume(final int n) {
                MediaRouter.sStatic.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (UserRouteInfo.this.mVcb != null) {
                            UserRouteInfo.this.mVcb.vcb.onVolumeUpdateRequest(UserRouteInfo.this.mVcb.route, n);
                        }
                    }
                });
            }

            @Override
            public void onSetVolumeTo(final int n) {
                MediaRouter.sStatic.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (UserRouteInfo.this.mVcb != null) {
                            UserRouteInfo.this.mVcb.vcb.onVolumeSetRequest(UserRouteInfo.this.mVcb.route, n);
                        }
                    }
                });
            }
        }
    }

    public static abstract class VolumeCallback {
        public abstract void onVolumeSetRequest(RouteInfo var1, int var2);

        public abstract void onVolumeUpdateRequest(RouteInfo var1, int var2);
    }

    static class VolumeCallbackInfo {
        public final RouteInfo route;
        public final VolumeCallback vcb;

        public VolumeCallbackInfo(VolumeCallback volumeCallback, RouteInfo routeInfo) {
            this.vcb = volumeCallback;
            this.route = routeInfo;
        }
    }

    static class VolumeChangeReceiver
    extends BroadcastReceiver {
        VolumeChangeReceiver() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int n;
            if (!intent.getAction().equals("android.media.VOLUME_CHANGED_ACTION") || intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", -1) != 3 || (n = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", 0)) == intent.getIntExtra("android.media.EXTRA_PREV_VOLUME_STREAM_VALUE", 0)) {
                return;
            }
            MediaRouter.systemVolumeChanged(n);
        }
    }

    static class WifiDisplayStatusChangedReceiver
    extends BroadcastReceiver {
        WifiDisplayStatusChangedReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.hardware.display.action.WIFI_DISPLAY_STATUS_CHANGED")) {
                MediaRouter.updateWifiDisplayStatus((WifiDisplayStatus)intent.getParcelableExtra("android.hardware.display.extra.WIFI_DISPLAY_STATUS"));
            }
        }
    }
}

