/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.database.Cursor;
import android.database.SQLException;
import android.drm.DrmManagerClient;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.media.MediaFile;
import android.media.MediaInserter;
import android.media.MediaScannerClient;
import android.mtp.MtpConstants;
import android.net.Uri;
import android.os.Environment;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.provider.MediaStore;
import android.provider.Settings;
import android.sax.ElementListener;
import android.sax.RootElement;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MediaScanner {
    private static final String ALARMS_DIR = "/alarms/";
    private static final int DATE_MODIFIED_PLAYLISTS_COLUMN_INDEX = 2;
    private static final String DEFAULT_RINGTONE_PROPERTY_PREFIX = "ro.config.";
    private static final boolean ENABLE_BULK_INSERTS = true;
    private static final int FILES_PRESCAN_DATE_MODIFIED_COLUMN_INDEX = 3;
    private static final int FILES_PRESCAN_FORMAT_COLUMN_INDEX = 2;
    private static final int FILES_PRESCAN_ID_COLUMN_INDEX = 0;
    private static final int FILES_PRESCAN_PATH_COLUMN_INDEX = 1;
    private static final String[] FILES_PRESCAN_PROJECTION;
    private static final String[] ID3_GENRES;
    private static final int ID_PLAYLISTS_COLUMN_INDEX = 0;
    private static final String[] ID_PROJECTION;
    private static final String MUSIC_DIR = "/music/";
    private static final String NOTIFICATIONS_DIR = "/notifications/";
    private static final int PATH_PLAYLISTS_COLUMN_INDEX = 1;
    private static final String[] PLAYLIST_MEMBERS_PROJECTION;
    private static final String PODCAST_DIR = "/podcasts/";
    private static final String RINGTONES_DIR = "/ringtones/";
    private static final String TAG = "MediaScanner";
    private static HashMap<String, String> mMediaPaths;
    private static HashMap<String, String> mNoMediaPaths;
    private Uri mAudioUri;
    private final BitmapFactory.Options mBitmapOptions = new BitmapFactory.Options();
    private boolean mCaseInsensitivePaths;
    private final MyMediaScannerClient mClient;
    private Context mContext;
    private String mDefaultAlarmAlertFilename;
    private boolean mDefaultAlarmSet;
    private String mDefaultCalendarAlertFilename;
    private boolean mDefaultCalendarAlertSet;
    private String mDefaultNewMailFilename;
    private boolean mDefaultNewMailSet;
    private String mDefaultNotification2Filename;
    private String mDefaultNotificationFilename;
    private boolean mDefaultNotificationSet;
    private String mDefaultRingtone2Filename;
    private String mDefaultRingtoneFilename;
    private boolean mDefaultRingtoneSet;
    private String mDefaultSentMailFilename;
    private boolean mDefaultSentMailSet;
    private DrmManagerClient mDrmManagerClient = null;
    private final boolean mExternalIsEmulated;
    private final String mExternalStoragePath;
    private Uri mFilesUri;
    private Uri mFilesUriNoNotify;
    private Uri mImagesUri;
    private boolean mInternalAndDefaultSoundNotSet;
    private MediaInserter mMediaInserter;
    private IContentProvider mMediaProvider;
    private int mMtpObjectHandle;
    private long mNativeContext;
    private int mOriginalCount;
    private String mPackageName;
    private ArrayList<FileEntry> mPlayLists;
    private ArrayList<PlaylistEntry> mPlaylistEntries = new ArrayList();
    private Uri mPlaylistsUri;
    private boolean mProcessGenres;
    private boolean mProcessPlaylists;
    private Uri mThumbsUri;
    private Uri mVideoUri;
    private boolean mWasEmptyPriorToScan = false;

    static {
        System.loadLibrary("media_jni");
        MediaScanner.native_init();
        FILES_PRESCAN_PROJECTION = new String[]{"_id", "_data", "format", "date_modified"};
        ID_PROJECTION = new String[]{"_id"};
        PLAYLIST_MEMBERS_PROJECTION = new String[]{"playlist_id"};
        ID3_GENRES = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "Britpop", null, "Polsk Punk", "Beat", "Christian Gangsta", "Heavy Metal", "Black Metal", "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop", "Synthpop"};
        mNoMediaPaths = new HashMap();
        mMediaPaths = new HashMap();
    }

    public MediaScanner(Context context) {
        this.mClient = new MyMediaScannerClient();
        this.native_setup();
        this.mContext = context;
        this.mPackageName = context.getPackageName();
        this.mBitmapOptions.inSampleSize = 1;
        this.mBitmapOptions.inJustDecodeBounds = true;
        this.setDefaultRingtoneFileNames();
        this.mExternalStoragePath = Environment.getExternalStorageDirectory().getAbsolutePath();
        this.mExternalIsEmulated = Environment.isExternalStorageEmulated();
    }

    static /* synthetic */ Uri access$1200(MediaScanner mediaScanner) {
        return mediaScanner.mFilesUri;
    }

    static /* synthetic */ MediaInserter access$1300(MediaScanner mediaScanner) {
        return mediaScanner.mMediaInserter;
    }

    static /* synthetic */ Uri access$1400(MediaScanner mediaScanner) {
        return mediaScanner.mVideoUri;
    }

    static /* synthetic */ Uri access$1500(MediaScanner mediaScanner) {
        return mediaScanner.mImagesUri;
    }

    static /* synthetic */ Uri access$1600(MediaScanner mediaScanner) {
        return mediaScanner.mAudioUri;
    }

    static /* synthetic */ boolean access$1700(MediaScanner mediaScanner) {
        return mediaScanner.mWasEmptyPriorToScan;
    }

    static /* synthetic */ boolean access$1800(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultNotificationSet;
    }

    static /* synthetic */ boolean access$1802(MediaScanner mediaScanner, boolean bl) {
        mediaScanner.mDefaultNotificationSet = bl;
        return bl;
    }

    static /* synthetic */ String access$1900(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultNotificationFilename;
    }

    static /* synthetic */ String access$2000(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultNotification2Filename;
    }

    static /* synthetic */ boolean access$2100(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultRingtoneSet;
    }

    static /* synthetic */ boolean access$2102(MediaScanner mediaScanner, boolean bl) {
        mediaScanner.mDefaultRingtoneSet = bl;
        return bl;
    }

    static /* synthetic */ String access$2200(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultRingtoneFilename;
    }

    static /* synthetic */ String access$2300(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultRingtone2Filename;
    }

    static /* synthetic */ boolean access$2400(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultAlarmSet;
    }

    static /* synthetic */ boolean access$2402(MediaScanner mediaScanner, boolean bl) {
        mediaScanner.mDefaultAlarmSet = bl;
        return bl;
    }

    static /* synthetic */ String access$2500(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultAlarmAlertFilename;
    }

    static /* synthetic */ boolean access$2600(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultNewMailSet;
    }

    static /* synthetic */ boolean access$2602(MediaScanner mediaScanner, boolean bl) {
        mediaScanner.mDefaultNewMailSet = bl;
        return bl;
    }

    static /* synthetic */ String access$2700(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultNewMailFilename;
    }

    static /* synthetic */ boolean access$2800(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultSentMailSet;
    }

    static /* synthetic */ boolean access$2802(MediaScanner mediaScanner, boolean bl) {
        mediaScanner.mDefaultSentMailSet = bl;
        return bl;
    }

    static /* synthetic */ String access$2900(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultSentMailFilename;
    }

    static /* synthetic */ boolean access$3000(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultCalendarAlertSet;
    }

    static /* synthetic */ boolean access$3002(MediaScanner mediaScanner, boolean bl) {
        mediaScanner.mDefaultCalendarAlertSet = bl;
        return bl;
    }

    static /* synthetic */ String access$3100(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultCalendarAlertFilename;
    }

    static /* synthetic */ String access$3200(MediaScanner mediaScanner) {
        return mediaScanner.mPackageName;
    }

    static /* synthetic */ IContentProvider access$3300(MediaScanner mediaScanner) {
        return mediaScanner.mMediaProvider;
    }

    static /* synthetic */ DrmManagerClient access$3502(MediaScanner mediaScanner, DrmManagerClient drmManagerClient) {
        mediaScanner.mDrmManagerClient = drmManagerClient;
        return drmManagerClient;
    }

    private void cachePlaylistEntry(String string2, String string3) {
        boolean bl;
        PlaylistEntry playlistEntry;
        block8: {
            block7: {
                char c;
                int n;
                playlistEntry = new PlaylistEntry();
                for (n = string2.length(); n > 0 && Character.isWhitespace(string2.charAt(n - 1)); --n) {
                }
                if (n < 3) {
                    return;
                }
                if (n < string2.length()) {
                    string2 = string2.substring(0, n);
                }
                if ((c = string2.charAt(0)) == '/') break block7;
                boolean bl2 = Character.isLetter(c);
                bl = false;
                if (!bl2) break block8;
                char c2 = string2.charAt(1);
                bl = false;
                if (c2 != ':') break block8;
                char c3 = string2.charAt(2);
                bl = false;
                if (c3 != '\\') break block8;
            }
            bl = true;
        }
        if (!bl) {
            string2 = string3 + string2;
        }
        playlistEntry.path = string2;
        this.mPlaylistEntries.add(playlistEntry);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void clearMediaPathCache(boolean bl, boolean bl2) {
        synchronized (MediaScanner.class) {
            if (bl) {
                mMediaPaths.clear();
            }
            if (bl2) {
                mNoMediaPaths.clear();
            }
            return;
        }
    }

    private boolean inScanDirectory(String string2, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.startsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initialize(String string2) {
        this.mMediaProvider = this.mContext.getContentResolver().acquireProvider("media");
        this.mAudioUri = MediaStore.Audio.Media.getContentUri(string2);
        this.mVideoUri = MediaStore.Video.Media.getContentUri(string2);
        this.mImagesUri = MediaStore.Images.Media.getContentUri(string2);
        this.mThumbsUri = MediaStore.Images.Thumbnails.getContentUri(string2);
        this.mFilesUri = MediaStore.Files.getContentUri(string2);
        this.mFilesUriNoNotify = this.mFilesUri.buildUpon().appendQueryParameter("nonotify", "1").build();
        if (!string2.equals("internal")) {
            this.mProcessPlaylists = true;
            this.mProcessGenres = true;
            this.mPlaylistsUri = MediaStore.Audio.Playlists.getContentUri(string2);
            this.mCaseInsensitivePaths = true;
            return;
        } else {
            this.mInternalAndDefaultSoundNotSet = false;
            if (TextUtils.isEmpty(Settings.System.getString(this.mContext.getContentResolver(), "notification_sound"))) {
                this.mInternalAndDefaultSoundNotSet = true;
            }
            if (TextUtils.isEmpty(Settings.System.getString(this.mContext.getContentResolver(), "ringtone"))) {
                this.mInternalAndDefaultSoundNotSet = true;
            }
            if (!TextUtils.isEmpty(Settings.System.getString(this.mContext.getContentResolver(), "alarm_alert"))) return;
            this.mInternalAndDefaultSoundNotSet = true;
            return;
        }
    }

    private boolean isDrmEnabled() {
        String string2 = SystemProperties.get("drm.service.enabled");
        return string2 != null && string2.equals("true");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isNoMediaFile(String string2) {
        boolean bl = true;
        if (new File(string2).isDirectory()) {
            return false;
        }
        int n = string2.lastIndexOf(47);
        if (n < 0) return false;
        if (n + 2 >= string2.length()) return false;
        if (string2.regionMatches(n + 1, "._", 0, 2)) return bl;
        if (!string2.regionMatches(bl, -4 + string2.length(), ".jpg", 0, 4)) return false;
        if (string2.regionMatches(bl, n + 1, "AlbumArt_{", 0, 10)) return bl;
        if (string2.regionMatches(bl, n + 1, "AlbumArt.", 0, 9)) return bl;
        int n2 = -1 + (string2.length() - n);
        if (n2 == 17) {
            if (string2.regionMatches(bl, n + 1, "AlbumArtSmall", 0, 13)) return bl;
        }
        if (n2 != 10) return false;
        if (string2.regionMatches(bl, n + 1, "Folder", 0, 6)) return bl;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isNoMediaPath(String string2) {
        int n;
        block15: {
            block14: {
                if (string2 == null) break block14;
                if (string2.indexOf("/.") >= 0) {
                    return true;
                }
                n = string2.lastIndexOf(47);
                if (n > 0) break block15;
            }
            return false;
        }
        String string3 = string2.substring(0, n);
        synchronized (MediaScanner.class) {
            if (mNoMediaPaths.containsKey(string3)) {
                return true;
            }
            if (!mMediaPaths.containsKey(string3)) {
                int n2 = 1;
                while (true) {
                    if (n2 < 0) {
                        mMediaPaths.put(string3, "");
                        break;
                    }
                    int n3 = string2.indexOf(47, n2);
                    if (n3 > n2 && new File(string2.substring(0, ++n3) + ".nomedia").exists()) {
                        mNoMediaPaths.put(string3, "");
                        return true;
                    }
                    n2 = n3;
                }
            }
            return MediaScanner.isNoMediaFile(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean matchEntries(long l, String string2) {
        int n = this.mPlaylistEntries.size();
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            PlaylistEntry playlistEntry = this.mPlaylistEntries.get(n2);
            if (playlistEntry.bestmatchlevel != Integer.MAX_VALUE) {
                if (string2.equalsIgnoreCase(playlistEntry.path)) {
                    playlistEntry.bestmatchid = l;
                    playlistEntry.bestmatchlevel = Integer.MAX_VALUE;
                    bl = false;
                } else {
                    int n3 = this.matchPaths(string2, playlistEntry.path);
                    int n4 = playlistEntry.bestmatchlevel;
                    bl = false;
                    if (n3 > n4) {
                        playlistEntry.bestmatchid = l;
                        playlistEntry.bestmatchlevel = n3;
                        bl = false;
                    }
                }
            }
            ++n2;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int matchPaths(String string2, String string3) {
        int n = 0;
        int n2 = string2.length();
        int n3 = string3.length();
        while (n2 > 0 && n3 > 0) {
            int n4;
            int n5;
            int n6;
            int n7 = string2.lastIndexOf(47, n2 - 1);
            int n8 = string3.lastIndexOf(47, n3 - 1);
            int n9 = string2.lastIndexOf(92, n2 - 1);
            int n10 = string3.lastIndexOf(92, n3 - 1);
            int n11 = n8 > n10 ? n8 : n10;
            int n12 = n11 < 0 ? 0 : n11 + 1;
            if (n3 - n12 != (n6 = n2 - (n5 = (n4 = n7 > n9 ? n7 : n9) < 0 ? 0 : n4 + 1)) || !string2.regionMatches(true, n5, string3, n12, n6)) break;
            ++n;
            n2 = n5 - 1;
            n3 = n12 - 1;
        }
        return n;
    }

    private final native void native_finalize();

    private static final native void native_init();

    private final native void native_setup();

    private void postscan(String[] stringArray) throws RemoteException {
        if (this.mProcessPlaylists) {
            this.processPlayLists();
        }
        if (this.mOriginalCount == 0 && this.mImagesUri.equals(MediaStore.Images.Media.getContentUri("external"))) {
            this.pruneDeadThumbnailFiles();
        }
        this.mPlayLists = null;
        this.mMediaProvider = null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void prescan(String var1_1, boolean var2_2) throws RemoteException {
        if (this.mPlayLists == null) {
            this.mPlayLists = new ArrayList<E>();
        } else {
            this.mPlayLists.clear();
        }
        if (var1_1 != null) {
            var3_3 = "_id>? AND _data=?";
            var4_4 = new String[]{"", var1_1};
        } else {
            var3_3 = "_id>?";
            var4_4 = new String[]{""};
        }
        var5_5 = this.mFilesUri.buildUpon();
        var5_5.appendQueryParameter("deletedata", "false");
        var7_6 = new MediaBulkDeleter(this.mMediaProvider, this.mPackageName, var5_5.build());
        var8_7 = null;
        if (!var2_2) ** GOTO lbl28
        var10_8 = -9223372036854775808L;
        try {
            var13_9 = this.mFilesUri.buildUpon().appendQueryParameter("limit", "1000").build();
            this.mWasEmptyPriorToScan = true;
            block7: while (true) {
                block19: {
                    var4_4[0] = "" + var10_8;
                    if (var8_7 != null) {
                        var8_7.close();
                        var8_7 = null;
                    }
                    if ((var8_7 = this.mMediaProvider.query(this.mPackageName, var13_9, MediaScanner.FILES_PRESCAN_PROJECTION, var3_3, var4_4, "_id", null)) != null && var8_7.getCount() != 0) break block19;
                    this.mWasEmptyPriorToScan |= this.mInternalAndDefaultSoundNotSet;
lbl28:
                    // 2 sources

                    this.mOriginalCount = 0;
                    var9_20 = this.mMediaProvider.query(this.mPackageName, this.mImagesUri, MediaScanner.ID_PROJECTION, null, null, null, null);
                    if (var9_20 != null) {
                        this.mOriginalCount = var9_20.getCount();
                        var9_20.close();
                    }
                    return;
                }
                this.mWasEmptyPriorToScan = false;
                while (true) {
                    if (!var8_7.moveToNext()) continue block7;
                    var14_10 = var8_7.getLong(0);
                    var16_11 = var8_7.getString(1);
                    var17_12 = var8_7.getInt(2);
                    var8_7.getLong(3);
                    var10_8 = var14_10;
                    if (var16_11 == null || !(var20_13 = var16_11.startsWith("/"))) continue;
                    try {
                        var22_15 = var27_19 = Os.access(var16_11, OsConstants.F_OK);
                    }
                    catch (ErrnoException var21_14) {
                        var22_15 = false;
                    }
                    if (var22_15 || MtpConstants.isAbstractObject(var17_12) || MediaFile.isPlayListFileType(var24_17 = (var23_16 = MediaFile.getFileType(var16_11)) == null ? 0 : var23_16.fileType)) continue;
                    var7_6.delete(var14_10);
                    if (!var16_11.toLowerCase(Locale.US).endsWith("/.nomedia")) continue;
                    var7_6.flush();
                    var25_18 = new File(var16_11).getParent();
                    this.mMediaProvider.call(this.mPackageName, "unhide", var25_18, null);
                }
                break;
            }
        }
        finally {
            if (var8_7 != null) {
                var8_7.close();
            }
            var7_6.flush();
        }
    }

    private void processCachedPlaylist(Cursor cursor, ContentValues contentValues, Uri uri) {
        cursor.moveToPosition(-1);
        while (cursor.moveToNext() && !this.matchEntries(cursor.getLong(0), cursor.getString(1))) {
        }
        int n = this.mPlaylistEntries.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            PlaylistEntry playlistEntry = this.mPlaylistEntries.get(i);
            if (playlistEntry.bestmatchlevel <= 0) continue;
            try {
                contentValues.clear();
                contentValues.put("play_order", n2);
                contentValues.put("audio_id", playlistEntry.bestmatchid);
                this.mMediaProvider.insert(this.mPackageName, uri, contentValues);
                ++n2;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "RemoteException in MediaScanner.processCachedPlaylist()", remoteException);
                return;
            }
        }
        this.mPlaylistEntries.clear();
    }

    private native void processDirectory(String var1, MediaScannerClient var2);

    private native void processFile(String var1, String var2, MediaScannerClient var3);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processM3uPlayList(String var1_1, String var2_2, Uri var3_3, ContentValues var4_4, Cursor var5_5) {
        var6_6 = null;
        var7_7 = new File(var1_1);
        var15_8 = var7_7.exists();
        var6_6 = null;
        if (!var15_8) ** GOTO lbl44
        var16_9 = new BufferedReader(new InputStreamReader(new FileInputStream(var7_7)), 8192);
        ** GOTO lbl20
        {
            catch (Throwable var8_16) lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (var6_6 == null) throw var8_17;
                    try {
                        var6_6.close();
                        throw var8_17;
                    }
                    catch (IOException var9_19) {
                        Log.e("MediaScanner", "IOException in MediaScanner.processM3uPlayList()", var9_19);
                        throw var8_17;
                    }
                    break;
                }
lbl20:
                // 2 sources

                var17_10 = var16_9.readLine();
                this.mPlaylistEntries.clear();
                while (var17_10 != null) {
                    if (var17_10.length() > 0 && var17_10.charAt(0) != '#') {
                        this.cachePlaylistEntry(var17_10, var2_2);
                    }
                    var17_10 = var16_9.readLine();
                }
                this.processCachedPlaylist(var5_5, var4_4, var3_3);
                var6_6 = var16_9;
lbl30:
                // 1 sources

                while (true) {
                    try {
                        var6_6.close();
                        return;
                    }
                    catch (IOException var13_15) {
                        Log.e("MediaScanner", "IOException in MediaScanner.processM3uPlayList()", var13_15);
                        return;
                    }
                    break;
                }
            }
            catch (Throwable var8_18) {
                var6_6 = var16_9;
                ** continue;
            }
            catch (IOException var11_14) {
                var6_6 = var16_9;
                ** GOTO lbl-1000
            }
lbl44:
            // 2 sources

            if (var6_6 == null) return;
            try {
                var6_6.close();
                return;
            }
            catch (IOException var18_11) {
                Log.e("MediaScanner", "IOException in MediaScanner.processM3uPlayList()", var18_11);
                return;
            }
            catch (IOException var11_12) {}
lbl-1000:
            // 2 sources

            {
                Log.e("MediaScanner", "IOException in MediaScanner.processM3uPlayList()", (Throwable)var11_13);
                if (var6_6 == null) return;
                ** continue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processPlayList(FileEntry fileEntry, Cursor cursor) throws RemoteException {
        Uri uri;
        String string2 = fileEntry.mPath;
        ContentValues contentValues = new ContentValues();
        int n = string2.lastIndexOf(47);
        if (n < 0) {
            throw new IllegalArgumentException("bad path " + string2);
        }
        long l = fileEntry.mRowId;
        String string3 = contentValues.getAsString("name");
        if (string3 == null && (string3 = contentValues.getAsString("title")) == null) {
            int n2 = string2.lastIndexOf(46);
            string3 = n2 < 0 ? string2.substring(n + 1) : string2.substring(n + 1, n2);
        }
        contentValues.put("name", string3);
        contentValues.put("date_modified", fileEntry.mLastModified);
        if (l == 0L) {
            contentValues.put("_data", string2);
            Uri uri2 = this.mMediaProvider.insert(this.mPackageName, this.mPlaylistsUri, contentValues);
            ContentUris.parseId(uri2);
            uri = Uri.withAppendedPath(uri2, "members");
        } else {
            Uri uri3 = ContentUris.withAppendedId(this.mPlaylistsUri, l);
            this.mMediaProvider.update(this.mPackageName, uri3, contentValues, null, null);
            uri = Uri.withAppendedPath(uri3, "members");
            this.mMediaProvider.delete(this.mPackageName, uri, null, null);
        }
        String string4 = string2.substring(0, n + 1);
        MediaFile.MediaFileType mediaFileType = MediaFile.getFileType(string2);
        if (mediaFileType == null) {
            return;
        }
        int n3 = mediaFileType.fileType;
        if (n3 != 41) {
            if (n3 == 42) {
                this.processPlsPlayList(string2, string4, uri, contentValues, cursor);
                return;
            }
            if (n3 != 43) return;
            this.processWplPlayList(string2, string4, uri, contentValues, cursor);
            return;
        }
        this.processM3uPlayList(string2, string4, uri, contentValues, cursor);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void processPlayLists() throws RemoteException {
        Iterator<FileEntry> iterator = this.mPlayLists.iterator();
        Cursor cursor = null;
        try {
            cursor = this.mMediaProvider.query(this.mPackageName, this.mFilesUri, FILES_PRESCAN_PROJECTION, "media_type=2", null, null, null);
            while (iterator.hasNext()) {
                FileEntry fileEntry = iterator.next();
                if (!fileEntry.mLastModifiedChanged) continue;
                this.processPlayList(fileEntry, cursor);
            }
        }
        catch (RemoteException remoteException) {
            if (cursor == null) return;
            cursor.close();
            return;
        }
        if (cursor == null) return;
        cursor.close();
        return;
        catch (Throwable throwable) {
            if (cursor == null) throw throwable;
            cursor.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPlsPlayList(String var1_1, String var2_2, Uri var3_3, ContentValues var4_4, Cursor var5_5) {
        var6_6 = null;
        var7_7 = new File(var1_1);
        var15_8 = var7_7.exists();
        var6_6 = null;
        if (!var15_8) ** GOTO lbl44
        var16_9 = new BufferedReader(new InputStreamReader(new FileInputStream(var7_7)), 8192);
        ** GOTO lbl20
        {
            catch (Throwable var8_17) lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (var6_6 == null) throw var8_18;
                    try {
                        var6_6.close();
                        throw var8_18;
                    }
                    catch (IOException var9_20) {
                        Log.e("MediaScanner", "IOException in MediaScanner.processPlsPlayList()", var9_20);
                        throw var8_18;
                    }
                    break;
                }
lbl20:
                // 2 sources

                var17_10 = var16_9.readLine();
                this.mPlaylistEntries.clear();
                while (var17_10 != null) {
                    if (var17_10.startsWith("File") && (var18_11 = var17_10.indexOf(61)) > 0) {
                        this.cachePlaylistEntry(var17_10.substring(var18_11 + 1), var2_2);
                    }
                    var17_10 = var16_9.readLine();
                }
                this.processCachedPlaylist(var5_5, var4_4, var3_3);
                var6_6 = var16_9;
lbl30:
                // 1 sources

                while (true) {
                    try {
                        var6_6.close();
                        return;
                    }
                    catch (IOException var13_16) {
                        Log.e("MediaScanner", "IOException in MediaScanner.processPlsPlayList()", var13_16);
                        return;
                    }
                    break;
                }
            }
            catch (Throwable var8_19) {
                var6_6 = var16_9;
                ** continue;
            }
            catch (IOException var11_15) {
                var6_6 = var16_9;
                ** GOTO lbl-1000
            }
lbl44:
            // 2 sources

            if (var6_6 == null) return;
            try {
                var6_6.close();
                return;
            }
            catch (IOException var19_12) {
                Log.e("MediaScanner", "IOException in MediaScanner.processPlsPlayList()", var19_12);
                return;
            }
            catch (IOException var11_13) {}
lbl-1000:
            // 2 sources

            {
                Log.e("MediaScanner", "IOException in MediaScanner.processPlsPlayList()", (Throwable)var11_14);
                if (var6_6 == null) return;
                ** continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processWplPlayList(String var1_1, String var2_2, Uri var3_3, ContentValues var4_4, Cursor var5_5) {
        block25: {
            var6_6 = null;
            var7_7 = new File(var1_1);
            var17_8 = var7_7.exists();
            var6_6 = null;
            if (!var17_8) break block25;
            var18_9 = new FileInputStream(var7_7);
            this.mPlaylistEntries.clear();
            Xml.parse(var18_9, Xml.findEncodingByName("UTF-8"), new WplHandler(var2_2, var3_3, var5_5).getContentHandler());
            this.processCachedPlaylist(var5_5, var4_4, var3_3);
            var6_6 = var18_9;
        }
        if (var6_6 == null) ** GOTO lbl18
        try {
            var6_6.close();
lbl18:
            // 4 sources

            return;
        }
        catch (IOException var19_10) {
            Log.e("MediaScanner", "IOException in MediaScanner.processWplPlayList()", var19_10);
            return;
        }
        catch (SAXException var14_11) lbl-1000:
        // 2 sources

        {
            while (true) {
                var14_12.printStackTrace();
                if (var6_6 == null) ** GOTO lbl18
                try {
                    var6_6.close();
                    return;
                }
                catch (IOException var15_14) {
                    Log.e("MediaScanner", "IOException in MediaScanner.processWplPlayList()", var15_14);
                    return;
                }
                break;
            }
        }
        catch (IOException var11_15) lbl-1000:
        // 2 sources

        {
            while (true) {
                var11_16.printStackTrace();
                if (var6_6 == null) ** continue;
                {
                    catch (Throwable var8_19) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (var6_6 != null) {
                                var6_6.close();
                            }
lbl46:
                            // 4 sources

                            throw var8_20;
                            catch (IOException var9_22) {
                                Log.e("MediaScanner", "IOException in MediaScanner.processWplPlayList()", var9_22);
                                ** continue;
                            }
                            break;
                        }
                    }
                }
                try {
                    var6_6.close();
                    return;
                }
                catch (IOException var12_18) {
                    Log.e("MediaScanner", "IOException in MediaScanner.processWplPlayList()", var12_18);
                    return;
                }
                break;
            }
        }
        catch (Throwable var8_21) {
            var6_6 = var18_9;
            ** continue;
        }
        catch (IOException var11_17) {
            var6_6 = var18_9;
            ** continue;
        }
        catch (SAXException var14_13) {
            var6_6 = var18_9;
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pruneDeadThumbnailFiles() {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = new File("/sdcard/DCIM/.thumbnails").list();
        Cursor cursor = null;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add("/sdcard/DCIM/.thumbnails" + "/" + stringArray[i]);
        }
        try {
            cursor = this.mMediaProvider.query(this.mPackageName, this.mThumbsUri, new String[]{"_data"}, null, null, null, null);
            Log.v(TAG, "pruneDeadThumbnailFiles... " + cursor);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    hashSet.remove(cursor.getString(0));
                } while (cursor.moveToNext());
            }
            for (String string2 : hashSet) {
                try {
                    new File(string2).delete();
                }
                catch (SecurityException securityException) {}
            }
            Log.v(TAG, "/pruneDeadThumbnailFiles... " + cursor);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    private void releaseResources() {
        if (this.mDrmManagerClient != null) {
            this.mDrmManagerClient.release();
            this.mDrmManagerClient = null;
        }
    }

    private void setDefaultRingtoneFileNames() {
        this.mDefaultRingtoneFilename = SystemProperties.get("ro.config.ringtone");
        this.mDefaultNotificationFilename = SystemProperties.get("ro.config.notification_sound");
        this.mDefaultAlarmAlertFilename = SystemProperties.get("ro.config.alarm_alert");
        this.mDefaultNewMailFilename = SystemProperties.get("ro.config.newmail_sound");
        this.mDefaultSentMailFilename = SystemProperties.get("ro.config.sentmail_sound");
        this.mDefaultCalendarAlertFilename = SystemProperties.get("ro.config.calendaralert_sound");
        this.mDefaultRingtone2Filename = SystemProperties.get("ro.config.ringtone");
        this.mDefaultNotification2Filename = SystemProperties.get("ro.config.notification_sound");
    }

    public native byte[] extractAlbumArt(FileDescriptor var1);

    protected void finalize() {
        this.mContext.getContentResolver().releaseProvider(this.mMediaProvider);
        this.native_finalize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    FileEntry makeEntryFor(String string2) {
        Cursor cursor;
        block6: {
            cursor = null;
            try {
                String[] stringArray = new String[]{string2};
                cursor = this.mMediaProvider.query(this.mPackageName, this.mFilesUriNoNotify, FILES_PRESCAN_PROJECTION, "_data=?", stringArray, null, null);
                if (!cursor.moveToFirst()) break block6;
                long l = cursor.getLong(0);
                int n = cursor.getInt(2);
                FileEntry fileEntry = new FileEntry(l, string2, cursor.getLong(3), n);
                return fileEntry;
            }
            catch (RemoteException remoteException) {}
        }
        return null;
        finally {
            if (cursor == null) return null;
            cursor.close();
            return null;
        }
    }

    public void release() {
        this.native_finalize();
    }

    public void scanDirectories(String[] stringArray, String string2) {
        try {
            System.currentTimeMillis();
            this.initialize(string2);
            this.prescan(null, true);
            System.currentTimeMillis();
            this.mMediaInserter = new MediaInserter(this.mMediaProvider, this.mPackageName, 500);
            for (int i = 0; i < stringArray.length; ++i) {
                this.processDirectory(stringArray[i], this.mClient);
            }
            this.mMediaInserter.flushAll();
            this.mMediaInserter = null;
            System.currentTimeMillis();
            this.postscan(stringArray);
            System.currentTimeMillis();
            return;
        }
        catch (SQLException sQLException) {
            Log.e(TAG, "SQLException in MediaScanner.scan()", sQLException);
            return;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.e(TAG, "UnsupportedOperationException in MediaScanner.scan()", unsupportedOperationException);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in MediaScanner.scan()", remoteException);
            return;
        }
        finally {
            this.releaseResources();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scanMtpFile(String string2, String string3, int n, int n2) {
        this.initialize(string3);
        MediaFile.MediaFileType mediaFileType = MediaFile.getFileType(string2);
        int n3 = mediaFileType == null ? 0 : mediaFileType.fileType;
        File file = new File(string2);
        long l = file.lastModified() / 1000L;
        if (!(MediaFile.isAudioFileType(n3) || MediaFile.isVideoFileType(n3) || MediaFile.isImageFileType(n3) || MediaFile.isPlayListFileType(n3) || MediaFile.isDrmFileType(n3))) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("_size", file.length());
            contentValues.put("date_modified", l);
            try {
                String[] stringArray = new String[]{Integer.toString(n)};
                this.mMediaProvider.update(this.mPackageName, MediaStore.Files.getMtpObjectsUri(string3), contentValues, "_id=?", stringArray);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "RemoteException in scanMtpFile", remoteException);
                return;
            }
        }
        this.mMtpObjectHandle = n;
        Cursor cursor = null;
        try {
            if (MediaFile.isPlayListFileType(n3)) {
                this.prescan(null, true);
                FileEntry fileEntry = this.makeEntryFor(string2);
                cursor = null;
                if (fileEntry != null) {
                    cursor = this.mMediaProvider.query(this.mPackageName, this.mFilesUri, FILES_PRESCAN_PROJECTION, null, null, null, null);
                    this.processPlayList(fileEntry, cursor);
                }
            } else {
                this.prescan(string2, false);
                MyMediaScannerClient myMediaScannerClient = this.mClient;
                String string4 = mediaFileType.mimeType;
                long l2 = file.length();
                boolean bl = n2 == 12289;
                myMediaScannerClient.doScanFile(string2, string4, l, l2, bl, true, MediaScanner.isNoMediaPath(string2));
                cursor = null;
            }
            this.mMtpObjectHandle = 0;
            if (cursor != null) {
                cursor.close();
            }
            this.releaseResources();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in MediaScanner.scanFile()", remoteException);
            this.mMtpObjectHandle = 0;
            if (cursor != null) {
                cursor.close();
            }
            this.releaseResources();
            return;
        }
        catch (Throwable throwable) {
            this.mMtpObjectHandle = 0;
            if (cursor != null) {
                cursor.close();
            }
            this.releaseResources();
            throw throwable;
        }
    }

    public Uri scanSingleFile(String string2, String string3, String string4) {
        File file;
        block6: {
            this.initialize(string3);
            this.prescan(string2, true);
            file = new File(string2);
            boolean bl = file.exists();
            if (bl) break block6;
            this.releaseResources();
            return null;
        }
        try {
            long l = file.lastModified() / 1000L;
            Uri uri = this.mClient.doScanFile(string2, string4, l, file.length(), false, true, MediaScanner.isNoMediaPath(string2));
            this.releaseResources();
            return uri;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in MediaScanner.scanFile()", remoteException);
            return null;
        }
        finally {
            this.releaseResources();
        }
    }

    public native void setLocale(String var1);

    private static class FileEntry {
        int mFormat;
        long mLastModified;
        boolean mLastModifiedChanged;
        String mPath;
        long mRowId;

        FileEntry(long l, String string2, long l2, int n) {
            this.mRowId = l;
            this.mPath = string2;
            this.mLastModified = l2;
            this.mFormat = n;
            this.mLastModifiedChanged = false;
        }

        public String toString() {
            return this.mPath + " mRowId: " + this.mRowId;
        }
    }

    static class MediaBulkDeleter {
        final Uri mBaseUri;
        final String mPackageName;
        final IContentProvider mProvider;
        ArrayList<String> whereArgs;
        StringBuilder whereClause = new StringBuilder();

        public MediaBulkDeleter(IContentProvider iContentProvider, String string2, Uri uri) {
            this.whereArgs = new ArrayList(100);
            this.mProvider = iContentProvider;
            this.mPackageName = string2;
            this.mBaseUri = uri;
        }

        public void delete(long l) throws RemoteException {
            if (this.whereClause.length() != 0) {
                this.whereClause.append(",");
            }
            this.whereClause.append("?");
            this.whereArgs.add("" + l);
            if (this.whereArgs.size() > 100) {
                this.flush();
            }
        }

        public void flush() throws RemoteException {
            int n = this.whereArgs.size();
            if (n > 0) {
                String[] stringArray = new String[n];
                String[] stringArray2 = this.whereArgs.toArray(stringArray);
                this.mProvider.delete(this.mPackageName, this.mBaseUri, "_id IN (" + this.whereClause.toString() + ")", stringArray2);
                this.whereClause.setLength(0);
                this.whereArgs.clear();
            }
        }
    }

    private class MyMediaScannerClient
    implements MediaScannerClient {
        private String mAlbum;
        private String mAlbumArtist;
        private String mArtist;
        private int mCompilation;
        private String mComposer;
        private int mDuration;
        private long mFileSize;
        private int mFileType;
        private String mGenre;
        private int mHeight;
        private boolean mIsDrm;
        private long mLastModified;
        private String mMimeType;
        private boolean mNoMedia;
        private String mPath;
        private String mTitle;
        private int mTrack;
        private int mWidth;
        private String mWriter;
        private int mYear;

        private MyMediaScannerClient() {
        }

        private boolean convertGenreCode(String string2, String string3) {
            String string4 = this.getGenreName(string2);
            if (string4.equals(string3)) {
                return true;
            }
            Log.d(MediaScanner.TAG, "'" + string2 + "' -> '" + string4 + "', expected '" + string3 + "'");
            return false;
        }

        private boolean doesPathHaveFilename(String string2, String string3) {
            int n = 1 + string2.lastIndexOf(File.separatorChar);
            int n2 = string3.length();
            boolean bl = string2.regionMatches(n, string3, 0, n2);
            boolean bl2 = false;
            if (bl) {
                int n3 = n + n2;
                int n4 = string2.length();
                bl2 = false;
                if (n3 == n4) {
                    bl2 = true;
                }
            }
            return bl2;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Uri endFile(FileEntry var1_1, boolean var2_2, boolean var3_3, boolean var4_4, boolean var5_5, boolean var6_6) throws RemoteException {
            block73: {
                block66: {
                    block67: {
                        block72: {
                            block70: {
                                block71: {
                                    block68: {
                                        block69: {
                                            block64: {
                                                if (this.mArtist == null || this.mArtist.length() == 0) {
                                                    this.mArtist = this.mAlbumArtist;
                                                }
                                                if ((var8_8 = (var7_7 = this.toValues()).getAsString("title")) == null || TextUtils.isEmpty(var8_8.trim())) {
                                                    var7_7.put("title", MediaFile.getFileTitle(var7_7.getAsString("_data")));
                                                }
                                                if (!"<unknown>".equals(var7_7.getAsString("album")) || (var45_10 = (var44_9 = var7_7.getAsString("_data")).lastIndexOf(47)) < 0) ** GOTO lbl11
                                                var46_11 = 0;
                                                while (true) {
                                                    block65: {
                                                        if ((var47_12 = var44_9.indexOf(47, var46_11 + 1)) >= 0 && var47_12 < var45_10) break block65;
                                                        if (var46_11 != 0) {
                                                            var7_7.put("album", var44_9.substring(var46_11 + 1, var45_10));
                                                        }
lbl11:
                                                        // 4 sources

                                                        var9_13 = var1_1.mRowId;
                                                        if (!MediaFile.isAudioFileType(this.mFileType) || var9_13 != 0L && MediaScanner.access$500(MediaScanner.this) == 0) break;
                                                        var7_7.put("is_ringtone", var2_2);
                                                        var7_7.put("is_notification", var3_3);
                                                        var7_7.put("is_alarm", var4_4);
                                                        var7_7.put("is_music", var5_5);
                                                        var7_7.put("is_podcast", var6_6);
                                                        break block64;
                                                    }
                                                    var46_11 = var47_12;
                                                }
                                                if (this.mFileType == 31 && !this.mNoMedia) {
                                                    try {
                                                        var12_25 = var11_24 = new ExifInterface(var1_1.mPath);
                                                    }
                                                    catch (IOException var43_37) {
                                                        var12_25 = null;
                                                    }
                                                    if (var12_25 != null) {
                                                        var13_26 = new float[2];
                                                        if (var12_25.getLatLong(var13_26)) {
                                                            var7_7.put("latitude", Float.valueOf(var13_26[0]));
                                                            var7_7.put("longitude", Float.valueOf(var13_26[1]));
                                                        }
                                                        if ((var14_27 = var12_25.getGpsDateTime()) != -1L) {
                                                            var7_7.put("datetaken", var14_27);
                                                        } else {
                                                            var16_30 = var12_25.getDateTime();
                                                            if (var16_30 != -1L && Math.abs(1000L * this.mLastModified - var16_30) >= 86400000L) {
                                                                var7_7.put("datetaken", var16_30);
                                                            }
                                                        }
                                                        if ((var18_28 = var12_25.getAttributeInt("Orientation", -1)) != -1) {
                                                            switch (var18_28) {
                                                                default: {
                                                                    var19_29 = 0;
                                                                    break;
                                                                }
                                                                case 6: {
                                                                    var19_29 = 90;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    var19_29 = 180;
                                                                    break;
                                                                }
                                                                case 8: {
                                                                    var19_29 = 270;
                                                                }
                                                            }
                                                            var7_7.put("orientation", var19_29);
                                                        }
                                                    }
                                                }
                                            }
                                            var20_14 = MediaScanner.access$1200(MediaScanner.this);
                                            var21_15 = MediaScanner.access$1300(MediaScanner.this);
                                            if (!this.mNoMedia) {
                                                if (MediaFile.isVideoFileType(this.mFileType)) {
                                                    var20_14 = MediaScanner.access$1400(MediaScanner.this);
                                                } else if (MediaFile.isImageFileType(this.mFileType)) {
                                                    var20_14 = MediaScanner.access$1500(MediaScanner.this);
                                                } else if (MediaFile.isAudioFileType(this.mFileType)) {
                                                    var20_14 = MediaScanner.access$1600(MediaScanner.this);
                                                }
                                            }
                                            if (var9_13 != 0L) break block66;
                                            if (MediaScanner.access$500(MediaScanner.this) != 0) {
                                                var7_7.put("media_scanner_new_object_id", MediaScanner.access$500(MediaScanner.this));
                                            }
                                            if (var20_14 == (var35_16 = MediaScanner.access$1200(MediaScanner.this))) {
                                                var42_17 = var1_1.mFormat;
                                                if (var42_17 == 0) {
                                                    var42_17 = MediaFile.getFormatCode(var1_1.mPath, this.mMimeType);
                                                }
                                                var7_7.put("format", var42_17);
                                            }
                                            var36_18 = MediaScanner.access$1700(MediaScanner.this);
                                            var37_19 = false;
                                            var24_20 = false;
                                            var25_21 = 0;
                                            if (!var36_18) break block67;
                                            if (!var3_3 || MediaScanner.access$1800(MediaScanner.this)) break block68;
                                            if (TextUtils.isEmpty(MediaScanner.access$1900(MediaScanner.this)) || this.doesPathHaveFilename(var1_1.mPath, MediaScanner.access$1900(MediaScanner.this)) || TextUtils.isEmpty(MediaScanner.access$2000(MediaScanner.this))) break block69;
                                            var41_22 = this.doesPathHaveFilename(var1_1.mPath, MediaScanner.access$2000(MediaScanner.this));
                                            var37_19 = false;
                                            var24_20 = false;
                                            var25_21 = 0;
                                            if (!var41_22) break block67;
                                        }
                                        var24_20 = true;
                                        var25_21 = 2;
                                        var37_19 = true;
                                        break block67;
                                    }
                                    if (!var2_2 || MediaScanner.access$2100(MediaScanner.this)) break block70;
                                    if (TextUtils.isEmpty(MediaScanner.access$2200(MediaScanner.this)) || this.doesPathHaveFilename(var1_1.mPath, MediaScanner.access$2200(MediaScanner.this)) || TextUtils.isEmpty(MediaScanner.access$2300(MediaScanner.this))) break block71;
                                    var40_31 = this.doesPathHaveFilename(var1_1.mPath, MediaScanner.access$2300(MediaScanner.this));
                                    var37_19 = false;
                                    var24_20 = false;
                                    var25_21 = 0;
                                    if (!var40_31) break block67;
                                }
                                var24_20 = true;
                                var37_19 = false;
                                var25_21 = 0;
                                break block67;
                            }
                            var37_19 = false;
                            var24_20 = false;
                            var25_21 = 0;
                            if (!var4_4) break block67;
                            var38_32 = MediaScanner.access$2400(MediaScanner.this);
                            var37_19 = false;
                            var24_20 = false;
                            var25_21 = 0;
                            if (var38_32) break block67;
                            if (TextUtils.isEmpty(MediaScanner.access$2500(MediaScanner.this))) break block72;
                            var39_33 = this.doesPathHaveFilename(var1_1.mPath, MediaScanner.access$2500(MediaScanner.this));
                            var37_19 = false;
                            var24_20 = false;
                            var25_21 = 0;
                            if (!var39_33) break block67;
                        }
                        var24_20 = true;
                        var37_19 = false;
                        var25_21 = 0;
                    }
                    if (var3_3 && !var37_19) {
                        if (!var37_19 && MediaScanner.access$1700(MediaScanner.this) && !MediaScanner.access$2600(MediaScanner.this) && (TextUtils.isEmpty(MediaScanner.access$2700(MediaScanner.this)) || this.doesPathHaveFilename(var1_1.mPath, MediaScanner.access$2700(MediaScanner.this)))) {
                            var24_20 = true;
                            var25_21 = 32;
                            var37_19 = true;
                        }
                        if (!var37_19 && MediaScanner.access$1700(MediaScanner.this) && !MediaScanner.access$2800(MediaScanner.this) && (TextUtils.isEmpty(MediaScanner.access$2900(MediaScanner.this)) || this.doesPathHaveFilename(var1_1.mPath, MediaScanner.access$2900(MediaScanner.this)))) {
                            var24_20 = true;
                            var25_21 = 64;
                            var37_19 = true;
                        }
                        if (!var37_19 && MediaScanner.access$1700(MediaScanner.this) && !MediaScanner.access$3000(MediaScanner.this) && (TextUtils.isEmpty(MediaScanner.access$3100(MediaScanner.this)) || this.doesPathHaveFilename(var1_1.mPath, MediaScanner.access$3100(MediaScanner.this)))) {
                            var24_20 = true;
                            var25_21 = 128;
                        }
                    }
                    if (var21_15 == null || var24_20) {
                        if (var21_15 != null) {
                            var21_15.flushAll();
                        }
                        var22_23 = MediaScanner.access$3300(MediaScanner.this).insert(MediaScanner.access$3200(MediaScanner.this), var20_14, var7_7);
                    } else if (var1_1.mFormat == 12289) {
                        var21_15.insertwithPriority(var20_14, var7_7);
                        var22_23 = null;
                    } else {
                        var21_15.insert(var20_14, var7_7);
                        var22_23 = null;
                    }
                    if (var22_23 != null) {
                        var1_1.mRowId = var9_13 = ContentUris.parseId(var22_23);
                    }
                    break block73;
                }
                var22_23 = ContentUris.withAppendedId(var20_14, var9_13);
                var7_7.remove("_data");
                if (!MediaScanner.isNoMediaPath(var1_1.mPath)) {
                    var32_34 = MediaFile.getFileTypeForMimeType(this.mMimeType);
                    if (MediaFile.isAudioFileType(var32_34)) {
                        var34_35 = 2;
                    } else if (MediaFile.isVideoFileType(var32_34)) {
                        var34_35 = 3;
                    } else if (MediaFile.isImageFileType(var32_34)) {
                        var34_35 = 1;
                    } else {
                        var33_36 = MediaFile.isPlayListFileType(var32_34);
                        var34_35 = 0;
                        if (var33_36) {
                            var34_35 = 4;
                        }
                    }
                    var7_7.put("media_type", var34_35);
                }
                MediaScanner.access$3300(MediaScanner.this).update(MediaScanner.access$3200(MediaScanner.this), var22_23, var7_7, null, null);
                var24_20 = false;
                var25_21 = 0;
            }
            if (!var24_20) return var22_23;
            if (var3_3 && var25_21 == 2) {
                this.setSettingIfNotSet("notification_sound", var20_14, var9_13);
                this.setSettingIfNotSet("default_notification_sound", var20_14, var9_13);
                this.setSettingIfNotSet("notification_sound_2", var20_14, var9_13);
                this.setSettingIfNotSet("default_notification_sound_2", var20_14, var9_13);
                MediaScanner.access$1802(MediaScanner.this, true);
                return var22_23;
            } else {
                if (var3_3 && var25_21 == 32) {
                    this.setSettingIfNotSet("newmail_sound", var20_14, var9_13);
                    this.setSettingIfNotSet("default_newmail_sound", var20_14, var9_13);
                    MediaScanner.access$2602(MediaScanner.this, true);
                    return var22_23;
                }
                if (var3_3 && var25_21 == 64) {
                    this.setSettingIfNotSet("sentmail_sound", var20_14, var9_13);
                    this.setSettingIfNotSet("default_sentmail_sound", var20_14, var9_13);
                    MediaScanner.access$2802(MediaScanner.this, true);
                    return var22_23;
                }
                if (var3_3 && var25_21 == 128) {
                    this.setSettingIfNotSet("calendaralert_sound", var20_14, var9_13);
                    this.setSettingIfNotSet("default_calendaralert_sound", var20_14, var9_13);
                    MediaScanner.access$3002(MediaScanner.this, true);
                    return var22_23;
                }
                if (var2_2) {
                    this.setSettingIfNotSet("ringtone", var20_14, var9_13);
                    this.setSettingIfNotSet("default_ringtone", var20_14, var9_13);
                    this.setSettingIfNotSet("ringtone_2", var20_14, var9_13);
                    this.setSettingIfNotSet("default_ringtone_2", var20_14, var9_13);
                    MediaScanner.access$2102(MediaScanner.this, true);
                    return var22_23;
                }
                if (!var4_4) return var22_23;
                this.setSettingIfNotSet("alarm_alert", var20_14, var9_13);
                this.setSettingIfNotSet("default_alarm_alert", var20_14, var9_13);
                MediaScanner.access$2402(MediaScanner.this, true);
                return var22_23;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private int getFileTypeFromDrm(String string2) {
            String string3;
            block5: {
                block4: {
                    if (!MediaScanner.this.isDrmEnabled()) break block4;
                    if (MediaScanner.this.mDrmManagerClient == null) {
                        MediaScanner.access$3502(MediaScanner.this, new DrmManagerClient(MediaScanner.this.mContext));
                    }
                    if (!MediaScanner.this.mDrmManagerClient.canHandle(string2, null)) break block4;
                    this.mIsDrm = true;
                    string3 = MediaScanner.this.mDrmManagerClient.getOriginalMimeType(string2);
                    if (string3 != null) break block5;
                }
                return 0;
            }
            this.mMimeType = string3;
            return MediaFile.getFileTypeForMimeType(string3);
        }

        private int parseSubstring(String string2, int n, int n2) {
            int n3 = string2.length();
            if (n == n3) {
                return n2;
            }
            int n4 = n + 1;
            char c = string2.charAt(n);
            if (c < '0' || c > '9') {
                return n2;
            }
            int n5 = c - 48;
            while (n4 < n3) {
                int n6 = n4 + 1;
                char c2 = string2.charAt(n4);
                if (c2 < '0' || c2 > '9') {
                    return n5;
                }
                n5 = n5 * 10 + (c2 - 48);
                n4 = n6;
            }
            return n5;
        }

        private void processImageFile(String string2) {
            try {
                ((MediaScanner)MediaScanner.this).mBitmapOptions.outWidth = 0;
                ((MediaScanner)MediaScanner.this).mBitmapOptions.outHeight = 0;
                BitmapFactory.decodeFile(string2, MediaScanner.this.mBitmapOptions);
                this.mWidth = ((MediaScanner)MediaScanner.this).mBitmapOptions.outWidth;
                this.mHeight = ((MediaScanner)MediaScanner.this).mBitmapOptions.outHeight;
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }

        private void setSettingIfNotSet(String string2, Uri uri, long l) {
            if (TextUtils.isEmpty(Settings.System.getString(MediaScanner.this.mContext.getContentResolver(), string2))) {
                Settings.System.putString(MediaScanner.this.mContext.getContentResolver(), string2, ContentUris.withAppendedId(uri, l).toString());
            }
        }

        private void testGenreNameConverter() {
            this.convertGenreCode("2", "Country");
            this.convertGenreCode("(2)", "Country");
            this.convertGenreCode("(2", "(2");
            this.convertGenreCode("2 Foo", "Country");
            this.convertGenreCode("(2) Foo", "Country");
            this.convertGenreCode("(2 Foo", "(2 Foo");
            this.convertGenreCode("2Foo", "2Foo");
            this.convertGenreCode("(2)Foo", "Country");
            this.convertGenreCode("200 Foo", "Foo");
            this.convertGenreCode("(200) Foo", "Foo");
            this.convertGenreCode("200Foo", "200Foo");
            this.convertGenreCode("(200)Foo", "Foo");
            this.convertGenreCode("200)Foo", "200)Foo");
            this.convertGenreCode("200) Foo", "200) Foo");
        }

        /*
         * Enabled aggressive block sorting
         */
        private ContentValues toValues() {
            ContentValues contentValues = new ContentValues();
            contentValues.put("_data", this.mPath);
            contentValues.put("title", this.mTitle);
            contentValues.put("date_modified", this.mLastModified);
            contentValues.put("_size", this.mFileSize);
            contentValues.put("mime_type", this.mMimeType);
            contentValues.put("is_drm", this.mIsDrm);
            int n = this.mWidth;
            String string2 = null;
            if (n > 0) {
                int n2 = this.mHeight;
                string2 = null;
                if (n2 > 0) {
                    contentValues.put("width", this.mWidth);
                    contentValues.put("height", this.mHeight);
                    string2 = this.mWidth + "x" + this.mHeight;
                }
            }
            if (this.mNoMedia) return contentValues;
            if (MediaFile.isVideoFileType(this.mFileType)) {
                String string3 = this.mArtist != null && this.mArtist.length() > 0 ? this.mArtist : "<unknown>";
                contentValues.put("artist", string3);
                String string4 = this.mAlbum != null && this.mAlbum.length() > 0 ? this.mAlbum : "<unknown>";
                contentValues.put("album", string4);
                contentValues.put("duration", this.mDuration);
                if (string2 == null) return contentValues;
                contentValues.put("resolution", string2);
                return contentValues;
            }
            if (MediaFile.isImageFileType(this.mFileType) || !MediaFile.isAudioFileType(this.mFileType)) return contentValues;
            String string5 = this.mArtist != null && this.mArtist.length() > 0 ? this.mArtist : "<unknown>";
            contentValues.put("artist", string5);
            String string6 = this.mAlbumArtist != null && this.mAlbumArtist.length() > 0 ? this.mAlbumArtist : null;
            contentValues.put("album_artist", string6);
            String string7 = this.mAlbum != null && this.mAlbum.length() > 0 ? this.mAlbum : "<unknown>";
            contentValues.put("album", string7);
            contentValues.put("composer", this.mComposer);
            contentValues.put("genre", this.mGenre);
            if (this.mYear != 0) {
                contentValues.put("year", this.mYear);
            }
            contentValues.put("track", this.mTrack);
            contentValues.put("duration", this.mDuration);
            contentValues.put("compilation", this.mCompilation);
            return contentValues;
        }

        /*
         * Enabled aggressive block sorting
         */
        public FileEntry beginFile(String string2, String string3, long l, long l2, boolean bl, boolean bl2) {
            FileEntry fileEntry;
            this.mMimeType = string3;
            this.mFileType = 0;
            this.mFileSize = l2;
            this.mIsDrm = false;
            if (!bl) {
                MediaFile.MediaFileType mediaFileType;
                if (!bl2 && MediaScanner.isNoMediaFile(string2)) {
                    bl2 = true;
                }
                this.mNoMedia = bl2;
                if (string3 != null) {
                    this.mFileType = MediaFile.getFileTypeForMimeType(string3);
                }
                if (this.mFileType == 0 && (mediaFileType = MediaFile.getFileType(string2)) != null) {
                    this.mFileType = mediaFileType.fileType;
                    if (this.mMimeType == null) {
                        this.mMimeType = mediaFileType.mimeType;
                    }
                }
                if (MediaScanner.this.isDrmEnabled() && MediaFile.isDrmFileType(this.mFileType)) {
                    this.mFileType = this.getFileTypeFromDrm(string2);
                }
            }
            long l3 = (fileEntry = MediaScanner.this.makeEntryFor(string2)) != null ? l - fileEntry.mLastModified : 0L;
            boolean bl3 = l3 > 1L || l3 < -1L;
            if (fileEntry == null || bl3) {
                if (bl3) {
                    fileEntry.mLastModified = l;
                } else {
                    int n = bl ? 12289 : 0;
                    fileEntry = new FileEntry(0L, string2, l, n);
                }
                fileEntry.mLastModifiedChanged = true;
            }
            if (MediaScanner.this.mProcessPlaylists && MediaFile.isPlayListFileType(this.mFileType)) {
                MediaScanner.this.mPlayLists.add(fileEntry);
                return null;
            }
            this.mArtist = null;
            this.mAlbumArtist = null;
            this.mAlbum = null;
            this.mTitle = null;
            this.mComposer = null;
            this.mGenre = null;
            this.mTrack = 0;
            this.mYear = 0;
            this.mDuration = 0;
            this.mPath = string2;
            this.mLastModified = l;
            this.mWriter = null;
            this.mCompilation = 0;
            this.mWidth = 0;
            this.mHeight = 0;
            return fileEntry;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Uri doScanFile(String string2, String string3, long l, long l2, boolean bl, boolean bl2, boolean bl3) {
            int n;
            StringBuilder stringBuilder;
            String string4;
            File file;
            String string5;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            boolean bl7;
            boolean bl8;
            FileEntry fileEntry;
            block8: {
                block7: {
                    String string6 = string2;
                    try {
                        fileEntry = this.beginFile(string6, string3, l, l2, bl, bl3);
                        if (MediaScanner.this.mMtpObjectHandle != 0) {
                            fileEntry.mRowId = 0L;
                        }
                        if (fileEntry == null) return null;
                        if (!fileEntry.mLastModifiedChanged) {
                            if (!bl2) return null;
                        }
                        if (bl3) {
                            return this.endFile(fileEntry, false, false, false, false, false);
                        }
                        Locale locale = Locale.ROOT;
                        String string7 = string2.toLowerCase(locale);
                        bl8 = string7.indexOf(MediaScanner.RINGTONES_DIR) > 0;
                        bl7 = string7.indexOf(MediaScanner.NOTIFICATIONS_DIR) > 0;
                        bl6 = string7.indexOf(MediaScanner.ALARMS_DIR) > 0;
                        bl5 = string7.indexOf(MediaScanner.PODCAST_DIR) > 0;
                        if (string7.indexOf(MediaScanner.MUSIC_DIR) > 0 || !bl8 && !bl7 && !bl6 && !bl5) break block7;
                        bl4 = false;
                        break block8;
                    }
                    catch (RemoteException remoteException) {
                        Log.e(MediaScanner.TAG, "RemoteException in MediaScanner.scanFile()", remoteException);
                    }
                    return null;
                }
                bl4 = true;
            }
            boolean bl9 = MediaFile.isAudioFileType(this.mFileType);
            boolean bl10 = MediaFile.isVideoFileType(this.mFileType);
            boolean bl11 = MediaFile.isImageFileType(this.mFileType);
            if ((bl9 || bl10 || bl11) && MediaScanner.this.mExternalIsEmulated && string2.startsWith(string5 = MediaScanner.this.mExternalStoragePath) && (file = new File(string4 = (stringBuilder = new StringBuilder().append(Environment.getMediaStorageDirectory())).append(string2.substring(n = MediaScanner.this.mExternalStoragePath.length())).toString())).exists()) {
                string2 = string4;
            }
            if (bl9 || bl10) {
                MediaScanner.this.processFile(string2, string3, this);
            }
            if (!bl11) return this.endFile(fileEntry, bl8, bl7, bl6, bl4, bl5);
            this.processImageFile(string2);
            return this.endFile(fileEntry, bl8, bl7, bl6, bl4, bl5);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getGenreName(String string2) {
            short s;
            int n;
            String string3 = null;
            if (string2 == null) {
                return string3;
            }
            int n2 = string2.length();
            if (n2 <= 0) return string2;
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < n2; ++n) {
                char c = string2.charAt(n);
                if (n == 0 && c == '(') {
                    bl = true;
                    continue;
                }
                if (!Character.isDigit(c)) break;
                stringBuffer.append(c);
            }
            char c = n < n2 ? (char)string2.charAt(n) : (char)' ';
            if (!bl || c != ')') {
                if (bl) return string2;
                if (!Character.isWhitespace(c)) return string2;
            }
            try {
                s = Short.parseShort(stringBuffer.toString());
                if (s < 0) return string2;
                if (s < ID3_GENRES.length && ID3_GENRES[s] != null) {
                    return ID3_GENRES[s];
                }
            }
            catch (NumberFormatException numberFormatException) {
                return string2;
            }
            string3 = null;
            if (s == 255) return string3;
            if (s >= 255) return stringBuffer.toString();
            if (n + 1 >= n2) {
                return stringBuffer.toString();
            }
            if (bl && c == ')') {
                ++n;
            }
            if ((string3 = string2.substring(n).trim()).length() != 0) return string3;
            return string2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleStringTag(String string2, String string3) {
            int n = 1;
            if (string2.equalsIgnoreCase("title") || string2.startsWith("title;")) {
                this.mTitle = string3;
                return;
            } else {
                if (string2.equalsIgnoreCase("artist") || string2.startsWith("artist;")) {
                    this.mArtist = string3.trim();
                    return;
                }
                if (string2.equalsIgnoreCase("albumartist") || string2.startsWith("albumartist;") || string2.equalsIgnoreCase("band") || string2.startsWith("band;")) {
                    this.mAlbumArtist = string3.trim();
                    return;
                }
                if (string2.equalsIgnoreCase("album") || string2.startsWith("album;")) {
                    this.mAlbum = string3.trim();
                    return;
                }
                if (string2.equalsIgnoreCase("composer") || string2.startsWith("composer;")) {
                    this.mComposer = string3.trim();
                    return;
                }
                if (MediaScanner.this.mProcessGenres && (string2.equalsIgnoreCase("genre") || string2.startsWith("genre;"))) {
                    this.mGenre = this.getGenreName(string3);
                    return;
                }
                if (string2.equalsIgnoreCase("year") || string2.startsWith("year;")) {
                    this.mYear = this.parseSubstring(string3, 0, 0);
                    return;
                }
                if (string2.equalsIgnoreCase("tracknumber") || string2.startsWith("tracknumber;")) {
                    this.mTrack = this.parseSubstring(string3, 0, 0) + 1000 * (this.mTrack / 1000);
                    return;
                }
                if (string2.equalsIgnoreCase("discnumber") || string2.equals("set") || string2.startsWith("set;")) {
                    this.mTrack = 1000 * this.parseSubstring(string3, 0, 0) + this.mTrack % 1000;
                    return;
                }
                if (string2.equalsIgnoreCase("duration")) {
                    this.mDuration = this.parseSubstring(string3, 0, 0);
                    return;
                }
                if (string2.equalsIgnoreCase("writer") || string2.startsWith("writer;")) {
                    this.mWriter = string3.trim();
                    return;
                }
                if (string2.equalsIgnoreCase("compilation")) {
                    this.mCompilation = this.parseSubstring(string3, 0, 0);
                    return;
                }
                if (string2.equalsIgnoreCase("isdrm")) {
                    if (this.parseSubstring(string3, 0, 0) != n) {
                        n = 0;
                    }
                    this.mIsDrm = n;
                    return;
                }
                if (string2.equalsIgnoreCase("width")) {
                    this.mWidth = this.parseSubstring(string3, 0, 0);
                    return;
                }
                if (!string2.equalsIgnoreCase("height")) return;
                this.mHeight = this.parseSubstring(string3, 0, 0);
                return;
            }
        }

        @Override
        public void scanFile(String string2, long l, long l2, boolean bl, boolean bl2) {
            this.doScanFile(string2, null, l, l2, bl, false, bl2);
        }

        @Override
        public void setMimeType(String string2) {
            if ("audio/mp4".equals(this.mMimeType) && string2.startsWith("video")) {
                return;
            }
            this.mMimeType = string2;
            this.mFileType = MediaFile.getFileTypeForMimeType(string2);
        }
    }

    private static class PlaylistEntry {
        long bestmatchid;
        int bestmatchlevel;
        String path;

        private PlaylistEntry() {
        }
    }

    class WplHandler
    implements ElementListener {
        final ContentHandler handler;
        String playListDirectory;

        public WplHandler(String string2, Uri uri, Cursor cursor) {
            this.playListDirectory = string2;
            RootElement rootElement = new RootElement("smil");
            rootElement.getChild("body").getChild("seq").getChild("media").setElementListener(this);
            this.handler = rootElement.getContentHandler();
        }

        @Override
        public void end() {
        }

        ContentHandler getContentHandler() {
            return this.handler;
        }

        @Override
        public void start(Attributes attributes) {
            String string2 = attributes.getValue("", "src");
            if (string2 != null) {
                MediaScanner.this.cachePlaylistEntry(string2, this.playListDirectory);
            }
        }
    }
}

