/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.media.IRemoteControlClient;
import android.media.IRemoteVolumeObserver;
import android.media.MediaFocusControl;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.io.PrintWriter;
import java.util.NoSuchElementException;

class PlayerRecord
implements IBinder.DeathRecipient {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaFocusControl";
    public static MediaFocusControl sController;
    private static int sLastRccId;
    private String mCallingPackageName;
    private int mCallingUid;
    private final PendingIntent mMediaIntent;
    public RccPlaybackState mPlaybackState;
    public int mPlaybackStream;
    public int mPlaybackType;
    public int mPlaybackVolume;
    public int mPlaybackVolumeHandling;
    public int mPlaybackVolumeMax;
    private IRemoteControlClient mRcClient;
    private RcClientDeathHandler mRcClientDeathHandler;
    private int mRccId = -1;
    private final ComponentName mReceiverComponent;
    public IRemoteVolumeObserver mRemoteVolumeObs;
    private IBinder mToken;

    static {
        sLastRccId = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PlayerRecord(PendingIntent pendingIntent, ComponentName componentName, IBinder iBinder) {
        int n;
        this.mMediaIntent = pendingIntent;
        this.mReceiverComponent = componentName;
        this.mToken = iBinder;
        this.mCallingUid = -1;
        this.mRcClient = null;
        sLastRccId = n = 1 + sLastRccId;
        this.mRccId = n;
        this.mPlaybackState = new RccPlaybackState(1, -1L, 1.0f);
        this.resetPlaybackInfo();
        if (this.mToken == null) return;
        try {
            this.mToken.linkToDeath(this, 0);
            return;
        }
        catch (RemoteException remoteException) {
            sController.unregisterMediaButtonIntentAsync(this.mMediaIntent);
            return;
        }
    }

    protected static void setMediaFocusControl(MediaFocusControl mediaFocusControl) {
        sController = mediaFocusControl;
    }

    @Override
    public void binderDied() {
        sController.unregisterMediaButtonIntentAsync(this.mMediaIntent);
    }

    public void destroy() {
        this.unlinkToRcClientDeath();
        if (this.mToken != null) {
            this.mToken.unlinkToDeath(this, 0);
            this.mToken = null;
        }
    }

    void dump(PrintWriter printWriter, boolean bl) {
        if (bl) {
            printWriter.println("  pi: " + this.mMediaIntent + " -- pack: " + this.mCallingPackageName + "  -- ercvr: " + this.mReceiverComponent + "  -- client: " + this.mRcClient + "  -- uid: " + this.mCallingUid + "  -- type: " + this.mPlaybackType + "  state: " + this.mPlaybackState);
            return;
        }
        printWriter.println("  uid: " + this.mCallingUid + "  -- id: " + this.mRccId + "  -- type: " + this.mPlaybackType + "  -- state: " + this.mPlaybackState + "  -- vol handling: " + this.mPlaybackVolumeHandling + "  -- vol: " + this.mPlaybackVolume + "  -- volMax: " + this.mPlaybackVolumeMax + "  -- volObs: " + this.mRemoteVolumeObs);
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    protected PendingIntent getMediaButtonIntent() {
        return this.mMediaIntent;
    }

    protected ComponentName getMediaButtonReceiver() {
        return this.mReceiverComponent;
    }

    protected IRemoteControlClient getRcc() {
        return this.mRcClient;
    }

    protected int getRccId() {
        return this.mRccId;
    }

    protected boolean hasMatchingMediaButtonIntent(PendingIntent pendingIntent) {
        if (this.mToken != null) {
            return this.mMediaIntent.equals(pendingIntent);
        }
        if (this.mReceiverComponent != null) {
            return this.mReceiverComponent.equals(pendingIntent.getIntent().getComponent());
        }
        return false;
    }

    protected boolean isPlaybackActive() {
        return MediaFocusControl.isPlaystateActive(this.mPlaybackState.mState);
    }

    protected void resetControllerInfoForNoRcc() {
        this.unlinkToRcClientDeath();
        this.mRcClient = null;
        this.mCallingPackageName = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resetControllerInfoForRcc(IRemoteControlClient iRemoteControlClient, String string2, int n) {
        if (this.mRcClientDeathHandler != null) {
            this.unlinkToRcClientDeath();
        }
        this.mRcClient = iRemoteControlClient;
        this.mCallingPackageName = string2;
        this.mCallingUid = n;
        if (iRemoteControlClient == null) {
            this.resetPlaybackInfo();
            return;
        }
        IBinder iBinder = this.mRcClient.asBinder();
        RcClientDeathHandler rcClientDeathHandler = new RcClientDeathHandler(iBinder, this.mMediaIntent);
        try {
            iBinder.linkToDeath(rcClientDeathHandler, 0);
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "registerRemoteControlClient() has a dead client " + iBinder);
            this.mRcClient = null;
        }
        this.mRcClientDeathHandler = rcClientDeathHandler;
    }

    public void resetPlaybackInfo() {
        this.mPlaybackType = 0;
        this.mPlaybackVolume = 15;
        this.mPlaybackVolumeMax = 15;
        this.mPlaybackVolumeHandling = 1;
        this.mPlaybackStream = 3;
        this.mPlaybackState.reset();
        this.mRemoteVolumeObs = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unlinkToRcClientDeath() {
        if (this.mRcClientDeathHandler == null || this.mRcClientDeathHandler.mCb == null) return;
        try {
            this.mRcClientDeathHandler.mCb.unlinkToDeath(this.mRcClientDeathHandler, 0);
            this.mRcClientDeathHandler = null;
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            Log.e(TAG, "Error in unlinkToRcClientDeath()", noSuchElementException);
            return;
        }
    }

    private class RcClientDeathHandler
    implements IBinder.DeathRecipient {
        private final IBinder mCb;
        private final PendingIntent mMediaIntent;

        RcClientDeathHandler(IBinder iBinder, PendingIntent pendingIntent) {
            this.mCb = iBinder;
            this.mMediaIntent = pendingIntent;
        }

        @Override
        public void binderDied() {
            Log.w(PlayerRecord.TAG, "  RemoteControlClient died");
            sController.registerRemoteControlClient(this.mMediaIntent, null, null);
            sController.postReevaluateRemote();
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }

    protected static class RccPlaybackState {
        public long mPositionMs;
        public float mSpeed;
        public int mState;

        public RccPlaybackState(int n, long l, float f) {
            this.mState = n;
            this.mPositionMs = l;
            this.mSpeed = f;
        }

        private String posToString() {
            if (this.mPositionMs == -1L) {
                return "PLAYBACK_POSITION_INVALID";
            }
            if (this.mPositionMs == -9216204211029966080L) {
                return "PLAYBACK_POSITION_ALWAYS_UNKNOWN";
            }
            return String.valueOf(this.mPositionMs) + "ms";
        }

        private String stateToString() {
            switch (this.mState) {
                default: {
                    return "[invalid playstate]";
                }
                case 0: {
                    return "PLAYSTATE_NONE";
                }
                case 1: {
                    return "PLAYSTATE_STOPPED";
                }
                case 2: {
                    return "PLAYSTATE_PAUSED";
                }
                case 3: {
                    return "PLAYSTATE_PLAYING";
                }
                case 4: {
                    return "PLAYSTATE_FAST_FORWARDING";
                }
                case 5: {
                    return "PLAYSTATE_REWINDING";
                }
                case 6: {
                    return "PLAYSTATE_SKIPPING_FORWARDS";
                }
                case 7: {
                    return "PLAYSTATE_SKIPPING_BACKWARDS";
                }
                case 8: {
                    return "PLAYSTATE_BUFFERING";
                }
                case 9: 
            }
            return "PLAYSTATE_ERROR";
        }

        public void reset() {
            this.mState = 1;
            this.mPositionMs = -1L;
            this.mSpeed = 1.0f;
        }

        public String toString() {
            return this.stateToString() + ", " + this.posToString() + ", " + this.mSpeed + "X";
        }
    }

    protected static class RemotePlaybackState {
        int mRccId;
        int mVolume;
        int mVolumeHandling;
        int mVolumeMax;

        protected RemotePlaybackState(int n, int n2, int n3) {
            this.mRccId = n;
            this.mVolume = n2;
            this.mVolumeMax = n3;
            this.mVolumeHandling = 1;
        }
    }
}

