/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.WebVttParser;
import android.util.Log;

class Tokenizer {
    private static final String TAG = "Tokenizer";
    private TokenizerPhase mDataTokenizer = new DataTokenizer();
    private int mHandledLen;
    private String mLine;
    private OnTokenListener mListener;
    private TokenizerPhase mPhase;
    private TokenizerPhase mTagTokenizer = new TagTokenizer();

    Tokenizer(OnTokenListener onTokenListener) {
        this.reset();
        this.mListener = onTokenListener;
    }

    static /* synthetic */ int access$102(Tokenizer tokenizer, int n) {
        tokenizer.mHandledLen = n;
        return n;
    }

    static /* synthetic */ int access$108(Tokenizer tokenizer) {
        int n = tokenizer.mHandledLen;
        tokenizer.mHandledLen = n + 1;
        return n;
    }

    static /* synthetic */ int access$112(Tokenizer tokenizer, int n) {
        int n2;
        tokenizer.mHandledLen = n2 = n + tokenizer.mHandledLen;
        return n2;
    }

    static /* synthetic */ TokenizerPhase access$202(Tokenizer tokenizer, TokenizerPhase tokenizerPhase) {
        tokenizer.mPhase = tokenizerPhase;
        return tokenizerPhase;
    }

    void reset() {
        this.mPhase = this.mDataTokenizer.start();
    }

    void tokenize(String string2) {
        this.mHandledLen = 0;
        this.mLine = string2;
        while (this.mHandledLen < this.mLine.length()) {
            this.mPhase.tokenize();
        }
        if (!(this.mPhase instanceof TagTokenizer)) {
            this.mListener.onLineEnd();
        }
    }

    class DataTokenizer
    implements TokenizerPhase {
        private StringBuilder mData;

        DataTokenizer() {
        }

        private boolean replaceEscape(String string2, String string3, int n) {
            if (Tokenizer.this.mLine.startsWith(string2, n)) {
                this.mData.append(Tokenizer.this.mLine.substring(Tokenizer.this.mHandledLen, n));
                this.mData.append(string3);
                Tokenizer.access$102(Tokenizer.this, n + string2.length());
                int cfr_ignored_0 = -1 + Tokenizer.this.mHandledLen;
                return true;
            }
            return false;
        }

        @Override
        public TokenizerPhase start() {
            this.mData = new StringBuilder();
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void tokenize() {
            int n = Tokenizer.this.mLine.length();
            for (int i = Tokenizer.this.mHandledLen; i < Tokenizer.this.mLine.length(); ++i) {
                if (Tokenizer.this.mLine.charAt(i) == '&') {
                    if (this.replaceEscape("&amp;", "&", i) || this.replaceEscape("&lt;", "<", i) || this.replaceEscape("&gt;", ">", i) || this.replaceEscape("&lrm;", "\u200e", i) || this.replaceEscape("&rlm;", "\u200f", i) || !this.replaceEscape("&nbsp;", "\u00a0", i)) continue;
                    continue;
                }
                if (Tokenizer.this.mLine.charAt(i) != '<') continue;
                n = i;
                Tokenizer.access$202(Tokenizer.this, Tokenizer.this.mTagTokenizer.start());
                break;
            }
            this.mData.append(Tokenizer.this.mLine.substring(Tokenizer.this.mHandledLen, n));
            Tokenizer.this.mListener.onData(this.mData.toString());
            this.mData.delete(0, this.mData.length());
            Tokenizer.access$102(Tokenizer.this, n);
        }
    }

    static interface OnTokenListener {
        public void onData(String var1);

        public void onEnd(String var1);

        public void onLineEnd();

        public void onStart(String var1, String[] var2, String var3);

        public void onTimeStamp(long var1);
    }

    class TagTokenizer
    implements TokenizerPhase {
        private String mAnnotation;
        private boolean mAtAnnotation;
        private String mName;

        TagTokenizer() {
        }

        private void yield_tag() {
            if (this.mName.startsWith("/")) {
                Tokenizer.this.mListener.onEnd(this.mName.substring(1));
                return;
            }
            if (this.mName.length() > 0 && Character.isDigit(this.mName.charAt(0))) {
                try {
                    long l = WebVttParser.parseTimestampMs(this.mName);
                    Tokenizer.this.mListener.onTimeStamp(l);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    Log.d(Tokenizer.TAG, "invalid timestamp tag: <" + this.mName + ">");
                    return;
                }
            }
            this.mAnnotation = this.mAnnotation.replaceAll("\\s+", " ");
            if (this.mAnnotation.startsWith(" ")) {
                this.mAnnotation = this.mAnnotation.substring(1);
            }
            if (this.mAnnotation.endsWith(" ")) {
                this.mAnnotation = this.mAnnotation.substring(0, -1 + this.mAnnotation.length());
            }
            int n = this.mName.indexOf(46);
            String[] stringArray = null;
            if (n >= 0) {
                stringArray = this.mName.substring(n + 1).split("\\.");
                this.mName = this.mName.substring(0, n);
            }
            Tokenizer.this.mListener.onStart(this.mName, stringArray, this.mAnnotation);
        }

        @Override
        public TokenizerPhase start() {
            this.mAnnotation = "";
            this.mName = "";
            this.mAtAnnotation = false;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void tokenize() {
            if (!this.mAtAnnotation) {
                Tokenizer.access$108(Tokenizer.this);
            }
            if (Tokenizer.this.mHandledLen < Tokenizer.this.mLine.length()) {
                String[] stringArray = this.mAtAnnotation || Tokenizer.this.mLine.charAt(Tokenizer.this.mHandledLen) == '/' ? Tokenizer.this.mLine.substring(Tokenizer.this.mHandledLen).split(">") : Tokenizer.this.mLine.substring(Tokenizer.this.mHandledLen).split("[\t\f >]");
                String string2 = Tokenizer.this.mLine.substring(Tokenizer.this.mHandledLen, Tokenizer.this.mHandledLen + stringArray[0].length());
                Tokenizer.access$112(Tokenizer.this, stringArray[0].length());
                if (this.mAtAnnotation) {
                    this.mAnnotation = this.mAnnotation + " " + string2;
                } else {
                    this.mName = string2;
                }
            }
            this.mAtAnnotation = true;
            if (Tokenizer.this.mHandledLen < Tokenizer.this.mLine.length() && Tokenizer.this.mLine.charAt(Tokenizer.this.mHandledLen) == '>') {
                this.yield_tag();
                Tokenizer.access$202(Tokenizer.this, Tokenizer.this.mDataTokenizer.start());
                Tokenizer.access$108(Tokenizer.this);
            }
        }
    }

    static interface TokenizerPhase {
        public TokenizerPhase start();

        public void tokenize();
    }
}

