/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaFormat;
import android.media.SubtitleTrack;
import android.media.TextTrackCue;
import android.media.TextTrackCueSpan;
import android.media.TextTrackRegion;
import android.media.Tokenizer;
import android.media.UnstyledTextExtractor;
import android.media.WebVttCueListener;
import android.media.WebVttParser;
import android.media.WebVttRenderingWidget;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

class WebVttTrack
extends SubtitleTrack
implements WebVttCueListener {
    private static final String TAG = "WebVttTrack";
    private Long mCurrentRunID;
    private final UnstyledTextExtractor mExtractor;
    private final WebVttParser mParser = new WebVttParser(this);
    private final Map<String, TextTrackRegion> mRegions;
    private final WebVttRenderingWidget mRenderingWidget;
    private final Vector<Long> mTimestamps;
    private final Tokenizer mTokenizer;

    WebVttTrack(WebVttRenderingWidget webVttRenderingWidget, MediaFormat mediaFormat) {
        super(mediaFormat);
        this.mExtractor = new UnstyledTextExtractor();
        this.mTokenizer = new Tokenizer(this.mExtractor);
        this.mTimestamps = new Vector();
        this.mRegions = new HashMap<String, TextTrackRegion>();
        this.mRenderingWidget = webVttRenderingWidget;
    }

    @Override
    public WebVttRenderingWidget getRenderingWidget() {
        return this.mRenderingWidget;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onCueParsed(TextTrackCue textTrackCue) {
        WebVttParser webVttParser = this.mParser;
        synchronized (webVttParser) {
            if (textTrackCue.mRegionId.length() != 0) {
                textTrackCue.mRegion = this.mRegions.get(textTrackCue.mRegionId);
            }
            if (this.DEBUG) {
                Log.v(TAG, "adding cue " + textTrackCue);
            }
            this.mTokenizer.reset();
            for (String string2 : textTrackCue.mStrings) {
                this.mTokenizer.tokenize(string2);
            }
            textTrackCue.mLines = this.mExtractor.getText();
            if (this.DEBUG) {
                Log.v(TAG, textTrackCue.appendLinesToBuilder(textTrackCue.appendStringsToBuilder(new StringBuilder()).append(" simplified to: ")).toString());
            }
            TextTrackCueSpan[][] textTrackCueSpanArray = textTrackCue.mLines;
            int n = textTrackCueSpanArray.length;
            int n2 = 0;
            while (true) {
                int n3;
                TextTrackCueSpan[] textTrackCueSpanArray2;
                if (n2 < n) {
                    textTrackCueSpanArray2 = textTrackCueSpanArray[n2];
                    n3 = textTrackCueSpanArray2.length;
                } else {
                    if (this.mTimestamps.size() > 0) {
                        textTrackCue.mInnerTimesMs = new long[this.mTimestamps.size()];
                        for (int i = 0; i < this.mTimestamps.size(); ++i) {
                            textTrackCue.mInnerTimesMs[i] = this.mTimestamps.get(i);
                        }
                        this.mTimestamps.clear();
                    } else {
                        textTrackCue.mInnerTimesMs = null;
                    }
                    textTrackCue.mRunID = this.mCurrentRunID;
                    // MONITOREXIT @DISABLED, blocks:[4, 6, 11] lbl36 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.addCue(textTrackCue);
                    return;
                }
                for (int i = 0; i < n3; ++i) {
                    TextTrackCueSpan textTrackCueSpan = textTrackCueSpanArray2[i];
                    if (textTrackCueSpan.mTimestampMs <= textTrackCue.mStartTimeMs || textTrackCueSpan.mTimestampMs >= textTrackCue.mEndTimeMs || this.mTimestamps.contains(textTrackCueSpan.mTimestampMs)) continue;
                    this.mTimestamps.add(textTrackCueSpan.mTimestampMs);
                }
                ++n2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onData(byte[] byArray, boolean bl, long l) {
        String string2;
        try {
            string2 = new String(byArray, "UTF-8");
            WebVttParser webVttParser = this.mParser;
            synchronized (webVttParser) {
                if (this.mCurrentRunID != null && l != this.mCurrentRunID) {
                    throw new IllegalStateException("Run #" + this.mCurrentRunID + " in progress.  Cannot process run #" + l);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.w(TAG, "subtitle data is not UTF-8 encoded: " + unsupportedEncodingException);
            return;
        }
        {
            this.mCurrentRunID = l;
            this.mParser.parse(string2);
            if (bl) {
                this.finishedRun(l);
                this.mParser.eos();
                this.mRegions.clear();
                this.mCurrentRunID = null;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onRegionParsed(TextTrackRegion textTrackRegion) {
        WebVttParser webVttParser = this.mParser;
        synchronized (webVttParser) {
            this.mRegions.put(textTrackRegion.mId, textTrackRegion);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateView(Vector<SubtitleTrack.Cue> vector) {
        block7: {
            block6: {
                if (!this.mVisible) break block6;
                if (this.DEBUG && this.mTimeProvider != null) {
                    try {
                        Log.d(TAG, "at " + this.mTimeProvider.getCurrentTimeUs(false, true) / 1000L + " ms the active cues are:");
                    }
                    catch (IllegalStateException illegalStateException) {
                        Log.d(TAG, "at (illegal state) the active cues are:");
                    }
                }
                if (this.mRenderingWidget != null) break block7;
            }
            return;
        }
        this.mRenderingWidget.setActiveCues(vector);
    }
}

