/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;

public class AudioEffect {
    public static final String ACTION_CLOSE_AUDIO_EFFECT_CONTROL_SESSION = "android.media.action.CLOSE_AUDIO_EFFECT_CONTROL_SESSION";
    public static final String ACTION_DISPLAY_AUDIO_EFFECT_CONTROL_PANEL = "android.media.action.DISPLAY_AUDIO_EFFECT_CONTROL_PANEL";
    public static final String ACTION_OPEN_AUDIO_EFFECT_CONTROL_SESSION = "android.media.action.OPEN_AUDIO_EFFECT_CONTROL_SESSION";
    public static final int ALREADY_EXISTS = -2;
    public static final int CONTENT_TYPE_GAME = 2;
    public static final int CONTENT_TYPE_MOVIE = 1;
    public static final int CONTENT_TYPE_MUSIC = 0;
    public static final int CONTENT_TYPE_VOICE = 3;
    public static final String EFFECT_AUXILIARY = "Auxiliary";
    public static final String EFFECT_INSERT = "Insert";
    public static final String EFFECT_PRE_PROCESSING = "Pre Processing";
    public static final UUID EFFECT_TYPE_AEC;
    public static final UUID EFFECT_TYPE_AGC;
    public static final UUID EFFECT_TYPE_BASS_BOOST;
    public static final UUID EFFECT_TYPE_BMF;
    public static final UUID EFFECT_TYPE_ENV_REVERB;
    public static final UUID EFFECT_TYPE_EQUALIZER;
    public static final UUID EFFECT_TYPE_LOUDNESS_ENHANCER;
    public static final UUID EFFECT_TYPE_NS;
    public static final UUID EFFECT_TYPE_NULL;
    public static final UUID EFFECT_TYPE_PRESET_REVERB;
    public static final UUID EFFECT_TYPE_VIRTUALIZER;
    public static final UUID EFFECT_TYPE_WNR;
    public static final int ERROR = -1;
    public static final int ERROR_BAD_VALUE = -4;
    public static final int ERROR_DEAD_OBJECT = -7;
    public static final int ERROR_INVALID_OPERATION = -5;
    public static final int ERROR_NO_INIT = -3;
    public static final int ERROR_NO_MEMORY = -6;
    public static final String EXTRA_AUDIO_SESSION = "android.media.extra.AUDIO_SESSION";
    public static final String EXTRA_CONTENT_TYPE = "android.media.extra.CONTENT_TYPE";
    public static final String EXTRA_PACKAGE_NAME = "android.media.extra.PACKAGE_NAME";
    public static final int NATIVE_EVENT_CONTROL_STATUS = 0;
    public static final int NATIVE_EVENT_ENABLED_STATUS = 1;
    public static final int NATIVE_EVENT_PARAMETER_CHANGED = 2;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_UNINITIALIZED = 0;
    public static final int SUCCESS = 0;
    private static final String TAG = "AudioEffect-JAVA";
    private OnControlStatusChangeListener mControlChangeStatusListener = null;
    private Descriptor mDescriptor;
    private OnEnableStatusChangeListener mEnableStatusChangeListener = null;
    private int mId;
    private long mJniData;
    public final Object mListenerLock;
    private long mNativeAudioEffect;
    public NativeEventHandler mNativeEventHandler = null;
    private OnParameterChangeListener mParameterChangeListener = null;
    private int mState = 0;
    private final Object mStateLock = new Object();

    static {
        System.loadLibrary("audioeffect_jni");
        AudioEffect.native_init();
        EFFECT_TYPE_ENV_REVERB = UUID.fromString("c2e5d5f0-94bd-4763-9cac-4e234d06839e");
        EFFECT_TYPE_PRESET_REVERB = UUID.fromString("47382d60-ddd8-11db-bf3a-0002a5d5c51b");
        EFFECT_TYPE_EQUALIZER = UUID.fromString("0bed4300-ddd6-11db-8f34-0002a5d5c51b");
        EFFECT_TYPE_BASS_BOOST = UUID.fromString("0634f220-ddd4-11db-a0fc-0002a5d5c51b");
        EFFECT_TYPE_VIRTUALIZER = UUID.fromString("37cc2c00-dddd-11db-8577-0002a5d5c51b");
        EFFECT_TYPE_AGC = UUID.fromString("0a8abfe0-654c-11e0-ba26-0002a5d5c51b");
        EFFECT_TYPE_WNR = UUID.fromString("dab015e0-bfac-11e3-bcd9-0002a5d5c51b");
        EFFECT_TYPE_AEC = UUID.fromString("7b491460-8d4d-11e0-bd61-0002a5d5c51b");
        EFFECT_TYPE_NS = UUID.fromString("58b4b260-8e06-11e0-aa8e-0002a5d5c51b");
        EFFECT_TYPE_BMF = UUID.fromString("30927220-bfb0-11e3-b03a-0002a5d5c51b");
        EFFECT_TYPE_LOUDNESS_ENHANCER = UUID.fromString("fe3199be-aed0-413f-87bb-11260eb63cf1");
        EFFECT_TYPE_NULL = UUID.fromString("ec7178ec-e5e1-4432-a3f4-4657e6795210");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AudioEffect(UUID uUID, UUID uUID2, int n, int n2) throws IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        this.mListenerLock = new Object();
        int[] nArray = new int[1];
        Object[] objectArray = new Descriptor[1];
        int n3 = this.native_setup(new WeakReference<AudioEffect>(this), uUID.toString(), uUID2.toString(), n, n2, nArray, objectArray);
        if (n3 != 0 && n3 != -2) {
            Log.e(TAG, "Error code " + n3 + " when initializing AudioEffect.");
            switch (n3) {
                default: {
                    throw new RuntimeException("Cannot initialize effect engine for type: " + uUID + " Error: " + n3);
                }
                case -4: {
                    throw new IllegalArgumentException("Effect type: " + uUID + " not supported.");
                }
                case -5: 
            }
            throw new UnsupportedOperationException("Effect library not loaded");
        }
        this.mId = nArray[0];
        this.mDescriptor = objectArray[0];
        Object object = this.mStateLock;
        synchronized (object) {
            this.mState = 1;
            return;
        }
    }

    public static int byteArrayToInt(byte[] byArray) {
        return AudioEffect.byteArrayToInt(byArray, 0);
    }

    public static int byteArrayToInt(byte[] byArray, int n) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.getInt(n);
    }

    public static short byteArrayToShort(byte[] byArray) {
        return AudioEffect.byteArrayToShort(byArray, 0);
    }

    public static short byteArrayToShort(byte[] byArray, int n) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.getShort(n);
    }

    public static byte[] concatArrays(byte[] ... byArray) {
        int n = 0;
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            n += byArray[i].length;
        }
        byte[] byArray2 = new byte[n];
        int n3 = 0;
        for (byte[] byArray3 : byArray) {
            System.arraycopy((byte[])byArray3, (int)0, (byte[])byArray2, (int)n3, (int)byArray3.length);
            n3 += byArray3.length;
        }
        return byArray2;
    }

    private void createNativeEventHandler() {
        Looper looper = Looper.myLooper();
        if (looper != null) {
            this.mNativeEventHandler = new NativeEventHandler(this, looper);
            return;
        }
        Looper looper2 = Looper.getMainLooper();
        if (looper2 != null) {
            this.mNativeEventHandler = new NativeEventHandler(this, looper2);
            return;
        }
        this.mNativeEventHandler = null;
    }

    public static byte[] intToByteArray(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.putInt(n);
        return byteBuffer.array();
    }

    public static boolean isEffectTypeAvailable(UUID uUID) {
        Descriptor[] descriptorArray = AudioEffect.queryEffects();
        for (int i = 0; i < descriptorArray.length; ++i) {
            if (!descriptorArray[i].type.equals(uUID)) continue;
            return true;
        }
        return false;
    }

    public static boolean isError(int n) {
        return n < 0;
    }

    private final native int native_command(int var1, int var2, byte[] var3, int var4, byte[] var5);

    private final native void native_finalize();

    private final native boolean native_getEnabled();

    private final native int native_getParameter(int var1, byte[] var2, int var3, byte[] var4);

    private final native boolean native_hasControl();

    private static final native void native_init();

    private static native Object[] native_query_effects();

    private static native Object[] native_query_pre_processing(int var0);

    private final native void native_release();

    private final native int native_setEnabled(boolean var1);

    private final native int native_setParameter(int var1, byte[] var2, int var3, byte[] var4);

    private final native int native_setup(Object var1, String var2, String var3, int var4, int var5, int[] var6, Object[] var7);

    /*
     * Enabled aggressive block sorting
     */
    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        AudioEffect audioEffect = (AudioEffect)((WeakReference)object).get();
        if (audioEffect == null || audioEffect.mNativeEventHandler == null) {
            return;
        }
        Message message = audioEffect.mNativeEventHandler.obtainMessage(n, n2, n3, object2);
        audioEffect.mNativeEventHandler.sendMessage(message);
    }

    public static Descriptor[] queryEffects() {
        return (Descriptor[])AudioEffect.native_query_effects();
    }

    public static Descriptor[] queryPreProcessings(int n) {
        return (Descriptor[])AudioEffect.native_query_pre_processing(n);
    }

    public static byte[] shortToByteArray(short s) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.putShort(s);
        return byteBuffer.array();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkState(String string2) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 1) {
                throw new IllegalStateException(string2 + " called on uninitialized AudioEffect.");
            }
            return;
        }
    }

    public void checkStatus(int n) {
        if (AudioEffect.isError(n)) {
            switch (n) {
                default: {
                    throw new RuntimeException("AudioEffect: set/get parameter error");
                }
                case -4: {
                    throw new IllegalArgumentException("AudioEffect: bad parameter value");
                }
                case -5: 
            }
            throw new UnsupportedOperationException("AudioEffect: invalid parameter operation");
        }
    }

    public int command(int n, byte[] byArray, byte[] byArray2) throws IllegalStateException {
        this.checkState("command()");
        return this.native_command(n, byArray.length, byArray, byArray2.length, byArray2);
    }

    protected void finalize() {
        this.native_finalize();
    }

    public Descriptor getDescriptor() throws IllegalStateException {
        this.checkState("getDescriptor()");
        return this.mDescriptor;
    }

    public boolean getEnabled() throws IllegalStateException {
        this.checkState("getEnabled()");
        return this.native_getEnabled();
    }

    public int getId() throws IllegalStateException {
        this.checkState("getId()");
        return this.mId;
    }

    public int getParameter(int n, byte[] byArray) throws IllegalStateException {
        return this.getParameter(AudioEffect.intToByteArray(n), byArray);
    }

    public int getParameter(int n, int[] nArray) throws IllegalStateException {
        byte[] byArray;
        if (nArray.length > 2) {
            return -4;
        }
        byte[] byArray2 = AudioEffect.intToByteArray(n);
        int n2 = this.getParameter(byArray2, byArray = new byte[4 * nArray.length]);
        if (n2 == 4 || n2 == 8) {
            nArray[0] = AudioEffect.byteArrayToInt(byArray);
            if (n2 == 8) {
                nArray[1] = AudioEffect.byteArrayToInt(byArray, 4);
            }
            return n2 / 4;
        }
        return -1;
    }

    public int getParameter(int n, short[] sArray) throws IllegalStateException {
        byte[] byArray;
        if (sArray.length > 2) {
            return -4;
        }
        byte[] byArray2 = AudioEffect.intToByteArray(n);
        int n2 = this.getParameter(byArray2, byArray = new byte[2 * sArray.length]);
        if (n2 == 2 || n2 == 4) {
            sArray[0] = AudioEffect.byteArrayToShort(byArray);
            if (n2 == 4) {
                sArray[1] = AudioEffect.byteArrayToShort(byArray, 2);
            }
            return n2 / 2;
        }
        return -1;
    }

    public int getParameter(byte[] byArray, byte[] byArray2) throws IllegalStateException {
        this.checkState("getParameter()");
        return this.native_getParameter(byArray.length, byArray, byArray2.length, byArray2);
    }

    public int getParameter(int[] nArray, byte[] byArray) throws IllegalStateException {
        if (nArray.length > 2) {
            return -4;
        }
        byte[] byArray2 = AudioEffect.intToByteArray(nArray[0]);
        if (nArray.length > 1) {
            byArray2 = AudioEffect.concatArrays(byArray2, AudioEffect.intToByteArray(nArray[1]));
        }
        return this.getParameter(byArray2, byArray);
    }

    public int getParameter(int[] nArray, int[] nArray2) throws IllegalStateException {
        byte[] byArray;
        int n;
        if (nArray.length > 2 || nArray2.length > 2) {
            return -4;
        }
        byte[] byArray2 = AudioEffect.intToByteArray(nArray[0]);
        if (nArray.length > 1) {
            byArray2 = AudioEffect.concatArrays(byArray2, AudioEffect.intToByteArray(nArray[1]));
        }
        if ((n = this.getParameter(byArray2, byArray = new byte[4 * nArray2.length])) == 4 || n == 8) {
            nArray2[0] = AudioEffect.byteArrayToInt(byArray);
            if (n == 8) {
                nArray2[1] = AudioEffect.byteArrayToInt(byArray, 4);
            }
            return n / 4;
        }
        return -1;
    }

    public int getParameter(int[] nArray, short[] sArray) throws IllegalStateException {
        byte[] byArray;
        int n;
        if (nArray.length > 2 || sArray.length > 2) {
            return -4;
        }
        byte[] byArray2 = AudioEffect.intToByteArray(nArray[0]);
        if (nArray.length > 1) {
            byArray2 = AudioEffect.concatArrays(byArray2, AudioEffect.intToByteArray(nArray[1]));
        }
        if ((n = this.getParameter(byArray2, byArray = new byte[2 * sArray.length])) == 2 || n == 4) {
            sArray[0] = AudioEffect.byteArrayToShort(byArray);
            if (n == 4) {
                sArray[1] = AudioEffect.byteArrayToShort(byArray, 2);
            }
            return n / 2;
        }
        return -1;
    }

    public boolean hasControl() throws IllegalStateException {
        this.checkState("hasControl()");
        return this.native_hasControl();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.native_release();
            this.mState = 0;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setControlStatusListener(OnControlStatusChangeListener onControlStatusChangeListener) {
        Object object = this.mListenerLock;
        // MONITORENTER : object
        this.mControlChangeStatusListener = onControlStatusChangeListener;
        // MONITOREXIT : object
        if (onControlStatusChangeListener == null) return;
        if (this.mNativeEventHandler != null) return;
        this.createNativeEventHandler();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setEnableStatusListener(OnEnableStatusChangeListener onEnableStatusChangeListener) {
        Object object = this.mListenerLock;
        // MONITORENTER : object
        this.mEnableStatusChangeListener = onEnableStatusChangeListener;
        // MONITOREXIT : object
        if (onEnableStatusChangeListener == null) return;
        if (this.mNativeEventHandler != null) return;
        this.createNativeEventHandler();
    }

    public int setEnabled(boolean bl) throws IllegalStateException {
        this.checkState("setEnabled()");
        return this.native_setEnabled(bl);
    }

    public int setParameter(int n, int n2) throws IllegalStateException {
        return this.setParameter(AudioEffect.intToByteArray(n), AudioEffect.intToByteArray(n2));
    }

    public int setParameter(int n, short s) throws IllegalStateException {
        return this.setParameter(AudioEffect.intToByteArray(n), AudioEffect.shortToByteArray(s));
    }

    public int setParameter(int n, byte[] byArray) throws IllegalStateException {
        return this.setParameter(AudioEffect.intToByteArray(n), byArray);
    }

    public int setParameter(byte[] byArray, byte[] byArray2) throws IllegalStateException {
        this.checkState("setParameter()");
        return this.native_setParameter(byArray.length, byArray, byArray2.length, byArray2);
    }

    public int setParameter(int[] nArray, byte[] byArray) throws IllegalStateException {
        if (nArray.length > 2) {
            return -4;
        }
        byte[] byArray2 = AudioEffect.intToByteArray(nArray[0]);
        if (nArray.length > 1) {
            byArray2 = AudioEffect.concatArrays(byArray2, AudioEffect.intToByteArray(nArray[1]));
        }
        return this.setParameter(byArray2, byArray);
    }

    public int setParameter(int[] nArray, int[] nArray2) throws IllegalStateException {
        if (nArray.length > 2 || nArray2.length > 2) {
            return -4;
        }
        byte[] byArray = AudioEffect.intToByteArray(nArray[0]);
        if (nArray.length > 1) {
            byArray = AudioEffect.concatArrays(byArray, AudioEffect.intToByteArray(nArray[1]));
        }
        byte[] byArray2 = AudioEffect.intToByteArray(nArray2[0]);
        if (nArray2.length > 1) {
            byArray2 = AudioEffect.concatArrays(byArray2, AudioEffect.intToByteArray(nArray2[1]));
        }
        return this.setParameter(byArray, byArray2);
    }

    public int setParameter(int[] nArray, short[] sArray) throws IllegalStateException {
        if (nArray.length > 2 || sArray.length > 2) {
            return -4;
        }
        byte[] byArray = AudioEffect.intToByteArray(nArray[0]);
        if (nArray.length > 1) {
            byArray = AudioEffect.concatArrays(byArray, AudioEffect.intToByteArray(nArray[1]));
        }
        byte[] byArray2 = AudioEffect.shortToByteArray(sArray[0]);
        if (sArray.length > 1) {
            byArray2 = AudioEffect.concatArrays(byArray2, AudioEffect.shortToByteArray(sArray[1]));
        }
        return this.setParameter(byArray, byArray2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setParameterListener(OnParameterChangeListener onParameterChangeListener) {
        Object object = this.mListenerLock;
        // MONITORENTER : object
        this.mParameterChangeListener = onParameterChangeListener;
        // MONITOREXIT : object
        if (onParameterChangeListener == null) return;
        if (this.mNativeEventHandler != null) return;
        this.createNativeEventHandler();
    }

    public static class Descriptor {
        public String connectMode;
        public String implementor;
        public String name;
        public UUID type;
        public UUID uuid;

        public Descriptor() {
        }

        public Descriptor(String string2, String string3, String string4, String string5, String string6) {
            this.type = UUID.fromString(string2);
            this.uuid = UUID.fromString(string3);
            this.connectMode = string4;
            this.name = string5;
            this.implementor = string6;
        }
    }

    private class NativeEventHandler
    extends Handler {
        private AudioEffect mAudioEffect;

        public NativeEventHandler(AudioEffect audioEffect2, Looper looper) {
            super(looper);
            this.mAudioEffect = audioEffect2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            OnParameterChangeListener onParameterChangeListener;
            block17: {
                block16: {
                    boolean bl = true;
                    if (this.mAudioEffect == null) break block16;
                    switch (message.what) {
                        default: {
                            Log.e(AudioEffect.TAG, "handleMessage() Unknown event type: " + message.what);
                            return;
                        }
                        case 1: {
                            OnEnableStatusChangeListener onEnableStatusChangeListener;
                            Object object = AudioEffect.this.mListenerLock;
                            synchronized (object) {
                                onEnableStatusChangeListener = this.mAudioEffect.mEnableStatusChangeListener;
                                if (onEnableStatusChangeListener == null) break;
                            }
                            AudioEffect audioEffect = this.mAudioEffect;
                            if (message.arg1 == 0) {
                                bl = false;
                            }
                            onEnableStatusChangeListener.onEnableStatusChange(audioEffect, bl);
                            return;
                        }
                        case 0: {
                            OnControlStatusChangeListener onControlStatusChangeListener;
                            Object object = AudioEffect.this.mListenerLock;
                            synchronized (object) {
                                onControlStatusChangeListener = this.mAudioEffect.mControlChangeStatusListener;
                                if (onControlStatusChangeListener == null) break;
                            }
                            AudioEffect audioEffect = this.mAudioEffect;
                            if (message.arg1 == 0) {
                                bl = false;
                            }
                            onControlStatusChangeListener.onControlStatusChange(audioEffect, bl);
                            return;
                        }
                        case 2: {
                            Object object = AudioEffect.this.mListenerLock;
                            synchronized (object) {
                                onParameterChangeListener = this.mAudioEffect.mParameterChangeListener;
                                if (onParameterChangeListener != null) break block17;
                            }
                        }
                    }
                }
                return;
            }
            int n = message.arg1;
            byte[] byArray = (byte[])message.obj;
            int n2 = AudioEffect.byteArrayToInt(byArray, 0);
            int n3 = AudioEffect.byteArrayToInt(byArray, 4);
            int n4 = AudioEffect.byteArrayToInt(byArray, 8);
            byte[] byArray2 = new byte[n3];
            byte[] byArray3 = new byte[n4];
            System.arraycopy((byte[])byArray, (int)12, (byte[])byArray2, (int)0, (int)n3);
            System.arraycopy((byte[])byArray, (int)n, (byte[])byArray3, (int)0, (int)n4);
            onParameterChangeListener.onParameterChange(this.mAudioEffect, n2, byArray2, byArray3);
        }
    }

    public static interface OnControlStatusChangeListener {
        public void onControlStatusChange(AudioEffect var1, boolean var2);
    }

    public static interface OnEnableStatusChangeListener {
        public void onEnableStatusChange(AudioEffect var1, boolean var2);
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(AudioEffect var1, int var2, byte[] var3, byte[] var4);
    }
}

