/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.audiofx.AudioEffect;
import java.util.StringTokenizer;

public class PresetReverb
extends AudioEffect {
    public static final int PARAM_PRESET = 0;
    public static final short PRESET_LARGEHALL = 5;
    public static final short PRESET_LARGEROOM = 3;
    public static final short PRESET_MEDIUMHALL = 4;
    public static final short PRESET_MEDIUMROOM = 2;
    public static final short PRESET_NONE = 0;
    public static final short PRESET_PLATE = 6;
    public static final short PRESET_SMALLROOM = 1;
    private static final String TAG = "PresetReverb";
    private BaseParameterListener mBaseParamListener = null;
    private OnParameterChangeListener mParamListener = null;
    private final Object mParamListenerLock = new Object();

    public PresetReverb(int n, int n2) throws IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        super(EFFECT_TYPE_PRESET_REVERB, EFFECT_TYPE_NULL, n, n2);
    }

    public short getPreset() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short[] sArray = new short[1];
        this.checkStatus(this.getParameter(0, sArray));
        return sArray[0];
    }

    public Settings getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        Settings settings = new Settings();
        short[] sArray = new short[1];
        this.checkStatus(this.getParameter(0, sArray));
        settings.preset = sArray[0];
        return settings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setParameterListener(OnParameterChangeListener onParameterChangeListener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                this.mParamListener = onParameterChangeListener;
                this.mBaseParamListener = new BaseParameterListener();
                super.setParameterListener(this.mBaseParamListener);
            }
            return;
        }
    }

    public void setPreset(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(0, s));
    }

    public void setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(0, settings.preset));
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener {
        private BaseParameterListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onParameterChange(AudioEffect audioEffect, int n, byte[] byArray, byte[] byArray2) {
            Object object = PresetReverb.this.mParamListenerLock;
            // MONITORENTER : object
            OnParameterChangeListener onParameterChangeListener = PresetReverb.this.mParamListener;
            OnParameterChangeListener onParameterChangeListener2 = null;
            if (onParameterChangeListener != null) {
                onParameterChangeListener2 = PresetReverb.this.mParamListener;
            }
            // MONITOREXIT : object
            if (onParameterChangeListener2 == null) return;
            int n2 = -1;
            short s = -1;
            if (byArray.length == 4) {
                n2 = AudioEffect.byteArrayToInt(byArray, 0);
            }
            if (byArray2.length == 2) {
                s = AudioEffect.byteArrayToShort(byArray2, 0);
            }
            if (n2 == -1) return;
            if (s == -1) return;
            onParameterChangeListener2.onParameterChange(PresetReverb.this, n, n2, s);
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(PresetReverb var1, int var2, int var3, short var4);
    }

    public static class Settings {
        public short preset;

        public Settings() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Settings(String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=;");
            stringTokenizer.countTokens();
            if (stringTokenizer.countTokens() != 3) {
                throw new IllegalArgumentException("settings: " + string2);
            }
            String string3 = stringTokenizer.nextToken();
            if (!string3.equals(PresetReverb.TAG)) {
                throw new IllegalArgumentException("invalid settings for PresetReverb: " + string3);
            }
            try {
                string3 = stringTokenizer.nextToken();
                if (!string3.equals("preset")) {
                    throw new IllegalArgumentException("invalid key name: " + string3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("invalid value for key: " + string3);
            }
            {
                this.preset = Short.parseShort(stringTokenizer.nextToken());
                return;
            }
        }

        public String toString() {
            return new String("PresetReverb;preset=" + Short.toString(this.preset));
        }
    }
}

