/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.media.AudioFormat;
import android.media.AudioSystem;
import android.media.audiopolicy.AudioMixingRule;

public class AudioMix {
    public static final int ROUTE_FLAG_LOOP_BACK = 2;
    public static final int ROUTE_FLAG_RENDER = 1;
    private AudioFormat mFormat;
    private int mRouteFlags;
    private AudioMixingRule mRule;

    private AudioMix(AudioMixingRule audioMixingRule, AudioFormat audioFormat, int n) {
        this.mRule = audioMixingRule;
        this.mFormat = audioFormat;
        this.mRouteFlags = n;
    }

    AudioFormat getFormat() {
        return this.mFormat;
    }

    int getRouteFlags() {
        return this.mRouteFlags;
    }

    AudioMixingRule getRule() {
        return this.mRule;
    }

    public static class Builder {
        private AudioFormat mFormat = null;
        private int mRouteFlags = 0;
        private AudioMixingRule mRule = null;

        Builder() {
        }

        public Builder(AudioMixingRule audioMixingRule) throws IllegalArgumentException {
            if (audioMixingRule == null) {
                throw new IllegalArgumentException("Illegal null AudioMixingRule argument");
            }
            this.mRule = audioMixingRule;
        }

        public AudioMix build() throws IllegalArgumentException {
            if (this.mRule == null) {
                throw new IllegalArgumentException("Illegal null AudioMixingRule");
            }
            if (this.mRouteFlags == 0) {
                this.mRouteFlags = 1;
            }
            if (this.mFormat == null) {
                int n = AudioSystem.getPrimaryOutputSamplingRate();
                if (n <= 0) {
                    n = 44100;
                }
                this.mFormat = new AudioFormat.Builder().setSampleRate(n).build();
            }
            return new AudioMix(this.mRule, this.mFormat, this.mRouteFlags);
        }

        public Builder setFormat(AudioFormat audioFormat) throws IllegalArgumentException {
            if (audioFormat == null) {
                throw new IllegalArgumentException("Illegal null AudioFormat argument");
            }
            this.mFormat = audioFormat;
            return this;
        }

        public Builder setMixingRule(AudioMixingRule audioMixingRule) throws IllegalArgumentException {
            if (audioMixingRule == null) {
                throw new IllegalArgumentException("Illegal null AudioMixingRule argument");
            }
            this.mRule = audioMixingRule;
            return this;
        }

        public Builder setRouteFlags(int n) throws IllegalArgumentException {
            if (n == 0) {
                throw new IllegalArgumentException("Illegal empty route flags");
            }
            if ((n & 3) == 0) {
                throw new IllegalArgumentException("Invalid route flags 0x" + Integer.toHexString(n) + "when creating an AudioMix");
            }
            this.mRouteFlags = n;
            return this;
        }
    }
}

