/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkAddress;
import android.net.ProxyInfo;
import android.net.RouteInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class LinkProperties
implements Parcelable {
    public static final Parcelable.Creator<LinkProperties> CREATOR = new Parcelable.Creator<LinkProperties>(){

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public LinkProperties createFromParcel(Parcel parcel) {
            LinkProperties linkProperties = new LinkProperties();
            String string2 = parcel.readString();
            if (string2 != null) {
                linkProperties.setInterfaceName(string2);
            }
            int n = parcel.readInt();
            for (int i = 0; i < n; ++i) {
                linkProperties.addLinkAddress((LinkAddress)parcel.readParcelable(null));
            }
            int n2 = parcel.readInt();
            int n3 = 0;
            while (true) {
                if (n3 < n2) {
                    linkProperties.addDnsServer(InetAddress.getByAddress(parcel.createByteArray()));
                } else {
                    linkProperties.setDomains(parcel.readString());
                    linkProperties.setMtu(parcel.readInt());
                    linkProperties.setTcpBufferSizes(parcel.readString());
                    int n4 = parcel.readInt();
                    for (int i = 0; i < n4; ++i) {
                        linkProperties.addRoute((RouteInfo)parcel.readParcelable(null));
                    }
                    if (parcel.readByte() == 1) {
                        linkProperties.setHttpProxy((ProxyInfo)parcel.readParcelable(null));
                    }
                    ArrayList arrayList = new ArrayList();
                    parcel.readList(arrayList, LinkProperties.class.getClassLoader());
                    Iterator iterator = arrayList.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return linkProperties;
                        }
                        linkProperties.addStackedLink((LinkProperties)iterator.next());
                    }
                    catch (UnknownHostException unknownHostException) {}
                }
                ++n3;
            }
        }

        public LinkProperties[] newArray(int n) {
            return new LinkProperties[n];
        }
    };
    private static final int MAX_MTU = 10000;
    private static final int MIN_MTU = 68;
    private static final int MIN_MTU_V6 = 1280;
    private ArrayList<InetAddress> mDnses;
    private String mDomains;
    private ProxyInfo mHttpProxy;
    private String mIfaceName;
    private ArrayList<LinkAddress> mLinkAddresses = new ArrayList();
    private int mMtu;
    private ArrayList<RouteInfo> mRoutes;
    private Hashtable<String, LinkProperties> mStackedLinks;
    private String mTcpBufferSizes;

    public LinkProperties() {
        this.mDnses = new ArrayList();
        this.mRoutes = new ArrayList();
        this.mStackedLinks = new Hashtable();
    }

    /*
     * Enabled aggressive block sorting
     */
    public LinkProperties(LinkProperties linkProperties) {
        this.mDnses = new ArrayList();
        this.mRoutes = new ArrayList();
        this.mStackedLinks = new Hashtable();
        if (linkProperties != null) {
            this.mIfaceName = linkProperties.getInterfaceName();
            for (LinkAddress linkAddress : linkProperties.getLinkAddresses()) {
                this.mLinkAddresses.add(linkAddress);
            }
            for (InetAddress inetAddress : linkProperties.getDnsServers()) {
                this.mDnses.add(inetAddress);
            }
            this.mDomains = linkProperties.getDomains();
            for (RouteInfo routeInfo : linkProperties.getRoutes()) {
                this.mRoutes.add(routeInfo);
            }
            ProxyInfo proxyInfo = linkProperties.getHttpProxy() == null ? null : new ProxyInfo(linkProperties.getHttpProxy());
            this.mHttpProxy = proxyInfo;
            Iterator<LinkProperties> iterator = linkProperties.mStackedLinks.values().iterator();
            while (iterator.hasNext()) {
                this.addStackedLink(iterator.next());
            }
            this.setMtu(linkProperties.getMtu());
            this.mTcpBufferSizes = linkProperties.mTcpBufferSizes;
        }
    }

    private int findLinkAddressIndex(LinkAddress linkAddress) {
        for (int i = 0; i < this.mLinkAddresses.size(); ++i) {
            if (!this.mLinkAddresses.get(i).isSameAddressAs(linkAddress)) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isValidMtu(int n, boolean bl) {
        return bl ? n >= 1280 && n <= 10000 : n >= 68 && n <= 10000;
    }

    private RouteInfo routeWithInterface(RouteInfo routeInfo) {
        return new RouteInfo(routeInfo.getDestination(), routeInfo.getGateway(), this.mIfaceName, routeInfo.getType());
    }

    public boolean addDnsServer(InetAddress inetAddress) {
        if (inetAddress != null && !this.mDnses.contains(inetAddress)) {
            this.mDnses.add(inetAddress);
            return true;
        }
        return false;
    }

    public boolean addLinkAddress(LinkAddress linkAddress) {
        if (linkAddress == null) {
            return false;
        }
        int n = this.findLinkAddressIndex(linkAddress);
        if (n < 0) {
            this.mLinkAddresses.add(linkAddress);
            return true;
        }
        if (this.mLinkAddresses.get(n).equals(linkAddress)) {
            return false;
        }
        this.mLinkAddresses.set(n, linkAddress);
        return true;
    }

    public boolean addRoute(RouteInfo routeInfo) {
        if (routeInfo != null) {
            String string2 = routeInfo.getInterface();
            if (string2 != null && !string2.equals(this.mIfaceName)) {
                throw new IllegalArgumentException("Route added with non-matching interface: " + string2 + " vs. " + this.mIfaceName);
            }
            RouteInfo routeInfo2 = this.routeWithInterface(routeInfo);
            if (!this.mRoutes.contains(routeInfo2)) {
                this.mRoutes.add(routeInfo2);
                return true;
            }
        }
        return false;
    }

    public boolean addStackedLink(LinkProperties linkProperties) {
        if (linkProperties != null && linkProperties.getInterfaceName() != null) {
            this.mStackedLinks.put(linkProperties.getInterfaceName(), linkProperties);
            return true;
        }
        return false;
    }

    public void clear() {
        this.mIfaceName = null;
        this.mLinkAddresses.clear();
        this.mDnses.clear();
        this.mDomains = null;
        this.mRoutes.clear();
        this.mHttpProxy = null;
        this.mStackedLinks.clear();
        this.mMtu = 0;
        this.mTcpBufferSizes = null;
    }

    public CompareResult<LinkAddress> compareAddresses(LinkProperties linkProperties) {
        CompareResult<LinkAddress> compareResult = new CompareResult<LinkAddress>();
        compareResult.removed = new ArrayList<LinkAddress>(this.mLinkAddresses);
        compareResult.added.clear();
        if (linkProperties != null) {
            for (LinkAddress linkAddress : linkProperties.getLinkAddresses()) {
                if (compareResult.removed.remove(linkAddress)) continue;
                compareResult.added.add(linkAddress);
            }
        }
        return compareResult;
    }

    public CompareResult<String> compareAllInterfaceNames(LinkProperties linkProperties) {
        CompareResult<String> compareResult = new CompareResult<String>();
        compareResult.removed = this.getAllInterfaceNames();
        compareResult.added.clear();
        if (linkProperties != null) {
            for (String string2 : linkProperties.getAllInterfaceNames()) {
                if (compareResult.removed.remove(string2)) continue;
                compareResult.added.add(string2);
            }
        }
        return compareResult;
    }

    public CompareResult<RouteInfo> compareAllRoutes(LinkProperties linkProperties) {
        CompareResult<RouteInfo> compareResult = new CompareResult<RouteInfo>();
        compareResult.removed = this.getAllRoutes();
        compareResult.added.clear();
        if (linkProperties != null) {
            for (RouteInfo routeInfo : linkProperties.getAllRoutes()) {
                if (compareResult.removed.remove(routeInfo)) continue;
                compareResult.added.add(routeInfo);
            }
        }
        return compareResult;
    }

    public CompareResult<InetAddress> compareDnses(LinkProperties linkProperties) {
        CompareResult<InetAddress> compareResult = new CompareResult<InetAddress>();
        compareResult.removed = new ArrayList<InetAddress>(this.mDnses);
        compareResult.added.clear();
        if (linkProperties != null) {
            for (InetAddress inetAddress : linkProperties.getDnsServers()) {
                if (compareResult.removed.remove(inetAddress)) continue;
                compareResult.added.add(inetAddress);
            }
        }
        return compareResult;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (!(object instanceof LinkProperties)) {
                    return false;
                }
                LinkProperties linkProperties = (LinkProperties)object;
                if (!this.isIdenticalInterfaceName(linkProperties) || !this.isIdenticalAddresses(linkProperties) || !this.isIdenticalDnses(linkProperties) || !this.isIdenticalRoutes(linkProperties) || !this.isIdenticalHttpProxy(linkProperties) || !this.isIdenticalStackedLinks(linkProperties) || !this.isIdenticalMtu(linkProperties) || !this.isIdenticalTcpBufferSizes(linkProperties)) break block5;
            }
            return true;
        }
        return false;
    }

    public List<InetAddress> getAddresses() {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        Iterator<LinkAddress> iterator = this.mLinkAddresses.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getAddress());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<InetAddress> getAllAddresses() {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        Iterator<LinkAddress> iterator = this.mLinkAddresses.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getAddress());
        }
        Iterator<LinkProperties> iterator2 = this.mStackedLinks.values().iterator();
        while (iterator2.hasNext()) {
            arrayList.addAll(iterator2.next().getAllAddresses());
        }
        return arrayList;
    }

    public List<String> getAllInterfaceNames() {
        ArrayList<String> arrayList = new ArrayList<String>(1 + this.mStackedLinks.size());
        if (this.mIfaceName != null) {
            arrayList.add(new String(this.mIfaceName));
        }
        Iterator<LinkProperties> iterator = this.mStackedLinks.values().iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(iterator.next().getAllInterfaceNames());
        }
        return arrayList;
    }

    public List<LinkAddress> getAllLinkAddresses() {
        ArrayList<LinkAddress> arrayList = new ArrayList<LinkAddress>();
        arrayList.addAll(this.mLinkAddresses);
        Iterator<LinkProperties> iterator = this.mStackedLinks.values().iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(iterator.next().getAllLinkAddresses());
        }
        return arrayList;
    }

    public List<RouteInfo> getAllRoutes() {
        ArrayList<RouteInfo> arrayList = new ArrayList<RouteInfo>();
        arrayList.addAll(this.mRoutes);
        Iterator<LinkProperties> iterator = this.mStackedLinks.values().iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(iterator.next().getAllRoutes());
        }
        return arrayList;
    }

    public List<InetAddress> getDnsServers() {
        return Collections.unmodifiableList(this.mDnses);
    }

    public String getDomains() {
        return this.mDomains;
    }

    public ProxyInfo getHttpProxy() {
        return this.mHttpProxy;
    }

    public String getInterfaceName() {
        return this.mIfaceName;
    }

    public List<LinkAddress> getLinkAddresses() {
        return Collections.unmodifiableList(this.mLinkAddresses);
    }

    public int getMtu() {
        return this.mMtu;
    }

    public List<RouteInfo> getRoutes() {
        return Collections.unmodifiableList(this.mRoutes);
    }

    public List<LinkProperties> getStackedLinks() {
        if (this.mStackedLinks.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<LinkProperties> arrayList = new ArrayList<LinkProperties>();
        Iterator<LinkProperties> iterator = this.mStackedLinks.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(new LinkProperties(iterator.next()));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public String getTcpBufferSizes() {
        return this.mTcpBufferSizes;
    }

    public boolean hasGlobalIPv6Address() {
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            if (!(linkAddress.getAddress() instanceof Inet6Address) || !linkAddress.isGlobalPreferred()) continue;
            return true;
        }
        return false;
    }

    public boolean hasIPv4Address() {
        Iterator<LinkAddress> iterator = this.mLinkAddresses.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next().getAddress() instanceof Inet4Address)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIPv4DefaultRoute() {
        Iterator<RouteInfo> iterator = this.mRoutes.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isIPv4Default()) continue;
            return true;
        }
        return false;
    }

    public boolean hasIPv4DnsServer() {
        Iterator<InetAddress> iterator = this.mDnses.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof Inet4Address)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIPv6DefaultRoute() {
        Iterator<RouteInfo> iterator = this.mRoutes.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isIPv6Default()) continue;
            return true;
        }
        return false;
    }

    public boolean hasIPv6DnsServer() {
        Iterator<InetAddress> iterator = this.mDnses.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof Inet6Address)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n;
        if (this.mIfaceName == null) {
            n = 0;
        } else {
            int n2 = this.mIfaceName.hashCode() + 31 * this.mLinkAddresses.size() + 37 * this.mDnses.size();
            int n3 = this.mDomains == null ? 0 : this.mDomains.hashCode();
            int n4 = n3 + n2 + 41 * this.mRoutes.size();
            int n5 = this.mHttpProxy == null ? 0 : this.mHttpProxy.hashCode();
            n = n5 + n4 + 47 * this.mStackedLinks.hashCode();
        }
        int n6 = n + 51 * this.mMtu;
        String string2 = this.mTcpBufferSizes;
        int n7 = 0;
        if (string2 == null) {
            return n6 + n7;
        }
        n7 = this.mTcpBufferSizes.hashCode();
        return n6 + n7;
    }

    public boolean isIdenticalAddresses(LinkProperties linkProperties) {
        List<InetAddress> list = linkProperties.getAddresses();
        List<InetAddress> list2 = this.getAddresses();
        if (list2.size() == list.size()) {
            return list2.containsAll(list);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isIdenticalDnses(LinkProperties linkProperties) {
        List<InetAddress> list = linkProperties.getDnsServers();
        String string2 = linkProperties.getDomains();
        if ((this.mDomains != null ? !this.mDomains.equals(string2) : string2 != null) || this.mDnses.size() != list.size()) {
            return false;
        }
        return this.mDnses.containsAll(list);
    }

    public boolean isIdenticalHttpProxy(LinkProperties linkProperties) {
        if (this.getHttpProxy() == null) {
            return linkProperties.getHttpProxy() == null;
        }
        return this.getHttpProxy().equals(linkProperties.getHttpProxy());
    }

    public boolean isIdenticalInterfaceName(LinkProperties linkProperties) {
        return TextUtils.equals(this.getInterfaceName(), linkProperties.getInterfaceName());
    }

    public boolean isIdenticalMtu(LinkProperties linkProperties) {
        return this.getMtu() == linkProperties.getMtu();
    }

    public boolean isIdenticalRoutes(LinkProperties linkProperties) {
        List<RouteInfo> list = linkProperties.getRoutes();
        if (this.mRoutes.size() == list.size()) {
            return this.mRoutes.containsAll(list);
        }
        return false;
    }

    public boolean isIdenticalStackedLinks(LinkProperties linkProperties) {
        if (!this.mStackedLinks.keySet().equals(linkProperties.mStackedLinks.keySet())) {
            return false;
        }
        for (LinkProperties linkProperties2 : this.mStackedLinks.values()) {
            String string2;
            if (linkProperties2.equals(linkProperties.mStackedLinks.get(string2 = linkProperties2.getInterfaceName()))) continue;
            return false;
        }
        return true;
    }

    public boolean isIdenticalTcpBufferSizes(LinkProperties linkProperties) {
        return Objects.equals(this.mTcpBufferSizes, linkProperties.mTcpBufferSizes);
    }

    public boolean isProvisioned() {
        return this.hasIPv4Address() || this.hasGlobalIPv6Address() && this.hasIPv6DefaultRoute() && this.hasIPv6DnsServer();
    }

    public boolean removeLinkAddress(LinkAddress linkAddress) {
        int n = this.findLinkAddressIndex(linkAddress);
        if (n >= 0) {
            this.mLinkAddresses.remove(n);
            return true;
        }
        return false;
    }

    public boolean removeRoute(RouteInfo routeInfo) {
        return routeInfo != null && Objects.equals(this.mIfaceName, routeInfo.getInterface()) && this.mRoutes.remove(routeInfo);
    }

    public boolean removeStackedLink(LinkProperties linkProperties) {
        boolean bl = false;
        if (linkProperties != null) {
            String string2 = linkProperties.getInterfaceName();
            bl = false;
            if (string2 != null) {
                LinkProperties linkProperties2 = this.mStackedLinks.remove(linkProperties.getInterfaceName());
                bl = false;
                if (linkProperties2 != null) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public void setDnsServers(Collection<InetAddress> collection) {
        this.mDnses.clear();
        Iterator<InetAddress> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addDnsServer(iterator.next());
        }
    }

    public void setDomains(String string2) {
        this.mDomains = string2;
    }

    public void setHttpProxy(ProxyInfo proxyInfo) {
        this.mHttpProxy = proxyInfo;
    }

    public void setInterfaceName(String string2) {
        this.mIfaceName = string2;
        ArrayList<RouteInfo> arrayList = new ArrayList<RouteInfo>(this.mRoutes.size());
        Iterator<RouteInfo> iterator = this.mRoutes.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.routeWithInterface(iterator.next()));
        }
        this.mRoutes = arrayList;
    }

    public void setLinkAddresses(Collection<LinkAddress> collection) {
        this.mLinkAddresses.clear();
        Iterator<LinkAddress> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addLinkAddress(iterator.next());
        }
    }

    public void setMtu(int n) {
        this.mMtu = n;
    }

    public void setTcpBufferSizes(String string2) {
        this.mTcpBufferSizes = string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string2 = this.mIfaceName == null ? "" : "InterfaceName: " + this.mIfaceName + " ";
        String string3 = "LinkAddresses: [";
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            string3 = string3 + linkAddress.toString() + ",";
        }
        String string4 = string3 + "] ";
        String string5 = "DnsAddresses: [";
        for (InetAddress inetAddress : this.mDnses) {
            string5 = string5 + inetAddress.getHostAddress() + ",";
        }
        String string6 = string5 + "] ";
        String string7 = "Domains: " + this.mDomains;
        String string8 = " MTU: " + this.mMtu;
        String string9 = "";
        if (this.mTcpBufferSizes != null) {
            string9 = " TcpBufferSizes: " + this.mTcpBufferSizes;
        }
        String string10 = " Routes: [";
        for (RouteInfo routeInfo : this.mRoutes) {
            string10 = string10 + routeInfo.toString() + ",";
        }
        String string11 = string10 + "] ";
        String string12 = this.mHttpProxy == null ? "" : " HttpProxy: " + this.mHttpProxy.toString() + " ";
        String string13 = "";
        if (this.mStackedLinks.values().size() > 0) {
            String string14 = string13 + " Stacked: [";
            for (LinkProperties linkProperties : this.mStackedLinks.values()) {
                string14 = string14 + " [" + linkProperties.toString() + " ],";
            }
            string13 = string14 + "] ";
        }
        return "{" + string2 + string4 + string11 + string6 + string7 + string8 + string9 + string12 + string13 + "}";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.getInterfaceName());
        parcel.writeInt(this.mLinkAddresses.size());
        Iterator<LinkAddress> iterator = this.mLinkAddresses.iterator();
        while (iterator.hasNext()) {
            parcel.writeParcelable(iterator.next(), n);
        }
        parcel.writeInt(this.mDnses.size());
        Iterator<InetAddress> iterator2 = this.mDnses.iterator();
        while (iterator2.hasNext()) {
            parcel.writeByteArray(iterator2.next().getAddress());
        }
        parcel.writeString(this.mDomains);
        parcel.writeInt(this.mMtu);
        parcel.writeString(this.mTcpBufferSizes);
        parcel.writeInt(this.mRoutes.size());
        Iterator<RouteInfo> iterator3 = this.mRoutes.iterator();
        while (iterator3.hasNext()) {
            parcel.writeParcelable(iterator3.next(), n);
        }
        if (this.mHttpProxy != null) {
            parcel.writeByte((byte)1);
            parcel.writeParcelable(this.mHttpProxy, n);
        } else {
            parcel.writeByte((byte)0);
        }
        parcel.writeList(new ArrayList<LinkProperties>(this.mStackedLinks.values()));
    }

    public static class CompareResult<T> {
        public List<T> added;
        public List<T> removed = new ArrayList<T>();

        public CompareResult() {
            this.added = new ArrayList<T>();
        }

        public String toString() {
            String string2 = "removed=[";
            for (T t : this.removed) {
                string2 = string2 + t.toString() + ",";
            }
            String string3 = string2 + "] added=[";
            for (T t : this.added) {
                string3 = string3 + t.toString() + ",";
            }
            return string3 + "]";
        }
    }
}

