/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkQualityInfo;
import android.os.SystemClock;
import android.util.Slog;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;

public class SamplingDataTracker {
    private static final boolean DBG = false;
    private static final String TAG = "SamplingDataTracker";
    private final int MINIMUM_SAMPLED_PACKETS;
    private final int MINIMUM_SAMPLING_INTERVAL;
    private SamplingSnapshot mBeginningSample;
    private SamplingSnapshot mEndingSample;
    private SamplingSnapshot mLastSample;
    public final Object mSamplingDataLock = new Object();

    public SamplingDataTracker() {
        this.MINIMUM_SAMPLING_INTERVAL = 15000;
        this.MINIMUM_SAMPLED_PACKETS = 30;
    }

    /*
     * Unable to fully structure code
     */
    public static void getSamplingSnapshots(Map<String, SamplingSnapshot> var0) {
        var1_1 = null;
        var2_2 = new BufferedReader(new FileReader("/proc/net/dev"));
        var2_2.readLine();
        var2_2.readLine();
        ** while ((var16_3 = var2_2.readLine()) != null)
lbl-1000:
        // 1 sources

        {
            var17_4 = var16_3.trim().split("[ ]+");
            if (var17_4.length < 17 || !(var19_6 = var0.containsKey(var18_5 = var17_4[0].split(":")[0]))) continue;
            try {
                var20_7 = new SamplingSnapshot();
                var20_7.mTxByteCount = Long.parseLong(var17_4[1]);
                var20_7.mTxPacketCount = Long.parseLong(var17_4[2]);
                var20_7.mTxPacketErrorCount = Long.parseLong(var17_4[3]);
                var20_7.mRxByteCount = Long.parseLong(var17_4[9]);
                var20_7.mRxPacketCount = Long.parseLong(var17_4[10]);
                var20_7.mRxPacketErrorCount = Long.parseLong(var17_4[11]);
                var20_7.mTimestamp = SystemClock.elapsedRealtime();
                var0.put(var18_5, var20_7);
                continue;
            }
            catch (NumberFormatException var21_8) {
                continue;
            }
        }
lbl27:
        // 1 sources

        if (var2_2 == null) ** GOTO lbl30
        try {
            var2_2.close();
lbl30:
            // 4 sources

            return;
        }
        catch (IOException var23_9) {
            Slog.e("SamplingDataTracker", "could not close /proc/net/dev");
            return;
        }
        catch (FileNotFoundException var26_10) lbl-1000:
        // 2 sources

        {
            while (true) {
                Slog.e("SamplingDataTracker", "could not find /proc/net/dev");
                if (var1_1 == null) ** GOTO lbl30
                try {
                    var1_1.close();
                    return;
                }
                catch (IOException var8_11) {
                    Slog.e("SamplingDataTracker", "could not close /proc/net/dev");
                    return;
                }
                break;
            }
        }
        catch (IOException var25_12) lbl-1000:
        // 2 sources

        {
            while (true) {
                Slog.e("SamplingDataTracker", "could not read /proc/net/dev");
                if (var1_1 == null) ** continue;
                {
                    catch (Throwable var4_14) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (var1_1 != null) {
                                var1_1.close();
                            }
lbl60:
                            // 4 sources

                            throw var4_15;
                            catch (IOException var5_17) {
                                Slog.e("SamplingDataTracker", "could not close /proc/net/dev");
                                ** continue;
                            }
                            break;
                        }
                    }
                }
                try {
                    var1_1.close();
                    return;
                }
                catch (IOException var12_13) {
                    Slog.e("SamplingDataTracker", "could not close /proc/net/dev");
                    return;
                }
                break;
            }
        }
        catch (Throwable var4_16) {
            var1_1 = var2_2;
            ** continue;
        }
        catch (IOException var10_18) {
            var1_1 = var2_2;
            ** continue;
        }
        catch (FileNotFoundException var3_19) {
            var1_1 = var2_2;
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSampleDuration() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample == null) return Integer.MAX_VALUE;
            if (this.mEndingSample == null) return Integer.MAX_VALUE;
            return (int)(this.mEndingSample.mTimestamp - this.mBeginningSample.mTimestamp);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getSampleTimestamp() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mEndingSample == null) return Long.MAX_VALUE;
            return this.mEndingSample.mTimestamp;
        }
    }

    public long getSampledPacketCount() {
        return this.getSampledPacketCount(this.mBeginningSample, this.mEndingSample);
    }

    public long getSampledPacketCount(SamplingSnapshot samplingSnapshot, SamplingSnapshot samplingSnapshot2) {
        if (samplingSnapshot != null && samplingSnapshot2 != null) {
            return samplingSnapshot2.mRxPacketCount - samplingSnapshot.mRxPacketCount + (samplingSnapshot2.mTxPacketCount - samplingSnapshot.mTxPacketCount);
        }
        return Long.MAX_VALUE;
    }

    public long getSampledPacketErrorCount() {
        if (this.mBeginningSample != null && this.mEndingSample != null) {
            return this.getSampledRxPacketErrorCount() + this.getSampledTxPacketErrorCount();
        }
        return Long.MAX_VALUE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getSampledRxByteCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample == null) return Long.MAX_VALUE;
            if (this.mEndingSample == null) return Long.MAX_VALUE;
            return this.mEndingSample.mRxByteCount - this.mBeginningSample.mRxByteCount;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getSampledRxPacketCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample == null) return Long.MAX_VALUE;
            if (this.mEndingSample == null) return Long.MAX_VALUE;
            return this.mEndingSample.mRxPacketCount - this.mBeginningSample.mRxPacketCount;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getSampledRxPacketErrorCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample == null) return Long.MAX_VALUE;
            if (this.mEndingSample == null) return Long.MAX_VALUE;
            return this.mEndingSample.mRxPacketErrorCount - this.mBeginningSample.mRxPacketErrorCount;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getSampledTxByteCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample == null) return Long.MAX_VALUE;
            if (this.mEndingSample == null) return Long.MAX_VALUE;
            return this.mEndingSample.mTxByteCount - this.mBeginningSample.mTxByteCount;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getSampledTxPacketCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample == null) return Long.MAX_VALUE;
            if (this.mEndingSample == null) return Long.MAX_VALUE;
            return this.mEndingSample.mTxPacketCount - this.mBeginningSample.mTxPacketCount;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getSampledTxPacketErrorCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample == null) return Long.MAX_VALUE;
            if (this.mEndingSample == null) return Long.MAX_VALUE;
            return this.mEndingSample.mTxPacketErrorCount - this.mBeginningSample.mTxPacketErrorCount;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetSamplingData() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            this.mLastSample = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCommonLinkQualityInfoFields(LinkQualityInfo linkQualityInfo) {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            linkQualityInfo.setLastDataSampleTime(this.getSampleTimestamp());
            linkQualityInfo.setDataSampleDuration(this.getSampleDuration());
            linkQualityInfo.setPacketCount(this.getSampledPacketCount());
            linkQualityInfo.setPacketErrorCount(this.getSampledPacketErrorCount());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startSampling(SamplingSnapshot samplingSnapshot) {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            this.mLastSample = samplingSnapshot;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopSampling(SamplingSnapshot samplingSnapshot) {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mLastSample != null && samplingSnapshot.mTimestamp - this.mLastSample.mTimestamp > 15000L && this.getSampledPacketCount(this.mLastSample, samplingSnapshot) > 30L) {
                this.mBeginningSample = this.mLastSample;
                this.mEndingSample = samplingSnapshot;
                this.mLastSample = null;
            }
            return;
        }
    }

    public static class SamplingSnapshot {
        public long mRxByteCount;
        public long mRxPacketCount;
        public long mRxPacketErrorCount;
        public long mTimestamp;
        public long mTxByteCount;
        public long mTxPacketCount;
        public long mTxPacketErrorCount;
    }
}

