/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpPacket;
import android.net.dhcp.DhcpStateMachine;
import java.net.InetAddress;
import java.nio.ByteBuffer;

class DhcpInformPacket
extends DhcpPacket {
    DhcpInformPacket(int n, InetAddress inetAddress, InetAddress inetAddress2, InetAddress inetAddress3, InetAddress inetAddress4, byte[] byArray) {
        super(n, inetAddress, inetAddress2, inetAddress3, inetAddress4, byArray, false);
    }

    @Override
    public ByteBuffer buildPacket(int n, short s, short s2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1500);
        this.fillInPacket(n, this.mClientIp, this.mYourIp, s, s2, byteBuffer, (byte)1, false);
        byteBuffer.flip();
        return byteBuffer;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void doNextOp(DhcpStateMachine dhcpStateMachine) {
        InetAddress inetAddress = this.mRequestedIp == null ? this.mClientIp : this.mRequestedIp;
        dhcpStateMachine.onInformReceived(this.mTransId, this.mClientMac, inetAddress, this.mRequestedParams);
    }

    @Override
    void finishPacket(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[7];
        byArray[0] = 1;
        System.arraycopy((byte[])this.mClientMac, (int)0, (byte[])byArray, (int)1, (int)6);
        this.addTlv(byteBuffer, (byte)53, (byte)3);
        this.addTlv(byteBuffer, (byte)55, this.mRequestedParams);
        this.addTlvEnd(byteBuffer);
    }

    @Override
    public String toString() {
        String string2 = super.toString();
        return string2 + " INFORM";
    }
}

