/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.Context;
import android.net.http.Connection;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.RequestQueue;
import android.os.Process;
import android.os.SystemClock;

class ConnectionThread
extends Thread {
    static final int WAIT_TICK = 1000;
    static final int WAIT_TIMEOUT = 5000;
    Connection mConnection;
    private RequestQueue.ConnectionManager mConnectionManager;
    private Context mContext;
    long mCurrentThreadTime;
    private int mId;
    private RequestFeeder mRequestFeeder;
    private volatile boolean mRunning = true;
    long mTotalThreadTime;
    private boolean mWaiting;

    ConnectionThread(Context context, int n, RequestQueue.ConnectionManager connectionManager, RequestFeeder requestFeeder) {
        this.mContext = context;
        this.setName("http" + n);
        this.mId = n;
        this.mConnectionManager = connectionManager;
        this.mRequestFeeder = requestFeeder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void requestStop() {
        RequestFeeder requestFeeder = this.mRequestFeeder;
        synchronized (requestFeeder) {
            this.mRunning = false;
            this.mRequestFeeder.notify();
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Process.setThreadPriority(1);
        this.mCurrentThreadTime = 0L;
        this.mTotalThreadTime = 0L;
        while (this.mRunning) {
            Request request;
            if (this.mCurrentThreadTime == -1L) {
                this.mCurrentThreadTime = SystemClock.currentThreadTimeMillis();
            }
            if ((request = this.mRequestFeeder.getRequest()) == null) {
                RequestFeeder requestFeeder = this.mRequestFeeder;
                synchronized (requestFeeder) {
                    this.mWaiting = true;
                    this.mRequestFeeder.wait();
                    break block12;
                }
            }
            this.mConnection = this.mConnectionManager.getConnection(this.mContext, request.mHost);
            this.mConnection.processRequests(request);
            if (this.mConnection.getCanPersist()) {
                if (!this.mConnectionManager.recycleConnection(this.mConnection)) {
                    this.mConnection.closeConnection();
                }
            } else {
                this.mConnection.closeConnection();
            }
            this.mConnection = null;
            if (this.mCurrentThreadTime <= 0L) continue;
            long l = this.mCurrentThreadTime;
            this.mCurrentThreadTime = SystemClock.currentThreadTimeMillis();
            this.mTotalThreadTime += this.mCurrentThreadTime - l;
            continue;
            {
                block12: {
                    catch (InterruptedException interruptedException) {}
                }
                this.mWaiting = false;
                if (this.mCurrentThreadTime != 0L) {
                    this.mCurrentThreadTime = SystemClock.currentThreadTimeMillis();
                }
            }
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toString() {
        synchronized (this) {
            String string2 = this.mConnection == null ? "" : this.mConnection.toString();
            String string3 = this.mWaiting ? "w" : "a";
            return "cid " + this.mId + " " + string3 + " " + string2;
        }
    }
}

