/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.net.wifi.IRttManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import java.util.concurrent.CountDownLatch;

public class RttManager {
    public static final int BASE = 160256;
    public static final int CMD_OP_ABORTED = 160260;
    public static final int CMD_OP_FAILED = 160258;
    public static final int CMD_OP_START_RANGING = 160256;
    public static final int CMD_OP_STOP_RANGING = 160257;
    public static final int CMD_OP_SUCCEEDED = 160259;
    private static final boolean DBG = true;
    public static final String DESCRIPTION_KEY = "android.net.wifi.RttManager.Description";
    private static final int INVALID_KEY = 0;
    public static final int REASON_INVALID_LISTENER = -3;
    public static final int REASON_INVALID_REQUEST = -4;
    public static final int REASON_NOT_AVAILABLE = -2;
    public static final int REASON_UNSPECIFIED = -1;
    public static final int RTT_CHANNEL_WIDTH_10 = 6;
    public static final int RTT_CHANNEL_WIDTH_160 = 3;
    public static final int RTT_CHANNEL_WIDTH_20 = 0;
    public static final int RTT_CHANNEL_WIDTH_40 = 1;
    public static final int RTT_CHANNEL_WIDTH_5 = 5;
    public static final int RTT_CHANNEL_WIDTH_80 = 2;
    public static final int RTT_CHANNEL_WIDTH_80P80 = 4;
    public static final int RTT_CHANNEL_WIDTH_UNSPECIFIED = -1;
    public static final int RTT_PEER_TYPE_AP = 1;
    public static final int RTT_PEER_TYPE_STA = 2;
    public static final int RTT_PEER_TYPE_UNSPECIFIED = 0;
    public static final int RTT_STATUS_ABORTED = 8;
    public static final int RTT_STATUS_FAILURE = 1;
    public static final int RTT_STATUS_FAIL_AP_ON_DIFF_CHANNEL = 6;
    public static final int RTT_STATUS_FAIL_NOT_SCHEDULED_YET = 4;
    public static final int RTT_STATUS_FAIL_NO_CAPABILITY = 7;
    public static final int RTT_STATUS_FAIL_NO_RSP = 2;
    public static final int RTT_STATUS_FAIL_REJECTED = 3;
    public static final int RTT_STATUS_FAIL_TM_TIMEOUT = 5;
    public static final int RTT_STATUS_SUCCESS = 0;
    public static final int RTT_TYPE_11_MC = 4;
    public static final int RTT_TYPE_11_V = 2;
    public static final int RTT_TYPE_ONE_SIDED = 1;
    public static final int RTT_TYPE_UNSPECIFIED = 0;
    private static final String TAG = "RttManager";
    private static AsyncChannel sAsyncChannel;
    private static CountDownLatch sConnected;
    private static HandlerThread sHandlerThread;
    private static int sListenerKey;
    private static final SparseArray sListenerMap;
    private static final Object sListenerMapLock;
    private static int sThreadRefCount;
    private static final Object sThreadRefLock;
    private Context mContext;
    private IRttManager mService;

    static {
        sListenerKey = 1;
        sListenerMap = new SparseArray();
        sListenerMapLock = new Object();
        sThreadRefLock = new Object();
    }

    public RttManager(Context context, IRttManager iRttManager) {
        this.mContext = context;
        this.mService = iRttManager;
        this.init();
    }

    static /* synthetic */ AsyncChannel access$002(AsyncChannel asyncChannel) {
        sAsyncChannel = asyncChannel;
        return asyncChannel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object getListener(int n) {
        if (n == 0) {
            return null;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            return sListenerMap.get(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getListenerKey(Object object) {
        if (object == null) {
            return 0;
        }
        Object object2 = sListenerMapLock;
        synchronized (object2) {
            int n = sListenerMap.indexOfValue(object);
            if (n != -1) return sListenerMap.keyAt(n);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() {
        Object object = sThreadRefLock;
        synchronized (object) {
            int n;
            sThreadRefCount = n = 1 + sThreadRefCount;
            if (n == 1) {
                Messenger messenger;
                try {
                    Messenger messenger2;
                    Log.d(TAG, "Get the messenger from " + this.mService);
                    messenger = messenger2 = this.mService.getMessenger();
                }
                catch (SecurityException securityException) {
                    messenger = null;
                }
                catch (RemoteException remoteException) {
                    messenger = null;
                }
                if (messenger == null) {
                    sAsyncChannel = null;
                    return;
                }
                sHandlerThread = new HandlerThread("WifiScanner");
                sAsyncChannel = new AsyncChannel();
                sConnected = new CountDownLatch(1);
                sHandlerThread.start();
                ServiceHandler serviceHandler = new ServiceHandler(sHandlerThread.getLooper());
                sAsyncChannel.connect(this.mContext, (Handler)serviceHandler, messenger);
                try {
                    sConnected.await();
                }
                catch (InterruptedException interruptedException) {
                    Log.e(TAG, "interrupted wait at init");
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int putListener(Object object) {
        if (object == null) {
            return 0;
        }
        Object object2 = sListenerMapLock;
        synchronized (object2) {
            int n;
            do {
                n = sListenerKey;
                sListenerKey = n + 1;
            } while (n == 0);
            sListenerMap.put(n, object);
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int removeListener(Object object) {
        int n = RttManager.getListenerKey(object);
        if (n == 0) {
            return n;
        }
        Object object2 = sListenerMapLock;
        synchronized (object2) {
            sListenerMap.remove(n);
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object removeListener(int n) {
        if (n == 0) {
            return null;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            Object e = sListenerMap.get(n);
            sListenerMap.remove(n);
            return e;
        }
    }

    private void validateChannel() {
        if (sAsyncChannel == null) {
            throw new IllegalStateException("No permission to access and change wifi or a bad initialization");
        }
    }

    public Capabilities getCapabilities() {
        return new Capabilities();
    }

    public void startRanging(RttParams[] rttParamsArray, RttListener rttListener) {
        this.validateChannel();
        ParcelableRttParams parcelableRttParams = new ParcelableRttParams(rttParamsArray);
        sAsyncChannel.sendMessage(160256, 0, RttManager.putListener(rttListener), parcelableRttParams);
    }

    public void stopRanging(RttListener rttListener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(160257, 0, RttManager.removeListener(rttListener));
    }

    public class Capabilities {
        public int supportedPeerType;
        public int supportedType;
    }

    public static class ParcelableRttParams
    implements Parcelable {
        public static final Parcelable.Creator<ParcelableRttParams> CREATOR = new Parcelable.Creator<ParcelableRttParams>(){

            @Override
            public ParcelableRttParams createFromParcel(Parcel parcel) {
                int n = parcel.readInt();
                if (n == 0) {
                    return new ParcelableRttParams(null);
                }
                RttParams[] rttParamsArray = new RttParams[n];
                for (int i = 0; i < n; ++i) {
                    rttParamsArray[i] = new RttParams();
                    rttParamsArray[i].deviceType = parcel.readInt();
                    rttParamsArray[i].requestType = parcel.readInt();
                    rttParamsArray[i].bssid = parcel.readString();
                    rttParamsArray[i].frequency = parcel.readInt();
                    rttParamsArray[i].channelWidth = parcel.readInt();
                    rttParamsArray[i].num_samples = parcel.readInt();
                    rttParamsArray[i].num_retries = parcel.readInt();
                }
                return new ParcelableRttParams(rttParamsArray);
            }

            public ParcelableRttParams[] newArray(int n) {
                return new ParcelableRttParams[n];
            }
        };
        public RttParams[] mParams;

        ParcelableRttParams(RttParams[] rttParamsArray) {
            this.mParams = rttParamsArray;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            if (this.mParams != null) {
                parcel.writeInt(this.mParams.length);
                for (RttParams rttParams : this.mParams) {
                    parcel.writeInt(rttParams.deviceType);
                    parcel.writeInt(rttParams.requestType);
                    parcel.writeString(rttParams.bssid);
                    parcel.writeInt(rttParams.frequency);
                    parcel.writeInt(rttParams.channelWidth);
                    parcel.writeInt(rttParams.num_samples);
                    parcel.writeInt(rttParams.num_retries);
                }
            } else {
                parcel.writeInt(0);
            }
        }
    }

    public static class ParcelableRttResults
    implements Parcelable {
        public static final Parcelable.Creator<ParcelableRttResults> CREATOR = new Parcelable.Creator<ParcelableRttResults>(){

            @Override
            public ParcelableRttResults createFromParcel(Parcel parcel) {
                int n = parcel.readInt();
                if (n == 0) {
                    return new ParcelableRttResults(null);
                }
                RttResult[] rttResultArray = new RttResult[n];
                for (int i = 0; i < n; ++i) {
                    rttResultArray[i] = new RttResult();
                    rttResultArray[i].bssid = parcel.readString();
                    rttResultArray[i].status = parcel.readInt();
                    rttResultArray[i].requestType = parcel.readInt();
                    rttResultArray[i].ts = parcel.readLong();
                    rttResultArray[i].rssi = parcel.readInt();
                    rttResultArray[i].rssi_spread = parcel.readInt();
                    rttResultArray[i].tx_rate = parcel.readInt();
                    rttResultArray[i].rtt_ns = parcel.readLong();
                    rttResultArray[i].rtt_sd_ns = parcel.readLong();
                    rttResultArray[i].rtt_spread_ns = parcel.readLong();
                    rttResultArray[i].distance_cm = parcel.readInt();
                    rttResultArray[i].distance_sd_cm = parcel.readInt();
                    rttResultArray[i].distance_spread_cm = parcel.readInt();
                }
                return new ParcelableRttResults(rttResultArray);
            }

            public ParcelableRttResults[] newArray(int n) {
                return new ParcelableRttResults[n];
            }
        };
        public RttResult[] mResults;

        public ParcelableRttResults(RttResult[] rttResultArray) {
            this.mResults = rttResultArray;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            if (this.mResults != null) {
                parcel.writeInt(this.mResults.length);
                for (RttResult rttResult : this.mResults) {
                    parcel.writeString(rttResult.bssid);
                    parcel.writeInt(rttResult.status);
                    parcel.writeInt(rttResult.requestType);
                    parcel.writeLong(rttResult.ts);
                    parcel.writeInt(rttResult.rssi);
                    parcel.writeInt(rttResult.rssi_spread);
                    parcel.writeInt(rttResult.tx_rate);
                    parcel.writeLong(rttResult.rtt_ns);
                    parcel.writeLong(rttResult.rtt_sd_ns);
                    parcel.writeLong(rttResult.rtt_spread_ns);
                    parcel.writeInt(rttResult.distance_cm);
                    parcel.writeInt(rttResult.distance_sd_cm);
                    parcel.writeInt(rttResult.distance_spread_cm);
                }
            } else {
                parcel.writeInt(0);
            }
        }
    }

    public static interface RttListener {
        public void onAborted();

        public void onFailure(int var1, String var2);

        public void onSuccess(RttResult[] var1);
    }

    public static class RttParams {
        public String bssid;
        public int channelWidth;
        public int deviceType;
        public int frequency;
        public int num_retries;
        public int num_samples;
        public int requestType;
    }

    public static class RttResult {
        public String bssid;
        public int distance_cm;
        public int distance_sd_cm;
        public int distance_spread_cm;
        public int requestType;
        public int rssi;
        public int rssi_spread;
        public long rtt_ns;
        public long rtt_sd_ns;
        public long rtt_spread_ns;
        public int status;
        public long ts;
        public int tx_rate;
    }

    private static class ServiceHandler
    extends Handler {
        ServiceHandler(Looper looper) {
            super(looper);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            Object object;
            switch (message.what) {
                default: {
                    object = RttManager.getListener(message.arg2);
                    if (object != null) break;
                    Log.d(RttManager.TAG, "invalid listener key = " + message.arg2);
                }
                case 69634: {
                    return;
                }
                case 69632: {
                    if (message.arg1 == 0) {
                        sAsyncChannel.sendMessage(69633);
                    } else {
                        Log.e(RttManager.TAG, "Failed to set up channel connection");
                        RttManager.access$002(null);
                    }
                    sConnected.countDown();
                    return;
                }
                case 69636: {
                    Log.e(RttManager.TAG, "Channel connection lost");
                    RttManager.access$002(null);
                    this.getLooper().quit();
                    return;
                }
            }
            Log.d(RttManager.TAG, "listener key = " + message.arg2);
            switch (message.what) {
                default: {
                    Log.d(RttManager.TAG, "Ignoring message " + message.what);
                    return;
                }
                case 160259: {
                    this.reportSuccess(object, message);
                    RttManager.removeListener(message.arg2);
                    return;
                }
                case 160258: {
                    this.reportFailure(object, message);
                    RttManager.removeListener(message.arg2);
                    return;
                }
                case 160260: 
            }
            ((RttListener)object).onAborted();
            RttManager.removeListener(message.arg2);
        }

        void reportFailure(Object object, Message message) {
            RttListener cfr_ignored_0 = (RttListener)object;
            Bundle bundle = (Bundle)message.obj;
            ((RttListener)object).onFailure(message.arg1, bundle.getString(RttManager.DESCRIPTION_KEY));
        }

        void reportSuccess(Object object, Message message) {
            RttListener cfr_ignored_0 = (RttListener)object;
            ParcelableRttResults parcelableRttResults = (ParcelableRttResults)message.obj;
            ((RttListener)object).onSuccess(parcelableRttResults.mResults);
        }
    }
}

